/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.IShareRela;
import com.kingdee.eas.fi.gr.cslrpt.ShareRelaCollection;
import com.kingdee.eas.fi.gr.cslrpt.ShareRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.ShareRelaInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractShareRelaEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class ShareRelaEditUI
extends AbstractShareRelaEditUI {
    private static final String NUMBER_EXP = "1";
    public static final int OP_CURRENT = 0;
    public static final int OP_FIRST = 1;
    public static final int OP_PREVIOUS = 2;
    public static final int OP_NEXT = 3;
    public static final int OP_LAST = 4;
    private static final int TB_ISOUTERSHAREHOLDER = 0;
    private static final int TB_SHAREHOLDER = 1;
    private static final int TB_OUTERSHAREHOLDER = 2;
    private static final int TB_REMARK = 4;
    private int activeRow = 0;
    private int activeCol = 0;
    private int currentIndex;
    private java.util.Date oldDate;
    private boolean isModified = false;
    ShareRelaCollection shcol = new ShareRelaCollection();

    public ShareRelaEditUI() throws Exception {
        this.initControl();
        this.initTable();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
    }

    private void initControl() {
        CompanyF7Helper.initCompanyBizUnitF7((KDBizPromptBox)this.bizPromptInvesteeCompany, (boolean)false, (boolean)true, (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.bizPromptInvesteeCompany.setEditFormat("$number$");
        this.bizPromptInvesteeCompany.setDisplayFormat("$number$+$name$");
        this.bizPromptInvesteeCompany.setEditable(true);
        this.bizPromptInvesteeCompany.setCommitFormat("$number$");
        this.bizPromptInvesteeCompany.setHistoryRecordEnabled(false);
    }

    private void initTable() {
        this.kdt.checkParsed();
        this.kdt.getDataRequestManager().putBindContents("isOut", Boolean.class.getName(), "isOut");
        this.kdt.getDataRequestManager().putBindContents("shareHolder", CompanyOrgUnitInfo.class.getName(), "shareHolder");
        this.kdt.getDataRequestManager().putBindContents("outerShareHolder", String.class.getName(), "outerShareHolder");
        this.kdt.getDataRequestManager().putBindContents("shareScale", BigDecimal.class.getName(), "shareScale");
        this.kdt.getDataRequestManager().putBindContents("remark", String.class.getName(), "remark");
        this.kdt.getDataRequestManager().putBindContents("investeeCompany", CompanyOrgUnitInfo.class.getName(), "investeeCompany");
        this.kdt.getDataRequestManager().putBindContents("changeDate", java.util.Date.class.getName(), "changeDate");
        this.kdt.getDataRequestManager().putBindContents("id", IObjectPK.class.getName(), "id");
        JCheckBox chkBoxItem = new JCheckBox("", false);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(chkBoxItem);
        this.kdt.getColumn(0).setEditor((ICellEditor)cellEditor);
        KDBizPromptBox bizBoxItem = new KDBizPromptBox();
        CompanyF7Helper.initCompanyBizUnitF7((KDBizPromptBox)bizBoxItem, (boolean)false, (boolean)true, (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        bizBoxItem.setDisplayFormat("$number$ $name$");
        bizBoxItem.setEditable(false);
        bizBoxItem.setHistoryRecordEnabled(false);
        KDTDefaultCellEditor companyEditor = new KDTDefaultCellEditor((IKDEditor)bizBoxItem);
        this.kdt.getColumn("shareHolder").setEditor((ICellEditor)companyEditor);
        this.kdt.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDTextField()));
        KDFormattedTextField formatField = new KDFormattedTextField();
        formatField.setDataType(1);
        formatField.setPrecision(13);
        KDTDefaultCellEditor shareScaleEditor = new KDTDefaultCellEditor((JTextField)formatField);
        this.kdt.getColumn("shareScale").setEditor((ICellEditor)shareScaleEditor);
        this.kdt.getColumn("shareScale").getStyleAttributes().setNumberFormat("%R-{#0.#############}f");
        this.kdt.getColumn("shareScale").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdt.getColumn("remark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDTextField()));
        this.kdt.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                ShareRelaEditUI.this.tableValueChanged(e);
            }
        });
        this.kdt.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                ShareRelaEditUI.this.activeRow = e.getRowIndex() + 1;
                ShareRelaEditUI.this.activeCol = e.getColumnIndex() + 1;
            }
        });
        this.kdt.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ShareRelaEditUI.this.autoInsertRow();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void autoInsertRow() {
        if (this.activeCol - 1 == 4 && this.activeRow == this.kdt.getRowCount()) {
            this.addTableLine();
        }
    }

    private void initHeadData(int direct) {
        CompanyOrgUnitInfo cmpy = null;
        try {
            String strPK;
            if (direct == 0) {
                this.setCurrentIndex();
            }
            if ((strPK = this.getAppointedEditID(direct)) != null) {
                cmpy = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(strPK));
                this.bizPromptInvesteeCompany.setData((Object)cmpy);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (this.getUIContext().get("changeDate") != null) {
            this.dateChangeDate.setValue((Object)((java.util.Date)this.getUIContext().get("changeDate")));
            this.oldDate = (java.util.Date)this.getUIContext().get("changeDate");
        }
    }

    private void setCtrlEnabled() {
        int maxNum = ((ArrayList)this.getUIContext().get("ids")).size() - 1;
        if (this.currentIndex == 0) {
            this.btnFirst.setEnabled(false);
            this.btnPrevious.setEnabled(false);
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
        } else if (this.currentIndex == maxNum) {
            this.btnFirst.setEnabled(true);
            this.btnPrevious.setEnabled(true);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        } else {
            this.btnFirst.setEnabled(true);
            this.btnPrevious.setEnabled(true);
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
        }
    }

    private void setCurrentIndex() {
        String strPk = this.getUIContext().get("pk").toString();
        ArrayList s = (ArrayList)this.getUIContext().get("ids");
        if (s.contains(strPk)) {
            Iterator it = s.iterator();
            boolean bExists = false;
            while (it.hasNext() && !bExists) {
                ++this.currentIndex;
                if (!it.next().equals(strPk)) continue;
                bExists = true;
            }
            --this.currentIndex;
        }
    }

    private String getAppointedEditID(int direct) {
        int maxnum = ((ArrayList)this.getUIContext().get("ids")).size() - 1;
        switch (direct) {
            case 1: {
                this.currentIndex = 0;
                break;
            }
            case 2: {
                if (this.currentIndex <= 0) break;
                --this.currentIndex;
                break;
            }
            case 3: {
                if (this.currentIndex >= maxnum) break;
                ++this.currentIndex;
                break;
            }
            case 4: {
                this.currentIndex = maxnum;
                break;
            }
            case 0: {
                break;
            }
        }
        this.setCtrlEnabled();
        return ((ArrayList)this.getUIContext().get("ids")).get(this.currentIndex).toString();
    }

    private void bindDataToTable(KDTable table, ShareRelaCollection collection) {
        if (collection == null) {
            return;
        }
        table.setUserObject((Object)collection);
        table.removeRows();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            ShareRelaInfo obj = (ShareRelaInfo)collection.getObject(i);
            IRow row = table.addRow(i);
            this.loadLineFields(table, row, (IObjectValue)obj);
        }
    }

    private void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        if (obj == null) {
            return;
        }
        row.setUserObject((Object)obj);
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String bindField = table.getColumn(i).getFieldName();
            if (StringUtils.isEmpty((String)bindField)) continue;
            if (bindField.indexOf(".") >= 0) {
                String[] subItems = StringUtils.split((String)bindField, (String)".");
                IObjectValue subObj = obj;
                int l = subItems.length - 1;
                for (int k = 0; k < l && (subObj = (IObjectValue)subObj.get(subItems[k])) != null; ++k) {
                }
                if (subObj == null) continue;
                row.getCell(i).setValue(subObj.get(subItems[subItems.length - 1]));
                continue;
            }
            if (i != 0) {
                row.getCell(i).setValue(obj.get(bindField));
                continue;
            }
            row.getCell(i).setValue((Object)new Boolean(RptUtil.isTrue((Object)obj.get(bindField))));
        }
        boolean isOuter = ((ShareRelaInfo)obj).isIsOut();
        row.getCell(1).getStyleAttributes().setLocked(isOuter);
        row.getCell(2).getStyleAttributes().setLocked(!isOuter);
    }

    private void tableValueChanged(KDTEditEvent e) {
        int selectRow = e.getRowIndex();
        KDTable kdt = (KDTable)e.getSource();
        if (e.getColIndex() == 0 && e.getValue() != null && e.getOldValue() != e.getValue()) {
            Boolean b = (Boolean)e.getValue();
            kdt.getRow(selectRow).getCell(1).getStyleAttributes().setLocked(b.booleanValue());
            kdt.getRow(selectRow).getCell(2).getStyleAttributes().setLocked(b == false);
            if (b.booleanValue()) {
                kdt.getRow(selectRow).getCell(1).setValue(null);
            } else {
                kdt.getRow(selectRow).getCell(2).setValue(null);
            }
        }
        if (e.getValue() != null && e.getValue() != e.getOldValue()) {
            this.isModified = true;
        }
    }

    private void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        boolean bNull = false;
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Object o;
            String bindField = table.getColumn(i).getFieldName();
            if (StringUtils.isEmpty((String)bindField)) continue;
            if (bindField.indexOf(".") >= 0) {
                String[] subItems = StringUtils.split((String)bindField, (String)".");
                IObjectValue subObj = obj;
                int l = subItems.length - 1;
                for (int k = 0; k < l && (subObj = (IObjectValue)subObj.get(subItems[k])) != null; ++k) {
                }
                if (subObj != null) {
                    subObj.put(subItems[subItems.length - 1], row.getCell(i).getValue());
                }
            } else {
                bNull = false;
            }
            if (i == 1 && (o = row.getCell(0).getValue()) != null && ((Boolean)o).booleanValue()) {
                bNull = true;
            }
            if (row.getCell(i).getValue() instanceof Float) {
                obj.put(bindField, bNull ? null : new BigDecimal(row.getCell(i).getValue().toString()).setScale(4, 4));
                continue;
            }
            obj.put(bindField, bNull ? null : row.getCell(i).getValue());
        }
    }

    private void bindTableToData(KDTable table, ShareRelaCollection collection) {
        if (collection == null) {
            return;
        }
        collection.clear();
        int n = table.getExpandedRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = table.getRow(i);
            ShareRelaInfo obj = (ShareRelaInfo)row.getUserObject();
            if (obj == null) {
                obj = new ShareRelaInfo();
            }
            if (!collection.addObject((IObjectValue)obj)) continue;
            this.storeLineFields(table, row, (IObjectValue)obj);
        }
    }

    @Override
    public void bizPromptInvesteeCompany_dataChanged(DataChangeEvent e) {
        if (e.getNewValue() != null && e.getOldValue() != e.getNewValue()) {
            this.isModified = true;
        }
    }

    @Override
    public void dateChangeDate_dataChanged(DataChangeEvent e) {
        if (e.getNewValue() != null && e.getOldValue() != e.getNewValue()) {
            this.isModified = true;
        }
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.initHeadData(1);
        this.initTableData();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.initHeadData(3);
        this.initTableData();
    }

    @Override
    public void actionPrevious_actionPerformed(ActionEvent e) throws Exception {
        this.initHeadData(2);
        this.initTableData();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.initHeadData(4);
        this.initTableData();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        this.addTableLine();
    }

    private void addTableLine() {
        this.btnRemoveLine.setEnabled(true);
        IRow row = this.kdt.addRow();
        this.kdt.getSelectManager().select(row.getRowIndex(), 0);
        row.getCell(0).setValue((Object)new Boolean(false));
        row.getCell(2).getStyleAttributes().setLocked(true);
        this.loadLineFields(this.kdt, row, null);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdt.getSelectManager().size() == 0 || this.isTableColumnSelected(this.kdt)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = this.kdt.getSelectManager().get().getTop();
        if (this.kdt.getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            this.removeTableLine();
        }
    }

    private void controlRemoveLine(KDTSelectEvent e) {
        int begin = e.getSelectBlock().getBeginRow();
        if (begin >= 0) {
            int end = e.getSelectBlock().getEndRow();
            IRow row = null;
            boolean enable = true;
            for (int i = begin; i <= end; ++i) {
                row = this.kdt.getRow(i);
                if (row == null || row.getCell("id") == null || row.getCell("id").getValue() == null) continue;
                row.getCell("isOut").getStyleAttributes().setLocked(true);
                row.getCell("shareHolder").getStyleAttributes().setLocked(true);
                row.getCell("outerShareHolder").getStyleAttributes().setLocked(true);
                if (!enable) continue;
                enable = false;
            }
            this.btnRemoveLine.setEnabled(enable);
        }
    }

    private void removeTableLine() throws Exception {
        int top = this.kdt.getSelectManager().get().getTop();
        if (this.kdt.getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        IObjectValue detailData = (IObjectValue)this.kdt.getRow(top).getUserObject();
        if (detailData != null && this.getOprtState().equals(OprtState.EDIT) && this.getUIContext().get("isChange") == null && ((ShareRelaInfo)detailData).getId() != null && BigDecimal.ZERO.equals(((ShareRelaInfo)detailData).getShareScale())) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(((ShareRelaInfo)detailData).getId().toString());
            Map<String, ShareRelaInfo> id_shares = CslRptUIUtil.getExistHisShareRelas(ids);
            for (ShareRelaInfo info : id_shares.values()) {
                MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"existHisRelaCantDel"), info.isIsOut() ? info.getOuterShareHolder() : info.getShareHolder().getName()));
                SysUtil.abort();
            }
        }
        this.kdt.removeRow(top);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSummit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPrevious.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        String hintInfo = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check");
        if (this.isModified && MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)hintInfo))) {
            this.bindTableToData(this.kdt, this.shcol);
            this.verifyInput(e);
            this.doModify();
        }
        this.setAddNew();
    }

    private void setAddNew() {
        this.kdt.removeRows();
        this.bizPromptInvesteeCompany.setValue(null);
        this.bizPromptInvesteeCompany.setEnabled(true);
        try {
            this.actionAddLine_actionPerformed(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setOprtState(OprtState.ADDNEW);
        this.btnAddNew.setEnabled(!this.getOprtState().equals(OprtState.ADDNEW));
    }

    @Override
    public void actionSummit_actionPerformed(ActionEvent e) throws Exception {
        this.bindTableToData(this.kdt, this.shcol);
        this.verifyInput(e);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.doAddNew();
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            if (this.getUIContext().get("isChange") != null) {
                this.doChange();
            } else {
                this.doModify();
            }
        }
    }

    private void doModify() throws Exception {
        CompanyOrgUnitInfo investee = (CompanyOrgUnitInfo)this.bizPromptInvesteeCompany.getValue();
        Date chgdt = this.dateChangeDate.getSqlDate();
        Iterator iter = this.shcol.iterator();
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        while (iter.hasNext()) {
            ShareRelaInfo shInfo = (ShareRelaInfo)iter.next();
            shInfo.setInvesteeCompany(investee);
            shInfo.setChangeDate(chgdt);
            shInfo.setTrackRecordCreator(companyOrgUnitInfo);
            shInfo.setIsLatest(true);
        }
        this.checkCompany(investee, this.shcol);
        int size = this.kdt.getRowCount();
        for (int i = 0; i < size; ++i) {
            if (this.kdt.getRow(i).getCell(3).getValue() != null) continue;
            throw new AdjustException(AdjustException.SHARESCALE_NOTNULL);
        }
        try {
            ((IShareRela)this.getBizInterface()).updateCollection((IObjectPK)new ObjectUuidPK(investee.getId()), chgdt, this.shcol);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        this.isModified = false;
    }

    private void doChange() throws Exception {
        CompanyOrgUnitInfo investee = (CompanyOrgUnitInfo)this.bizPromptInvesteeCompany.getValue();
        java.util.Date chgdt = this.oldDate;
        Date chgdate = this.dateChangeDate.getSqlDate();
        Iterator iter = this.shcol.iterator();
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        while (iter.hasNext()) {
            ShareRelaInfo shInfo = (ShareRelaInfo)iter.next();
            shInfo.setInvesteeCompany(investee);
            shInfo.setChangeDate(chgdate);
            shInfo.setIsLatest(true);
            shInfo.setId(null);
            shInfo.setTrackRecordCreator(companyOrgUnitInfo);
        }
        this.checkCompany(investee, this.shcol);
        try {
            ((IShareRela)this.getBizInterface()).recordChange((IObjectPK)new ObjectUuidPK(investee.getId()), chgdt, this.shcol);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        this.isModified = false;
    }

    private void doAddNew() throws Exception {
        CompanyOrgUnitInfo investee = (CompanyOrgUnitInfo)this.bizPromptInvesteeCompany.getValue();
        Date chgdt = this.dateChangeDate.getSqlDate();
        this.checkCompany(investee, this.shcol);
        Iterator iter = this.shcol.iterator();
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        while (iter.hasNext()) {
            ShareRelaInfo shInfo = (ShareRelaInfo)iter.next();
            shInfo.setInvesteeCompany(investee);
            shInfo.setChangeDate(chgdt);
            shInfo.setIsLatest(true);
            shInfo.setTrackRecordCreator(companyOrgUnitInfo);
        }
        try {
            ((IShareRela)this.getBizInterface()).addNewCollection((IObjectPK)new ObjectUuidPK(investee.getId()), chgdt, this.shcol);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        this.setOprtState(OprtState.EDIT);
        this.btnAddNew.setEnabled(!this.getOprtState().equals(OprtState.ADDNEW));
        this.isModified = false;
    }

    private void checkCompany(CompanyOrgUnitInfo investee, ShareRelaCollection shcol) {
        BOSUuid id = investee.getId();
        Iterator iter = shcol.iterator();
        while (iter.hasNext()) {
            ShareRelaInfo shInfo = (ShareRelaInfo)iter.next();
            if (shInfo.isIsOut() || !id.equals((Object)shInfo.getShareHolder().getId())) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Company_Is_Shareholder"));
            SysUtil.abort();
        }
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddNew.setEnabled(!this.getOprtState().equals(OprtState.ADDNEW));
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnFirst.setVisible(false);
            this.btnPrevious.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnLast.setVisible(false);
            this.separator2.setVisible(false);
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
            this.actionAddLine_actionPerformed(null);
        }
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.initHeadData(0);
            this.initTableData();
            this.bizPromptInvesteeCompany.setEditable(false);
            this.bizPromptInvesteeCompany.setEnabled(false);
            if (this.getUIContext().get("isChange") != null) {
                this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Change"));
            } else {
                this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
            }
        }
        final boolean isChange = this.getOprtState().equals(OprtState.EDIT) && this.getUIContext().get("isChange") != null;
        this.kdt.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                if (isChange) {
                    ShareRelaEditUI.this.controlRemoveLine(e);
                }
            }
        });
        this.isModified = false;
        if (this.isHasOnlyOneRecord()) {
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        }
    }

    private boolean isHasOnlyOneRecord() throws EASBizException, BOSException {
        Integer isLast = new Integer(1);
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("isLatest", isLast);
        int count = ShareRelaFactory.getRemoteInstance().getRelaCount(param);
        return count == 1;
    }

    private void initTableData() {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("isOut"));
        sic.add(new SelectorItemInfo("investeeCompany.name"));
        sic.add(new SelectorItemInfo("shareHolder.name"));
        sic.add(new SelectorItemInfo("shareHolder.number"));
        sic.add(new SelectorItemInfo("outerShareHolder"));
        sic.add(new SelectorItemInfo("shareScale"));
        sic.add(new SelectorItemInfo("changeDate"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("isLatest"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("investeeCompany.id"));
        sic.add(new SelectorItemInfo("shareHolder.id"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem0 = new FilterItemInfo("investeeCompany.id", (Object)this.getAppointedEditID(0), CompareType.EQUALS);
        FilterItemInfo filterItem2 = new FilterItemInfo("isLatest", (Object)Integer.valueOf(NUMBER_EXP), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem0);
        filter.getFilterItems().add(filterItem2);
        filter.setMaskString(" #0 and #1");
        view.setFilter(filter);
        SorterItemCollection sorter = view.getSorter();
        sorter.add(new SorterItemInfo("investeeCompany.name"));
        sorter.add(new SorterItemInfo("shareHolder.name"));
        sorter.add(new SorterItemInfo("outerShareHolder"));
        try {
            IShareRela ie = ShareRelaFactory.getRemoteInstance();
            this.shcol = ie.getShareRelaCollection(view);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        if (this.shcol != null) {
            this.bindDataToTable(this.kdt, this.shcol);
            this.setChangeDate(this.shcol);
        }
    }

    private void setChangeDate(ShareRelaCollection shcol) {
        ShareRelaInfo obj;
        if (shcol.size() > 0 && (obj = (ShareRelaInfo)shcol.getObject(0)).getChangeDate() != null) {
            this.dateChangeDate.setValue((Object)obj.getChangeDate());
            this.oldDate = obj.getChangeDate();
        }
    }

    private boolean isExistShareRelaOnChangeDate(java.util.Date date) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        CompanyOrgUnitInfo investee = (CompanyOrgUnitInfo)this.bizPromptInvesteeCompany.getData();
        filter.getFilterItems().add(new FilterItemInfo("investeeCompany.id", (Object)investee.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("changeDate", (Object)date));
        IShareRela iShareRela = ShareRelaFactory.getRemoteInstance();
        return iShareRela.exists(filter);
    }

    private ICoreBase getBizInterface() throws Exception {
        return ShareRelaFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.bizPromptInvesteeCompany.getValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Company_IsNull")));
        }
        if (this.dateChangeDate.getValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Change_Date_Null")));
        }
        Date newDate = this.dateChangeDate.getSqlDate();
        if (this.getUIContext().get("isChange") != null) {
            if (newDate.compareTo(this.oldDate) <= 0) {
                throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_ChangeDate_Latest")));
            }
        } else if (this.getOprtState().equals(OprtState.EDIT) && this.isExistShareRelaOnChangeDate(newDate) && this.oldDate != null && newDate.compareTo(this.oldDate) != 0) {
            throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SHARERELA_EXIST_ON_SAMEDATE")));
        }
        Iterator iter = this.shcol.iterator();
        ArrayList<BOSUuid> arr = new ArrayList<BOSUuid>();
        ArrayList<String> arr2 = new ArrayList<String>();
        BigDecimal rateSum = new BigDecimal("0");
        while (iter.hasNext()) {
            ShareRelaInfo shInfo = (ShareRelaInfo)iter.next();
            if (shInfo.isIsOut()) {
                if (StringUtils.isEmpty((String)shInfo.getOuterShareHolder())) {
                    throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_Outer_NotNull")));
                }
                if (arr2.contains(shInfo.getOuterShareHolder())) {
                    throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_Outer_Repeat")));
                }
                arr2.add(shInfo.getOuterShareHolder());
            } else {
                if (shInfo.getShareHolder() == null) {
                    throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_Innter_NotNull")));
                }
                if (arr.contains(shInfo.getShareHolder().getId())) {
                    throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_Innter_Repeat")));
                }
                arr.add(shInfo.getShareHolder().getId());
            }
            if (this.getOprtState().equals(OprtState.ADDNEW) && shInfo.getShareScale() == null) {
                if (shInfo.isIsOut()) {
                    throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_OuterRate_NotNull")), new Object[]{shInfo.getOuterShareHolder()});
                }
                throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_InnerRate_NotNull")), new Object[]{shInfo.getShareHolder().getName()});
            }
            boolean isShareScaleNull = false;
            if (shInfo.get("shareScale") == null) {
                isShareScaleNull = true;
                shInfo.setShareScale(new BigDecimal("0"));
            }
            if (shInfo.getShareScale().doubleValue() < 0.0) {
                if (shInfo.isIsOut()) {
                    throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_Outer_NotMinus")), new Object[]{shInfo.getOuterShareHolder()});
                }
                throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_Inner_NotMinus")), new Object[]{shInfo.getShareHolder().getName()});
            }
            if (shInfo.getShareScale().doubleValue() == 0.0) {
                boolean isCanSave = true;
                if (this.getOprtState().equals(OprtState.ADDNEW)) {
                    isCanSave = false;
                } else if (this.getOprtState().equals(OprtState.EDIT) && this.getUIContext().get("isChange") == null) {
                    if (shInfo.getId() != null) {
                        ArrayList<String> ids = new ArrayList<String>();
                        ids.add(shInfo.getId().toString());
                        Map<String, ShareRelaInfo> id_infos = CslRptUIUtil.getExistHisShareRelas(ids);
                        if (!id_infos.containsKey(shInfo.getId().toString())) {
                            isCanSave = false;
                        }
                    } else {
                        isCanSave = false;
                    }
                }
                if (!isCanSave) {
                    throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)(isShareScaleNull ? (shInfo.isIsOut() ? "ShareRela_OuterRate_NotNull" : "ShareRela_InnerRate_NotNull") : "zerocantsave"))), new Object[]{shInfo.isIsOut() ? shInfo.getOuterShareHolder() : shInfo.getShareHolder().getName()});
                }
            }
            rateSum = rateSum.add(shInfo.getBigDecimal("shareScale"));
        }
        if (this.kdt.getRowCount() < 1) {
            throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_Innter_NotNull")));
        }
        if (rateSum.doubleValue() < 0.0 || rateSum.doubleValue() > 100.0) {
            throw new EASBizException(new NumericExceptionSubItem(NUMBER_EXP, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ShareRela_Count_Rule")));
        }
    }

    protected boolean checkBeforeWindowClosing() {
        boolean isDestroy = super.checkBeforeWindowClosing();
        if (isDestroy && this.isModified) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.actionSummit_actionPerformed(null);
                }
                catch (Exception e) {
                    this.handleException(e);
                    return false;
                }
                return true;
            }
            return result == 1;
        }
        return isDestroy;
    }
}

