/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.IShareRela;
import com.kingdee.eas.fi.gr.cslrpt.ShareRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractShareRelaStructureUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CslOrgTreeUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class ShareRelaStructureUI
extends AbstractShareRelaStructureUI {
    private static final Logger logger = CoreUIObject.getLogger(ShareRelaStructureUI.class);
    private static final int COMPANY = 1;
    private static final int TARGETCOMPANY = 2;
    private int queryFlag;
    private boolean isFromZero = false;
    private boolean isToZero = false;
    private static String printDateMsg = "Print_date";
    private static String printPersonMsg = "Print_person";
    private static String printPageCountMsg = "Print_pageCount";
    DefaultKingdeeTreeNode rootNode = null;

    public ShareRelaStructureUI() throws Exception {
        this.registerEvent();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void kDOrg_valueChanged(TreeSelectionEvent e) throws Exception {
        super.kDOrg_valueChanged(e);
        this.execQuery();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refreshControl();
        this.execQuery();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.refreshControl();
        this.kDFrom.getStyleAttributes().setLocked(true);
        this.kDTo.getStyleAttributes().setLocked(true);
    }

    private void registerEvent() {
        this.kDFrom.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                ShareRelaStructureUI.this.KDFrom_doRequestRowSet(e);
            }
        });
        this.kDTo.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                ShareRelaStructureUI.this.KDTo_doRequestRowSet(e);
            }
        });
    }

    protected void execQuery() {
        this.kDFrom.repaint();
        this.kDFrom.removeRows();
        this.kDTo.repaint();
        this.kDTo.removeRows();
    }

    private Map getFilter(boolean isFrom) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("isfrom", new Boolean(isFrom));
        DefaultKingdeeTreeNode currentNode = (DefaultKingdeeTreeNode)this.kDOrg.getLastSelectedPathComponent();
        if (currentNode == null) {
            return null;
        }
        Object company = currentNode.getUserObject();
        if (company == null || !(company instanceof OrgStructureInfo)) {
            return null;
        }
        m.put("companyid", ((OrgStructureInfo)company).getUnit().getId().toString());
        Object date = this.kDDatePicker1.getValue();
        if (date == null) {
            return null;
        }
        m.put("changedate", this.kDDatePicker1.getValue());
        return m;
    }

    private void KDFrom_doRequestRowSet(RequestRowSetEvent e) {
        Map param = this.getFilter(true);
        if (param == null) {
            return;
        }
        IRowSet rs = null;
        try {
            IShareRela sr = ShareRelaFactory.getRemoteInstance();
            rs = sr.getCompanyListByDate(param);
        }
        catch (BOSException e1) {
            super.handUIException((Throwable)e1);
        }
        e.setRowSet(rs);
        this.onGetRowSet(rs);
        if (rs == null) {
            return;
        }
        try {
            rs.beforeFirst();
            this.isFromZero = !rs.next();
            rs.beforeFirst();
        }
        catch (SQLException ex) {
            super.handUIException((Throwable)ex);
        }
    }

    private void KDTo_doRequestRowSet(RequestRowSetEvent e) {
        Map param = this.getFilter(false);
        if (param == null) {
            return;
        }
        IRowSet rs = null;
        try {
            IShareRela sr = ShareRelaFactory.getRemoteInstance();
            rs = sr.getCompanyListByDate(param);
        }
        catch (BOSException e1) {
            super.handUIException((Throwable)e1);
        }
        e.setRowSet(rs);
        this.onGetRowSet(rs);
        if (rs == null) {
            return;
        }
        try {
            rs.beforeFirst();
            boolean bl = this.isToZero = !rs.next();
            if (this.isToZero && !this.isFromZero) {
                this.kDTabbedPane1.setSelectedIndex(0);
                this.setCurrentPane(1);
            } else if (!this.isToZero && this.isFromZero) {
                this.kDTabbedPane1.setSelectedIndex(1);
                this.setCurrentPane(2);
            }
            rs.beforeFirst();
        }
        catch (SQLException ex) {
            super.handUIException((Throwable)ex);
        }
    }

    private void refreshControl() throws Exception {
        this.initTree();
    }

    protected void initTree() throws Exception {
        DefaultTreeModel model = CslOrgTreeUtil.getCompanyF7TreeModel();
        this.rootNode = (DefaultKingdeeTreeNode)model.getRoot();
        DefaultTreeModel model2 = new DefaultTreeModel((TreeNode)this.rootNode);
        this.kDOrg.setModel((TreeModel)model2);
        this.kDOrg.setSelectionNode(this.rootNode);
        this.kDOrg.expandAllNodes(true, (TreeNode)this.rootNode);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.doPrint();
    }

    private void doPrint() {
        if (this.getCurrentPane() == 1) {
            this.preparePrintPage(this.kDFrom);
            this.kDFrom.getPrintManager().print();
        } else if (this.getCurrentPane() == 2) {
            this.preparePrintPage(this.kDTo);
            this.kDTo.getPrintManager().print();
        }
    }

    protected void preparePrintPage(KDTable tblMain) {
        HeadFootModel header = new HeadFootModel();
        String title = this.getPrintPageTitle();
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setFontSize(14);
        sa.setBold(true);
        header.addRow(this.getPrintPageTitle(), sa);
        HeadFootModel footer = new HeadFootModel();
        String dateString = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + printDateMsg)) + "&[Date]";
        String personString = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + printPersonMsg)) + SysContext.getSysContext().getCurrentUserInfo();
        String pageNumber = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + printPageCountMsg)) + "&[Page]/&[PageCount]";
        String footerString = dateString + "&|" + personString + "&|" + pageNumber;
        StyleAttributes sb = Styles.getDefaultSA();
        footer.addRow(footerString, sb);
        this.preparePrintPageHeader(header);
        this.preparePrintPageFooter(footer);
        Page hPage = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)header);
        Page fPage = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)footer);
        ExtVarProvider extVarProvider = this.getPrintExtVarProvider();
        if (extVarProvider != null) {
            tblMain.getPrintManager().setHeaderFooter(hPage, fPage, extVarProvider);
        } else {
            tblMain.getPrintManager().setHeaderFooter(hPage, fPage);
        }
    }

    @Override
    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        this.doPrintPreview();
    }

    private void doPrintPreview() {
        if (this.getCurrentPane() == 1) {
            this.preparePrintPage(this.kDFrom);
            this.kDFrom.getPrintManager().printPreview();
        } else if (this.getCurrentPane() == 2) {
            this.preparePrintPage(this.kDTo);
            this.kDTo.getPrintManager().printPreview();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setText("");
        this.btnPrint.setText("");
        this.btnPrintView.setText("");
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    @Override
    protected void kDClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void kDTabbedPane1_stateChanged(ChangeEvent e) throws Exception {
        super.kDTabbedPane1_stateChanged(e);
        if (((KDTabbedPane)e.getSource()).getSelectedIndex() == 0) {
            this.setCurrentPane(1);
        } else {
            this.setCurrentPane(2);
        }
    }

    private void setCurrentPane(int editFlag) {
        this.queryFlag = editFlag;
    }

    private int getCurrentPane() {
        return this.queryFlag;
    }

    @Override
    protected void kDDatePicker1_dataChanged(DataChangeEvent e) throws Exception {
        this.execQuery();
    }
}

