/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractSheetSelectUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class SheetSelectUI
extends AbstractSheetSelectUI {
    private static final long serialVersionUID = -5283890202561119812L;
    private static final Logger logger = CoreUIObject.getLogger(SheetSelectUI.class);
    protected Book book;
    private static final String RES = "com.kingdee.eas.cp.ba.client.RptResource";

    public void checkPermission() throws EASBizException, BOSException {
        OrgUnitInfo currentOrgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        UserInfo currentUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (!(Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(currentOrgUnitInfo.getId())) || "00000000-0000-0000-0000-00000000000013B7DE7F".equals(currentUserInfo.getId().toString()) || PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectStringPK(currentUserInfo.getId().toString()), (IObjectPK)new ObjectStringPK(currentOrgUnitInfo.getId().toString()), "cp_ba_Rpt"))) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"rpt_Report"));
            SysUtil.abort();
        }
    }

    public void onLoad() throws Exception {
        this.checkPermission();
        this.book = (Book)this.getUIContext().get("book");
        this.kDScrollPane1.setBorder(this.kDSheetPanel.getBorder());
        this.kDSheetPanel.setBorder(null);
        this.kDScrollPane1.getVerticalScrollBar().setUnitIncrement(25);
        this.setData();
        this._btnSelAll.setIcon((Icon)ResourceManager.getImageIcon((String)"tbtn_SelectAll.gif"));
        this._btnSelAll.setBorder(null);
        this._btnSelAll.setText(null);
        this._btnSelAll.setLimitedSize(false);
        this._btnSelAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SheetSelectUI.this.setAllSelected(true);
            }
        });
        this._btnUnSelAll.setIcon((Icon)ResourceManager.getImageIcon((String)"tbtn_deleteall.gif"));
        this._btnUnSelAll.setBorder(null);
        this._btnUnSelAll.setText(null);
        this._btnUnSelAll.setLimitedSize(false);
        this._btnUnSelAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SheetSelectUI.this.setAllSelected(false);
            }
        });
    }

    private void setAllSelected(boolean b) {
        int count = this.kDSheetPanel.getComponentCount();
        for (int i = 0; i < count; ++i) {
            ((KDCheckBox)this.kDSheetPanel.getComponent(i)).setSelected(b);
        }
    }

    private String[] getSelectedSheets() {
        int count = this.kDSheetPanel.getComponentCount();
        ArrayList<String> al = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            if (!((KDCheckBox)this.kDSheetPanel.getComponent(i)).isSelected()) continue;
            al.add(this.book.getSheet(i).getSheetName());
        }
        if (al.size() == 0) {
            return new String[0];
        }
        String[] str = new String[al.size()];
        for (int i = 0; i < str.length; ++i) {
            str[i] = (String)al.get(i);
        }
        return str;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void _cmdOK_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String[]> map = new HashMap<String, String[]>(2);
        String[] selectsheets = this.getSelectedSheets();
        if (selectsheets.length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"720_selectsheet"));
            return;
        }
        map.put("selectsheets", selectsheets);
        this.setUserObject(map);
        this.getUIWindow().close();
    }

    @Override
    protected void _cmdCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private void setData() {
        this.kDSheetPanel.removeAll();
        if (this.book != null && this.book.getSheetCount() > 0) {
            int count = this.book.getSheetCount();
            this.kDSheetPanel.setLayout((LayoutManager)new GridLayout(count, 1, 5, 0));
            for (int i = 0; i < count; ++i) {
                KDCheckBox ck = new KDCheckBox(this.book.getSheet(i).getSheetName());
                this.kDSheetPanel.add((Component)ck);
                ck.setLocation(0, i * 25 + 25);
                ck.setSelected(true);
            }
            this.kDSheetPanel.doLayout();
            this.kDSheetPanel.revalidate();
        }
    }
}

