/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.LazyShowName;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ShowItemSourceName {
    private DBHandler dao;
    private Map<Integer, Collection<String>> sourceIds = new HashMap<Integer, Collection<String>>(1);
    private Map<String, Collection<LazyShowName>> sourceMap = new HashMap<String, Collection<LazyShowName>>(1);

    public ShowItemSourceName(DBHandler dao) {
        this.dao = dao;
        this.sourceIds.put(100, new HashSet());
        this.sourceIds.put(IItemSourceType.SOURCE_TYPE_REPORT.iterator().next(), new HashSet());
    }

    public LazyShowName register(IItemSourceType sourceType) {
        String showName = null;
        LazyShowName lazyShowName = new LazyShowName(ResourceDebugUtil.res("none"));
        if (sourceType.getItemSourceId() == null) {
            return lazyShowName;
        }
        if (sourceType.getItemSourceType() == 100) {
            if (sourceType instanceof FormulaCalcContextInfo) {
                showName = ((FormulaCalcContextInfo)sourceType).getName();
            }
            if (showName == null && sourceType.getItemSourceId() != null) {
                this.sourceIds.get(100).add(sourceType.getItemSourceId().toString());
                if (!this.sourceMap.containsKey(sourceType.getItemSourceId().toString())) {
                    this.sourceMap.put(sourceType.getItemSourceId().toString(), new HashSet(1));
                }
                this.sourceMap.get(sourceType.getItemSourceId().toString()).add(lazyShowName);
            } else {
                lazyShowName.setName(showName);
            }
        } else if (IItemSourceType.SOURCE_TYPE_REPORT.contains(sourceType.getItemSourceType())) {
            if (sourceType instanceof ReportBaseInfo) {
                showName = ((ReportBaseInfo)sourceType).getName();
            }
            if (showName == null && sourceType.getItemSourceId() != null) {
                this.sourceIds.get(IItemSourceType.SOURCE_TYPE_REPORT.iterator().next()).add(sourceType.getItemSourceId().toString());
                if (!this.sourceMap.containsKey(sourceType.getItemSourceId().toString())) {
                    this.sourceMap.put(sourceType.getItemSourceId().toString(), new HashSet(1));
                }
                this.sourceMap.get(sourceType.getItemSourceId().toString()).add(lazyShowName);
            } else {
                lazyShowName.setName(showName);
            }
        }
        return lazyShowName;
    }

    public void exec() throws BOSException {
        this.setNameForFormulaCalcContext();
        this.setNameForReportBase();
    }

    protected void setNameForReportBase() throws BOSException {
        Collection<String> reports = this.sourceIds.get(IItemSourceType.SOURCE_TYPE_REPORT.iterator().next());
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("name");
        view.getSelector().add("id");
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(reports), CompareType.INCLUDE));
        CslReportCollection reportInfos = this.dao.get(ICslReport.class).getCslReportCollection(view);
        Collection<LazyShowName> showNames = null;
        Iterator iterator = reportInfos.iterator();
        while (iterator.hasNext()) {
            CslReportInfo report = (CslReportInfo)iterator.next();
            showNames = this.sourceMap.get(report.getId().toString());
            if (showNames == null) continue;
            for (LazyShowName showName : showNames) {
                showName.setName(ResourceDebugUtil.res("report") + ":" + report.getName());
            }
        }
    }

    protected Collection<String> setNameForFormulaCalcContext() throws BOSException {
        Collection<String> calcContexts = this.sourceIds.get(100);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("name");
        view.getSelector().add("id");
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(calcContexts), CompareType.INCLUDE));
        FormulaCalcContextCollection calcContextInfos = this.dao.get(IFormulaCalcContext.class).getFormulaCalcContextCollection(view);
        Collection<LazyShowName> showNames = null;
        Iterator iterator = calcContextInfos.iterator();
        while (iterator.hasNext()) {
            FormulaCalcContextInfo calcContextInfo = (FormulaCalcContextInfo)iterator.next();
            showNames = this.sourceMap.get(calcContextInfo.getId().toString());
            if (showNames == null) continue;
            for (LazyShowName showName : showNames) {
                showName.setName(ResourceDebugUtil.res("autoitem.scheme") + ":" + calcContextInfo.getName());
            }
        }
        return calcContexts;
    }
}

