/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractSumItemFormulaPickerUI;
import com.kingdee.eas.fi.gr.cslrpt.util.SumItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.util.TokenMgrError;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SumItemFormulaPickerUI
extends AbstractSumItemFormulaPickerUI {
    public String sumItemFormula = null;
    public RPTItemCollection subItems = null;

    public SumItemFormulaPickerUI() throws Exception {
        this.lblSumFormula.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.btnPlus.setText(null);
        this.btnPlus.setIcon(EASResource.getIcon((String)"imgTbtn_plussign"));
        this.btnMinus.setText(null);
        this.btnMinus.setIcon(EASResource.getIcon((String)"imgTbtn_minussign"));
        this.btnMultiply.setText(null);
        this.btnMultiply.setIcon(EASResource.getIcon((String)"imgTbtn_multiplysign"));
        this.btnDivide.setText(null);
        this.btnDivide.setIcon(EASResource.getIcon((String)"imgTbtn_dividesign"));
        this.btnClear.setText(null);
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnInsert.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.txtExpression.setMaxLength(4000);
        this.mltRptItemF7.setEditable(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiCtx = super.getUIContext();
        this.sumItemFormula = uiCtx.get("SUMITEMFORMULA") != null ? uiCtx.get("SUMITEMFORMULA").toString() : "";
        this.txtExpression.setSelectAllOnFocus(false);
        this.txtExpression.setText(this.sumItemFormula);
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.mltRptItemF7, null);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (!this.checkFormula(this.txtExpression.getText().toString())) {
            return;
        }
        this.toSubItems();
        this.sumItemFormula = this.txtExpression.getText() != null ? this.txtExpression.getText().toString() : "";
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        super.btnClear_actionPerformed(e);
        this.txtExpression.setText("");
        this.txtExpression.requestFocus();
    }

    @Override
    public void insertOperatorAction_actionPerformed(ActionEvent e) throws Exception {
        super.insertOperatorAction_actionPerformed(e);
        int ch = 0;
        Object src = e.getSource();
        if (src == this.btnPlus) {
            ch = 43;
        } else if (src == this.btnMinus) {
            ch = 45;
        } else if (src == this.btnMultiply) {
            ch = 42;
        } else if (src == this.btnDivide) {
            ch = 47;
        } else if (src == this.btnInsert) {
            ch = 105;
        }
        this.insertOperator((char)ch);
        this.txtExpression.setCaretPosition(this.txtExpression.getText().length());
    }

    private void toSubItems() throws EASBizException, BOSException {
        String str = this.txtExpression.getText().toString();
        if (str == null || str.length() == 0) {
            return;
        }
        IRPTItem ie = RPTItemFactory.getRemoteInstance();
        this.subItems = ie.getItemListBySumItemFormula(str);
    }

    private void insertOperator(char ch) {
        String txtInsert = null;
        int pos = this.txtExpression.getCaretPosition();
        if (this.canInsert(ch)) {
            if (ch != '(') {
                if (ch == 'i') {
                    RPTItemInfo item = (RPTItemInfo)this.mltRptItemF7.getValue();
                    if (item != null) {
                        txtInsert = item.getNumber().toString().trim();
                    }
                } else {
                    txtInsert = Character.toString(ch);
                }
                this.txtExpression.insert(txtInsert, pos);
            } else {
                this.txtExpression.insert("()", pos);
                this.txtExpression.setCaretPosition(pos + 1);
            }
        }
    }

    private boolean canInsert(char ch) {
        boolean res = false;
        String line = this.txtExpression.getText();
        String regexp = null;
        if (ch == 'i') {
            regexp = "[\\+|\\-|\\*|\\/]{1}+";
        } else if (ch == '+' || ch == '-' || ch == '*' || ch == '/') {
            regexp = "[^\\+|^\\-|^\\*|^\\/|^\\s]{1,}";
        }
        Pattern pt = Pattern.compile(regexp);
        Matcher matcher = pt.matcher(line);
        int scanIndex = line.length() == 0 ? line.length() : line.length() - 1;
        res = matcher.find(scanIndex) | (ch == 'i' && line.length() == 0);
        return res;
    }

    private boolean checkFormula(String s) throws EASBizException {
        if (s == null || s.length() == 0) {
            return true;
        }
        SumItemFormula parser = new SumItemFormula(s);
        try {
            parser.formulaLine();
        }
        catch (Exception e) {
            return false;
        }
        catch (TokenMgrError e) {
            throw new EASBizException(new NumericExceptionSubItem("1", e.getMessage()));
        }
        return true;
    }

    private boolean _checkFormula(String s) {
        if (s == null || s.length() == 0) {
            return true;
        }
        String ms = null;
        Pattern pt = null;
        Matcher matcher = null;
        ms = "[\\+]{2,}";
        pt = Pattern.compile(ms);
        matcher = pt.matcher(s);
        if (matcher.find()) {
            return false;
        }
        ms = "[\\+|\\s]{1,}[//s]*[\\+|\\s]{1,}";
        pt = Pattern.compile(ms);
        matcher = pt.matcher(s);
        if (matcher.find()) {
            return false;
        }
        ms = "[\\+]{1,}";
        pt = Pattern.compile(ms);
        matcher = pt.matcher(s);
        if (matcher.lookingAt()) {
            return false;
        }
        ms = "[^\\+|^\\-|^\\s]{1,}";
        pt = Pattern.compile(ms);
        matcher = pt.matcher(s);
        int index = -1;
        while (matcher.find()) {
            index = matcher.end();
        }
        return index == -1 || !(matcher = (pt = Pattern.compile(ms = "[\\+]{1,}")).matcher(s)).find(index);
    }
}

