/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import bsh.ParseException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslParamFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportRelaInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataRepairUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DynaKeyAndValue;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportCalculator;
import com.kingdee.eas.fi.gr.cslrpt.ICslReportRela;
import com.kingdee.eas.fi.gr.cslrpt.ICslRptCalculator;
import com.kingdee.eas.fi.gr.cslrpt.ISumRptRela;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.OrderByEnum;
import com.kingdee.eas.fi.gr.cslrpt.SumCalculateMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.SumRptRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractSumRptCalculateGuideForMultiUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaRptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaRptStyle;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.cslrpt.util.SumHelper;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynaGradeSettingAdviserImpl;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.dynamic.util.PointXComparator;
import com.kingdee.eas.fi.gr.dynamic.util.PointYComparator;
import com.kingdee.eas.fi.newrpt.client.designer.ReportDesignerUI;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptSumTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Area3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import junit.framework.Assert;
import org.apache.log4j.Logger;

public class SumRptCalculateGuideForMultiUI
extends AbstractSumRptCalculateGuideForMultiUI {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.client.SumRptCalculateGuideForMultiUI");
    protected CslReportInfo curReport;
    protected Book curSheets;
    private OrgTreeInfo orgTree;
    private OrgUnitInfo parentCompany;
    protected boolean isCancel = true;
    private boolean isDynaSum = false;
    private Object[] dynaSumMethod = null;
    public static final char DONE = '\u0000';
    private boolean dyRptCalcOnlyLISTAll = false;
    private boolean onlyHasGrade = false;
    private static final Color lightblue = new Color(153, 204, 255);
    private boolean isDyRptSaveUpdateItem4CM = false;
    private boolean isSortByNumber = false;
    private int initValue = 0;

    public SumRptCalculateGuideForMultiUI() throws Exception {
        this.btnGroup.add((AbstractButton)this.btnByItems);
        this.btnGroup.add((AbstractButton)this.btnBySheets);
        this.isDynaSum = CslRptUtil.getCslParamForDynamicSumRpt(null);
        this.isDyRptSaveUpdateItem4CM = CSLParamUtil.isDyRptSaveUpdateItem4CM(null);
        this.dynaSumMethod = CSLParamUtil.getDynaSumMethod(null);
        this.dyRptCalcOnlyLISTAll = CSLParamUtil.isDyRptCalcOnlyLISTAll(this.dynaSumMethod);
        this.isSortByNumber = CSLParamUtil.getBooleanCslParamValue(null, "dynaCslOrSumRptCalcByNumber");
    }

    private HashSet getSourceTemplateGroups(String sumTemplateID) {
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entityView.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("targetTemplet", (Object)sumTemplateID));
        entityView.getSelector().add(new SelectorItemInfo("sourceTemplet.group"));
        CoreBaseCollection relas = null;
        try {
            ICslReportRela rptRela = CslReportRelaFactory.getRemoteInstance();
            relas = rptRela.getCollection(entityView);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        if (relas == null || relas.size() == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (CslReportRelaInfo reportRela : relas) {
            result.add(reportRela.getSourceTemplet().getGroup());
        }
        return result;
    }

    public HashMap constructTableMap(Sheet table) {
        if (table == null) {
            return null;
        }
        HashMap<Point, ItemFormula> result = new HashMap<Point, ItemFormula>();
        Sheet.ICellsIterator it = table.getCellsIterator(null, false, true);
        while (it.hasNext()) {
            Cell cell = it.next();
            ItemFormula curFormula = (ItemFormula)cell.getUserObjectValue("ITEM");
            if (curFormula == null || !curFormula.isValidity()) continue;
            curFormula.setCell(null);
            Point position = new Point(cell.getCol(), cell.getRow());
            result.put(position, curFormula);
        }
        return result;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.cbOnlyList.setEnabled(false);
        this.initData();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnDeselectAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectAll.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"818_SumRptCalculateGuideUI_SelectAll"));
        this.btnDeselectAll.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"819_SumRptCalculateGuideUI_DeselectAll"));
        ReportDesignerUI processUI = (ReportDesignerUI)this.getUIContext().get("Owner");
        CslReportInfo report = (CslReportInfo)processUI.getBookProvider().getEditValue();
        if (!(report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE))) {
            this.contSumMethod.setVisible(false);
            this.cbOnlyList.setVisible(false);
            this.contDisplayNumber.setVisible(false);
        } else if (report.getTemplate().getDynaRptType().equals((Object)DynaEnumRptTypeEnum.FIXED)) {
            this.comboSumMethod.removeAllItems();
            this.comboSumMethod.addItem((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE);
        }
        this.adjustUIInterface(report);
        if (report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE)) {
            this.btnSelectAll.doClick();
            this.btnSelectAll.setEnabled(false);
            this.btnDeselectAll.setEnabled(false);
            this.tblCompany.setEnabled(false);
            this.labelShadow.setVisible(true);
            this.contSumMethod.setVisible(false);
            this.contCalculateMethod.setVisible(false);
            this.cbOnlyList.setVisible(true);
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Dyn_CSL_Calculator"));
            this.cbxTypeShadow.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        SumRptCalculateGuideForMultiUI.this.comboSumMethod.setSelectedIndex(SumRptCalculateGuideForMultiUI.this.cbxTypeShadow.getSelectedIndex());
                    }
                }
            });
            if (report.getTemplate().getDynaRptType().equals((Object)DynaEnumRptTypeEnum.DYNAMIC)) {
                this.initComboSumMethod();
            } else {
                this.cbxTypeShadow.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Dyn_Csl_ByTemplate"));
            }
        }
        this.onlyHasGrade = true;
        if (!report.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
            block0: for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                Sheet sheet = this.curSheets.getSheet(i);
                ArrayList list = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
                for (int j = 0; j < list.size(); ++j) {
                    Point point = (Point)list.get(j);
                    DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)point);
                    if (param.isGrade()) continue;
                    this.onlyHasGrade = false;
                    continue block0;
                }
            }
        }
        if (report.getTemplate().getSumType().equals((Object)RptSumTypeEnum.BYPAGE)) {
            String oql = " where sumReportID = '" + this.curReport.getId().toString() + "' and sheetId <> 'empty_sheet'";
            ISumRptRela irela = SumRptRelaFactory.getRemoteInstance();
            if (irela.exists(oql)) {
                this.IncrementCal.setVisible(true);
                this.IncrementCal.setEditable(true);
                this.IncrementCal.setSelected(false);
                this.IncrementCal.setEnabled(true);
            } else {
                this.IncrementCal.setVisible(false);
                this.IncrementCal.setEditable(false);
                this.IncrementCal.setSelected(false);
                this.IncrementCal.setEnabled(false);
            }
        }
        if (this.isDyRptSaveUpdateItem4CM) {
            this.cbkShowTotal.setSelected(false);
            this.cbkShowTotal.setEnabled(false);
        }
        this.doComfirm();
    }

    protected void doComfirm() throws Exception {
        if (this.getUIContext().get("isShowGuide") != null && !((Boolean)this.getUIContext().get("isShowGuide")).booleanValue()) {
            this.btnComfirm_actionPerformed(null);
            this.destroyWindow();
        }
    }

    private void initComboSumMethod() {
        if (this.dyRptCalcOnlyLISTAll) {
            this.cbxTypeShadow.addItem((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME.getAlias());
            this.comboSumMethod.setSelectedItem((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME);
            this.cbkOnlyListCompany.setEnabled(false);
            return;
        }
        this.comboSumMethod.removeAllItems();
        this.comboSumMethod.addItems(this.dynaSumMethod);
        for (int i = 0; i < this.dynaSumMethod.length; ++i) {
            Object enum1 = this.dynaSumMethod[i];
            if (DynaSumMethodEnum.SUM_BY_NAME.equals(enum1)) {
                this.cbxTypeShadow.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Dyn_Csl_ByName"));
                continue;
            }
            if (DynaSumMethodEnum.SUM_BY_COMPANY.equals(enum1)) {
                this.cbxTypeShadow.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Dyn_Csl_ByCompany"));
                continue;
            }
            if (DynaSumMethodEnum.SUM_BY_TEMPLATE.equals(enum1)) {
                this.cbxTypeShadow.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"Dyn_Csl_ByTemplate"));
                continue;
            }
            if (DynaSumMethodEnum.LIST_NAME_COMPANY.equals(enum1)) {
                this.cbxTypeShadow.addItem((Object)DynaSumMethodEnum.LIST_NAME_COMPANY.getAlias());
                continue;
            }
            if (DynaSumMethodEnum.LIST_COMPANY_NAME.equals(enum1)) {
                this.cbxTypeShadow.addItem((Object)DynaSumMethodEnum.LIST_COMPANY_NAME.getAlias());
                continue;
            }
            if (!DynaSumMethodEnum.LIST_DETAIL_COMP_NAME.equals(enum1)) continue;
            this.cbxTypeShadow.addItem((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME.getAlias());
        }
    }

    private void adjustUIInterface(CslReportInfo report) {
        int gene = -1;
        if (!(report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) || !report.getTemplate().getSumType().equals((Object)RptSumTypeEnum.BYPAGE))) {
            gene = 1;
        }
        if (!(report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) || !report.getTemplate().getSumType().equals((Object)RptSumTypeEnum.BYITEM))) {
            gene = 3;
        }
        if (gene == -1) {
            return;
        }
        int h = (this.contSumMethod.getHeight() + 3) * gene;
        Rectangle r = this.kDSeparator1.getBounds();
        r.y -= h;
        this.kDSeparator1.setBounds(r);
        r = this.btnComfirm.getBounds();
        r.y -= h;
        this.btnComfirm.setBounds(r);
        r = this.btnCancel.getBounds();
        r.y -= h;
        this.btnCancel.setBounds(r);
        r = this.getBounds();
        r.height -= h;
        this.setBounds(r);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
        this.getUIContext().put("isCancelCalculateGuideUI", Boolean.TRUE);
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.isCancel) {
            this.getUIContext().put("isCancelCalculateGuideUI", Boolean.TRUE);
        }
        return super.checkBeforeWindowClosing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void btnComfirm_actionPerformed(ActionEvent e) throws Exception {
        HashMap ret;
        super.btnComfirm_actionPerformed(e);
        Map ownerContext = ((CoreUIObject)this.getUIContext().get("Owner")).getUIContext();
        Boolean isCalcSinglePage = (Boolean)ownerContext.get("KEY_CALCULATESINGLEPAGE");
        boolean isCalcSingle = isCalcSinglePage != null && isCalcSinglePage != false;
        boolean isAutoCal = this.curSheets.isAutoCalculate();
        if (isAutoCal) {
            this.curSheets.setAutoCalculate(false);
        }
        this.isCancel = false;
        int sumType = -1;
        if (this.curReport.getTemplate() != null && this.curReport.getTemplate().getSumType() != null) {
            sumType = this.curReport.getTemplate().getSumType().getValue();
            if (sumType == 2) {
                this.btnByItems.setSelected(true);
            } else if (sumType == 1) {
                this.btnBySheets.setSelected(true);
            }
        } else {
            throw new Exception("SumReport's template information is null!");
        }
        int precision = CslRptUIUtil.getPrecisionByCry(this.curReport.getCurrency());
        Vector vecSelectedCompanys = this.getSelectedCompanys();
        ICslRptCalculator calculator = CslRptCalculatorFactory.getRemoteInstance();
        Vector<OrgUnitInfo> companys = new Vector<OrgUnitInfo>(0);
        Vector<String> companyIDs = new Vector<String>(0);
        for (OrgUnitInfo company : vecSelectedCompanys) {
            companyIDs.add(company.getNumber());
            companys.add(company);
        }
        if (!this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) && !this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE)) {
            HashMap<String, Serializable> m = new HashMap<String, Serializable>();
            m.put("report", this.curReport);
            m.put("companys", companys);
            m.put("bySumReport", this.contCalculateMethod.isVisible() ? (((SumCalculateMethodEnum)((Object)this.comboSumCalculateMethod.getSelectedItem())).equals((Object)SumCalculateMethodEnum.BySumReport) ? Boolean.TRUE : Boolean.FALSE) : Boolean.TRUE);
            if (this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
                m.put("isListCompany", Boolean.valueOf(this.cbkOnlyListCompany.isSelected()));
            }
            if ((ret = calculator.checkSumRptRule(m)) != null && (Integer)ret.get("noConfirmCount") > 0 && MsgBox.showConfirm3a((Component)((Object)this), (String)CslRptUtil.getStringWithFormatCR("SumRpt_calculateHint", new Object[]{ret.get("companySize") != null ? ret.get("companySize") : new Integer(companyIDs.size()), ret.get("noConfirmCount")}), (String)(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SumRpt_NoConfirmCompany") + (String)ret.get("detail"))) == 2) {
                return;
            }
        }
        if (this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE)) {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put("report", this.curReport);
            map.put("companys", companys);
            map.put("bySumReport", Boolean.FALSE);
            ret = calculator.checkSumRptRule(map);
            if (ret != null && (Integer)ret.get("noConfirmCount") > 0 && MsgBox.showConfirm3a((Component)((Object)this), (String)CslRptUtil.getStringWithFormatCR("CslRpt_calculateHint", new Object[]{new Integer(companyIDs.size()), ret.get("noConfirmCount")}), (String)(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SumRpt_NoConfirmCompany") + (String)ret.get("detail"))) == 2) {
                return;
            }
        }
        if (isCalcSinglePage != null && isCalcSinglePage.booleanValue()) {
            Map<String, Vector<OrgUnitInfo>> data = new HashMap();
            if (ownerContext.containsKey("singlePageCompanyIds")) {
                data = (Map)ownerContext.get("singlePageCompanyIds");
            }
            String sheetName = this.curSheets.getActiveSheet().getSheetName();
            data.put(sheetName, companys);
            ownerContext.put("singlePageCompanyIds", data);
        } else {
            ownerContext.remove("singlePageCompanyIds");
            ownerContext.put("companyIds", companys);
        }
        DynaSumMethodEnum sumMethod = (DynaSumMethodEnum)((Object)this.comboSumMethod.getSelectedItem());
        DynaRptStyle dynaRptStyle = new DynaRptStyle(null, this.curReport, this.curSheets, sumMethod, isCalcSingle);
        dynaRptStyle.getDynaRptStyle();
        boolean includeDiffTable = this.cbkIncludeDiffTable.isSelected();
        ((CoreUIObject)this.getUIContext().get("Owner")).getUIContext().put("includeDiffTable", new Boolean(includeDiffTable));
        if (!(this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE))) {
            if (this.btnBySheets.isSelected()) {
                CslRptUIUtil.clearSheetSumCellData(this.curSheets);
                if (this.isDynaSum) {
                    CslRptUIUtil.clearSheetDynaCellData(this.curSheets);
                }
            } else {
                CslRptUIUtil.clearCellData(this.curSheets, true, false);
            }
        }
        if (this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
            HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
            HashMap<String, Map> tableValues = new HashMap<String, Map>();
            DynaSumMethodEnum selectedItem = (DynaSumMethodEnum)((Object)this.comboSumMethod.getSelectedItem());
            if (selectedItem == null) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"690_SumRptCalculateGuideUI"));
                SysUtil.abort();
            }
            boolean onlyList = this.cbOnlyList.isSelected();
            boolean isShowTotal = this.cbkShowTotal.isSelected() && this.cbkShowTotal.isEnabled();
            boolean isOnlyListCompany = this.cbkOnlyListCompany.isSelected() && this.cbkOnlyListCompany.isEnabled();
            for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                Sheet table = this.curSheets.getSheet(i);
                if (!table.isEnableCalculation()) continue;
                Map tableMap = this.getTableMap(selectedItem, onlyList, isShowTotal, isOnlyListCompany, table);
                DynamicTemplateUtility.setSheetSumMethod((Sheet)table, (DynaSumMethodEnum)selectedItem);
                if (table == null) continue;
                tables.put(table.getID(), table);
                tableValues.put(table.getID(), tableMap);
            }
            ICSLReportCalculator ie = CSLReportCalculatorFactory.getRemoteInstance();
            ArrayList<String> companyList = new ArrayList<String>();
            for (OrgUnitInfo company : vecSelectedCompanys) {
                companyList.add(company.getId().toString());
            }
            Map sumResult = null;
            sumResult = this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) ? ie.calculateDynaSumRpt(this.curReport.getId().toString(), companyList, tableValues, true, false) : (this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) ? this.calcMultiDynaSumRpt(this.curReport.getId().toString(), companyList, tableValues) : ie.calculateDynaSumRpt(this.curReport.getId().toString(), companyList, tableValues, false, includeDiffTable));
            if (sumResult != null && !this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
                this.curSheets.setUserObject("sumResult", (Object)sumResult);
            }
            boolean isAutoCalculate = false;
            Sheet sheet = null;
            try {
                DynaItemListener.setExeFlag((boolean)false);
                this.curSheets.getUndoManager().enable(false);
                this.curSheets.getUndoManager().startGroup();
                isAutoCalculate = this.curSheets.isAutoCalculate();
                this.curSheets.setAutoCalculate(false);
                if (!this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
                    DynamicTemplateUtility.clearDynaTableFirst((Book)this.curSheets);
                }
                this.fillDynaData(this.curReport.getSourceType(), tables, tableValues, sumResult, precision);
            }
            finally {
                this.curSheets.setAutoCalculate(isAutoCalculate);
                this.curSheets.getUndoManager().endGroup();
                this.curSheets.getUndoManager().enable(true);
                DynaItemListener.setExeFlag((boolean)true);
            }
            ownerContext.put("DynaSumMethod", selectedItem);
            ownerContext.put("onlyList", onlyList);
            if (sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_NAME) && !this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
                for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                    sheet = this.curSheets.getSheet(i);
                    DataRepairUtil.repairDynGradeParamByActualTableData(sheet);
                }
            }
        } else if (this.btnByItems.isSelected()) {
            HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
            HashMap<String, HashMap> tableValues = new HashMap<String, HashMap>();
            for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                Sheet table = this.curSheets.getSheet(i);
                if (!table.isEnableCalculation()) continue;
                HashMap tableMap = this.constructTableMap(table);
                if (table == null) continue;
                tables.put(table.getID(), table);
                tableValues.put(table.getID(), tableMap);
            }
            ICSLReportCalculator ie = CSLReportCalculatorFactory.getRemoteInstance();
            Map sumResult = ie.calculateSumRptByItem((IObjectPK)new ObjectUuidPK(this.curReport.getId()), companyIDs, tableValues, includeDiffTable, this.contCalculateMethod.isVisible() ? ((SumCalculateMethodEnum)((Object)this.comboSumCalculateMethod.getSelectedItem())).equals((Object)SumCalculateMethodEnum.BySumReport) : true, this.curReport.getDataCollectNumber());
            CslRptUIUtil.refreshTableData(tables, sumResult, precision);
        } else if (this.btnBySheets.isSelected()) {
            // empty if block
        }
        dynaRptStyle.resetDynaRptStyle();
        if (isAutoCal) {
            this.curSheets.setAutoCalculate(isAutoCal);
        }
        this.getUIContext().put("bySumReport", this.contCalculateMethod.isVisible() ? (((SumCalculateMethodEnum)((Object)this.comboSumCalculateMethod.getSelectedItem())).equals((Object)SumCalculateMethodEnum.BySumReport) ? Boolean.TRUE : Boolean.FALSE) : Boolean.TRUE);
        this.destroyWindow();
    }

    protected Map getTableMap(DynaSumMethodEnum selectedItem, boolean onlyList, boolean isShowTotal, boolean isOnlyListCompany, Sheet table) {
        Map tableMap = SumHelper.scanDynaTable(table, selectedItem, onlyList, isShowTotal, isOnlyListCompany);
        return tableMap;
    }

    protected void replaceBookByTemplate(CslReportInfo curReport) throws Exception {
        Book book = this.getTemplateBook(curReport);
        CslRptUIUtil.getDynaKeyAndValue(book);
        CslRptUIUtil.setFormulaLocation(book);
        this.addSheet(book, this.curSheets);
    }

    private Book getTemplateBook(CslReportInfo cslreportInfo) throws Exception {
        Book tempBook = cslreportInfo.getTemplate().getBook();
        if (tempBook == null) {
            String id = cslreportInfo.getTemplate().getId().toString();
            TemplateInfo info = TemplateFactory.getRemoteInstance().getTemplateInfo("select data where id='" + id + "'");
            tempBook = info.getBook();
        }
        return tempBook;
    }

    private void addSheet(Book templateBook, Book book) {
        int actSh = book.getActiveSheetIndex();
        if (templateBook != null && book != null) {
            book.addSheet(new Sheet(book, "&&&"));
            for (int j = 0; j < templateBook.getSheetCount(); ++j) {
                Sheet tmpsheet = templateBook.getSheet(j);
                Sheet sheet = book.getSheet(tmpsheet.getSheetName());
                if (sheet == null || !sheet.isEnableCalculation()) continue;
                int index = sheet.getSheetIndex();
                book.removeSheet(index);
                book.insertSheet(index, tmpsheet);
                tmpsheet.updateUnknownMethod(book.getDeps().getUnknownMethodManager());
            }
            book.removeSheet("&&&");
            book.activeSheet(actSh);
            book.getSheet(actSh).setSelected(true);
        }
    }

    protected void sumDynaData(ArrayList reportIDs, int count, ICslRptCalculator calculator, ArrayList rptList, Map sheetIDs, Map dynaSumRange, HashMap tables, int precision) throws Exception {
        HashMap sumdynaSheets = null;
        HashMap dynaOrder = null;
        int n = reportIDs.size();
        for (int i = 0; i < n; ++i) {
            if (count < 2) {
                rptList.add(reportIDs.get(i));
                ++count;
                continue;
            }
            HashMap result = calculator.calculateSumRptByDynaSheets(rptList, sheetIDs, dynaSumRange, sumdynaSheets, dynaOrder);
            if (result == null) {
                sumdynaSheets = null;
                dynaOrder = null;
            } else {
                sumdynaSheets = result.get("dynaSumRange") == null ? null : (HashMap)result.get("dynaSumRange");
                dynaOrder = result.get("order") == null ? null : (HashMap)result.get("order");
            }
            this.refreshTableData(tables, result, precision);
            rptList = new ArrayList();
            rptList.add(reportIDs.get(i));
            count = 0;
        }
        if (rptList.size() > 0) {
            HashMap result = calculator.calculateSumRptByDynaSheets(rptList, sheetIDs, dynaSumRange, sumdynaSheets, dynaOrder);
            this.refreshTableData(tables, result, precision);
            this.refreshDynaTableData(this.curSheets, tables, result, precision, dynaSumRange);
        }
    }

    private String getDiffTableReportId(CslReportInfo info) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.isGrouping"));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)info.getOrgTree().getId().toString()));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)info.getOrgUnit().getNumber()));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(info.getYear())));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(info.getPeriod())));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("template.group", (Object)info.getTemplate().getGroup()));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(8)));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("currency", (Object)info.getCurrency().getId().toString()));
        try {
            CslReportInfo diffTable = CslReportFactory.getRemoteInstance().getCslReportInfo(viewInfo.toString());
            if (diffTable != null) {
                return diffTable.getId().toString();
            }
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        return null;
    }

    protected void refreshTableData(Map sheets, Map sheetData, int precision) throws Exception {
        if (sheets == null || sheets.size() == 0 || sheetData == null || sheetData.size() == 0) {
            return;
        }
        HashMap sumBySheet = (HashMap)sheetData.get("sumBySheet");
        if (sumBySheet == null || sumBySheet.size() == 0) {
            return;
        }
        for (String tableID : sumBySheet.keySet()) {
            if (tableID == null || tableID.trim().length() == 0) continue;
            Sheet curSheet = (Sheet)sheets.get(tableID);
            HashMap curSheetData = (HashMap)sumBySheet.get(tableID);
            if (curSheetData == null || curSheetData.size() == 0) continue;
            Iterator iterCell = curSheetData.keySet().iterator();
            Object o = null;
            HashMap v = null;
            Cell cell = null;
            while (iterCell.hasNext()) {
                BigDecimal cellValue;
                Point position = (Point)iterCell.next();
                cell = curSheet.getCell(position.y, position.x, true);
                Variant oldValue = cell.getValue();
                BigDecimal old = null;
                try {
                    old = oldValue.toBigDecimal();
                }
                catch (Exception e) {
                    old = new BigDecimal("0");
                }
                Variant varValue = null;
                o = curSheetData.get(position);
                if (o != null && o instanceof HashMap) {
                    v = (HashMap)curSheetData.get(position);
                    if (v != null && v.get("value") != null) {
                        cellValue = (BigDecimal)v.get("value");
                        varValue = new Variant((Object)cellValue.add(old));
                    } else {
                        varValue = Variant.nullVariant;
                    }
                } else if (o != null) {
                    cellValue = o;
                    varValue = new Variant((Object)cellValue.add(old));
                } else {
                    varValue = Variant.nullVariant;
                }
                if (varValue == null) {
                    varValue = Variant.nullVariant;
                }
                cell.setValue(varValue);
                if (cell.getFormula() == null || cell.getFormula().equals("")) continue;
                cell.setUserObject("cellValue", cell.getValue().getValue());
            }
        }
    }

    private boolean IsAlNum(char c) {
        return Character.isLetter(c) || Character.isDigit(c);
    }

    private boolean isSBC_Case_Symbol(char c) {
        switch (c) {
            case '\u201c': 
            case '\u3001': 
            case '\uff03': 
            case '\uff04': 
            case '\uff05': 
            case '\uff06': 
            case '\uff07': 
            case '\uff08': 
            case '\uff09': 
            case '\uff0a': 
            case '\uff0b': 
            case '\uff0c': 
            case '\uff0d': 
            case '\uff0e': 
            case '\uff0f': 
            case '\uff1a': 
            case '\uff1b': 
            case '\uff1c': 
            case '\uff1d': 
            case '\uff1e': 
            case '\uff1f': 
            case '\uff20': 
            case '\uff3b': 
            case '\uff3d': 
            case '\uff3f': 
            case '\uff40': 
            case '\uff5b': 
            case '\uff5c': 
            case '\uff5d': 
            case '\uff5e': {
                return true;
            }
        }
        return false;
    }

    private DynaKeyValue decompose(String key) {
        DynaKeyValue dynaKeyValue = new DynaKeyValue();
        StringBuffer k = new StringBuffer();
        if (key != null && key.length() > 0) {
            int j = 0;
            for (int i = 0; i < key.length(); ++i) {
                if (key.charAt(i) == '&') {
                    if (++j == 1) {
                        dynaKeyValue.range = new Integer(k.toString());
                        k = new StringBuffer();
                    }
                    if (j != 2) continue;
                    dynaKeyValue.dynaKey = k.toString();
                    k = new StringBuffer();
                    continue;
                }
                if (j < 1) {
                    k.append(key.charAt(i));
                }
                if (j != 1) continue;
                k.append(key.charAt(i));
            }
            int last = key.lastIndexOf("&");
            String dynaValueRow = key.substring(last + 1, key.length());
            dynaKeyValue.dynaValueCol = new Integer(dynaValueRow);
        }
        return dynaKeyValue;
    }

    protected void fillDynaData(RptSrcTypeEnum rptSrcTypeEnum, Map tables, Map tableItem, Map sumResult, int precision) throws Exception {
        int selectedSize = (Integer)this.spnDisplayNumber.getValue();
        if (selectedSize <= 0) {
            selectedSize = this.initValue;
        }
        if (!this.spnDisplayNumber.isEnabled()) {
            selectedSize = -1;
        }
        DynaSumMethodEnum sumMethod = (DynaSumMethodEnum)((Object)this.comboSumMethod.getSelectedItem());
        TemplateInfo templateInfo = TemplateFactory.getRemoteInstance().getTemplateInfo((IObjectPK)new ObjectUuidPK(this.curReport.getTemplate().getId()));
        Book book = templateInfo.getBook();
        Sheet templateTable = null;
        for (String sheetID : tables.keySet()) {
            if (!sumResult.containsKey(sheetID)) continue;
            if (book != null) {
                Sheet sheetByID;
                for (int i = 0; i < book.getSheetCount(); ++i) {
                    Sheet sheet = book.getSheet(i);
                    if (!sheetID.equals(sheet.getID())) continue;
                    templateTable = sheet;
                    break;
                }
                if (templateTable == null && (sheetByID = this.curSheets.getSheetByID(sheetID)) != null) {
                    templateTable = book.getSheet(sheetByID.getSheetName());
                }
            }
            Sheet table = (Sheet)tables.get(sheetID);
            Map sheetMap = (Map)sumResult.get(sheetID);
            HashMap<Point, String> templateFormulas = new HashMap<Point, String>();
            Object[] basePointArray = this.sortByPosistion(table, sheetMap.keySet());
            ArrayList templateBasePoints = null;
            if (sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_NAME)) {
                if (templateTable == null) continue;
                templateBasePoints = DynamicTemplateUtility.getBasePointList((Sheet)templateTable);
            }
            for (int n = basePointArray.length - 1; n >= 0; --n) {
                boolean isSumByName;
                Point basePoint = (Point)basePointArray[n];
                int baseLine = 0;
                DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)table, (Point)basePoint);
                if (param == null) continue;
                if (rptSrcTypeEnum == RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) {
                    this.fillMultiSumData(param, basePoint, table, (Map)sheetMap.get(basePoint), selectedSize);
                    continue;
                }
                DItemGradeInfo gradeInfo = this.getTemplateGradeInfo(table, basePoint, param);
                boolean isShowTotal = this.cbkShowTotal.isSelected() && this.cbkShowTotal.isEnabled() && !param.isGrade() && (param.getOrderBy().equals((Object)OrderByEnum.NONE) || param.getOrderRow() <= 0);
                boolean isTextGrade = param.isGrade() && param.getDynaItemSource() == 0;
                boolean bl = isSumByName = sumMethod == DynaSumMethodEnum.SUM_BY_NAME;
                if (isTextGrade && (sumMethod == DynaSumMethodEnum.SUM_BY_NAME || sumMethod == DynaSumMethodEnum.LIST_NAME_COMPANY)) {
                    DynamicTemplateUtility.copyBasePointRangeForGrade((Sheet)templateTable, (Sheet)table, (Object[])basePointArray, (List)templateBasePoints, (int)n, (boolean)isSumByName);
                    this.fillTextGradeData(basePoint, table, (Map)sheetMap.get(basePoint), gradeInfo, selectedSize, true, true, true);
                    continue;
                }
                if (isTextGrade && this.cbOnlyList.isSelected() && sumMethod != DynaSumMethodEnum.SUM_BY_TEMPLATE) {
                    if (sumMethod != DynaSumMethodEnum.SUM_BY_COMPANY) {
                        DynamicTemplateUtility.copyBasePointRangeForGrade((Sheet)templateTable, (Sheet)table, (Object[])basePointArray, (List)templateBasePoints, (int)n, (boolean)isSumByName);
                    }
                    this.fillTextGradeData(basePoint, table, (Map)sheetMap.get(basePoint), gradeInfo, selectedSize, false, false, this.cbOnlyList.isSelected());
                    continue;
                }
                if (isTextGrade && (sumMethod == DynaSumMethodEnum.LIST_COMPANY_NAME || sumMethod == DynaSumMethodEnum.LIST_DETAIL_COMP_NAME) && !this.cbOnlyList.isSelected()) {
                    this.fillTextCompany_Name(basePoint, table, (Map)sheetMap.get(basePoint), gradeInfo, selectedSize);
                    continue;
                }
                boolean isHorizon = param.getSpreadStyle() == 1;
                boolean isLeftUp = param.getPosition() == 1;
                DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, table, true, true);
                int beforeDynaItemCount = indexHandle.getBeforeDynaItemSumRangeCount();
                Map nameMap = (Map)sheetMap.get(basePoint);
                Set keySet = nameMap.keySet();
                Iterator<Object> iter3 = null;
                ArrayList<Object> resultListBySort = null;
                if (sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) {
                    iter3 = keySet.iterator();
                } else {
                    if (param.isGrade() || !param.getOrderBy().equals((Object)OrderByEnum.NONE) && param.getOrderRow() == 0 || param.getOrderBy().equals((Object)OrderByEnum.NONE) && (sumMethod.equals((Object)DynaSumMethodEnum.LIST_COMPANY_NAME) || sumMethod.equals((Object)DynaSumMethodEnum.LIST_NAME_COMPANY) || sumMethod.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME) || sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_NAME))) {
                        int i;
                        Object[] array = keySet.toArray();
                        Comparator comparator = null;
                        if (!isTextGrade || !DynaSumMethodEnum.SUM_BY_NAME.equals((Object)sumMethod)) {
                            comparator = this.isSortByNumber ? new DyNumberComparetor(nameMap) : new ChinaComparetor(Collator.getInstance(Locale.CHINA));
                        }
                        ArrayList<Object> arr = new ArrayList<Object>();
                        int size = array.length;
                        for (int i2 = 0; i2 < size; ++i2) {
                            if (array[i2] == null) continue;
                            arr.add(array[i2]);
                        }
                        array = arr.toArray();
                        Arrays.sort(array, comparator);
                        ArrayList<Object> list = new ArrayList<Object>();
                        if (comparator != null && param.getOrderBy().equals((Object)OrderByEnum.DESC)) {
                            for (i = array.length - 1; i >= 0; --i) {
                                list.add(array[i]);
                            }
                        } else {
                            for (i = 0; i < array.length; ++i) {
                                list.add(array[i]);
                            }
                        }
                        resultListBySort = list;
                    } else if (!param.getOrderBy().equals((Object)OrderByEnum.NONE) && param.getOrderRow() > 0) {
                        ArrayList<Object> list;
                        Point sortedPoint = null;
                        boolean isHead = false;
                        if (param.getOrderRow() > 0) {
                            sortedPoint = isHorizon ? new Point(basePoint.x, basePoint.y + param.getOrderRow()) : new Point(basePoint.x + param.getOrderRow(), basePoint.y);
                        } else {
                            sortedPoint = basePoint;
                            isHead = true;
                        }
                        resultListBySort = list = this.getSortedMap(nameMap, sortedPoint, param.getOrderBy(), isHead);
                    } else {
                        resultListBySort = Arrays.asList(keySet.toArray());
                    }
                    iter3 = resultListBySort.iterator();
                }
                int rowFixed = isHorizon ? basePoint.y : basePoint.y + 1 + beforeDynaItemCount;
                int colFixed = isHorizon ? basePoint.x + 1 + beforeDynaItemCount : basePoint.x;
                Cell cellFixed = table.getCell(rowFixed, colFixed, true);
                CslReportInfo report = this.curReport;
                int actualSize = this.getActualSize(nameMap, resultListBySort, isShowTotal);
                if (report.getTemplate().getDynaRptType().equals((Object)DynaEnumRptTypeEnum.DYNAMIC) && !sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) {
                    if (actualSize > selectedSize && selectedSize > 0) {
                        actualSize = selectedSize;
                    }
                    int size = param.getDefaultCounter();
                    if (actualSize == 0) {
                        actualSize = size;
                    }
                    baseLine = isHorizon ? basePoint.x + 1 + beforeDynaItemCount : basePoint.y + 1 + beforeDynaItemCount;
                    int itemFormulaCount = 0;
                    int startIndex = 0;
                    if (isHorizon) {
                        itemFormulaCount = DynamicTemplateUtility.getRowCount((Sheet)table, (int)basePoint.y, (int)basePoint.x);
                        startIndex = basePoint.y;
                    } else {
                        itemFormulaCount = DynamicTemplateUtility.getColCount((Sheet)table, (int)basePoint.y, (int)basePoint.x);
                        startIndex = basePoint.x;
                    }
                    if (param.getDynaItemShowType() == 1) {
                        --startIndex;
                    }
                    if (!param.getIsFirst() && !param.isGrade() && size > 0) {
                        this.clearSelfDefineFormula(baseLine, startIndex, itemFormulaCount, table, param.getSpreadStyle());
                    }
                    if (actualSize != size) {
                        int insertStart;
                        int insertend;
                        int insertend2;
                        int insertStart2;
                        int diff = actualSize - size;
                        boolean isInsert = diff > 0;
                        diff = Math.abs(diff);
                        if (isHorizon) {
                            if (isInsert) {
                                insertStart2 = basePoint.x + size + beforeDynaItemCount + 1;
                                insertend2 = insertStart2 + diff - 1;
                                UserObjectHelper.getUnprotectedRange((Range)table.getColRange(insertStart2, insertend2)).insert(false, InsertType.FLLOW_UP_STYLE);
                            } else {
                                insertend = basePoint.x + size + beforeDynaItemCount;
                                insertStart = insertend - diff + 1;
                                UserObjectHelper.getUnprotectedRange((Range)table.getColRange(insertStart, insertend)).delete();
                            }
                        } else if (isInsert) {
                            insertStart2 = basePoint.y + size + beforeDynaItemCount + 1;
                            insertend2 = insertStart2 + diff - 1;
                            UserObjectHelper.getUnprotectedRange((Range)table.getRowRange(insertStart2, insertend2)).insert(true, InsertType.FLLOW_UP_STYLE);
                        } else {
                            insertend = basePoint.y + size + beforeDynaItemCount;
                            insertStart = insertend - diff + 1;
                            UserObjectHelper.getUnprotectedRange((Range)table.getRowRange(insertStart, insertend)).delete();
                        }
                        param.setDefaultCounter(actualSize);
                        indexHandle.autoAdjustSum(param, !isHorizon, itemFormulaCount);
                        DynamicTemplateUtility.saveParametersToCell((Range)UserObjectHelper.getUnprotectedRange((Range)table.getRange(basePoint.y, basePoint.x)), (DynaParameters)param);
                    }
                }
                if (!sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) {
                    int i = 0;
                    int childCount = -1;
                    boolean enterNoBranchRange = false;
                    int first = baseLine;
                    ArrayList<Integer> totalLine = new ArrayList<Integer>();
                    String companyName = null;
                    while (iter3.hasNext()) {
                        int StartRowCol;
                        if (!isTextGrade || sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY)) {
                            if (i > actualSize - 1) {
                                break;
                            }
                        } else {
                            param.setDefaultCounter(nameMap.size());
                            DynamicTemplateUtility.saveParametersToCell((Range)UserObjectHelper.getUnprotectedRange((Range)table.getRange(basePoint.y, basePoint.x)), (DynaParameters)param);
                        }
                        String number = (String)iter3.next();
                        Map map = (Map)nameMap.get(number);
                        String name = (String)map.get("KEY_DITEM_NAME");
                        String numberShow = (String)map.get("KEY_DITEM_SHOW_NUMBER");
                        Map pointMap = (Map)map.get("KEY_POINT_VALUE");
                        String grade = (String)map.get("GRADE_NUMBER");
                        String comp = (String)map.get("COMPANY_NAME");
                        if (companyName == null) {
                            companyName = comp;
                        }
                        if ((comp == null && companyName != null || comp != null && !comp.equals(companyName)) && isShowTotal) {
                            int StartRowCol2;
                            int end = baseLine + i - 1;
                            companyName = comp;
                            totalLine.add(new Integer(end + 1));
                            int row = isHorizon ? basePoint.y : baseLine + i;
                            int col = isHorizon ? baseLine + i : basePoint.x;
                            Cell cell = table.getCell(row, col, true);
                            cell.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"317_AfterElimReportUI")));
                            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
                            sa.setBackground(lightblue);
                            cell.setSSA((ShareStyleAttributes)sa);
                            cell.setUserObject("isSum", (Object)"Y");
                            int maxRowCol = isHorizon ? table.getMaxColIndex() : table.getMaxColIndex();
                            for (int j = StartRowCol2 = isHorizon ? basePoint.y + 1 : basePoint.x + 1; j <= maxRowCol; ++j) {
                                Range range = UserObjectHelper.getUnprotectedRange((Range)(isHorizon ? table.getRange(j, basePoint.x) : table.getRange(basePoint.y, j)));
                                ItemFormula itemformula = (ItemFormula)range.getUserObject("ITEM");
                                if (itemformula == null || itemformula.getValueType() == 3) continue;
                                Cell cell2 = cell = isHorizon ? table.getCell(j, baseLine + i, true) : table.getCell(baseLine + i, j, true);
                                if (cell == null) continue;
                                String cellStart = isHorizon ? Location.getCellName(j, first) : Location.getCellName(first, j);
                                String cellEnd = isHorizon ? Location.getCellName(j, end) : Location.getCellName(end, j);
                                String formula = "=sum(" + cellStart + ":" + cellEnd + ")";
                                cell.setFormula(formula);
                                sa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
                                sa.setBackground(lightblue);
                                cell.setSSA((ShareStyleAttributes)sa);
                                cell.setUserObject("isSum", (Object)"Y");
                            }
                            first = end + 2;
                            ++i;
                        }
                        int row = isHorizon ? basePoint.y : baseLine + i;
                        int col = isHorizon ? baseLine + i : basePoint.x;
                        Cell cell = table.getCell(row, col, true);
                        Cell showNumberCell = table.getCell(isHorizon ? row - 1 : row, isHorizon ? col : col - 1, true);
                        if (cell != null) {
                            String nameShow = name;
                            if (param.isGrade()) {
                                if (gradeInfo != null && param.getDynaItemSource() == 0) {
                                    DItemGradeEntryInfo info = gradeInfo.findParent(grade);
                                    if (info != null) {
                                        nameShow = info.getIdentBlank() + info.getParentIndentBlank() + nameShow;
                                    }
                                    if ((info = gradeInfo.find(grade)) != null && !info.isLeaf()) {
                                        if (!info.hasBranchChildren()) {
                                            childCount = 0;
                                            enterNoBranchRange = true;
                                        } else {
                                            enterNoBranchRange = false;
                                        }
                                    }
                                    UserObjectHelper.getItemFormula((Cell)cell, (boolean)true).putExt("GRADE_NUMBER", grade);
                                } else {
                                    String[] array = number.split("!");
                                    if (array.length > 1) {
                                        for (int k = 1; k < array.length; ++k) {
                                            nameShow = "  " + nameShow;
                                            numberShow = " " + numberShow;
                                        }
                                    }
                                }
                            }
                            cell.setValue(new Variant((Object)nameShow));
                            if (param.getDynaItemShowType() == 1) {
                                showNumberCell.setValue(new Variant((Object)numberShow));
                            }
                            if (enterNoBranchRange && childCount > actualSize) {
                                UserObjectHelper.getUnprotectedRange((Range)table.getRange(row, col)).setRowHidden(true);
                            }
                            ++childCount;
                            if (sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_NAME)) {
                                if ("GRADESUM_TREE_ROOT".equals(name)) {
                                    cell.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Msg_Total")));
                                } else {
                                    DynaItemListener.setExeFlag((boolean)true);
                                    if (isTextGrade) {
                                        DynaItemListener.setAutoFillTextGradeSum((boolean)false);
                                    }
                                    DynaItemListener.autoFillFormula((Sheet)table, (int)row, (int)col, (String)number, null, (int)0, null, (boolean)false);
                                    if (isTextGrade) {
                                        DynaItemListener.setAutoFillTextGradeSum((boolean)true);
                                    }
                                    DynaItemListener.setExeFlag((boolean)false);
                                }
                            }
                        }
                        for (Point point : pointMap.keySet()) {
                            cell = isHorizon ? table.getCell(point.y, baseLine + i, true) : table.getCell(baseLine + i, point.x, true);
                            if (cell == null) continue;
                            Object value = pointMap.get(point);
                            if (value != null && value instanceof BigDecimal) {
                                cell.setValue(new Variant(value));
                                continue;
                            }
                            if (value == null) continue;
                            cell.setValue(new Variant(value));
                        }
                        ++i;
                        if (iter3.hasNext() || !isShowTotal) continue;
                        int end = baseLine + i - 1;
                        companyName = comp;
                        totalLine.add(new Integer(end + 1));
                        row = isHorizon ? basePoint.y : baseLine + i;
                        col = isHorizon ? baseLine + i : basePoint.x;
                        cell = table.getCell(row, col, true);
                        cell.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"317_AfterElimReportUI")));
                        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
                        sa.setBackground(lightblue);
                        cell.setSSA((ShareStyleAttributes)sa);
                        cell.setUserObject("isSum", (Object)"Y");
                        int maxRowCol = isHorizon ? table.getMaxColIndex() : table.getMaxColIndex();
                        for (int j = StartRowCol = isHorizon ? basePoint.y + 1 : basePoint.x + 1; j <= maxRowCol; ++j) {
                            Range range = UserObjectHelper.getUnprotectedRange((Range)(isHorizon ? table.getRange(j, basePoint.x) : table.getRange(basePoint.y, j)));
                            ItemFormula itemformula = (ItemFormula)range.getUserObject("ITEM");
                            if (itemformula == null || itemformula.getValueType() == 3) continue;
                            Cell cell3 = cell = isHorizon ? table.getCell(j, baseLine + i, true) : table.getCell(baseLine + i, j, true);
                            if (cell == null) continue;
                            String cellStart = isHorizon ? Location.getCellName(j, first) : Location.getCellName(first, j);
                            String cellEnd = isHorizon ? Location.getCellName(j, end) : Location.getCellName(end, j);
                            String formula = "=sum(" + cellStart + ":" + cellEnd + ")";
                            cell.setFormula(formula);
                            sa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
                            sa.setBackground(lightblue);
                            cell.setSSA((ShareStyleAttributes)sa);
                            cell.setUserObject("isSum", (Object)"Y");
                        }
                        first = end + 2;
                        ++i;
                    }
                    if (isShowTotal) {
                        DynamicTemplateUtility.autoAdjustSum((Sheet)table, (Point)basePoint, (int)actualSize, totalLine);
                    }
                    if (sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_NAME) && templateBasePoints != null) {
                        DynaRptCalcHelper.insertTemplateStyle(resultListBySort, table, basePoint, param, templateTable, (Point)templateBasePoints.get(n));
                    }
                } else if (sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) {
                    if (templateTable == null) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"691_SumRptCalculateGuideUI"));
                        return;
                    }
                    ArrayList originalBasePoints = DynamicTemplateUtility.getBasePointList((Sheet)templateTable);
                    Point originalBasePoint = (Point)originalBasePoints.get(n);
                    DynaParameters originalParam = DynamicTemplateUtility.getDynaParameters((Sheet)templateTable, (Point)originalBasePoint);
                    if (originalParam == null) continue;
                    actualSize = originalParam.getDefaultCounter();
                    if (actualSize > selectedSize && selectedSize > 0) {
                        actualSize = selectedSize;
                    }
                    int size = param.getDefaultCounter();
                    int n2 = baseLine = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
                    if (actualSize != size) {
                        int diff = actualSize - size;
                        boolean isInsert = diff > 0;
                        diff = Math.abs(diff);
                        baseLine += beforeDynaItemCount;
                        for (int line = 0; line < diff; ++line) {
                            InsertType insertType = InsertType.NOSTYLE;
                            if (isHorizon) {
                                if (isInsert) {
                                    UserObjectHelper.getUnprotectedRange((Range)table.getColRange(baseLine, baseLine)).insert(false, insertType);
                                    continue;
                                }
                                UserObjectHelper.getUnprotectedRange((Range)table.getColRange(baseLine, baseLine)).delete();
                                continue;
                            }
                            if (isInsert) {
                                UserObjectHelper.getUnprotectedRange((Range)table.getRowRange(baseLine, baseLine)).insert(true, insertType);
                                continue;
                            }
                            UserObjectHelper.getUnprotectedRange((Range)table.getRowRange(baseLine, baseLine)).delete();
                        }
                        DynamicTemplateUtility.autoAdjustSum((Sheet)table, (Point)basePoint, (int)actualSize, (boolean)true);
                        param.setDefaultCounter(actualSize);
                        DynamicTemplateUtility.saveParametersToCell((Range)UserObjectHelper.getUnprotectedRange((Range)table.getRange(basePoint.y, basePoint.x)), (DynaParameters)param);
                    }
                    int headStart = -1;
                    int headEnd = -1;
                    int bodyStart = -1;
                    int bodyEnd = -1;
                    if (isHorizon) {
                        headStart = basePoint.y + 1;
                        headEnd = table.getMaxRowIndex();
                        bodyStart = basePoint.x + 1;
                        bodyEnd = basePoint.x + param.getDefaultCounter();
                    } else {
                        headStart = basePoint.x + 1;
                        headEnd = table.getMaxColIndex();
                        bodyStart = basePoint.y + 1;
                        bodyEnd = basePoint.y + param.getDefaultCounter();
                    }
                    bodyStart += beforeDynaItemCount;
                    bodyEnd += beforeDynaItemCount;
                    int originalbodyStart = -1;
                    int originalbodyEnd = -1;
                    if (isHorizon) {
                        originalbodyStart = originalBasePoint.x + 1;
                        originalbodyEnd = originalBasePoint.x + param.getDefaultCounter();
                    } else {
                        originalbodyStart = originalBasePoint.y + 1;
                        originalbodyEnd = originalBasePoint.y + param.getDefaultCounter();
                    }
                    originalbodyStart += beforeDynaItemCount;
                    originalbodyEnd += beforeDynaItemCount;
                    Cell tmpCell = null;
                    for (int i = 0; i < param.getDefaultCounter(); ++i) {
                        Point itemheadPoint;
                        if (templateTable == null) continue;
                        Point originalItemheadPoint = isHorizon ? new Point(i + originalbodyStart, originalBasePoint.y) : new Point(originalBasePoint.x, i + originalbodyStart);
                        Point point = itemheadPoint = isHorizon ? new Point(i + bodyStart, basePoint.y) : new Point(basePoint.x, i + bodyStart);
                        if (templateTable.getCell(originalItemheadPoint.y, originalItemheadPoint.x, false) == null) continue;
                        tmpCell = templateTable.getCell(originalItemheadPoint.y, originalItemheadPoint.x, false);
                        String headName = tmpCell.getValue().toString();
                        Cell headcell = table.getCell(itemheadPoint.y, itemheadPoint.x, true);
                        if (headName == null) continue;
                        headcell.setValue(new Variant((Object)headName));
                    }
                    Cell cell = null;
                    Cell curCell = null;
                    String templateExpression = null;
                    for (int i = headStart; i <= headEnd; ++i) {
                        Point headPoint = null;
                        headPoint = isHorizon ? new Point(basePoint.x, i) : new Point(i, basePoint.y);
                        for (int j = 0; j < param.getDefaultCounter(); ++j) {
                            Object value;
                            Map map;
                            Map pointMap;
                            String number;
                            ItemFormula formula;
                            curCell = isHorizon ? table.getCell(i, j + bodyStart, true) : table.getCell(j + bodyStart, i, true);
                            Cell cell4 = cell = isHorizon ? templateTable.getCell(i, j + originalbodyStart, false) : templateTable.getCell(j + originalbodyStart, i, false);
                            if (cell == null || (formula = CslRptUIUtil.getFormula(templateTable.getRange(cell))) == null || (number = formula.getDItemNumber()) == null || number.length() == 0) continue;
                            CslRptUIUtil.setFormula(UserObjectHelper.getUnprotectedRange((Range)table.getRange(curCell)), formula);
                            if (cell.hasFormula()) {
                                templateExpression = cell.getFormula();
                                Point p = new Point(cell.getCol(), cell.getRow());
                                templateFormulas.put(p, templateExpression);
                            }
                            if (!nameMap.containsKey(number) || !(pointMap = (Map)(map = (Map)nameMap.get(number)).get("KEY_POINT_VALUE")).containsKey(headPoint) || (value = pointMap.get(headPoint)) == null) continue;
                            curCell.setValue(new Variant(value));
                        }
                    }
                }
                if (!param.getIsFirst() || param.isGrade()) continue;
                param.setIsFirst(false);
                DynamicTemplateUtility.saveParametersToCell((Range)UserObjectHelper.getUnprotectedRange((Range)table.getRange(basePoint.y, basePoint.x)), (DynaParameters)param);
            }
            if (!sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) continue;
            for (Point p : templateFormulas.keySet()) {
                String formula = (String)templateFormulas.get(p);
                Cell cell = table.getCell(p.y, p.x, true);
                if (cell == null) continue;
                cell.setFormula(formula);
            }
        }
    }

    private void clearSelfDefineFormula(int startRow, int left, int colCount, Sheet curSheet, int spreadStyle) {
        Cell cellTemp = null;
        for (int j = left; j < left + colCount; ++j) {
            if (spreadStyle == 0) {
                cellTemp = curSheet.getCell(startRow, j, true);
            } else if (spreadStyle == 1) {
                cellTemp = curSheet.getCell(j, startRow, true);
            }
            Range rangeTemp = null;
            String formula = "";
            if (cellTemp != null) {
                rangeTemp = UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(cellTemp));
                formula = cellTemp.getFormula();
            }
            if (rangeTemp == null) continue;
            if (!DynamicTemplateUtility.isExcelFormula((String)formula)) {
                rangeTemp.setFormula(null);
                rangeTemp.setValue(Variant.nullVariant);
                rangeTemp.setUserObject("ITEM", null);
                rangeTemp.setUserObject("0", null);
                rangeTemp.setUserObject("1", null);
                continue;
            }
            rangeTemp.setValue(Variant.nullVariant);
            rangeTemp.setUserObject("ITEM", null);
            rangeTemp.setUserObject("0", null);
            rangeTemp.setUserObject("1", null);
        }
    }

    private void fillTextGradeData(Point basePoint, Sheet sheet, Map nameMap, DItemGradeInfo gradeInfo, int selectedSize, boolean byname, boolean isGenItemFormula, boolean isOnlyList) {
        DItemGradeInfo info = new DItemGradeInfo();
        Iterator it = nameMap.entrySet().iterator();
        String tmpName = null;
        String tmpNumber = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Map v = (Map)entry.getValue();
            DItemGradeEntryInfo en = new DItemGradeEntryInfo((String)v.get("GRADE_NUMBER"), (String)entry.getKey());
            tmpName = (String)v.get("KEY_DITEM_NAME");
            tmpNumber = (String)entry.getKey();
            en.setName(tmpName);
            en.setNumber(tmpNumber);
            if (tmpName == null && tmpNumber == null) continue;
            info.getEntries().add(en);
            String compName = (String)v.get("COMPANY_NAME");
            en.setCompany(compName);
        }
        info.reform2(true);
        DItemGradeInfo info2 = DynamicTemplateUtility.getGradeInfo((Range)sheet.getRange(basePoint.y, basePoint.x));
        HashMap dupBranchValues = new HashMap();
        BigDecimal preValue = null;
        BigDecimal curValue = null;
        BigDecimal sumValue = null;
        HashMap nameNumberListMap = new HashMap();
        List<String> numberList = null;
        Map aDupMap = null;
        Map dupPointValueMap = null;
        Map aNameMap = null;
        Map namePointValueMap = null;
        Object var24_24 = null;
        Iterator dupIter = null;
        for (DItemGradeEntryInfo i : info.getEntries()) {
            DItemGradeEntryInfo find;
            if (info2 == null || (find = info2.find(i.getGrade())) == null || find.isLeaf()) continue;
            i.setLeaf(false);
            if (!isOnlyList) continue;
            String name = find.getName();
            i.setName(name);
            if (!this.cbOnlyList.isSelected() || find.isIncludeUnknowDetail()) continue;
            BigDecimal zero = new BigDecimal("0");
            if (dupBranchValues.containsKey(name)) {
                aDupMap = (Map)dupBranchValues.get(name);
                aNameMap = (Map)nameMap.get(i.getNumber());
                dupPointValueMap = (Map)aDupMap.get("KEY_POINT_VALUE");
                namePointValueMap = (Map)aNameMap.get("KEY_POINT_VALUE");
                for (Map.Entry entry : dupPointValueMap.entrySet()) {
                    if (!(entry.getValue() instanceof BigDecimal)) continue;
                    preValue = entry.getValue() == null ? zero : (BigDecimal)entry.getValue();
                    curValue = namePointValueMap.get(entry.getKey()) == null ? zero : (BigDecimal)namePointValueMap.get(entry.getKey());
                    sumValue = preValue.add(curValue);
                    entry.setValue(sumValue);
                }
                numberList = (List)nameNumberListMap.get(name);
                numberList.add(i.getNumber());
                continue;
            }
            dupBranchValues.put(name, nameMap.get(i.getNumber()));
            numberList = new ArrayList<String>();
            numberList.add(i.getNumber());
            nameNumberListMap.put(name, numberList);
        }
        if (!byname) {
            info.removeDupBranch(info.getEntries());
        }
        String nameKey = null;
        Map.Entry nameNumberEntry22 = null;
        Map aDupValueMap = null;
        Map aDupPointValueMap = null;
        List aNumberList = null;
        String numberKey22 = null;
        Map aNameValueMap = null;
        Map aNamePonitValueMap = null;
        Map.Entry dupPointValueEntry22 = null;
        Iterator dupPointValueIter = null;
        if (!nameNumberListMap.isEmpty()) {
            for (Map.Entry nameNumberEntry22 : nameNumberListMap.entrySet()) {
                nameKey = (String)nameNumberEntry22.getKey();
                aDupValueMap = (Map)dupBranchValues.get(nameKey);
                aDupPointValueMap = (Map)aDupValueMap.get("KEY_POINT_VALUE");
                aNumberList = (List)nameNumberEntry22.getValue();
                for (String numberKey22 : aNumberList) {
                    aNameValueMap = (Map)nameMap.get(numberKey22);
                    aNamePonitValueMap = (Map)aNameValueMap.get("KEY_POINT_VALUE");
                    for (Map.Entry dupPointValueEntry22 : aDupPointValueMap.entrySet()) {
                        if (!(dupPointValueEntry22.getValue() instanceof BigDecimal)) continue;
                        aNamePonitValueMap.put(dupPointValueEntry22.getKey(), dupPointValueEntry22.getValue());
                    }
                }
            }
        }
        DynaGradeSettingAdviserImpl ad = new DynaGradeSettingAdviserImpl(sheet);
        ad.setBasePoint(basePoint);
        ad.setIsFillSumData(byname);
        ad.setNameMap(nameMap);
        ad.setShowCount(Integer.MAX_VALUE);
        ad.setGenItemFormula(isGenItemFormula);
        if (gradeInfo != null) {
            ad.setTemplateGradeInfo(gradeInfo);
        }
        DynaSumMethodEnum sumMethod = (DynaSumMethodEnum)((Object)this.comboSumMethod.getSelectedItem());
        ad.setSumMethod(sumMethod.getValue());
        ad.fill(info);
    }

    private void fillTextCompany_Name(Point basePoint, Sheet sheet, Map nameMap, DItemGradeInfo gradeInfo, int selectedSize) {
        TreeMap<String, DItemGradeInfo> infos = new TreeMap<String, DItemGradeInfo>();
        for (Map.Entry entry : nameMap.entrySet()) {
            Map v = (Map)entry.getValue();
            DItemGradeEntryInfo en = new DItemGradeEntryInfo((String)v.get("GRADE_NUMBER"), (String)entry.getKey());
            String name2 = (String)v.get("KEY_DITEM_NAME");
            String compName = (String)v.get("COMPANY_NAME");
            DItemGradeInfo info = (DItemGradeInfo)infos.get(compName);
            if (info == null) {
                info = new DItemGradeInfo();
                infos.put(compName, info);
            }
            en.setName(name2);
            en.setNumber((String)entry.getKey());
            en.setCompany(compName);
            info.getEntries().add(en);
        }
        DynaGradeSettingAdviserImpl ad = new DynaGradeSettingAdviserImpl(sheet);
        ad.setBasePoint(basePoint);
        ad.setIsFillSumData(true);
        ad.setNameMap(nameMap);
        ad.setShowCount(Integer.MAX_VALUE);
        ad.setGenItemFormula(false);
        DynaSumMethodEnum sumMethod = (DynaSumMethodEnum)((Object)this.comboSumMethod.getSelectedItem());
        ad.setSumMethod(sumMethod.getValue());
        if (gradeInfo != null) {
            ad.setTemplateGradeInfo(gradeInfo);
        }
        ad.fill(infos);
    }

    private Object[] sortByPosistion(Sheet table, Set set) {
        Object[] basePointArray = set.toArray();
        if (basePointArray.length > 0) {
            Point basePoint = (Point)basePointArray[0];
            DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell((Sheet)table, (int)basePoint.y, (int)basePoint.x);
            if (param != null) {
                if (param.getSpreadStyle() == 1) {
                    Arrays.sort(basePointArray, new PointXComparator());
                } else {
                    Arrays.sort(basePointArray, new PointYComparator());
                }
            }
        }
        return basePointArray;
    }

    private List getSortedMap(final Map nameMap, final Point sortedPoint, OrderByEnum orderBy, final boolean isHead) {
        Set keySet = nameMap.keySet();
        Object[] array = keySet.toArray();
        if (orderBy.equals((Object)OrderByEnum.DESC)) {
            class KeyComparatorDesc
            implements Comparator {
                KeyComparatorDesc() {
                }

                public int compare(Object o1, Object o2) {
                    if (isHead) {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return 1;
                        }
                        if (o2 == null) {
                            return -1;
                        }
                        return o2.toString().compareTo(o1.toString());
                    }
                    Map m1 = (Map)nameMap.get(o1);
                    Map m2 = (Map)nameMap.get(o2);
                    if (m1 == null && m2 == null) {
                        return 0;
                    }
                    if (m1 == null) {
                        return 1;
                    }
                    if (m2 == null) {
                        return -1;
                    }
                    Map map1 = (Map)m1.get("KEY_POINT_VALUE");
                    Map map2 = (Map)m2.get("KEY_POINT_VALUE");
                    Object obj = map1.get(sortedPoint);
                    Object obj2 = map2.get(sortedPoint);
                    if (obj == null && obj2 == null) {
                        return 0;
                    }
                    if (obj == null) {
                        return 1;
                    }
                    if (obj2 == null) {
                        return -1;
                    }
                    if (obj instanceof BigDecimal && obj2 instanceof BigDecimal) {
                        BigDecimal n1 = (BigDecimal)obj;
                        BigDecimal n2 = (BigDecimal)obj2;
                        return n2.compareTo(n1);
                    }
                    if (obj instanceof String && obj2 instanceof String) {
                        return ((String)obj2).compareTo((String)obj);
                    }
                    return 0;
                }
            }
            Arrays.sort(array, new KeyComparatorDesc());
        } else {
            class KeyComparatorAsc
            implements Comparator {
                KeyComparatorAsc() {
                }

                public int compare(Object o1, Object o2) {
                    if (isHead) {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        return o1.toString().compareTo(o2.toString());
                    }
                    Map m1 = (Map)nameMap.get(o1);
                    Map m2 = (Map)nameMap.get(o2);
                    if (m1 == null && m2 == null) {
                        return 0;
                    }
                    if (m1 == null) {
                        return -1;
                    }
                    if (m2 == null) {
                        return 1;
                    }
                    Map map1 = (Map)m1.get("KEY_POINT_VALUE");
                    Map map2 = (Map)m2.get("KEY_POINT_VALUE");
                    Object obj = map1.get(sortedPoint);
                    Object obj2 = map2.get(sortedPoint);
                    if (obj == null && obj2 == null) {
                        return 0;
                    }
                    if (obj == null) {
                        return -1;
                    }
                    if (obj2 == null) {
                        return 1;
                    }
                    if (obj instanceof BigDecimal && obj2 instanceof BigDecimal) {
                        BigDecimal n1 = (BigDecimal)obj;
                        BigDecimal n2 = (BigDecimal)obj2;
                        return n1.compareTo(n2);
                    }
                    if (obj instanceof String && obj2 instanceof String) {
                        return ((String)obj).compareTo((String)obj2);
                    }
                    return 0;
                }
            }
            Arrays.sort(array, new KeyComparatorAsc());
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    private CslReportCollection getCslReports(HashSet companyIDs, int year, int period, HashSet templateGroups, String currencyId, String dataCollectNumber) throws Exception {
        CslReportCollection collection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.isGrouping"));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyIDs, CompareType.INCLUDE));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(year)));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(period)));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("template.group", (Object)templateGroups, CompareType.INCLUDE));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("currency", (Object)currencyId, CompareType.EQUALS));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("committedStatus", (Object)new Integer(3)));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)dataCollectNumber));
        try {
            collection = CslReportFactory.getRemoteInstance().getCslReportCollection(viewInfo);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        return collection;
    }

    private OrgUnitCollection getOrgUnits(OrgTreeInfo orgTreeInfo, OrgUnitInfo parentCompanyInfo) throws EASBizException, BOSException {
        return DynamicTemplateUtility.getOrgUnits((OrgTreeInfo)orgTreeInfo, (OrgUnitInfo)parentCompanyInfo);
    }

    protected ArrayList getReportIDs(CslReportInfo rpt, Vector vecSelectedCompanys) throws SumRptException {
        HashSet<String> templateGroups = this.getSourceTemplateGroups(rpt.getTemplate().getId().toString());
        if (templateGroups == null) {
            templateGroups = new HashSet<String>();
        }
        templateGroups.add(this.curReport.getTemplate().getGroup());
        CslReportCollection reports = null;
        HashSet<String> companys = new HashSet<String>();
        for (OrgUnitInfo company : vecSelectedCompanys) {
            companys.add(company.getId().toString());
        }
        try {
            if (rpt.getCurrency() == null) {
                super.handUIException((Throwable)new BOSException(CslRptUtil.getString("SumRptCaclCurrencyIsNull")));
            }
            reports = this.getCslReports(companys, rpt.getYear(), rpt.getPeriod(), templateGroups, rpt.getCurrency().getId().toString(), rpt.getDataCollectNumber());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (reports == null || reports.size() == 0) {
            return null;
        }
        HashMap<String, Boolean> comAndGroup = new HashMap<String, Boolean>();
        ArrayList<String> reportIDs = new ArrayList<String>();
        Iterator iterReport = reports.iterator();
        while (iterReport.hasNext()) {
            CslReportInfo reportInfo = (CslReportInfo)iterReport.next();
            comAndGroup.put(reportInfo.getOrgUnit().getNumber(), reportInfo.getOrgUnit().isIsGrouping());
            reportIDs.add(reportInfo.getId().toString());
        }
        return reportIDs;
    }

    protected Vector getSelectedCompanys() {
        Vector<OrgUnitInfo> companys = new Vector<OrgUnitInfo>(0);
        for (int i = 0; i < this.tblCompany.getRowCount(); ++i) {
            IRow row = this.tblCompany.getRow(i);
            if (!row.getCell(1).getValue().equals(Boolean.TRUE)) continue;
            OrgUnitInfo company = (OrgUnitInfo)row.getCell(4).getValue();
            Assert.assertNotNull((Object)company);
            companys.addElement(company);
        }
        if (companys.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_CompanyNull"));
            SysUtil.abort();
        }
        return companys;
    }

    private void initCompanyTable(OrgTreeInfo orgTreeInfo, OrgUnitInfo parentCompanyInfo) throws EASBizException, BOSException {
        if (orgTreeInfo == null || parentCompanyInfo == null) {
            return;
        }
        OrgUnitCollection units = this.getOrgUnits(orgTreeInfo, parentCompanyInfo);
        this.tblCompany.checkParsed();
        this.tblCompany.getSelectManager().setSelectMode(2);
        this.tblCompany.removeRows();
        this.tblCompany.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SumRptCalculateGuideForMultiUI.this.tblCompany.getSelectManager().setActiveColumnIndex(1);
            }
        });
        if (units != null && units.size() > 0) {
            for (OrgUnitInfo info : units) {
                if (info == null) continue;
                IRow r = this.tblCompany.addRow();
                if (this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || this.curReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE)) {
                    r.getStyleAttributes().setBackground(Color.lightGray);
                }
                r.getCell(0).setValue((Object)info.getId());
                r.getCell(1).setValue((Object)Boolean.FALSE);
                r.getCell(2).setValue((Object)info.getNumber());
                r.getCell(3).setValue((Object)info.getName());
                r.getCell(4).setValue((Object)info);
            }
        }
        if (this.tblCompany.getRowCount() > 0) {
            this.tblCompany.getColumn(2).getStyleAttributes().setLocked(true);
            this.tblCompany.getColumn(3).getStyleAttributes().setLocked(true);
        }
    }

    private void initData() throws EASBizException, BOSException {
        this.btnByItems.setVisible(false);
        this.btnBySheets.setVisible(false);
        this.curReport = (CslReportInfo)this.getUIContext().get("CslReport");
        this.curSheets = (Book)this.getUIContext().get("Sheets");
        this.orgTree = this.curReport.getOrgTree();
        this.parentCompany = this.curReport.getOrgUnit();
        this.initCompanyTable(this.orgTree, this.parentCompany);
        String value = CslParamFactory.getRemoteInstance().getParam("KEY_CSLPARAM_CalShowNumber");
        this.initValue = this.getDefaultValue(value);
        SpinnerNumberModel model = new SpinnerNumberModel(this.initValue, 1, Integer.MAX_VALUE, 1);
        this.spnDisplayNumber.setModel((SpinnerModel)model);
        this.spnDisplayNumber.updateUI();
        this.comboSumCalculateMethod.removeItem((Object)SumCalculateMethodEnum.ByOther);
    }

    private int getDefaultValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 5000;
        }
    }

    @Override
    protected void btnDeselectAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable(this.tblCompany, "select", Boolean.FALSE);
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable(this.tblCompany, "select", Boolean.TRUE);
    }

    @Override
    protected void comboSumMethod_actionPerformed(ActionEvent e) throws Exception {
        DynaSumMethodEnum sumMethod = (DynaSumMethodEnum)((Object)this.comboSumMethod.getSelectedItem());
        if (sumMethod == null) {
            return;
        }
        if (sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY) || sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_NAME)) {
            this.spnDisplayNumber.setEnabled(true);
        } else {
            this.spnDisplayNumber.setEnabled(false);
        }
        if (sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_COMPANY) || sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_NAME) || sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE) || sumMethod.equals((Object)DynaSumMethodEnum.LIST_NAME_COMPANY)) {
            this.cbOnlyList.setEnabled(false);
            this.cbOnlyList.setSelected(true);
        } else {
            this.cbOnlyList.setEnabled(true);
            this.cbOnlyList.setSelected(true);
        }
        if (sumMethod.equals((Object)DynaSumMethodEnum.LIST_COMPANY_NAME)) {
            if (!this.onlyHasGrade) {
                this.cbkShowTotal.setEnabled(true);
            }
            this.cbkOnlyListCompany.setEnabled(false);
        } else if (sumMethod.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME)) {
            if (!this.onlyHasGrade) {
                this.cbkShowTotal.setEnabled(true);
                this.cbkOnlyListCompany.setEnabled(true);
            }
        } else {
            this.cbkShowTotal.setEnabled(false);
            this.cbkOnlyListCompany.setEnabled(false);
        }
        if (this.isDyRptSaveUpdateItem4CM) {
            this.cbkShowTotal.setSelected(false);
            this.cbkShowTotal.setEnabled(false);
        }
    }

    private void refreshDynaTableData(Book book, Map sheets, Map result, int precision, Map dynaSumRange) throws Exception {
        if (sheets == null || sheets.size() == 0 || result == null || result.size() == 0) {
            return;
        }
        HashMap dynaSumResult = (HashMap)result.get("dynaSumRange");
        HashMap order = (HashMap)result.get("order");
        if (dynaSumResult == null || dynaSumResult.size() == 0) {
            return;
        }
        for (String sheetName : sheets.keySet()) {
            SumcalcRange dynaKeyRange;
            if (sheetName == null || sheetName.trim().length() == 0) continue;
            Sheet curSheet = (Sheet)sheets.get(sheetName);
            DynaKeyAndValue dynaValue = (DynaKeyAndValue)dynaSumRange.get(curSheet.getSheetName());
            Integer leftKeyCol = dynaValue.leftKeyCol;
            SumcalcRange sumcalcRange = dynaKeyRange = curSheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            if (dynaKeyRange == null) continue;
            HashMap dynaKeyResult = new HashMap();
            SumcalcRange keyRange = new SumcalcRange();
            SumcalcRange valueRange = new SumcalcRange();
            int temp = -1;
            for (int i = 0; dynaKeyRange != null && i < dynaKeyRange.size(); ++i) {
                ++temp;
                CellBlock block = dynaKeyRange.getCellBlock(i);
                int beginRow = block.getRow();
                int endRow = block.getRow2();
                int newBeginRow = beginRow;
                ArrayList orderArray = (ArrayList)order.get(sheetName);
                if (orderArray.size() == 0) {
                    --i;
                    dynaKeyRange = (curSheet = CslRptUtil.doDeleteDynaRange(curSheet, dynaKeyRange, beginRow, endRow)).getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
                    UserObjectHelper.getUnprotectedRange((Range)curSheet.getRowRange(beginRow, endRow)).delete();
                    continue;
                }
                if (dynaSumResult.get(sheetName) != null) {
                    HashMap dynaMap = null;
                    HashMap keyMap = new HashMap();
                    dynaMap = (HashMap)dynaSumResult.get(sheetName);
                    dynaKeyRange = this.circleMap(dynaMap, curSheet, sheetName, newBeginRow, leftKeyCol, temp, orderArray, keyMap, dynaKeyResult, keyRange, valueRange, dynaKeyRange, beginRow, endRow);
                    ++newBeginRow;
                    continue;
                }
                curSheet = CslRptUtil.doDeleteDynaRange(curSheet, dynaKeyRange, beginRow, endRow);
                UserObjectHelper.getUnprotectedRange((Range)curSheet.getRowRange(beginRow, endRow)).delete();
            }
            this.setsheetBlock(curSheet, keyRange, valueRange);
            this.clearErrorFormula(curSheet);
            CslRptUIUtil.paintBackColor(curSheet, keyRange);
            CslRptUIUtil.paintBackColor(curSheet, valueRange);
        }
    }

    private void setsheetBlock(Sheet curSheet, SumcalcRange keyRange, SumcalcRange valueRange) {
        ArrayList allValueCol;
        HashMap leftKeyColAndAllRowCount = CslRptUIUtil.getLeftColAndAllLeftRow(curSheet, keyRange);
        if (leftKeyColAndAllRowCount.get("allRow") != null) {
            ArrayList allKeyRow = (ArrayList)leftKeyColAndAllRowCount.get("allRow");
            if (allKeyRow.size() != 0 && leftKeyColAndAllRowCount.get("leftCol") != null) {
                SumcalcRange newKeyZone = CslRptUIUtil.reSaveKeyZoneByRange(curSheet, allKeyRow, (Integer)leftKeyColAndAllRowCount.get("leftCol"));
                curSheet.setUserObject("DYNAMICSUMKEYZONE", (Object)newKeyZone);
            } else {
                curSheet.setUserObject("DYNAMICSUMKEYZONE", (Object)keyRange);
            }
        }
        ArrayList arrayList = allValueCol = curSheet.getUserObjectValue("allValueCol") == null ? null : (ArrayList)curSheet.getUserObjectValue("allValueCol");
        if (allValueCol != null) {
            SumcalcRange newDynaValueZone = new SumcalcRange();
            for (int k = 0; k < allValueCol.size(); ++k) {
                SumcalcRange newValueZone;
                HashMap allValueRowByCol = CslRptUIUtil.getAllValueRow(curSheet, valueRange, (Integer)allValueCol.get(k));
                if (allValueRowByCol.get("allRow") == null || (newValueZone = CslRptUIUtil.reSaveKeyZoneByRange(curSheet, (ArrayList)allValueRowByCol.get("allRow"), (Integer)allValueCol.get(k))) == null) continue;
                newDynaValueZone.addRanges(newValueZone);
            }
            curSheet.setUserObject("DYNAMICSUMVALUEZONE", (Object)newDynaValueZone);
        }
    }

    private void clearErrorFormula(Sheet sheet) {
        String formula = null;
        if (sheet == null) {
            return;
        }
        int rowCount = sheet.getMaxRowIndex() + 1;
        for (int row = 0; row < rowCount; ++row) {
            int colCount = sheet.getMaxColIndex() + 1;
            for (int col = 0; col < colCount; ++col) {
                Cell cell = sheet.getCell(row, col, false);
                if (cell == null || (formula = cell.getFormula()) == null || !formula.equals("=SUM(#REF!)")) continue;
                cell.setFormula(null);
                if (cell.getUserObject("cellValue") == null) continue;
                cell.setValue(new Variant(cell.getUserObjectValue("cellValue")));
            }
        }
    }

    private SumcalcRange circleMap(HashMap dynaMap, Sheet curSheet, String sheetName, int newBeginRow, Integer leftKeyCol, int blockNumber, ArrayList order, HashMap keyMap, HashMap dynaKeyResult, SumcalcRange keyRange, SumcalcRange valueRange, SumcalcRange oldDynaKeyRange, int beginRow, int endRow) throws Exception {
        Integer maxRow;
        Collator c = Collator.getInstance(Locale.CHINA);
        Object[] orderArray = order.toArray();
        Arrays.sort(orderArray, c);
        HashMap formulaLocMap = curSheet.getUserObjectValue("fomulaLocation") == null ? null : (HashMap)curSheet.getUserObjectValue("fomulaLocation");
        HashMap allHaveFormulaCol = null;
        ArrayList valueFomulaList = null;
        if (formulaLocMap != null) {
            allHaveFormulaCol = formulaLocMap.get("allHaveFormulaCol") == null ? null : (HashMap)formulaLocMap.get("allHaveFormulaCol");
            valueFomulaList = formulaLocMap.get("formulaLocation") == null ? null : (ArrayList)formulaLocMap.get("formulaLocation");
        } else {
            allHaveFormulaCol = new HashMap(0);
            valueFomulaList = new ArrayList(0);
        }
        int diffRow = -10;
        int templateMaxRow = -1;
        boolean isFillFormula = true;
        HashMap mapAll = this.decomposeFormula(valueFomulaList, newBeginRow, blockNumber, diffRow);
        if (mapAll == null) {
            mapAll = new HashMap(0);
        }
        HashMap curRangeFormulaMap = mapAll.get("map") == null ? null : (HashMap)mapAll.get("map");
        Integer n = maxRow = mapAll.get("maxRow") == null ? null : (Integer)mapAll.get("maxRow");
        if (maxRow != null) {
            if (maxRow != -1) {
                templateMaxRow = maxRow;
                isFillFormula = true;
            } else {
                isFillFormula = false;
            }
        }
        int newKeyRangeRow = 0;
        for (int k = 0; k < orderArray.length; ++k) {
            String key = orderArray[k].toString();
            if (key.indexOf("&") == -1) continue;
            DynaKeyValue dynaKeyValue = this.decompose(key);
            int newRange = blockNumber;
            int origRange = dynaKeyValue.range;
            if (newRange != origRange) continue;
            String keyNew = dynaKeyValue.range + "&" + dynaKeyValue.dynaKey;
            if (!dynaKeyResult.containsKey(keyNew)) {
                if (++newKeyRangeRow > endRow - beginRow + 1) {
                    CslRptUtil.doInsertDynaKeyRange(curSheet, oldDynaKeyRange, newBeginRow);
                    if (oldDynaKeyRange != null && !oldDynaKeyRange.isEmpty()) {
                        oldDynaKeyRange = curSheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
                    }
                    UserObjectHelper.getUnprotectedRange((Range)curSheet.getRowRange(newBeginRow - 1, newBeginRow - 1)).insert(true, InsertType.FLLOW_UP_STYLE);
                    this.copyNextDataToPreData(curSheet, newBeginRow);
                }
                dynaKeyResult.put(keyNew, new Integer(newBeginRow));
                UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(newBeginRow, leftKeyCol.intValue())).setValue(new Variant((Object)dynaKeyValue.dynaKey));
                UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(newBeginRow, dynaKeyValue.dynaValueCol.intValue())).setValue(new Variant(dynaMap.get(sheetName + "&" + key)));
                keyRange.addRange(curSheet.getRange(newBeginRow, leftKeyCol.intValue()));
                valueRange.addRange(curSheet.getRange(newBeginRow, dynaKeyValue.dynaValueCol.intValue()));
                if (isFillFormula && curRangeFormulaMap != null && curRangeFormulaMap.size() > 0) {
                    this.setCellFormula(curSheet, dynaKeyValue.dynaValueCol, newRange, curRangeFormulaMap, templateMaxRow, newBeginRow, allHaveFormulaCol, valueRange);
                }
                this.setsheetBlock(curSheet, keyRange, valueRange);
                ++newBeginRow;
                continue;
            }
            Integer row = (Integer)dynaKeyResult.get(keyNew);
            UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(row.intValue(), leftKeyCol.intValue())).setValue(new Variant((Object)dynaKeyValue.dynaKey));
            UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(row.intValue(), dynaKeyValue.dynaValueCol.intValue())).setValue(new Variant(dynaMap.get(sheetName + "&" + key)));
            keyRange.addRange(curSheet.getRange(row.intValue(), leftKeyCol.intValue()));
            valueRange.addRange(curSheet.getRange(row.intValue(), dynaKeyValue.dynaValueCol.intValue()));
            if (!isFillFormula || curRangeFormulaMap == null || curRangeFormulaMap.size() <= 0) continue;
            this.setCellFormula(curSheet, dynaKeyValue.dynaValueCol, newRange, curRangeFormulaMap, templateMaxRow, row, allHaveFormulaCol, valueRange);
        }
        int differenceRow = endRow - beginRow + 1;
        if (newKeyRangeRow < differenceRow) {
            oldDynaKeyRange = (curSheet = CslRptUtil.doDeleteDynaRange(curSheet, oldDynaKeyRange, beginRow + newKeyRangeRow, endRow)).getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            UserObjectHelper.getUnprotectedRange((Range)curSheet.getRowRange(beginRow + newKeyRangeRow, endRow)).delete();
        }
        return oldDynaKeyRange;
    }

    private void copyNextDataToPreData(Sheet curSheet, int currentRow) {
        for (int i = 0; i <= curSheet.getMaxColIndex(); ++i) {
            boolean isEmpty = curSheet.getRange(currentRow, i).getValue().isEmpty();
            if (isEmpty) continue;
            UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(currentRow - 1, i)).setValue(curSheet.getRange(currentRow, i).getValue());
            UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(currentRow, i)).setValue(Variant.nullVariant);
        }
    }

    private void setCellFormula(Sheet curSheet, int column, int range, HashMap curRangeFormula, int templateMaxRow, int currentRow, HashMap allHaveFormulaCol, SumcalcRange valueRange) throws Exception {
        String haveFormulaKey;
        String[] allHaveFormula;
        Iterator iter;
        String key = range + "&" + currentRow + "&" + column;
        boolean isFind = false;
        if (curRangeFormula.get(key) != null) {
            isFind = true;
            UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(currentRow, column)).setFormula("=" + curRangeFormula.get(key).toString());
            valueRange.addRange(curSheet.getRange(currentRow, column));
        }
        if (!isFind) {
            iter = curRangeFormula.keySet().iterator();
            while (iter.hasNext()) {
                String k = iter.next().toString();
                String[] dynaMsg = k.split("&");
                if (new Integer(dynaMsg[0]) != range || new Integer(dynaMsg[1]) != currentRow) continue;
                UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(currentRow, new Integer(dynaMsg[2]).intValue())).setFormula("=" + curRangeFormula.get(k).toString());
                valueRange.addRange(curSheet.getRange(currentRow, new Integer(dynaMsg[2]).intValue()));
                isFind = true;
            }
        }
        if (!isFind && allHaveFormulaCol != null && allHaveFormulaCol.size() > 0 && (iter = allHaveFormulaCol.keySet().iterator()).hasNext() && new Integer((allHaveFormula = (haveFormulaKey = iter.next().toString()).split("&"))[0]) == range) {
            Iterator iterater = curRangeFormula.keySet().iterator();
            while (iterater.hasNext()) {
                String k = iterater.next().toString();
                String[] dynaMsg = k.split("&");
                if (new Integer(dynaMsg[0]) != range || !dynaMsg[2].equals(allHaveFormula[1])) continue;
                this.parseFormula(curSheet, curRangeFormula.get(k).toString(), currentRow, new Integer(allHaveFormula[1]), valueRange);
                isFind = true;
                break;
            }
        }
    }

    private void parseFormula(Sheet curSheet, String lastFormularowInTemplate, int currentRow, int column, SumcalcRange valueRange) throws Exception {
        Expression exp = ExcelFormulaPaserHelper.parse((String)lastFormularowInTemplate);
        if (!(exp instanceof UnaryOperationExpr) && exp instanceof BinaryOperationExpr) {
            exp = ExcelFormulaPaserHelper.parse((String)lastFormularowInTemplate);
            this.walk(exp);
            StringBuffer cellFormula = new StringBuffer();
            this.interpret(exp.toString(), cellFormula, currentRow);
            if (curSheet.getCell(currentRow, column, false) != null) {
                UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(currentRow, column)).setFormula("=" + cellFormula.toString());
                valueRange.addRange(curSheet.getRange(currentRow, column));
            } else {
                UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(currentRow, column)).setFormula("=" + cellFormula.toString());
                valueRange.addRange(curSheet.getRange(currentRow, column));
            }
        }
    }

    private HashMap decomposeFormula(ArrayList valueFomulaList, int beginRow, int range, int diffRow) throws Exception {
        if (valueFomulaList == null || valueFomulaList.size() == 0) {
            return new HashMap(0);
        }
        HashMap<String, Serializable> mapAll = new HashMap<String, Serializable>();
        HashMap<String, String> map = new HashMap<String, String>();
        int maxRowIndex = -1;
        for (int i = 0; i < valueFomulaList.size(); ++i) {
            String formula = valueFomulaList.get(i).toString();
            String[] f = formula.split("&");
            if (range != new Integer(f[1])) continue;
            if (diffRow == -10) {
                diffRow = beginRow - new Integer(f[2]);
            }
            int curRow = new Integer(f[2]) + diffRow;
            Expression exp = ExcelFormulaPaserHelper.parse((String)f[0]);
            if (!(exp instanceof UnaryOperationExpr) && exp instanceof BinaryOperationExpr) {
                exp = ExcelFormulaPaserHelper.parse((String)f[0]);
                this.walk(exp);
                StringBuffer cellFormula = new StringBuffer();
                this.interpret(exp.toString(), cellFormula, curRow);
                map.put(new Integer(f[1]) + "&" + curRow + "&" + new Integer(f[3]), cellFormula.toString());
            }
            if (maxRowIndex == -1) {
                maxRowIndex = curRow;
                continue;
            }
            if (maxRowIndex >= curRow) continue;
            maxRowIndex = curRow;
        }
        mapAll.put("map", map);
        mapAll.put("maxRow", new Integer(maxRowIndex));
        return mapAll;
    }

    private void walk(Expression exp) {
        if (exp instanceof BinaryOperationExpr) {
            this.walk(((BinaryOperationExpr)exp).left);
            this.walk(((BinaryOperationExpr)exp).right);
        } else if (exp instanceof UnaryOperationExpr) {
            this.walk(((UnaryOperationExpr)exp).operand);
        } else if (exp instanceof FunctionExpr) {
            List ps = ((FunctionExpr)exp).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                this.walk((Expression)ps.get(i));
            }
        } else if (exp instanceof Area3DExpr) {
            this.walk((Expression)((Area3DExpr)exp).area);
        } else if (exp instanceof Ref3DExpr) {
            this.walk((Expression)((Ref3DExpr)exp).ref);
        }
    }

    private void interpret(String exp, StringBuffer formula, int currentRow) throws ParseException {
        if (exp == null || exp.length() == 0) {
            return;
        }
        for (int i = 0; i < exp.length(); ++i) {
            char c = exp.charAt(i);
            if (Character.isLetter(c) && c != '\'') {
                ArrayList list = this.GetName(exp, c, i);
                if (list.size() == 0) continue;
                String cellName = list.get(0).toString();
                i = (Integer)list.get(1);
                int[] rowCol = Location.getCellRowAndColumn(cellName);
                int row = currentRow;
                int col = rowCol[1];
                formula.append(Location.getCellName(row, col));
                continue;
            }
            formula.append(c);
        }
    }

    private ArrayList GetName(String exp, char look, int location) throws ParseException {
        StringBuffer Token2 = new StringBuffer();
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.IsAlNum(look) || this.isSBC_Case_Symbol(look)) {
            Token2.append(Character.toUpperCase(look));
            if (location == exp.length()) {
                look = '\u0000';
                continue;
            }
            if (location + 1 != exp.length()) {
                look = exp.charAt(++location);
                continue;
            }
            ++location;
            break;
        }
        list.add(Token2.toString());
        list.add(new Integer(location - 1));
        return list;
    }

    private int getActualSize(Map areaMap, List sortList, boolean isShowTotal) {
        if (!isShowTotal) {
            return areaMap.size();
        }
        int result = areaMap.size();
        int totalSize = 0;
        if (sortList != null) {
            String tmpCompanyName = "";
            for (int i = 0; i < sortList.size(); ++i) {
                String companyName;
                if (!areaMap.containsKey(sortList.get(i)) || tmpCompanyName.equals(companyName = (String)((Map)areaMap.get(sortList.get(i))).get("COMPANY_NAME"))) continue;
                ++totalSize;
                tmpCompanyName = companyName;
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            for (Map map : areaMap.values()) {
                String companyName = (String)map.get("COMPANY_NAME");
                if (list.contains(companyName)) continue;
                list.add(companyName);
            }
            totalSize = list.size();
        }
        return result += totalSize;
    }

    protected void dealWithBasePoint(Book book) throws BOSException {
    }

    protected void fillMultiSumData(DynaParameters param, Point basePoint, Sheet table, Map map, int selectedSize) throws EASBizException, BOSException {
    }

    protected Map calcMultiDynaSumRpt(String reportID, List companyList, Map tableValues) throws EASBizException, BOSException {
        return null;
    }

    private DItemGradeInfo getTemplateGradeInfo(Sheet curSheet, Point basePoint, DynaParameters param) {
        Object dItemGradeInfo = curSheet.getRange(basePoint.y, basePoint.x).getUserObject("DItemGradeInfo");
        DItemGradeInfo gradeInfo = null;
        if (param.isGrade() || dItemGradeInfo instanceof DItemGradeInfo) {
            gradeInfo = (DItemGradeInfo)dItemGradeInfo;
        }
        if (gradeInfo != null) {
            gradeInfo.reform();
        }
        return gradeInfo;
    }

    class DyNumberComparetor
    implements Comparator {
        Map nameMap = null;

        public DyNumberComparetor(Map nameMap) {
            this.nameMap = nameMap;
        }

        public int compare(Object arg0, Object arg1) {
            Map values0 = (Map)this.nameMap.get(arg0);
            Map values1 = (Map)this.nameMap.get(arg1);
            if (values0.get("KEY_DITEM_SORT_NUMBER") != null && values1.get("KEY_DITEM_SORT_NUMBER") != null) {
                return ((String)values0.get("KEY_DITEM_SORT_NUMBER")).compareTo((String)values1.get("KEY_DITEM_SORT_NUMBER"));
            }
            if (values0.get("KEY_DITEM_NAME") != null && values1.get("KEY_DITEM_NAME") != null) {
                return Collator.getInstance(Locale.CHINA).compare(values0.get("KEY_DITEM_NAME"), values1.get("KEY_DITEM_NAME"));
            }
            return 0;
        }
    }

    class ChinaComparetor
    implements Comparator {
        Comparator chinaComparetor = null;

        public ChinaComparetor(Comparator chinaComparetor) {
            this.chinaComparetor = chinaComparetor;
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 != null && arg1 != null) {
                int index0 = arg0.toString().indexOf("[");
                int index1 = arg1.toString().indexOf("[");
                if (index0 >= 0 && index1 >= 0) {
                    int firstResult = this.chinaComparetor.compare(arg0.toString().substring(0, index0), arg1.toString().substring(0, index1));
                    if (firstResult == 0) {
                        return this.chinaComparetor.compare(arg0.toString().substring(index0), arg1.toString().substring(index1));
                    }
                    return firstResult;
                }
                return this.chinaComparetor.compare(arg0, arg1);
            }
            if (arg0 != null) {
                return 1;
            }
            if (arg1 != null) {
                return -1;
            }
            return 0;
        }
    }

    class DynaKeyValue {
        public Integer range;
        public String dynaKey;
        public Integer dynaValueCol;

        DynaKeyValue() {
        }
    }
}

