/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.CslReportRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportRelaInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReportRela;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractSumRptTmpGuide_ChooseSheetUI;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptTmpGuideUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptTmpGuide_ChooseTmpUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptTmpGuide_ShowResultUI;
import com.kingdee.eas.fi.newrpt.client.designer.ReportDesignerUI;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Assert;

public class SumRptTmpGuide_ChooseSheetUI
extends AbstractSumRptTmpGuide_ChooseSheetUI {
    private static final String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptUIMsg";
    private Book srcBook = null;
    private Map sheetParams = null;

    public void onLoad() throws Exception {
        super.onLoad();
        MnsRptTmpGuideUIUtil.initGuideImage(this.pnlImage);
        MnsRptTmpGuideUIUtil.hmUIs.put(SumRptTmpGuide_ChooseSheetUI.class.getName(), this);
        this.initData();
        this.btnCancel.setEnabled(true);
        this.btnNextStep.setEnabled(false);
        this.btnPreStep.setEnabled(true);
        this.btnFinished.setEnabled(true);
        this.btnHelp.setVisible(false);
        this.btnSelectAll.setEnabled(true);
        this.btnSelectNone.setEnabled(true);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectNone.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnFinished.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SumRptTmpGuide_ChooseSheetUI.this.btnFinished_actionPerformed(e);
                }
                catch (Exception e1) {
                    SysUtil.abort((Throwable)e1);
                }
            }
        });
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        if (MnsRptTmpGuideUIUtil.isCloseWindow((Component)((Object)this))) {
            MnsRptTmpGuideUIUtil.closeAllUI();
        }
    }

    protected void btnFinished_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<Object> selectSheetIds = new ArrayList<Object>();
        for (int i = 0; i < this.pnlChkBox.getComponentCount(); ++i) {
            KDCheckBox checkBox = (KDCheckBox)this.pnlChkBox.getComponent(i);
            if (!checkBox.isSelected()) continue;
            selectSheetIds.add(checkBox.getUserObject());
        }
        if (selectSheetIds.size() > 0) {
            Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(SumRptTmpGuide_ChooseTmpUI.class.getName());
            ReportDesignerUI reportUI = null;
            TemplateInfo curTemplate = null;
            TemplateInfo templateModel = null;
            if (obj != null && obj instanceof SumRptTmpGuide_ChooseTmpUI) {
                SumRptTmpGuide_ChooseTmpUI tmpUI = (SumRptTmpGuide_ChooseTmpUI)((Object)obj);
                reportUI = tmpUI.reportUI;
                curTemplate = tmpUI.curTemplate;
                templateModel = tmpUI.templateModel;
            }
            Iterator iterSheet = selectSheetIds.iterator();
            if (reportUI == null) {
                throw new Exception("reportUI is null.");
            }
            Book destBook = reportUI.getBook();
            String name = BOSUuid.create((String)"SHEET").toString();
            name = StringUtils.replace((String)name, (String)"-", (String)"");
            destBook.insertSheet(0, new Sheet(destBook, name));
            while (destBook.getSheetCount() > 1) {
                destBook.removeSheet(1);
            }
            Map<String, Boolean> paramMap = this.getDefaultParam();
            this.setBookAutoCalAndUndoByParam(paramMap);
            while (iterSheet.hasNext()) {
                String curSheetID = (String)iterSheet.next();
                Sheet sheet = this.srcBook.getSheetByID(curSheetID);
                this.deleteInBlock(sheet);
                destBook.insertSheet(destBook.getSheetCount(), sheet, false);
                sheet.setID(curSheetID);
            }
            this.restoreBookAutoCalAndUndoByParam(paramMap);
            destBook.removeSheet(name);
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection col = filter.getFilterItems();
            if (col != null && curTemplate != null) {
                col.add(new FilterItemInfo("targetTemplet", (Object)curTemplate.getId().toString()));
            }
            entityView.setFilter(filter);
            CslReportRelaInfo relaInfo = new CslReportRelaInfo();
            relaInfo.setTargetTemplet(curTemplate);
            relaInfo.setSourceTemplet(templateModel);
            ICslReportRela rela = CslReportRelaFactory.getRemoteInstance();
            CoreBaseCollection relas = rela.getCollection(entityView);
            if (relas != null && relas.size() > 0) {
                for (CslReportRelaInfo tmpRela : relas) {
                    rela.delete((IObjectPK)new ObjectUuidPK(tmpRela.getId()));
                }
            }
            rela.addnew((CoreBaseInfo)relaInfo);
        }
        MnsRptTmpGuideUIUtil.hmUIs.clear();
        MnsRptTmpGuideUIUtil.closeAllUI();
        this.uiWindow.close();
        this.destroyWindow();
    }

    private Map<String, Boolean> getDefaultParam() {
        Boolean restoreCalculate = new Boolean(false);
        Boolean restoreUnManager = new Boolean(false);
        HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>();
        paramMap.put("restoreCalculate", restoreCalculate);
        paramMap.put("restoreUnManager", restoreUnManager);
        return paramMap;
    }

    private void setBookAutoCalAndUndoByParam(Map<String, Boolean> paramMap) {
        if (this.srcBook.isAutoCalculate()) {
            paramMap.remove("restoreCalculate");
            paramMap.put("restoreCalculate", true);
            this.srcBook.setCalculate(false);
        }
        if (this.srcBook.getUndoManager().isEnable()) {
            paramMap.remove("restoreUnManager");
            paramMap.put("restoreUnManager", true);
            this.srcBook.getUndoManager().enable(false);
        }
    }

    private void restoreBookAutoCalAndUndoByParam(Map<String, Boolean> paramMap) {
        if (paramMap.get("restoreCalculate").booleanValue()) {
            this.srcBook.setCalculate(true);
        }
        if (paramMap.get("restoreUnManager").booleanValue()) {
            this.srcBook.getUndoManager().enable(true);
        }
    }

    private void deleteInBlock(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        Sheet.ICellsIterator cellsIterator = sheet.getCellsIterator(null, true, true);
        Cell cell = null;
        while (cellsIterator.hasNext()) {
            String formula;
            cell = cellsIterator.next();
            if (cell == null || !CslRptUtil.isBusinessDependent(formula = cell.getFormula())) continue;
            cell.setFormula(null);
        }
    }

    @Override
    protected void btnNextStep_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void btnPreStep_actionPerformed(ActionEvent e) throws Exception {
        super.btnPreStep_actionPerformed(e);
        this.getUIWindow().hide();
        Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(SumRptTmpGuide_ChooseTmpUI.class.getName());
        if (obj != null && obj instanceof CoreUI) {
            CoreUI preUI = (CoreUI)obj;
            preUI.getUIWindow().show();
        }
    }

    private String getNextUIName() {
        return SumRptTmpGuide_ShowResultUI.class.getName();
    }

    private void initData() throws Exception {
        Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(SumRptTmpGuide_ChooseTmpUI.class.getName());
        if (obj != null && obj instanceof SumRptTmpGuide_ChooseTmpUI) {
            SumRptTmpGuide_ChooseTmpUI tmpUI = (SumRptTmpGuide_ChooseTmpUI)((Object)obj);
            TemplateInfo templateModel = tmpUI.templateModel;
            Assert.assertNotNull((Object)templateModel);
            this.srcBook = templateModel.getBook();
            RptSheetParamCollection sheets = templateModel.getSheetParam();
            Iterator iter = sheets.iterator();
            this.sheetParams = new HashMap();
            while (iter.hasNext()) {
                RptSheetParamInfo sheetParam = (RptSheetParamInfo)iter.next();
                this.sheetParams.put(sheetParam.getSheetID(), sheetParam);
            }
            this.initSheetNamePanel(templateModel.getSheetParam());
            this.sheetParams.clear();
            this.sheetParams = null;
        }
    }

    private void initSheetNamePanel(RptSheetParamCollection collection) {
        this.pnlChkBox.removeAll();
        if (this.srcBook == null || this.srcBook.getSheetCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SheetIsNull"));
            Object obj = MnsRptTmpGuideUIUtil.hmUIs.get(SumRptTmpGuide_ChooseTmpUI.class.getName());
            if (obj instanceof CoreUI) {
                CoreUI nextUI = (CoreUI)obj;
                nextUI.getUIWindow().show();
            }
            SysUtil.abort();
        }
        if (this.srcBook.getSheetCount() < 7) {
            this.pnlChkBox.setLayout((LayoutManager)new GridLayout(7, 1));
        } else {
            this.pnlChkBox.setLayout((LayoutManager)new GridLayout(this.srcBook.getSheetCount(), 1));
        }
        KDCheckBox tmpChk = null;
        int rptGroup = -1;
        for (int i = 0; i < this.srcBook.getSheetCount(); ++i) {
            Sheet sheet = this.srcBook.getSheet(i);
            RptSheetParamInfo sheetParam = (RptSheetParamInfo)this.sheetParams.get(sheet.getID());
            if (sheetParam == null || sheetParam.getReportClass() == null || (rptGroup = sheetParam.getReportClass().getValue()) == -1 || rptGroup == 10 || rptGroup == 20 || rptGroup == 30 || rptGroup == 40) continue;
            tmpChk = new KDCheckBox(sheet.getSheetName());
            tmpChk.setUserObject((Object)sheetParam.getSheetID());
            this.pnlChkBox.add((Component)tmpChk);
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        int count = this.pnlChkBox.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component com = this.pnlChkBox.getComponent(i);
            if (!(com instanceof KDCheckBox)) continue;
            ((KDCheckBox)com).setSelected(true);
        }
    }

    @Override
    public void actionSelectNone_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectNone_actionPerformed(e);
        int count = this.pnlChkBox.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component com = this.pnlChkBox.getComponent(i);
            if (!(com instanceof KDCheckBox)) continue;
            ((KDCheckBox)com).setSelected(false);
        }
    }
}

