/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupNormalProcessUI;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TitleProcessUI
extends GroupNormalProcessUI {
    private boolean isCaceled = true;
    private static final long serialVersionUID = 2345900243622732922L;
    private KDWorkButton btnConfirm = new KDWorkButton();
    private Map titleColIndexMap = new HashMap();

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.clearCache();
        this.initMyToolBar();
        this.addBookChangeListener();
        this.initForFisrtAccess();
    }

    private void initForFisrtAccess() {
        Sheet sheet = this.getBook().getActiveSheet();
        this.fillAnalysisColMap(sheet);
    }

    private void addBookChangeListener() {
        this.getBook().addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                TitleProcessUI.this.getSpreadManager().getSpreadContainer().getSpread().scrollCellVisible(0, 0);
                Sheet sheet = e.getSheet();
                TitleProcessUI.this.fillAnalysisColMap(sheet);
            }
        });
    }

    private void fillAnalysisColMap(Sheet sheet) {
        String sheetID = sheet.getID();
        String sheetName = sheet.getSheetName();
        String id = this.specialID(sheetName, sheetID);
        Set set = this.titleColIndexMap.keySet();
        if (!set.contains(id)) {
            this.titleColIndexMap.put(id, new ArrayList());
        }
    }

    private String specialID(String sheetName, String sheetID) {
        return sheetID + "&" + sheetName;
    }

    private void initMyToolBar() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        toolBarManager.getToolBar("style").setVisible(false);
        this.btnConfirm.setName("btnConfirm");
        this.btnConfirm.setEnabled(true);
        this.btnConfirm.setVisible(true);
        this.btnConfirm.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"314_AdjustTempletEditUI"));
        this.btnConfirm.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"314_AdjustTempletEditUI"));
        this.btnConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TitleProcessUI.this.btnConfirm_actionPerformed();
            }
        });
        toolBarManager.getToolBar("common").add((Component)this.btnConfirm);
        int number = toolBarManager.getToolBar("common").getComponentCount();
        for (int i = number - 1; i >= 1; --i) {
            Component c = toolBarManager.getToolBar("common").getComponent(i);
            if (c instanceof KDWorkButton) {
                KDWorkButton btn = (KDWorkButton)c;
                if (btn.getName() != null && "btnConfirm".equals(btn.getName().trim())) continue;
                toolBarManager.getToolBar("common").remove(c);
                continue;
            }
            toolBarManager.getToolBar("common").remove(c);
        }
    }

    private void btnConfirm_actionPerformed() {
        this.getUIWindow().close();
        this.confirm();
        this.isCaceled = false;
    }

    private void confirm() {
        boolean isSelectTitle = this.getUIContext().get("isSelectTitle") == null ? true : (Boolean)this.getUIContext().get("isSelectTitle");
        Book book = this.getBook();
        Set set = this.titleColIndexMap.keySet();
        int num = book.getSheetCount();
        for (int i = 0; i < num; ++i) {
            Sheet currentSheet = book.getSheet(i);
            String id = this.specialID(currentSheet.getSheetName(), currentSheet.getID());
            if (!set.contains(id)) continue;
            ArrayList<Integer> list = new ArrayList<Integer>();
            Range range = currentSheet.getSelectionRange();
            for (int j = range.size() - 1; j >= 0; --j) {
                CellBlock block = (CellBlock)range.getAt(j);
                for (int k = block.getCol2(); k >= block.getCol(); --k) {
                    if (isSelectTitle) {
                        list.add(new Integer(k));
                        continue;
                    }
                    if (!this.isAnalysisCol(currentSheet, k)) continue;
                    list.add(new Integer(k));
                }
            }
            if (list.size() != 0) {
                this.titleColIndexMap.put(id, list);
                continue;
            }
            this.titleColIndexMap.remove(id);
        }
    }

    private boolean isAnalysisCol(Sheet sheet, int columnIndex) {
        int rowCount = sheet.getMaxRowIndex() + 1;
        boolean returnFlag = false;
        for (int i = 0; i < rowCount; ++i) {
            Cell cell = sheet.getCell(i, columnIndex, false);
            String itemFormula = TemplateHelper.getItemFormula((Cell)cell);
            if (itemFormula == null || itemFormula.trim().length() <= 0) continue;
            returnFlag = true;
            break;
        }
        return returnFlag;
    }

    private void clearCache() {
        this.titleColIndexMap.clear();
    }

    public boolean destroyWindow() {
        this.confirm();
        return super.destroyWindow();
    }

    private Map getTitleColIndexMap() {
        return this.titleColIndexMap;
    }

    public void onShow() {
        super.onShow();
        this.getSpreadManager().getSpreadContainer().getSpread().getBook().getActiveSheet().getRange(0, 0).select();
        this.getSpreadManager().getSpreadContainer().getSpread().scrollCellVisible(0, 0);
    }

    public Object getData() {
        StringBuffer colNamesBuff = new StringBuffer();
        Map map = this.getTitleColIndexMap();
        if (map == null) {
            return "";
        }
        ArrayList keyList = new ArrayList(map.keySet());
        int iNum = keyList.size();
        for (int i = 0; i < iNum; ++i) {
            String key = keyList.get(i).toString();
            List tempList = (List)map.get(key);
            String name = key.split("&")[1];
            colNamesBuff.append(name);
            colNamesBuff.append("(");
            int jNum = tempList.size();
            for (int j = 0; j < jNum; ++j) {
                int index = Integer.valueOf(tempList.get(j).toString());
                colNamesBuff.append(TableToolkit.int2pos((int)index));
                if (j == jNum - 1) break;
                colNamesBuff.append(",");
            }
            colNamesBuff.append(")");
            if (i == iNum - 1) break;
            colNamesBuff.append(";");
        }
        return colNamesBuff.toString();
    }

    public boolean isCaceled() {
        return this.isCaceled;
    }
}

