/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DispenseSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletGroupFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletGroupInfo;
import com.kingdee.eas.fi.gr.cslrpt.ITempletDispense;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseCollection;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ElimTempletGnlDispenseUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ElimTempletGroupListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.gr.cslrpt.client.TpltGroupDisData;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TpltGroupDispenseToUniUI
extends ElimTempletGnlDispenseUI {
    private TempletDispenseCollection templetDispenseCollection = null;
    private static final long serialVersionUID = -7378949352349612981L;

    @Override
    public void onLoad() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"TpltGroupUnDispense_Title"));
        super.onLoad();
    }

    protected ITempletDispense getBizInterfaceSelf() throws Exception {
        return TempletDispenseFactory.getRemoteInstance();
    }

    @Override
    protected void loadOrgTreeSelected() {
    }

    @Override
    protected void loadOrgTreeSelected(OrgTreeInfo orgTreeInfo) {
        this.tblOrgTreeSelected.removeRows();
        try {
            TempletDispenseCollection dispenseCollection;
            String orgTreeID = orgTreeInfo.getId().toString();
            this.templetDispenseCollection = dispenseCollection = this.getDisedRecordsByBDAndTempID(orgTreeID);
            OrgTreeCollection orgTreeCollection = new OrgTreeCollection();
            this.buildTreeScByBound(orgTreeInfo, orgTreeID, dispenseCollection, orgTreeCollection);
            OrgTreeCollection orgTreeUniqueCollection = CslRptUIUtil.getOrgTreeUniqueCollection(orgTreeCollection);
            this.addScAndFormatToTreeWhenCheckBound(orgTreeUniqueCollection);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, TpltGroupDisData> org_unitTemplateNameMap = new HashMap<String, TpltGroupDisData>();
        CoreBaseCollection infos = this.buildCollForDis(org_unitTemplateNameMap);
        this.disAndPrompt(e, infos);
        this.destroyWindow();
        if (org_unitTemplateNameMap.size() > 0) {
            String result = this.getUndisString(org_unitTemplateNameMap);
            UIContext uiCtx = new UIContext((Object)this);
            String title = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"TEMPLATEGROUP_UNDIS_TITLE");
            uiCtx.put((Object)"Title", (Object)title);
            SimpleNotePad.showMessageByModel(uiCtx, result);
        } else if (infos.size() > 0) {
            ElimTempletGroupListUI ui = (ElimTempletGroupListUI)((Object)this.getUIContext().get("Owner"));
            ui.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"temGroup_disp_succ"));
            ui.showMessage();
        }
    }

    private String getUndisString(Map<String, TpltGroupDisData> org_unitTemplateNameMap) {
        StringBuilder report = new StringBuilder();
        String str = null;
        Object[] params = new Object[2];
        str = "----------------------------------------------------{0}----------------------------------------------------";
        report.append(MessageFormat.format(str, CslRptUtil.getString("TemplateGroup_UnDispense_CheckInfo"))).append("\r\n\r\n");
        str = CslRptUtil.getString("TemplateGroup_UnDispense_InfoTitle");
        report.append(str).append("\r\n");
        Collection<TpltGroupDisData> tpltGroupDisDataCol = org_unitTemplateNameMap.values();
        for (TpltGroupDisData tData : tpltGroupDisDataCol) {
            String orgBoundNumber = tData.getOrgBoundNumber();
            String orgBoundName = tData.getOrgBoundName();
            params[0] = orgBoundNumber;
            params[1] = orgBoundName;
            str = CslRptUtil.getString("TemplateGroup_UnDispense_OrgBoundInfo");
            report.append("\r\n").append(MessageFormat.format(str, params)).append("\r\n");
            List<TpltGroupDisData.TpltGroupDisUnitData> unitDataList = tData.getUnitDataList();
            for (TpltGroupDisData.TpltGroupDisUnitData tDisUnitData : unitDataList) {
                params[0] = tDisUnitData.getUnitNumber();
                params[1] = tDisUnitData.getUnitName();
                str = CslRptUtil.getString("TemplateGroup_UnDispense_UnitInfo");
                report.append(MessageFormat.format(str, params)).append("\r\n");
                params[0] = tDisUnitData.getElimTempletGroupNumber();
                params[1] = tDisUnitData.getElimTempletGroupName();
                str = CslRptUtil.getString("TemplateGroup_UnDispense_TemplateGroupInfo");
                report.append(MessageFormat.format(str, params)).append("\r\n");
            }
        }
        return report.toString();
    }

    private void disAndPrompt(ActionEvent e, CoreBaseCollection infos) throws BOSException, EASBizException, Exception {
        Result result;
        if (infos.size() > 0 && (result = this.getBizInterfaceSelf().submit(infos)).getResult() != 1) {
            StringBuffer errMsg = new StringBuffer();
            String msg = "";
            Object[] oParameter = null;
            for (int i = 0; i < result.size(); ++i) {
                if (result.getLineResult(i).isSucess()) continue;
                Exception ex = result.getLineResult(i).getException();
                if (e == null) {
                    msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"17_AdjustTempletDispenseUI");
                    oParameter = new Object[]{i + 1};
                } else {
                    msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"18_AdjustTempletDispenseUI");
                    oParameter = new Object[]{i + 1, ex.getMessage()};
                }
                errMsg.append(MessageFormat.format(msg, new Object[]{oParameter})).append("\\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"313_AdjustTempletDispenseUI"), (String)errMsg.toString(), (int)8188);
        }
    }

    private CoreBaseCollection buildCollForDis(Map<String, TpltGroupDisData> org_unitTemplateNameMap) throws Exception {
        int i;
        int count = this.tblOrgTreeSelected.getRowCount();
        CoreBaseCollection infos = new CoreBaseCollection();
        if (count == 0 || this.prmptOrgBound.getValue() == null) {
            return infos;
        }
        String orgTreeID = ((OrgTreeInfo)this.prmptOrgBound.getValue()).getId().toString();
        TempletDispenseCollection dispenseCollection = this.getDisedRecordsByBDAndTempID(orgTreeID);
        HashSet<String> dispensedUnitIdSet = new HashSet<String>();
        if (dispenseCollection != null) {
            for (int i2 = 0; i2 < dispenseCollection.size(); ++i2) {
                dispensedUnitIdSet.add(dispenseCollection.get(i2).getCompany().getId().toString());
            }
        }
        HashMap<String, TempletDispenseInfo> unit_disMap = new HashMap<String, TempletDispenseInfo>();
        String unitId = null;
        for (i = 0; i < count; ++i) {
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(BOSUuid.read((String)this.tblOrgTreeSelected.getRow(i).getCell(6).getValue().toString()));
            orgTree.setName(this.tblOrgTreeSelected.getRow(i).getCell(5).getValue().toString());
            orgTree.setNumber(this.tblOrgTreeSelected.getRow(i).getCell(4).getValue().toString());
            OrgUnitInfo unitTree = new OrgUnitInfo();
            unitTree.setId(BOSUuid.read((String)this.tblOrgTreeSelected.getRow(i).getCell(2).getValue().toString()));
            unitTree.setName(this.tblOrgTreeSelected.getRow(i).getCell(1).getValue().toString());
            unitTree.setNumber(this.tblOrgTreeSelected.getRow(i).getCell(0).getValue().toString());
            TempletDispenseInfo info = new TempletDispenseInfo();
            info.setSourceType(DispenseSrcTypeEnum.ELIMTEMPLETGROUP);
            info.setDispenseSrcID(this.dispenseSrcId);
            info.setOrgBound(orgTree);
            info.setCompany(unitTree.castToFullOrgUnitInfo());
            info.setBoolean("isFromElimAdd", true);
            unitId = info.getCompany().getId().toString();
            if (dispensedUnitIdSet.contains(unitId)) continue;
            unit_disMap.put(unitId, info);
        }
        if (unit_disMap.size() > 0) {
            dispenseCollection = this.getDisedRecordsByBDAndSourceType(orgTreeID);
            if (dispenseCollection != null && dispenseCollection.size() > 0) {
                for (i = 0; i < dispenseCollection.size(); ++i) {
                    TempletDispenseInfo info = dispenseCollection.get(i);
                    FullOrgUnitInfo company = info.getCompany();
                    String unitID = company.getId().toString();
                    String unitName = company.getName();
                    String unitNumber = company.getNumber();
                    if (!unit_disMap.containsKey(unitID)) continue;
                    unit_disMap.remove(unitID);
                    String orgName = info.getOrgBound().getName();
                    String orgNumber = info.getOrgBound().getNumber();
                    String srcId = info.getDispenseSrcID();
                    ElimTempletGroupInfo eInfo = ElimTempletGroupFactory.getRemoteInstance().getElimTempletGroupInfo("select name,number where id = '" + srcId + "'");
                    String templateName = eInfo.getName();
                    String templateNumber = eInfo.getNumber();
                    TpltGroupDisData tpltGroupDisData = org_unitTemplateNameMap.get(orgTreeID.toString());
                    if (tpltGroupDisData == null) {
                        tpltGroupDisData = new TpltGroupDisData();
                        tpltGroupDisData.setOrgBoundName(orgName);
                        tpltGroupDisData.setOrgBoundNumber(orgNumber);
                        org_unitTemplateNameMap.put(orgTreeID.toString(), tpltGroupDisData);
                    }
                    TpltGroupDisData.TpltGroupDisUnitData unitInstance = tpltGroupDisData.getUnitInstance();
                    unitInstance.setUnitName(unitName);
                    unitInstance.setUnitNumber(unitNumber);
                    unitInstance.setElimTempletGroupName(templateName);
                    unitInstance.setElimTempletGroupNumber(templateNumber);
                    tpltGroupDisData.getUnitDataList().add(unitInstance);
                }
            }
            if (unit_disMap.size() > 0) {
                Iterator it = unit_disMap.values().iterator();
                while (it.hasNext()) {
                    infos.add((CoreBaseInfo)it.next());
                }
            }
        }
        return infos;
    }

    private TempletDispenseCollection getDisedRecordsByBDAndSourceType(String orgTreeID) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgBound", (Object)orgTreeID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)2, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("orgBound.name"));
        sic.add(new SelectorItemInfo("orgBound.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        view.setFilter(filter);
        view.setSelector(sic);
        return this.getBizInterfaceSelf().getTempletDispenseCollection(view);
    }

    private void delDisedRecords() throws BOSException, EASBizException, Exception {
        if (this.templetDispenseCollection != null && this.templetDispenseCollection.size() > 0) {
            ObjectUuidPK[] pks = new ObjectUuidPK[this.templetDispenseCollection.size()];
            for (int i = 0; i < this.templetDispenseCollection.size(); ++i) {
                ObjectUuidPK pk;
                pks[i] = pk = new ObjectUuidPK(this.templetDispenseCollection.get(i).getId());
            }
            this.getBizInterfaceSelf().delete((IObjectPK[])pks);
        }
    }

    private TempletDispenseCollection getDisedRecordsByBDAndTempID(String orgTreeID) throws BOSException, Exception {
        TempletDispenseCollection dispenseCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgBound", (Object)orgTreeID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dispenseSrcID", (Object)this.dispenseSrcId, CompareType.EQUALS));
        view.setFilter(filter);
        dispenseCollection = this.getBizInterfaceSelf().getTempletDispenseCollection(view);
        return dispenseCollection;
    }

    private void addScAndFormatToTreeWhenCheckBound(OrgTreeCollection orgTreeUniqueCollection) {
        if (orgTreeUniqueCollection != null && orgTreeUniqueCollection.size() > 0) {
            this.orgTreeSelected = orgTreeUniqueCollection;
            this.addCollectionToTable(orgTreeUniqueCollection, this.tblOrgTreeSelected);
            String format = CslRptUIUtil.getNationalDateFormatString();
            if (format != null) {
                this.tblOrgTreeSelected.getColumn(7).getStyleAttributes().setNumberFormat("%{" + format + "}t");
                this.tblOrgTreeSelected.getColumn(8).getStyleAttributes().setNumberFormat("%{" + format + "}t");
            } else {
                this.tblOrgTreeSelected.getColumn(7).getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
                this.tblOrgTreeSelected.getColumn(8).getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
            }
        } else {
            this.orgTreeSelected = null;
        }
    }

    private void buildTreeScByBound(OrgTreeInfo orgTreeInfo, String orgTreeID, TempletDispenseCollection dispenseCollection, OrgTreeCollection orgTreeCollection) throws BOSException, Exception {
        if (dispenseCollection != null && dispenseCollection.size() > 0) {
            ArrayList companys = this.getBizInterfaceSelf().getUnitBySrcIDAndOrgID(this.dispenseSrcId, orgTreeID);
            int count = companys.size();
            HashMap row = new HashMap();
            for (int i = 0; i < count; ++i) {
                row = (HashMap)companys.get(i);
                OrgTreeInfo cmpTree = new OrgTreeInfo();
                cmpTree.setId(BOSUuid.read((String)row.get("unitID").toString()));
                cmpTree.setName(row.get("unitName").toString());
                cmpTree.setNumber(row.get("unitNum").toString());
                cmpTree.setString("orgTreeID", row.get("orgID").toString());
                cmpTree.setString("orgNum", row.get("orgNum").toString());
                cmpTree.setString("orgName", row.get("orgName").toString());
                Timestamp orgStartDate = orgTreeInfo.getStartDate();
                Timestamp orgEndDate = orgTreeInfo.getEndDate();
                cmpTree.setString("orgStartDate", orgStartDate != null ? orgStartDate.toString() : "");
                cmpTree.setString("orgEndDate", orgEndDate != null ? orgEndDate.toString() : "");
                orgTreeCollection.add(cmpTree);
            }
        }
    }

    private void setTreeDataAndFormat(OrgTreeCollection orgTreeCollection) {
        if (orgTreeCollection != null && orgTreeCollection.size() > 0) {
            this.orgTreeSelected = orgTreeCollection;
            this.addCollectionToTable(orgTreeCollection, this.tblOrgTreeSelected);
            String format = CslRptUIUtil.getNationalDateFormatString();
            if (format == null) {
                this.tblOrgTreeSelected.getColumn(7).getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
                this.tblOrgTreeSelected.getColumn(8).getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
            } else {
                this.tblOrgTreeSelected.getColumn(7).getStyleAttributes().setNumberFormat("%{" + format + "}t");
                this.tblOrgTreeSelected.getColumn(8).getStyleAttributes().setNumberFormat("%{" + format + "}t");
            }
        }
    }

    private void buildSltedTreeScData(TempletDispenseCollection dispenseCollection, OrgTreeCollection orgTreeCollection) throws BOSException, Exception {
        if (dispenseCollection != null && dispenseCollection.size() > 0) {
            ArrayList companys = this.getBizInterfaceSelf().getUnitByDispenseSrcID(this.dispenseSrcId);
            int count = companys.size();
            for (int i = 0; i < count; ++i) {
                HashMap row = (HashMap)companys.get(i);
                OrgTreeInfo cmpTree = new OrgTreeInfo();
                cmpTree.setId(BOSUuid.read((String)row.get("unitID").toString()));
                cmpTree.setName(row.get("unitName").toString());
                cmpTree.setNumber(row.get("unitNum").toString());
                cmpTree.setString("orgID", row.get("orgID").toString());
                cmpTree.setString("orgNum", row.get("orgNum").toString());
                cmpTree.setString("orgName", row.get("orgName").toString());
                cmpTree.setString("orgStartDate", row.get("startDate") != null ? row.get("startDate").toString() : "");
                cmpTree.setString("orgEndDate", row.get("endDate") != null ? row.get("endDate").toString() : "");
                orgTreeCollection.add(cmpTree);
            }
        }
    }

    private TempletDispenseCollection getDisedRecords() throws BOSException, Exception {
        TempletDispenseCollection dispenseCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("dispenseSrcID", (Object)this.dispenseSrcId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgBound.status", (Object)1));
        view.setFilter(filter);
        dispenseCollection = this.getBizInterfaceSelf().getTempletDispenseCollection(view);
        return dispenseCollection;
    }

    @Override
    protected void prmptOrgBound_dataChanged(DataChangeEvent e) throws Exception {
        super.prmptOrgBound_dataChanged(e);
        if (this.prmptOrgBound.getValue() == null) {
            this.tblOrgTreeSelected.removeRows();
        }
    }
}

