/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DispenseSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ITempletDispense;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseCollection;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractTpltGroupDispenseUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;

public class TpltGroupDispenseUI
extends AbstractTpltGroupDispenseUI {
    private static final int ORGTREE_NUMBER = 0;
    private static final int ORGTREE_NAME = 1;
    private static final int ORGTREE_ID = 2;
    private static final int ORGTREE = 3;
    private IOrgTree iOrgTree = null;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes";
    private String resName = "OrgTree_All_Have_ElimGrp";
    private String dispenseSrcId = null;
    private OrgTreeCollection orgTreeForSelect = null;
    private OrgTreeCollection orgTreeSelected = null;
    private TempletDispenseCollection tpltDisCollection = null;
    SelectorItemCollection sic = new SelectorItemCollection();

    public TpltGroupDispenseUI() throws Exception {
        this.sic.add(new SelectorItemInfo("id"));
        this.sic.add(new SelectorItemInfo("number"));
        this.sic.add(new SelectorItemInfo("name"));
        this.tblOrgTreeForSelect.getStyleAttributes().setLocked(true);
        this.tblOrgTreeForSelect.getSelectManager().setSelectMode(10);
        this.tblOrgTreeSelected.getStyleAttributes().setLocked(true);
        this.tblOrgTreeSelected.getSelectManager().setSelectMode(10);
    }

    private OrgTreeCollection getOrgTreeForSelect() {
        if (this.orgTreeForSelect == null) {
            this.orgTreeForSelect = new OrgTreeCollection();
        }
        return this.orgTreeForSelect;
    }

    private OrgTreeCollection getOrgTreeSelected() {
        if (this.orgTreeSelected == null) {
            this.orgTreeSelected = new OrgTreeCollection();
        }
        return this.orgTreeSelected;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSelect.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnUnSelect.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnUnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.dispenseSrcId = this.getUIContext().get("ID").toString();
        this.loadOrgTreeForSelect();
        this.loadOrgTreeSelected();
    }

    protected ITempletDispense getBizInterface() throws Exception {
        return TempletDispenseFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void loadOrgTreeForSelect() throws BOSException, EASBizException {
        OrgTreeCollection orgTreeCollection = null;
        TempletDispenseCollection dispenseCollection = null;
        try {
            orgTreeCollection = CslRptUIUtil.getOrgTreeUniqueCollection();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(2), CompareType.EQUALS));
            view.setFilter(filter1);
            dispenseCollection = this.getBizInterface().getTempletDispenseCollection(view);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (orgTreeCollection != null && orgTreeCollection.size() > 0) {
            if (dispenseCollection != null && dispenseCollection.size() > 0) {
                HashSet<String> orgTreeIdSet = new HashSet<String>();
                for (int i = 0; i < dispenseCollection.size(); ++i) {
                    orgTreeIdSet.add(dispenseCollection.get(i).getOrgBound().getId().toString());
                }
                HashMap orgTreeInfoMap = this.getOrgTreeInfoMap(orgTreeIdSet);
                block3: for (int i = 0; i < dispenseCollection.size(); ++i) {
                    ObjectUuidPK pk = new ObjectUuidPK(dispenseCollection.get(i).getOrgBound().getId());
                    OrgTreeInfo info = (OrgTreeInfo)orgTreeInfoMap.get(pk.toString());
                    for (int j = 0; j < orgTreeCollection.size(); ++j) {
                        if (info == null || !orgTreeCollection.get(j).getNumber().equals(info.getNumber())) continue;
                        orgTreeCollection.removeObject(j);
                        continue block3;
                    }
                }
            }
            this.orgTreeForSelect = orgTreeCollection;
            if (this.orgTreeForSelect != null && this.orgTreeForSelect.size() == 0) {
                MsgBox.showInfo((Component)this.getParent(), (String)EASResource.getString((String)this.resClassName, (String)this.resName));
            }
            this.addCollectionToTable(orgTreeCollection, this.tblOrgTreeForSelect);
        }
    }

    private void addCollectionToTable(OrgTreeCollection orgTreeCollection, KDTable table) {
        table.checkParsed();
        table.getSelectManager().setSelectMode(10);
        table.removeRows();
        int count = orgTreeCollection.size();
        for (int i = 0; i < count; ++i) {
            OrgTreeInfo orgTree = orgTreeCollection.get(i);
            IRow r = table.addRow();
            r.getCell(0).setValue((Object)orgTree.getNumber());
            r.getCell(1).setValue((Object)orgTree.getName());
            r.getCell(2).setValue((Object)orgTree.getId());
            r.getCell(3).setValue((Object)orgTree);
        }
        if (count > 0) {
            table.getSelectManager().select(0, 0, 0, 0);
        }
    }

    private void loadOrgTreeSelected() {
        TempletDispenseCollection dispenseCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("dispenseSrcID", (Object)this.dispenseSrcId, CompareType.EQUALS));
        view.setFilter(filter);
        OrgTreeCollection orgTreeCollection = new OrgTreeCollection();
        try {
            this.tpltDisCollection = dispenseCollection = this.getBizInterface().getTempletDispenseCollection(view);
            if (dispenseCollection != null && dispenseCollection.size() > 0) {
                int dispenseCount = dispenseCollection.size();
                HashSet<String> orgTreeIdSet = new HashSet<String>();
                for (int i = 0; i < dispenseCount; ++i) {
                    orgTreeIdSet.add(dispenseCollection.get(i).getOrgBound().getId().toString());
                }
                HashMap orgTreeInfoMap = this.getOrgTreeInfoMap(orgTreeIdSet);
                Object temp = null;
                for (int i = 0; i < dispenseCount; ++i) {
                    temp = orgTreeInfoMap.get(dispenseCollection.get(i).getOrgBound().getId().toString());
                    if (temp == null) continue;
                    OrgTreeInfo orgTree = temp;
                    orgTreeCollection.add(orgTree);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        OrgTreeCollection orgTreeUniqueCollection = CslRptUIUtil.getOrgTreeUniqueCollection(orgTreeCollection);
        if (orgTreeUniqueCollection != null && orgTreeUniqueCollection.size() > 0) {
            this.orgTreeSelected = orgTreeUniqueCollection;
            this.addCollectionToTable(orgTreeUniqueCollection, this.tblOrgTreeSelected);
        }
    }

    private HashMap getOrgTreeInfoMap(HashSet orgTreeIdSet) throws BOSException {
        if (this.iOrgTree == null) {
            this.iOrgTree = OrgTreeFactory.getRemoteInstance();
        }
        HashMap<String, OrgTreeInfo> orgTreeInfoMap = new HashMap<String, OrgTreeInfo>();
        if (orgTreeIdSet.size() > 0) {
            EntityViewInfo v = new EntityViewInfo();
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            v.getSelector().addObjectCollection((IObjectCollection)this.sic);
            f.getFilterItems().add(new FilterItemInfo("id", (Object)orgTreeIdSet, CompareType.INCLUDE));
            OrgTreeCollection trees = this.iOrgTree.getOrgTreeCollection(v);
            for (int i = 0; i < trees.size(); ++i) {
                orgTreeInfoMap.put(trees.get(i).getId().toString(), trees.get(i));
            }
        }
        return orgTreeInfoMap;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSelect_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelect_actionPerformed(e);
        if (!this.isAlreadyOneTemplateOfOrgBound(this.tblOrgTreeForSelect)) {
            OrgTreeCollection orgTreeCollection = this.getSelectedCollectionFromTable(this.tblOrgTreeForSelect);
            this.getOrgTreeSelected().addCollection(orgTreeCollection);
            this.addCollectionToTable(this.getOrgTreeSelected(), this.tblOrgTreeSelected);
            this.addCollectionToTable(this.getOrgTreeForSelect(), this.tblOrgTreeForSelect);
        }
    }

    private boolean isAlreadyOneTemplateOfOrgBound(KDTable table) throws Exception {
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = table.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                OrgTreeInfo orgTreeInfo = (OrgTreeInfo)table.getRow(j).getCell(3).getValue();
                this.getBizInterface().checkIsOnlyOneTplt(orgTreeInfo.getId().toString(), this.dispenseSrcId);
            }
        }
        return false;
    }

    @Override
    public void actionUnSelect_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnSelect_actionPerformed(e);
        OrgTreeCollection orgTreeCollection = this.getSelectedCollectionFromTable(this.tblOrgTreeSelected);
        this.getOrgTreeForSelect().addCollection(orgTreeCollection);
        this.addCollectionToTable(this.getOrgTreeSelected(), this.tblOrgTreeSelected);
        this.addCollectionToTable(this.getOrgTreeForSelect(), this.tblOrgTreeForSelect);
    }

    private OrgTreeCollection getOrgTreeCollection(KDTable table) {
        OrgTreeCollection orgTreeCol = null;
        if (table.equals(this.tblOrgTreeForSelect)) {
            orgTreeCol = this.getOrgTreeForSelect();
        } else if (table.equals(this.tblOrgTreeSelected)) {
            orgTreeCol = this.getOrgTreeSelected();
        }
        return orgTreeCol;
    }

    private OrgTreeCollection getSelectedCollectionFromTable(KDTable table) throws Exception {
        OrgTreeCollection orgTreeCollection = null;
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = table.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                if (orgTreeCollection == null) {
                    orgTreeCollection = new OrgTreeCollection();
                }
                OrgTreeInfo orgTreeInfo = (OrgTreeInfo)table.getRow(j).getCell(3).getValue();
                orgTreeCollection.add(orgTreeInfo);
                this.getOrgTreeCollection(table).remove(orgTreeInfo);
            }
        }
        return orgTreeCollection;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        Result result;
        super.actionConfirm_actionPerformed(e);
        if (this.tpltDisCollection != null && this.tpltDisCollection.size() > 0) {
            ObjectUuidPK[] pks = new ObjectUuidPK[this.tpltDisCollection.size()];
            for (int i = 0; i < this.tpltDisCollection.size(); ++i) {
                ObjectUuidPK pk;
                pks[i] = pk = new ObjectUuidPK(this.tpltDisCollection.get(i).getId());
            }
            this.getBizInterface().delete((IObjectPK[])pks);
        }
        OrgTreeCollection allOrgTreeSelect = CslRptUIUtil.getAllVersionOrgTreeCollection(this.getOrgTreeSelected());
        CoreBaseCollection infos = new CoreBaseCollection();
        for (int j = 0; j < allOrgTreeSelect.size(); ++j) {
            OrgTreeInfo orgTreeInfo = allOrgTreeSelect.get(j);
            if (orgTreeInfo.getStatus().getValue() == 0) continue;
            TempletDispenseInfo info = new TempletDispenseInfo();
            info.setSourceType(DispenseSrcTypeEnum.ELIMTEMPLETGROUP);
            info.setDispenseSrcID(this.dispenseSrcId);
            info.setOrgBound(allOrgTreeSelect.get(j));
            infos.add((CoreBaseInfo)info);
        }
        if (infos.size() > 0 && (result = this.getBizInterface().submit(infos)).getResult() != 1) {
            StringBuffer errMsg = new StringBuffer();
            String msg = null;
            Object[] oParamater = null;
            for (int i = 0; i < result.size(); ++i) {
                if (result.getLineResult(i).isSucess()) continue;
                Exception ex = result.getLineResult(i).getException();
                if (e == null) {
                    oParamater = new Object[]{i + 1};
                    msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"17_AdjustTempletDispenseUI");
                } else {
                    oParamater = new Object[]{i + 1, ex.getMessage()};
                    msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"18_AdjustTempletDispenseUI");
                }
                errMsg.append(MessageFormat.format(msg, new Object[]{oParamater})).append("\\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"313_AdjustTempletDispenseUI"), (String)errMsg.toString(), (int)8188);
        }
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        if (!this.isAlreadyOneTemplateOfOrgBound(this.tblOrgTreeForSelect)) {
            this.getOrgTreeSelected().addCollection(this.getOrgTreeForSelect());
            this.getOrgTreeForSelect().clear();
            this.addCollectionToTable(this.getOrgTreeSelected(), this.tblOrgTreeSelected);
            this.addCollectionToTable(this.getOrgTreeForSelect(), this.tblOrgTreeForSelect);
        }
    }

    @Override
    public void actionUnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnSelectAll_actionPerformed(e);
        this.getOrgTreeForSelect().addCollection(this.getOrgTreeSelected());
        this.getOrgTreeSelected().clear();
        this.addCollectionToTable(this.getOrgTreeSelected(), this.tblOrgTreeSelected);
        this.addCollectionToTable(this.getOrgTreeForSelect(), this.tblOrgTreeForSelect);
    }
}

