/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTPrintManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportRelaInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReportRela;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class UpdateSumRptTemplate {
    private static final Logger logger = Logger.getLogger(UpdateSumRptTemplate.class);

    private static TemplateCollection getTemplates() throws BOSException {
        String oql = "select id, name, company, templateType, sumType, data, lastUpdateTime where templateType = 3 and sumType = 1";
        TemplateCollection col = TemplateFactory.getRemoteInstance().getTemplateCollection(oql);
        return col;
    }

    private static TemplateInfo getNormalTmpBySumTmp(String templateId) throws BOSException, EASBizException {
        String oql = "select sourceTemplet.id, sourceTemplet.data where targetTemplet.id = '" + templateId + "'";
        ICslReportRela ir = CslReportRelaFactory.getRemoteInstance();
        if (ir.exists(oql)) {
            CslReportRelaInfo info = ir.getCslReportRelaInfo(oql);
            return info.getSourceTemplet();
        }
        return null;
    }

    public static void update() throws BOSException, EASBizException, IOException, KDFException {
        TemplateCollection col = UpdateSumRptTemplate.getTemplates();
        for (TemplateInfo sumTemplate : col) {
            TemplateInfo normalTemplate = UpdateSumRptTemplate.getNormalTmpBySumTmp(sumTemplate.getId().toString());
            if (normalTemplate == null) {
                logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"703_UpdateSumRptTemplate") + sumTemplate.getId().toString()));
                continue;
            }
            logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"704_UpdateSumRptTemplate") + sumTemplate.getId().toString()));
            UpdateSumRptTemplate.updateTemplate(sumTemplate, normalTemplate);
        }
    }

    private static void updateTemplate(TemplateInfo sumTemplate, TemplateInfo normalTemplate) throws IOException, KDFException, EASBizException, BOSException {
        KDF kdf = null;
        try {
            kdf = sumTemplate.getKDF();
        }
        catch (AssertionError e) {
            logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"705_UpdateSumRptTemplate") + sumTemplate.getId().toString()));
            return;
        }
        KDF nkdf = null;
        if (normalTemplate != null) {
            nkdf = normalTemplate.getKDF();
        } else {
            logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"706_UpdateSumRptTemplate") + sumTemplate.getId().toString() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"707_UpdateSumRptTemplate")));
        }
        boolean willSave = false;
        Color color = new Color(242, 242, 217);
        KDF newkdf = new KDF();
        Collection tables = kdf.getAllTable();
        for (KDTable table : tables) {
            RptSheet sheet = RptSheet.getRptSheet((KDTable)table);
            String sumZone = sheet.getSumCalcZone();
            if (sumZone != null) continue;
            willSave = true;
            Collection cells = UpdateSumRptTemplate.getAllSumCells(nkdf, table.getID());
            int colCount = table.getExpandedColumnCount();
            int rowCount = table.getExpandedRowCount();
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    String site = i + "," + j;
                    ICell cell = table.getCell(i, j);
                    if (cell == null) continue;
                    Object obj = cell.getValue();
                    boolean isNumeric = false;
                    if (obj != null) {
                        try {
                            BigDecimal value = new BigDecimal(obj.toString());
                            isNumeric = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (isNumeric && !cell.getStyleAttributes().isLocked()) {
                        sumZone = UpdateSumRptTemplate.addToSumZone(sumZone, site);
                        cell.getStyleAttributes().setBackground(color);
                        continue;
                    }
                    if (UpdateSumRptTemplate.hasFormula(cell)) {
                        sumZone = UpdateSumRptTemplate.addToSumZone(sumZone, site);
                        cell.getStyleAttributes().setBackground(color);
                        continue;
                    }
                    if (!cells.contains(site)) continue;
                    sumZone = UpdateSumRptTemplate.addToSumZone(sumZone, site);
                    cell.getStyleAttributes().setBackground(color);
                }
            }
            sheet.setSumCalcZone(sumZone);
            newkdf.addTable((IDObject)table);
            UpdateSumRptTemplate.savePrintSetting(table, newkdf);
        }
        nkdf = null;
        if (willSave) {
            HashMap map = kdf.getUserObjects();
            for (String key : map.keySet()) {
                newkdf.addUserObject(key, kdf.getUserObject(key));
            }
            sumTemplate.setKDF(newkdf);
            logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"708_UpdateSumRptTemplate"));
            TemplateFactory.getRemoteInstance().submit((CoreBaseInfo)sumTemplate);
        }
        kdf = null;
        newkdf = null;
    }

    private static void savePrintSetting(KDTable tbl, KDF kdf) {
        Page foot;
        KDTPrintManager pm = tbl.getPrintManager();
        Page head = pm.getHeader();
        if (head != null) {
            pm.setHeaderID(tbl.getID() + "header");
            kdf.addHeader(head);
        }
        if ((foot = pm.getFooter()) != null) {
            pm.setFooterID(tbl.getID() + "footer");
            kdf.addFooter(foot);
        }
        pm.saveToKDF(kdf);
    }

    private static boolean hasFormula(ICell cell) {
        RptCell rptCell;
        Object obj;
        String expression = cell.getExpressions();
        if (!StringUtils.isEmpty((String)expression)) {
            if (expression.indexOf("AcctItem") > 0) {
                return true;
            }
            if (expression.indexOf("CsRef") > 0) {
                return true;
            }
            if (expression.indexOf("Refm") > 0) {
                return true;
            }
            if (expression.indexOf("Ref") > 0) {
                return true;
            }
            if (expression.indexOf("ExchangeRate") > 0) {
                return true;
            }
            if (expression.indexOf("SUMIF") > 0) {
                return true;
            }
            if (expression.indexOf("Sum") > 0) {
                return true;
            }
            if (expression.indexOf("Max") > 0) {
                return true;
            }
            if (expression.indexOf("Min") > 0) {
                return true;
            }
            if (expression.indexOf("Count") > 0) {
                return true;
            }
            if (expression.indexOf("Average") > 0) {
                return true;
            }
            if (expression.indexOf("Item") > 0) {
                return true;
            }
            if (expression.indexOf("DItem") > 0) {
                return true;
            }
            if (expression.indexOf("DyItem") > 0) {
                return true;
            }
            if (expression.indexOf("AdjustData") > 0) {
                return true;
            }
            if (expression.indexOf("ElimData") > 0) {
                return true;
            }
            if (expression.indexOf("AcctAC") > 0) {
                return true;
            }
            if (expression.indexOf("Cash") > 0) {
                return true;
            }
            if (expression.indexOf("AcctExt") > 0) {
                return true;
            }
            if (expression.indexOf("AcctCash") > 0) {
                return true;
            }
            if (expression.indexOf("Acct") > 0) {
                return true;
            }
            if (expression.indexOf("=") == 0) {
                if (expression.indexOf("RptDate") > 0) {
                    return false;
                }
                return expression.indexOf("GetOrgName") <= 0;
            }
        }
        return (obj = cell.getUserObject()) != null && obj instanceof RptCell && (rptCell = (RptCell)obj).getItemFormula() != null;
    }

    private static String addToSumZone(String sumZone, String site) {
        if (sumZone == null) {
            return site;
        }
        return sumZone + "|" + site;
    }

    private static Collection getAllSumCells(KDF kdf, String id) {
        if (kdf == null) {
            return new ArrayList(0);
        }
        KDTable table = (KDTable)kdf.getTableByID(id);
        if (table == null) {
            return new ArrayList(0);
        }
        int colCount = table.getExpandedColumnCount();
        int rowCount = table.getExpandedRowCount();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                ICell cell = table.getCell(i, j);
                if (cell == null || !UpdateSumRptTemplate.hasFormula(cell)) continue;
                result.add(i + "," + j);
            }
        }
        return result;
    }
}

