/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeCompanyCollection;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeCompanyInfo;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeCurrencyCollection;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeCurrencyInfo;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeTemplateCollection;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeTemplateInfo;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeUpPeriodEnum;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeUpScheduleFactory;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeUpScheduleInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractWebTimeUpScheduleEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ProcessSchedulePlan;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WebTimeUpScheduleEditUI
extends AbstractWebTimeUpScheduleEditUI {
    private List selectedCurrency = new ArrayList();
    private List selectedCompany = new ArrayList();
    private List selectedTemplate = new ArrayList();
    private NewCompanyF7 companyF7;

    @Override
    public void loadFields() {
        super.loadFields();
        if (WebTimeUpPeriodEnum.currentPeriod.equals((Object)this.editData.getTimePeriod())) {
            this.rdoThisPeriod.setSelected(true);
        } else {
            this.rdoLastPeriod.setSelected(true);
        }
    }

    @Override
    public void storeFields() {
        int i;
        int i2;
        CoreBaseInfo info;
        int i3;
        super.storeFields();
        if (this.rdoThisPeriod.isSelected()) {
            this.editData.setTimePeriod(WebTimeUpPeriodEnum.currentPeriod);
        } else {
            this.editData.setTimePeriod(WebTimeUpPeriodEnum.lastPeriod);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.selectedCompany);
        WebTimeCompanyCollection col = this.editData.getCompanys();
        if (col == null) {
            col = new WebTimeCompanyCollection();
        }
        for (i3 = col.size() - 1; col != null && i3 >= 0; --i3) {
            WebTimeCompanyInfo info2 = col.get(i3);
            if (list.contains(info2.getCompany().getId().toString())) {
                list.remove(info2.getCompany().getId().toString());
                continue;
            }
            col.removeObject(i3);
        }
        if (!list.isEmpty()) {
            if (col == null) {
                col = new WebTimeCompanyCollection();
            }
            for (i3 = 0; i3 < list.size(); ++i3) {
                String companyid = (String)list.get(i3);
                info = new WebTimeCompanyInfo();
                FullOrgUnitInfo unit = new FullOrgUnitInfo();
                unit.setId(BOSUuid.read((String)companyid));
                info.setCompany(unit);
                info.setSchedule(this.editData);
                col.add((WebTimeCompanyInfo)info);
            }
        }
        list.clear();
        list.addAll(this.selectedTemplate);
        WebTimeTemplateCollection tcol = this.editData.getTemplates();
        if (tcol == null) {
            tcol = new WebTimeTemplateCollection();
        }
        for (i2 = tcol.size() - 1; tcol != null && i2 >= 0; --i2) {
            info = tcol.get(i2);
            String key = info.getTemplateNumber() + ";" + info.getTemplateType().getValue();
            if (list.contains(key)) {
                list.remove(key);
                continue;
            }
            tcol.removeObject(i2);
        }
        if (!list.isEmpty()) {
            if (tcol == null) {
                tcol = new WebTimeTemplateCollection();
            }
            for (i2 = 0; i2 < list.size(); ++i2) {
                String key = (String)list.get(i2);
                String[] str = key.split("\\;");
                String templateNumber = str[0];
                String type = str[1];
                WebTimeTemplateInfo info3 = new WebTimeTemplateInfo();
                info3.setTemplateNumber(templateNumber);
                info3.setTemplateType(RptTmpTypeEnum.getEnum((int)Integer.parseInt(type)));
                info3.setSchedule(this.editData);
                tcol.add(info3);
            }
        }
        this.selectedCurrency.clear();
        list.clear();
        for (i2 = 0; i2 < this.tblCurrency.getRowCount(); ++i2) {
            IRow row = this.tblCurrency.getRow(i2);
            if (!Boolean.TRUE.equals(row.getCell("select").getValue())) continue;
            String id = row.getCell("id").getValue().toString();
            this.selectedCurrency.add(id);
            list.add(id);
        }
        WebTimeCurrencyCollection ccol = this.editData.getCurrencies();
        if (ccol == null) {
            ccol = new WebTimeCurrencyCollection();
        }
        for (i = ccol.size() - 1; i >= 0; --i) {
            WebTimeCurrencyInfo info4 = ccol.get(i);
            if (this.selectedCurrency.contains(info4.getCurrency().getId().toString())) {
                list.remove(info4.getCurrency().getId().toString());
                continue;
            }
            ccol.removeObject(i);
        }
        if (!list.isEmpty()) {
            for (i = 0; i < list.size(); ++i) {
                String currencyid = (String)list.get(i);
                WebTimeCurrencyInfo info5 = new WebTimeCurrencyInfo();
                CurrencyInfo currency = new CurrencyInfo();
                currency.setId(BOSUuid.read((String)currencyid));
                info5.setCurrency(currency);
                info5.setSchedule(this.editData);
                ccol.add(info5);
            }
        }
    }

    protected IObjectValue createNewData() {
        this.selectedTemplate.clear();
        this.selectedCompany.clear();
        this.selectedCurrency.clear();
        this.tblTemplate.removeRows();
        this.tblCompany.removeRows();
        for (int i = 0; i < this.tblCurrency.getRowCount(); ++i) {
            IRow row = this.tblCurrency.getRow(i);
            row.getCell("select").setValue((Object)Boolean.FALSE);
        }
        WebTimeUpScheduleInfo info = new WebTimeUpScheduleInfo();
        info.setTimePeriod(WebTimeUpPeriodEnum.lastPeriod);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WebTimeUpScheduleFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("timePeriod"));
        sic.add(new SelectorItemInfo("companys.company"));
        sic.add(new SelectorItemInfo("templates.templateNumber"));
        sic.add(new SelectorItemInfo("templates.templateType"));
        sic.add(new SelectorItemInfo("currencies.currency"));
        return sic;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
        } else {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
        }
        this.initCollection();
        this.initialControl();
    }

    private void initCollection() throws EASBizException, BOSException {
        WebTimeTemplateCollection temps = this.editData.getTemplates();
        this.selectedTemplate.clear();
        for (int i = 0; i < temps.size(); ++i) {
            WebTimeTemplateInfo info = temps.get(i);
            this.selectedTemplate.add(info.getTemplateNumber() + ";" + info.getTemplateType().getValue());
        }
        if (!this.selectedTemplate.isEmpty()) {
            this.initTemplateTable();
        }
        WebTimeCompanyCollection comps = this.editData.getCompanys();
        this.selectedCompany.clear();
        for (int i = 0; i < comps.size(); ++i) {
            WebTimeCompanyInfo info = comps.get(i);
            this.selectedCompany.add(info.getCompany().getId().toString());
        }
        if (!this.selectedCompany.isEmpty()) {
            this.initCompanyTable();
        }
        WebTimeCurrencyCollection currs = this.editData.getCurrencies();
        this.selectedCurrency.clear();
        for (int i = 0; i < currs.size(); ++i) {
            WebTimeCurrencyInfo info = currs.get(i);
            this.selectedCurrency.add(info.getCurrency().getId().toString());
        }
        this.initCurrencyTable();
    }

    private void initTemplateTable() throws BOSException, EASBizException {
        this.tblTemplate.checkParsed();
        List col = WebTimeUpScheduleFactory.getRemoteInstance().getTemplate(this.editData.getId().toString());
        for (int i = 0; i < col.size(); ++i) {
            TemplateInfo info = (TemplateInfo)col.get(i);
            this.fillTemplateTable(info);
        }
    }

    private void initCompanyTable() throws BOSException {
        this.tblCompany.checkParsed();
        String in = this.getInExpr(this.selectedCompany);
        String oql = "select id,number,name where id in (" + in + ")";
        FullOrgUnitCollection col = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(oql);
        for (int i = 0; i < col.size(); ++i) {
            FullOrgUnitInfo info = col.get(i);
            this.fillCompanyTable((OrgUnitInfo)info);
        }
    }

    private String getInExpr(List list) {
        boolean isFirst = true;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            String s = (String)list.get(i);
            if (!isFirst) {
                buf.append(",");
            }
            buf.append("'").append(s).append("'");
            isFirst = false;
        }
        return buf.toString();
    }

    private void initCurrencyTable() throws EASBizException, BOSException {
        CurrencyCollection col = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
        this.tblCurrency.checkParsed();
        for (int i = 0; i < col.size(); ++i) {
            CurrencyInfo info = col.get(i);
            IRow row = this.tblCurrency.addRow();
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("name").setValue((Object)info.getName());
            if (this.selectedCurrency.contains(info.getId().toString())) {
                row.getCell("select").setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell("select").setValue((Object)Boolean.FALSE);
        }
    }

    private void initialControl() throws BOSException {
        this.tblCompany.getSelectManager().setSelectMode(10);
        this.tblComTemplate.getSelectManager().setSelectMode(10);
        this.tblTemplate.getSelectManager().setSelectMode(10);
        this.tblCurrency.getSelectManager().setSelectMode(10);
        NewCompanyF7 f7 = new NewCompanyF7((IUIObject)this);
        f7.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
        f7.setMultiSelect(true);
        f7.setNeedAddOrgRange(false);
        this.companyF7 = f7;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_NumberNull")));
        }
        if (StringUtils.isEmpty((String)this.txtName.getSelectedItem().toString())) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_NameNull")));
        }
        if (StringUtils.isEmpty((String)this.txtTimeDef.getText())) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"WebTimeUpSchedule_TimeDefNull")));
        }
        if (this.tblCompany.getRowCount() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"WebTimeUpSchedule_CompanyNull")));
        }
        if (this.tblTemplate.getRowCount() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"WebTimeUpSchedule_TemplateNull")));
        }
        boolean hasSelect = false;
        for (int i = 0; i < this.tblCurrency.getRowCount(); ++i) {
            IRow row = this.tblCurrency.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell("select").getValue())) continue;
            hasSelect = true;
            break;
        }
        if (!hasSelect) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"WebTimeUpSchedule_CurrencyNull")));
        }
    }

    @Override
    protected void btnImportCompany_actionPerformed(ActionEvent e) throws Exception {
        super.btnImportCompany_actionPerformed(e);
        this.companyF7.show();
        Object obj = this.companyF7.getData();
        if (obj instanceof Object[] && ((Object[])obj).length != 0) {
            Object[] comps = (Object[])obj;
            for (int i = 0; i < comps.length; ++i) {
                CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)comps[i];
                if (this.selectedCompany.contains(info.getId().toString())) continue;
                this.selectedCompany.add(info.getId().toString());
                this.fillCompanyTable((OrgUnitInfo)info);
            }
        }
    }

    private void fillCompanyTable(OrgUnitInfo info) {
        IRow row = this.tblCompany.addRow();
        row.getCell("id").setValue((Object)info.getId().toString());
        row.getCell("number").setValue((Object)info.getNumber());
        row.getCell("name").setValue((Object)info.getName());
    }

    @Override
    protected void btnImportTemplate_actionPerformed(ActionEvent e) throws Exception {
        super.btnImportTemplate_actionPerformed(e);
        Frame frame = (Frame)Util.getComponent((Component)((Object)this), (String)UINewFrame.class.getName());
        KDCommonPromptDialog dialog = new KDCommonPromptDialog(frame, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"414_CSLTemplateExportSelectUI"));
        QueryInfo queryInfo = Util.getQueryInfo((String)"com.kingdee.eas.fi.gr.cslrpt.CSLTemplateExportQuery");
        dialog.setQueryInfo(queryInfo);
        dialog.setEnabledMultiSelection(true);
        dialog.show();
        Object obj = dialog.getData();
        if (obj instanceof Object[] && ((Object[])obj).length != 0) {
            Object[] comps = (Object[])obj;
            for (int i = 0; i < comps.length; ++i) {
                TemplateInfo info = (TemplateInfo)comps[i];
                String key = info.getNumber() + ";" + info.getTemplateType().getValue();
                if (this.selectedTemplate.contains(key)) continue;
                this.selectedTemplate.add(key);
                this.fillTemplateTable(info);
            }
        }
    }

    private void fillTemplateTable(TemplateInfo info) {
        IRow row = this.tblTemplate.addRow();
        row.getCell("id").setValue((Object)info.getId().toString());
        row.getCell("number").setValue((Object)info.getNumber());
        row.getCell("name").setValue((Object)info.getName());
        row.getCell("versionNumber").setValue((Object)info.getVersionNumber());
        row.getCell("periodType").setValue((Object)info.getPeriodType().getAlias());
        row.getCell("templateType").setValue((Object)String.valueOf(info.getTemplateType().getValue()));
        row.getCell("templateTypeName").setValue((Object)info.getTemplateType().getAlias());
        row.getCell("isIncludeOtherDC").setValue((Object)new Boolean(info.isIncludeOtherDC()));
        row.getCell("isIncludeOtherDC").getStyleAttributes().setLocked(true);
    }

    @Override
    protected void btnRemoveCompany_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveCompany_actionPerformed(e);
        this.deleteSelectRows(this.tblCompany);
    }

    @Override
    protected void btnRemoveTemplate_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveTemplate_actionPerformed(e);
        this.deleteSelectRows(this.tblTemplate);
    }

    private void deleteSelectRows(KDTable table) throws EASBizException, BOSException {
        if (table.getSelectManager().size() == 0) {
            return;
        }
        ArrayList list = this.getSelectedRows(table);
        Object[] index = list.toArray();
        Arrays.sort(index);
        for (int i = index.length; i > 0; --i) {
            int rowindex = (Integer)index[i - 1];
            if (table == this.tblCompany) {
                String s = table.getRow(rowindex).getCell("id").getValue().toString();
                this.selectedCompany.remove(s);
            } else if (table == this.tblTemplate) {
                IRow row = table.getRow(rowindex);
                String s = row.getCell("number").getValue().toString() + ";" + row.getCell("templateType").getValue().toString();
                this.selectedTemplate.remove(s);
            }
            table.removeRow(rowindex);
        }
    }

    private ArrayList getSelectedRows(KDTable table) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        KDTSelectBlock selectBlock = null;
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            selectBlock = table.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                Integer tempIndex;
                if (j == -1 || list.contains(tempIndex = new Integer(j))) continue;
                list.add(tempIndex);
            }
        }
        return list;
    }

    @Override
    protected void btnTimeDefine_actionPerformed(ActionEvent e) throws Exception {
        super.btnTimeDefine_actionPerformed(e);
        String[] tempSchedule = ProcessSchedulePlan.open((Object)this, this.txtTimeDef.getText());
        if (tempSchedule == null || StringUtils.isEmpty((String)tempSchedule[0])) {
            return;
        }
        this.txtTimeDef.setText(tempSchedule[0]);
        this.txtTimeDesc.setSelectedItemData((Object)tempSchedule[1]);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.verifyNumber(this.txtNumber.getText());
    }

    private void verifyNumber(String number) throws EASBizException {
        if (number.indexOf(32) != -1) {
            this.txtNumber.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"HasBlank")));
        }
        if (number.indexOf("\"") != -1 || number.indexOf("'") != -1) {
            this.txtNumber.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"709_WebTimeUpScheduleEditUI")));
        }
        if (number.indexOf("*") != -1) {
            this.txtNumber.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"710_WebTimeUpScheduleEditUI")));
        }
        if (number.indexOf("\\") != -1) {
            this.txtNumber.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"814_WebTimeUpScheduleEditUI")));
        }
        if (number.indexOf("/") != -1) {
            this.txtNumber.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"711_WebTimeUpScheduleEditUI")));
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.selectedTemplate.clear();
        this.selectedCompany.clear();
        this.selectedCurrency.clear();
        this.tblTemplate.removeRows();
        this.tblCompany.removeRows();
        for (int i = 0; i < this.tblCurrency.getRowCount(); ++i) {
            IRow row = this.tblCurrency.getRow(i);
            row.getCell("select").setValue((Object)Boolean.FALSE);
        }
    }
}

