/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLSchemeTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.IWebTimeUpSchedule;
import com.kingdee.eas.fi.gr.cslrpt.SchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.SchemeFactory;
import com.kingdee.eas.fi.gr.cslrpt.SchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeUpScheduleCollection;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeUpScheduleFactory;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeUpScheduleInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractWebTimeUpScheduleListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLUploadConfigUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.gr.cslrpt.client.WebTimeUpScheduleEditUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLIOUtils;
import com.kingdee.eas.fi.gr.cslrpt.util.DPFFile;
import com.kingdee.eas.fi.gr.cslrpt.util.ExtensionFileFilter;
import com.kingdee.eas.fi.gr.cslrpt.util.FTPUpDown;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class WebTimeUpScheduleListUI
extends AbstractWebTimeUpScheduleListUI {
    public static final String EXPORTCONFIG = "ExportConfig";
    public static final String EXPORTCONFIG_FILE_PATH = "ExportConfig_ItemFile_Path";
    public static final String EXPORTCONFIG_FTP_SERVERIP = "ExportConfig_ItemFTP_ServerIP";
    public static final String EXPORTCONFIG_FTP_SERVERDIR = "ExportConfig_ItemFTP_ServerDIR";
    public static final String EXPORTCONFIG_FTP_LOGINNAME = "ExportConfig_ItemFTP_LoginName";
    public static final String EXPORTCONFIG_FTP_PASSWORD = "ExportConfig_ItemFTP_Password";
    public static final String EXPORTCONFIG_FTP_FROMLOCAL = "ExportConfig_ItemFTP_IsFromLocal";
    public static final String EXPORTCONFIG_MAIL_MAILGROUP = "ExportConfig_ITemMail_MailGroup";
    public static final String EXPORTCONFIG_MAIL_FROMLOCAL = "ExportConfig_ItemMail_IsFromLocal";
    public static final String EXPORTCONFIG_MAIL_CHECK = "ExportConfig_ItemMail_CHECK";
    public static final String DefaultDirectory = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "gamania";
    private HashMap ExportConfigMap = new HashMap();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return WebTimeUpScheduleEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WebTimeUpScheduleFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnOutputToLocal.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnOutputToFTP.setIcon(EASResource.getIcon((String)"imgTbtn_impress"));
        this.btnOutputByMail.setIcon(EASResource.getIcon((String)"imgTbtn_send"));
        this.btnOutputConfig.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.menuItemOutputToLocal.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemOutputToFTP.setIcon(EASResource.getIcon((String)"imgTbtn_impress"));
        this.menuItemOutputByMail.setIcon(EASResource.getIcon((String)"imgTbtn_send"));
        this.menuItemOutputConfig.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.loadLastedConfig();
    }

    private void loadLastedConfig() throws Exception {
        SchemeCollection filePathSchemes = SchemeFactory.getRemoteInstance().getSchemeCollection("where type = 2 and number = '" + CSLUploadConfigUI.class.getName() + "' ");
        Iterator iter = filePathSchemes.iterator();
        while (iter.hasNext()) {
            SchemeInfo element = (SchemeInfo)iter.next();
            HashMap pathMap = (HashMap)element.getAdapterObject(CSLSchemeTypeEnum.SAVEPATH);
            if (pathMap == null || !CSLUploadConfigUI.class.getName().equalsIgnoreCase((String)pathMap.get("relateUI"))) continue;
            this.ExportConfigMap.put(EXPORTCONFIG_FILE_PATH, pathMap.get("relatePath"));
        }
        SchemeCollection serverSchemes = SchemeFactory.getRemoteInstance().getSchemeCollection("where type = 3");
        Iterator iter2 = serverSchemes.iterator();
        while (iter2.hasNext()) {
            SchemeInfo scheme = (SchemeInfo)iter2.next();
            Object config = null;
            if (scheme == null || !((config = scheme.getAdapterObject(CSLSchemeTypeEnum.EXPORTCOMPANY)) instanceof HashMap)) continue;
            HashMap s = (HashMap)config;
            this.ExportConfigMap.put(EXPORTCONFIG_FTP_SERVERIP, s.get("serverAddress").toString());
            this.ExportConfigMap.put(EXPORTCONFIG_FTP_SERVERDIR, s.get("serverDirectory").toString());
            this.ExportConfigMap.put(EXPORTCONFIG_FTP_LOGINNAME, s.get("serverLoginName").toString());
            this.ExportConfigMap.put(EXPORTCONFIG_FTP_PASSWORD, s.get("serverLoginPassword").toString());
            if (s.get("EXPORTCONFIG_FTP_FROMLOCAL") != null) {
                this.ExportConfigMap.put(EXPORTCONFIG_FTP_FROMLOCAL, Boolean.valueOf(s.get("EXPORTCONFIG_FTP_FROMLOCAL").toString()));
            } else {
                this.ExportConfigMap.put(EXPORTCONFIG_FTP_FROMLOCAL, false);
            }
            if (s.get("EXPORTCONFIG_MAIL_FROMLOCAL") != null) {
                this.ExportConfigMap.put(EXPORTCONFIG_MAIL_FROMLOCAL, Boolean.valueOf(s.get("EXPORTCONFIG_MAIL_FROMLOCAL").toString()));
            } else {
                this.ExportConfigMap.put(EXPORTCONFIG_MAIL_FROMLOCAL, false);
            }
            if (s.get("EXPORTCONFIG_MAIL_CHECK") != null) {
                this.ExportConfigMap.put(EXPORTCONFIG_MAIL_CHECK, Boolean.valueOf(s.get("EXPORTCONFIG_MAIL_CHECK").toString()));
                break;
            }
            this.ExportConfigMap.put(EXPORTCONFIG_MAIL_CHECK, false);
            break;
        }
    }

    @Override
    public void actionOutputByMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionOutputByMail_actionPerformed(e);
    }

    @Override
    public void actionOutputConfig_actionPerformed(ActionEvent e) throws Exception {
        super.actionOutputConfig_actionPerformed(e);
        String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"templateConfigSafeWarning");
        if (MsgBox.showConfirm2New((Component)((Object)this), (String)msg) == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"parentUI", (Object)this);
            uiContext.put((Object)EXPORTCONFIG, (Object)this.ExportConfigMap);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CSLUploadConfigUI.class.getName(), (Map)uiContext, null, this.getOprtState());
            window.show();
        } else {
            SysUtil.abort();
        }
    }

    protected void removeFiles(File file) {
        if (file.isDirectory()) {
            File[] f = file.listFiles();
            for (int i = 0; i < f.length; ++i) {
                this.removeFiles(f[i]);
            }
        }
        file.delete();
    }

    @Override
    public void actionOutputToFTP_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        super.actionOutputToFTP_actionPerformed(e);
        FTPUpDown ftp = null;
        try {
            ftp = new FTPUpDown((String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_SERVERIP), "", (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_LOGINNAME), (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_PASSWORD));
        }
        catch (Exception e1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"342_CSLReportImportUI"));
            SysUtil.abort();
        }
        ArrayList result = null;
        boolean isFromLocal = (Boolean)this.ExportConfigMap.get(EXPORTCONFIG_FTP_FROMLOCAL);
        if (!isFromLocal) {
            result = this.doExport(DefaultDirectory);
        }
        Object[] files = this.getUploadFiles(isFromLocal);
        for (int i = 0; i < files.length; ++i) {
            ftp.uploadFile(files[i].getAbsolutePath(), (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_SERVERDIR));
        }
        File dir = new File(FilenameUtils.normalize((String)DefaultDirectory));
        if (!isFromLocal && dir.exists()) {
            this.removeFiles(dir);
        }
        StringBuffer resultStr = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"712_WebTimeUpScheduleListUI"));
        resultStr.append("\n\r\n\r");
        if (result != null && result.size() > 0) {
            msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"98_WebTimeUpScheduleListUI");
            resultStr.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"713_WebTimeUpScheduleListUI")).append("\n\r").append(StringUtils.arrayToString((Object[])result.toArray(), (String)",\n\r")).append("\n\r" + MessageFormat.format(msg, result.size(), (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_SERVERIP), (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_SERVERDIR)));
        } else if (result == null && files.length > 0) {
            msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"98_WebTimeUpScheduleListUI");
            resultStr.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"714_WebTimeUpScheduleListUI")).append("\n\r").append(CSLIOUtils.arrayToString(files, "getName", ",\n\r")).append("\n\r" + MessageFormat.format(msg, files.length, (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_SERVERIP), (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_SERVERDIR)));
        } else {
            resultStr.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"715_WebTimeUpScheduleListUI"));
        }
        UIContext utx = new UIContext((Object)this);
        utx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"400_CSLTemplateExportSelectUI"));
        SimpleNotePad.showMessageByModel(utx, resultStr.toString());
    }

    private File[] getUploadFiles(boolean isFromLocal) {
        File[] files;
        File dir = new File(FilenameUtils.normalize((String)DefaultDirectory));
        if (isFromLocal) {
            dir = new File((String)this.ExportConfigMap.get(EXPORTCONFIG_FILE_PATH));
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"354_CSLReportImportUI"));
            SysUtil.abort();
        }
        if ((files = dir.listFiles(new ExtensionFileFilter("DPF"))) == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"401_CSLTemplateExportSelectUI"));
            SysUtil.abort();
        }
        return files;
    }

    @Override
    public void actionOutputToLocal_actionPerformed(ActionEvent e) throws Exception {
        super.actionOutputToLocal_actionPerformed(e);
        String file = (String)this.ExportConfigMap.get(EXPORTCONFIG_FILE_PATH);
        if (StringUtils.isEmpty((String)file)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"716_WebTimeUpScheduleListUI"));
            SysUtil.abort();
        }
        ArrayList result = this.doExport(file);
        StringBuffer resultStr = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"717_WebTimeUpScheduleListUI"));
        resultStr.append("\n\r\n\r");
        if (result.size() > 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"54_WebTimeUpScheduleListUI");
            resultStr.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"718_WebTimeUpScheduleListUI")).append("\n\r").append(StringUtils.arrayToString((Object[])result.toArray(), (String)",\n\r")).append("\n\r" + MessageFormat.format(msg, result.size(), file));
        } else {
            resultStr.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"715_WebTimeUpScheduleListUI"));
        }
        UIContext utx = new UIContext((Object)this);
        utx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"719_WebTimeUpScheduleListUI"));
        SimpleNotePad.showMessageByModel(utx, resultStr.toString());
    }

    private ArrayList doExport(String exportDir) throws BOSException, IOException, EASBizException {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        boolean isFirst = true;
        StringBuffer buf = new StringBuffer();
        buf.append("select id, number, name, description, timePeriod, timeDef,");
        buf.append(" scheduleType, companys.company, templates.templateNumber,");
        buf.append(" templates.templateType, currencies.currency");
        buf.append(" where id in (");
        for (int i = 0; i < ids.size(); ++i) {
            if (!isFirst) {
                buf.append(",");
            }
            buf.append("'").append(ids.get(i)).append("'");
            isFirst = false;
        }
        buf.append(")");
        WebTimeUpScheduleCollection schedules = WebTimeUpScheduleFactory.getRemoteInstance().getWebTimeUpScheduleCollection(buf.toString());
        ArrayList result = new ArrayList();
        File dir = new File(FilenameUtils.normalize((String)exportDir));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (int i = 0; i < schedules.size(); ++i) {
            WebTimeUpScheduleInfo schedule = schedules.get(i);
            result.addAll(this.export(exportDir, schedule));
        }
        return result;
    }

    private ArrayList export(String exportDir, WebTimeUpScheduleInfo schedule) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        DPFFile dpf = null;
        IWebTimeUpSchedule ischedule = WebTimeUpScheduleFactory.getRemoteInstance();
        List companys = ischedule.getCompany(schedule.getId().toString());
        List templates = ischedule.getTemplate(schedule.getId().toString());
        List currencies = ischedule.getCurrency(schedule.getId().toString());
        for (int i = 0; i < companys.size(); ++i) {
            StringBuffer file;
            OrgUnitInfo element = (OrgUnitInfo)companys.get(i);
            dpf = new DPFFile(schedule, element, templates, currencies);
            boolean flag = dpf.export((file = new StringBuffer(exportDir).append(System.getProperty("file.separator")).append(element.getNumber()).append("-").append(schedule.getNumber()).append(".DPF")).toString(), DPFFile.DNF_PASSWORD);
            if (!flag) continue;
            result.add(element.getName() + "-" + schedule.getName());
        }
        return result;
    }

    protected ArrayList getSelectedIdValues() {
        if (this.tblMain.getSelectManager().get().getMode() == 8) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                String id;
                ICell cell = this.tblMain.getRow(i).getCell(this.getKeyFieldName());
                if (cell == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                    SysUtil.abort();
                }
                if (list.contains(id = cell.getValue().toString())) continue;
                list.add(id);
            }
            return list;
        }
        return super.getSelectedIdValues();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.FI_GR_CSLREPORT;
    }
}

