/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.WithdrawalSurplusListFactory;
import com.kingdee.eas.fi.gr.cslrpt.WithdrawalSurplusListInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractWithdrawalSurplusEditUI;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class WithdrawalSurplusEditUI
extends AbstractWithdrawalSurplusEditUI {
    private static final long serialVersionUID = 8521429837037397347L;
    private static final Logger logger = CoreUIObject.getLogger(WithdrawalSurplusEditUI.class);
    private String highMaintainLowLevel = "true";
    private CurrencyCollection currencies = null;
    private CurrencyInfo baseCurrency = null;
    int precision = 2;

    @Override
    public void storeFields() {
        super.storeFields();
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(this.editData.getCurrency().getId());
        this.editData.setCurrency(currency);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext() != null && this.getUIContext().get("isModify") == null) {
            CompanyOrgUnitInfo orgUnitId = SysContext.getSysContext().getCurrentFIUnit();
            if (this.editData.getTrackRecordCreator() == null) {
                this.editData.setTrackRecordCreator(orgUnitId);
            } else if (!this.editData.getTrackRecordCreator().getId().equals((Object)orgUnitId.getId())) {
                this.editData.setTrackRecordCreator(orgUnitId);
            }
        }
        super.actionSubmit_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setControlStatus();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setControlStatus();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setControlStatus();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setControlStatus();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo company = SysContext.getSysContext().getCurrentOrgUnit();
        boolean isCurrOrgRecord = this.checkCurrOrgRecord(this.editData.getTrackRecordCreator() == null ? "" : this.editData.getTrackRecordCreator().getId().toString(), company);
        if (!isCurrOrgRecord) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"534_InvestDayListUI"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        WithdrawalSurplusListInfo info = new WithdrawalSurplusListInfo();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.clear(14);
        info.setWithDrawalDate(calendar.getTime());
        info.setAmount(null);
        info.setCompany(null);
        info.setCurrency(this.getBaseCurrency());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WithdrawalSurplusListFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        CurrencyInfo info;
        BOSUuid id;
        if (this.currencies == null) {
            EntityViewInfo view = new EntityViewInfo();
            SorterItemInfo sortItem = new SorterItemInfo("number");
            sortItem.setSortType(SortType.ASCEND);
            view.getSorter().add(sortItem);
            this.currencies = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view, true);
        }
        super.onLoad();
        this.isCanMainTainRecord();
        this.highMaintainLowLevel = ParamManager.getParamValue(null, null, (String)"GR_CSL_HIGHERUPFINANCEORGMAINTAINLOWERLEVEVL");
        if (this.highMaintainLowLevel.equals("true")) {
            CompanyF7Helper.initCompanyBizUnitF7((KDBizPromptBox)this.prmtCompany, (boolean)false, (boolean)true, (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        } else {
            HashSet<String> disablePermSet = new HashSet<String>();
            disablePermSet.add(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            NewOrgViewF7PromptDialog f7 = CompanyF7Helper.getDisablePermCompanyBizUnitF7(disablePermSet);
            f7.setNeedAddOrgRange(false);
            this.prmtCompany.setSelector((KDPromptSelector)f7);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
            this.prmtCompany.setEntityViewInfo(view);
        }
        this.prmtCompany.setEditable(true);
        this.prmtCompany.setDisplayFormat("$name$");
        this.prmtCompany.setEditFormat("$number$");
        this.prmtCompany.setCommitFormat("$number$");
        BOSUuid bOSUuid = id = this.editData.getCurrency() != null ? this.editData.getCurrency().getId() : null;
        if (id == null && (info = this.getBaseCurrency()) != null) {
            id = info.getId();
        }
        this.comboCurrency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CurrencyInfo currencyInfo = (CurrencyInfo)WithdrawalSurplusEditUI.this.comboCurrency.getSelectedItem();
                WithdrawalSurplusEditUI.this.precision = currencyInfo.getPrecision();
                WithdrawalSurplusEditUI.this.txtAmount.setPrecision(WithdrawalSurplusEditUI.this.precision);
            }
        });
        this.setSelectCurrency(this.currencies, id);
        this.txtAmount.setNegatived(false);
        this.txtAmount.setHorizontalAlignment(4);
        this.pkWithDrawalDate.setSupportedEmpty(false);
    }

    private void setSelectCurrency(CurrencyCollection currencies, BOSUuid id) {
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            CurrencyInfo currency = currencies.get(i);
            this.comboCurrency.addItem((Object)currency);
            if (!currency.getId().equals((Object)id)) continue;
            this.comboCurrency.setSelectedIndex(i);
        }
    }

    private CurrencyInfo getBaseCurrency() {
        if (this.baseCurrency == null) {
            CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
            if (curCompany != null && curCompany.getBaseCurrency() != null) {
                this.baseCurrency = SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency();
            }
            return this.baseCurrency;
        }
        return this.baseCurrency;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.pkWithDrawalDate.getValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_ProDis_DateIsNull")));
        }
        if (this.prmtCompany.getData() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_ProDis_CompanyIsNull")));
        }
        if (this.comboCurrency.getSelectedIndex() == -1) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_ProDis_CurrencyIsNull")));
        }
        if (this.comboWithDrawalType.getSelectedIndex() == -1) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"720_WithdrawalSurplusEditUI")});
        }
        if (StringUtils.isEmpty((String)this.txtAmount.getText())) {
            this.txtAmount.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_ProDis_AmountMustGreaterZero")));
        }
        String text = this.txtAmount.getText().replaceAll(",", "");
        text = text.replaceAll("\\.\\.", "\\.");
        BigDecimal amount = null;
        try {
            amount = new BigDecimal(text);
        }
        catch (NumberFormatException nfe) {
            this.txtAmount.setText("");
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"wrong_money_format")));
        }
        BigDecimal zero = new BigDecimal("0");
        if (amount.compareTo(zero) != 1) {
            this.txtAmount.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_ProDis_AmountMustGreaterZero")));
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("trackRecordCreator"));
        return sic;
    }

    private void isCanMainTainRecord() throws EASBizException, BOSException {
        if (this.getUIContext().get("ID") != null) {
            String id = this.getUIContext().get("ID").toString();
            WithdrawalSurplusListInfo info = WithdrawalSurplusListFactory.getRemoteInstance().getWithdrawalSurplusListInfo("select trackRecordCreator where id='" + id + "'");
            String recordId = info.getTrackRecordCreator() == null ? "" : info.getTrackRecordCreator().getId().toString();
            boolean isCanMainTain = recordId.equals(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
            if (isCanMainTain) {
                this.actionCopy.setEnabled(true);
                this.actionAddNew.setEnabled(true);
                if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
                    this.actionEdit.setEnabled(false);
                } else {
                    this.actionEdit.setEnabled(true);
                }
            } else {
                this.actionCopy.setEnabled(false);
                this.actionAddNew.setEnabled(false);
                this.actionEdit.setEnabled(false);
            }
        }
    }

    private void setControlStatus() {
        if (this.editData != null && this.editData.getId() != null) {
            String recordId = this.editData.getTrackRecordCreator() == null ? "" : this.editData.getTrackRecordCreator().getId().toString();
            boolean isCanMainTain = recordId.equals(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
            if (isCanMainTain) {
                this.actionCopy.setEnabled(true);
                this.actionAddNew.setEnabled(true);
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
            } else {
                this.actionCopy.setEnabled(false);
                this.actionAddNew.setEnabled(false);
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            }
            if (this.editData.getCurrency() != null && this.editData.getCurrency().getId() != null) {
                for (int i = 0; i < this.comboCurrency.getItemCount(); ++i) {
                    if (!this.editData.getCurrency().getId().toString().equals(((CurrencyInfo)this.comboCurrency.getItemAt(i)).getId().toString())) continue;
                    this.comboCurrency.setSelectedIndex(i);
                }
            }
        }
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (!b) {
            RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
        }
        return b;
    }

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    private boolean checkCurrOrgRecord(String recordCreatorId, OrgUnitInfo company) {
        if (recordCreatorId == null) {
            return false;
        }
        return recordCreatorId.equals(company.getId().toString());
    }
}

