/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.WithdrawalSurplusListFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractWithdrawalSurplusListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.WithdrawalSurplusEditUI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class WithdrawalSurplusListUI
extends AbstractWithdrawalSurplusListUI {
    private static final long serialVersionUID = 2369067126105633666L;
    private static final Logger logger = CoreUIObject.getLogger(WithdrawalSurplusListUI.class);
    private String highMaintainLowLevel = "true";
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private boolean selfGradeOnly = false;

    public WithdrawalSurplusListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                WithdrawalSurplusListUI.this.fillTable(e);
            }
        });
    }

    private void fillTable(KDTDataRequestEvent e) {
        int n = e.getLastRow();
        for (int i = e.getFirstRow(); i <= n; ++i) {
            Object recordCreatorid = this.tblMain.getRow(i).getCell("trackRecordCreatorid").getValue();
            if (recordCreatorid == null || recordCreatorid.equals(this.company.getId().toString())) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.addSeletedChangedListener();
        CslGradeManageUtil.showBtnByCurrentOrg((KDWorkButton)this.btnUpdateMaintainOrg);
    }

    private void addSeletedChangedListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    WithdrawalSurplusListUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    WithdrawalSurplusListUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.changeBtnSateByCreateCompany();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void changeBtnSateByCreateCompany() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        if (!this.tblMain.getRow(selectRow).getCell("trackRecordCreatorid").getValue().toString().equals(this.company.getId().toString())) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.menuItemEdit.setEnabled(true);
            this.menuItemRemove.setEnabled(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.isCanUpdate(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"533_InvestDayListUI"));
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    protected ArrayList getSelectedIdValues() {
        ArrayList ids = super.getSelectedIdValues();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ArrayList<String> removeIds = new ArrayList<String>();
        if (selectRows.length > 0) {
            for (int i = 0; i < selectRows.length; ++i) {
                Object recordCreatorid;
                int rowIndex = selectRows[i];
                IRow row = this.tblMain.getRow(rowIndex);
                if (row == null || (recordCreatorid = row.getCell("trackRecordCreatorid").getValue()) == null || recordCreatorid.equals(this.company.getId().toString())) continue;
                String cellStr = (String)row.getCell(this.getKeyFieldName()).getValue();
                removeIds.add(cellStr);
            }
            ids.removeAll(removeIds);
            if (ids.size() == 0) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"533_InvestDayListUI");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
        }
        return ids;
    }

    private void isCanUpdate(String msg) {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            boolean isCanMainTain = CslRptUIUtil.checkCanMainTain(this.highMaintainLowLevel, row, (OrgUnitInfo)this.company);
            if (!isCanMainTain) {
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        String format = CslRptUIUtil.getNationalDateFormatString();
        if (format != null) {
            this.tblMain.getColumn("withDrawalDate").getStyleAttributes().setNumberFormat(format);
        }
        this.refreshList();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getGradeSettingFilter();
    }

    protected String getEditUIName() {
        return WithdrawalSurplusEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WithdrawalSurplusListFactory.getRemoteInstance();
    }

    protected boolean isAllowOAMenu() {
        return false;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return CslRptUtil.getCurrentChckPermOrgPk(action);
    }

    @Override
    public void actionSelfAndAllSwitch_actionPerformed(ActionEvent e) throws Exception {
        if (this.selfGradeOnly) {
            this.selfGradeOnly = false;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showSelf"));
        } else {
            this.selfGradeOnly = true;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showAll"));
        }
        this.changeFilterByFlag();
        this.actionRefresh_actionPerformed(e);
    }

    public void changeFilterByFlag() throws BOSException {
        FilterInfo gradeInfo = new FilterInfo();
        if (this.selfGradeOnly) {
            gradeInfo = this.getSelfGradeFilter();
        } else {
            gradeInfo = this.getGradeSettingFilter();
            if (gradeInfo.getFilterItems().size() == 0) {
                gradeInfo.getFilterItems().add(new FilterItemInfo("TRACKRECORDCREATOR", (Object)"0", CompareType.NOTEQUALS));
            }
        }
        FilterInfo filter = this.getMainQuery().getFilter();
        if (filter == null) {
            this.getMainQuery().setFilter(gradeInfo);
            return;
        }
        boolean find = false;
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"TRACKRECORDCREATOR".equalsIgnoreCase(item.getPropertyName())) continue;
            item.setCompareValue(gradeInfo.getFilterItems().get(0).getCompareValue());
            item.setCompareType(gradeInfo.getFilterItems().get(0).getCompareType());
            find = true;
            break;
        }
        if (!find) {
            this.getMainQuery().getFilter().mergeFilter(gradeInfo, "AND");
        }
    }

    private FilterInfo getSelfGradeFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.getSelfDataPub((FilterInfo)filterInfo, (String)"TRACKRECORDCREATOR", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private FilterInfo getGradeSettingFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.filteData((FilterInfo)filterInfo, (String)"TRACKRECORDCREATOR", (String)((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    @Override
    public void actionUpdateMaintainOrg_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtil.updateMaintainOrg((String)"T_CSL_WithdrawalSurplusList", (String)"FTrackRecordCreatorID", (ArrayList)super.getSelectedIdValues());
        this.actionRefresh_actionPerformed(e);
    }
}

