/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.CommonQueryParamForHandler;
import com.kingdee.eas.base.commonquery.DynQuerySolutionFactory;
import com.kingdee.eas.base.commonquery.DynQuerySolutionInfo;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryParam;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.LowTimeHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.client.query.CommonQueryPanel;
import com.kingdee.eas.fi.gr.cslrpt.client.query.Util;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class CommonQueryUI
extends CoreUI {
    protected CommonQueryPanel commonQueryPanel = null;
    private CommonQueryParam commonQueryParam = null;
    private static final String commonQueryRes = "com.kingdee.eas.base.commonquery.client.CommonQueryPanel";
    private static Logger logger = Logger.getLogger(CommonQueryUI.class);

    protected void initUserConfig() {
    }

    public boolean isPrepareInit() {
        return true;
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = new RequestContext();
            this.commonQueryParam = (CommonQueryParam)this.getUIContext().get("COMMON_QUERY_PARAM");
            if (this.commonQueryParam != null) {
                ArrayList<RequestContext> customerReqList = new ArrayList<RequestContext>();
                ArrayList panels = this.commonQueryParam.getPanels();
                int size = panels.size();
                for (int i = 0; i < size; ++i) {
                    Object tmp = panels.get(i);
                    if (!(tmp instanceof CustomerQueryPanel)) continue;
                    CustomerQueryPanel cqPanel = (CustomerQueryPanel)tmp;
                    IUIActionPostman man = cqPanel.prepareInit();
                    if (!cqPanel.isPrepareInit() || man == null) continue;
                    RequestContext customerRequest = (RequestContext)man.getRequestContext();
                    customerRequest.put("commonqueryuicustomerquerypanelname", (Object)cqPanel.getClass().getName());
                    customerReqList.add(customerRequest);
                }
                request.put("customerReq", customerReqList);
            }
            request.setClassName("com.kingdee.eas.base.commonquery.app.CommonQueryUIHandler");
            request.setMethodName("handleInit");
            ShareTypeEnum type = this.getCurrentShareTypeEnum();
            BOSUuid orgID = null;
            if (this.commonQueryParam.getQueryObjectPK() != null) {
                String ObjectName = this.commonQueryParam.getQueryObjectPK().getFullName();
                try {
                    orgID = Util.getOrgID(ObjectName);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            request.setConfigPK(null);
            request.put("commonqueryuitype", (Object)type);
            request.put("commonqueryuiorgid", (Object)orgID);
            request.put("tableParamFromUI", (Object)this.getTableParamsFromUI());
            request.put("CommonQueryParamForHandler", (Object)this.getCopy(this.commonQueryParam));
            request.put("hasDynQuery", (Object)String.valueOf(this.commonQueryParam.isShowDynQuery()));
            List langList = KDBizMultiLangBox.getLanguageList();
            for (int i = 0; i < langList.size(); ++i) {
                Locale l = ((LanguageInfo)langList.get(i)).getLocale();
                request.put("sysDefaultRule_" + l.toString().toLowerCase(), (Object)ResourceBase.getString((String)commonQueryRes, (String)"sysDefaultRule", (Locale)l));
            }
            handler.setRequestContext((Serializable)request);
        }
        return handler;
    }

    public void onLoad() throws Exception {
        LowTimeHelper timeHelper = new LowTimeHelper();
        timeHelper.beginTime();
        super.onLoad();
        timeHelper.printTime2Last("onLoad");
        this.commonQueryParam = (CommonQueryParam)this.getUIContext().get("COMMON_QUERY_PARAM");
        timeHelper.printTime2Last("init param ");
        EntityViewInfo entityViewInfo = this.commonQueryParam.getEntityViewInfo();
        timeHelper.printTime2Last("get entityViewInfo ");
        EntityViewInfo lockedEntityViewInfo = this.commonQueryParam.getLockedEntityViewInfo();
        timeHelper.printTime2Last("get lockedEntityViewInfo ");
        IMetaDataPK queryObjectPK = this.commonQueryParam.getQueryObjectPK();
        timeHelper.printTime2Last("get queryObjectPK ");
        String parentUIClassName = this.commonQueryParam.getParentUIClassName();
        timeHelper.printTime2Last("get parentUIClassName ");
        if (parentUIClassName == null) {
            throw new IllegalArgumentException(EASResource.getString((String)"com.kingdee.eas.base.commonquery..cqResource", (String)"res_1") + "parentUIClassName" + EASResource.getString((String)"com.kingdee.eas.base.commonquery..cqResource", (String)"res_2") + EASResource.getString((String)"com.kingdee.eas.base.commonquery..cqResource", (String)"res_3") + "CommonQueryDialog.setParentUIClassName(" + EASResource.getString((String)"com.kingdee.eas.base.commonquery..cqResource", (String)"res_4") + "UI" + EASResource.getString((String)"com.kingdee.eas.base.commonquery..cqResource", (String)"res_5") + ") " + EASResource.getString((String)"com.kingdee.eas.base.commonquery..cqResource", (String)"res_6"));
        }
        timeHelper.printTime2Last("get parentUIClassName == null ");
        boolean showFilter = this.commonQueryParam.isShowFilter();
        boolean showSorter = false;
        timeHelper.printTime2Last("showSorter begin ");
        QueryInfo queryInfo = Util.getQueryInfo(queryObjectPK);
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        if (propertyUnitCollection != null) {
            for (int i = 0; i < propertyUnitCollection.size(); ++i) {
                Boolean boolFlag;
                PropertyUnitInfo propertyUnitInfo = propertyUnitCollection.get(i);
                if (propertyUnitInfo.getExtendedProperty("isCommonQuerySorter") == null || !(boolFlag = Boolean.valueOf(propertyUnitInfo.getExtendedProperty("isCommonQuerySorter"))).equals(Boolean.TRUE)) continue;
                showSorter = this.commonQueryParam.isShowSorter();
                break;
            }
        }
        timeHelper.printTime2Last("showSorter begin over ");
        boolean showTable = true;
        boolean showToolbar = this.commonQueryParam.isShowToolbar();
        boolean showButton = this.commonQueryParam.isShowButton();
        boolean disRowCount = this.commonQueryParam.isDisShowRowCount();
        boolean showDynQuery = this.commonQueryParam.isShowDynQuery();
        IProcessor processor = this.commonQueryParam.getProcessors();
        IPromptBoxFactory promptBoxFactory = this.commonQueryParam.getPromptBoxFactory();
        int width = this.getWidth(this.commonQueryParam.getWidth(), showToolbar);
        int height = this.getHeight(this.commonQueryParam.getHeight(), showButton);
        ArrayList panels = this.commonQueryParam.getPanels();
        String dialogName = this.commonQueryParam.getDialogName();
        int showShareType = this.commonQueryParam.getShowShareType();
        timeHelper.printTime2Last("CommonQueryPanel begin ");
        this.commonQueryPanel = new CommonQueryPanel(entityViewInfo, lockedEntityViewInfo, queryObjectPK, parentUIClassName, showFilter, showSorter, showTable, showToolbar, showButton, disRowCount, processor, promptBoxFactory, width, height);
        timeHelper.printTime2Last("CommonQueryPanel begin over ");
        this.commonQueryPanel.setShowDynQuery(showDynQuery);
        this.commonQueryPanel.setDefalutEntityViewInfo(this.commonQueryParam.getDefaultEntityViewInfo());
        this.commonQueryPanel.setFilterPanelName(this.commonQueryParam.getFilterPanelName());
        this.commonQueryPanel.setShowShareType(showShareType);
        this.commonQueryPanel.setUiObject(this.commonQueryParam.getUiObject());
        this.commonQueryPanel.setShowFieldCompare(this.commonQueryParam.isShowFieldCompare());
        this.commonQueryPanel.setHiddenTableCols(this.commonQueryParam.getHiddenCols());
        this.commonQueryPanel.setVisibleTableCols(this.commonQueryParam.getVisibleCols());
        this.commonQueryPanel.setDynF7FilterInfo(this.commonQueryParam.getDynF7FilterInfo());
        this.addPanels(panels);
        timeHelper.printTime2Last("commonQueryPanel.onLoad() begin ");
        this.commonQueryPanel.onLoad();
        timeHelper.printTime2Last("commonQueryPanel.onLoad() begin over");
        this.setDialogTitle(dialogName);
        this.setPreferredSize(new Dimension(width, height));
        this.setLayout(new BorderLayout(width, height));
        this.add((Component)((Object)this.commonQueryPanel), "Center");
        ShareTypeEnum currentShareType = this.getCurrentShareTypeEnum();
        if (this.commonQueryPanel.getDefaultToolBar() != null) {
            String defaultTableparams = this.commonQueryParam.getDefaultTableparams();
            if (defaultTableparams == null) {
                defaultTableparams = this.getdefaultTableParams();
                this.commonQueryParam.setDefaultTableparams(defaultTableparams);
            }
            this.commonQueryPanel.getDefaultToolBar().setShareType(currentShareType);
            this.commonQueryPanel.getDefaultToolBar().getShareTypeComboBox().setSelectedItem((Object)currentShareType);
        } else {
            timeHelper.printTime2Last("LoadSoutionList begin ");
            this.LoadSoutionList(currentShareType);
            timeHelper.printTime2Last("LoadSoutionList begin over ");
        }
        timeHelper.printAllTime();
    }

    private ShareTypeEnum getCurrentShareTypeEnum() {
        int showShareType = this.commonQueryParam.getShowShareType();
        ShareTypeEnum currentShareType = this.commonQueryParam.getCurrentShareType();
        if (currentShareType == null) {
            currentShareType = (showShareType & 0x10) == 16 ? ShareTypeEnum.USER_NOORG_LEVEL : ((showShareType & 1) == 1 ? ShareTypeEnum.USER_LEVEL : ((showShareType & 2) == 2 ? ShareTypeEnum.ORG_LEVEL : ((showShareType & 8) == 8 ? ShareTypeEnum.CU_LEVEL : ((showShareType & 4) == 4 ? ShareTypeEnum.PUBLIC_LEVEL : ShareTypeEnum.USER_LEVEL))));
        }
        return currentShareType;
    }

    private CommonQueryParamForHandler getCopy(CommonQueryParam params) {
        CommonQueryParamForHandler handlerParam = new CommonQueryParamForHandler();
        handlerParam.setCurrentShareType(params.getCurrentShareType());
        handlerParam.setDefaultTableparams(params.getDefaultTableparams());
        handlerParam.setDisShowRowCount(params.isDisShowRowCount());
        handlerParam.setDisVisiableDefaultView(params.isDisVisiableDefaultView());
        handlerParam.setParentUIClassName(params.getParentUIClassName());
        handlerParam.setQSolutionInfo(params.getQSolutionInfo());
        handlerParam.setQueryObjectPK(params.getQueryObjectPK());
        handlerParam.setShowButton(params.isShowButton());
        handlerParam.setShowDefaultSolution(params.isShowDefaultSolution());
        handlerParam.setShowFieldCompare(params.isShowFieldCompare());
        handlerParam.setShowFilter(params.isShowFilter());
        handlerParam.setShowShareType(params.getShowShareType());
        handlerParam.setShowDynQuery(params.isShowDynQuery());
        handlerParam.setShowSorter(params.isShowSorter());
        handlerParam.setShowTable(params.isShowTable());
        handlerParam.setShowToolbar(params.isShowToolbar());
        return handlerParam;
    }

    private BOSUuid getCurrentUserId() {
        return SysContext.getSysContext().getCurrentUserInfo().getId();
    }

    public QuerySolutionCollection getUserNoorgLevelQuerySolution(IQuerySolution iQuerySolution, String parentUIName, String queryName, ShareTypeEnum currentShareType) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        filterItemInfo = new FilterItemInfo("queryObjectName", (Object)queryName);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("parentUIName", (Object)parentUIName);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("owner", (Object)this.getCurrentUserId());
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(currentShareType.getValue()));
        filterInfo.getFilterItems().add(filterItemInfo);
        if (ShareTypeEnum.USER_NOORG_LEVEL.equals((Object)currentShareType)) {
            filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(1));
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("solutiontype", (Object)"10");
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND (#3 or (#4 and #5))");
        } else {
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 ");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection coll = entityViewInfo.getSelector();
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("dynQuery.id"));
        coll.add(new SelectorItemInfo("dynQuery.number"));
        coll.add(new SelectorItemInfo("dynQuery.name"));
        coll.add(new SelectorItemInfo("dynQuery.deletedStatus"));
        coll.add(new SelectorItemInfo("QueryPanelInfo.*"));
        coll.add(new SelectorItemInfo("QueryPanelInfo.id"));
        coll.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        coll.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        SorterItemCollection sorterCol = new SorterItemCollection();
        sorterCol.add(new SorterItemInfo("name"));
        entityViewInfo.setSorter(sorterCol);
        return iQuerySolution.getQuerySolutionCollection(entityViewInfo);
    }

    private void loadShowToolBarSolution(ShareTypeEnum currentShareType) throws Exception {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
        String queryName = this.commonQueryPanel.getQueryInfo().getFullName();
        BOSUuid orgID = Util.getOrgID(queryName);
        String parentUIName = this.commonQueryPanel.getParentUIClassName();
        QuerySolutionInfo querySolutionInfo = null;
        QuerySolutionCollection querySolutionCollection = null;
        QuerySolutionInfo qSolutionInfo = this.commonQueryParam.getQSolutionInfo();
        if (qSolutionInfo == null) {
            querySolutionCollection = ShareTypeEnum.USER_NOORG_LEVEL.equals((Object)currentShareType) ? this.getUserNoorgLevelQuerySolution(iQuerySolution, parentUIName, queryName, currentShareType) : iQuerySolution.getQuerySolutions(orgID.toString(), queryName, parentUIName, currentShareType);
            this.upgradeToNoOrg(querySolutionCollection, currentShareType);
            querySolutionInfo = this.getDefaultSolution(querySolutionCollection);
            if (querySolutionInfo == null) {
                querySolutionInfo = this.addNewDefaultSolution(queryName, orgID, currentShareType, querySolutionCollection.size() <= 0);
                querySolutionCollection.add(querySolutionInfo);
            }
        } else {
            querySolutionInfo = qSolutionInfo;
            querySolutionCollection = new QuerySolutionCollection();
            querySolutionCollection.add(querySolutionInfo);
        }
        querySolutionCollection = Util.justOneDefaultSolutionVisible(querySolutionCollection);
        this.commonQueryPanel.getSolutionListPanel().refreshSolutionList(querySolutionCollection);
        querySolutionInfo = this.getNeedDisplaySolution(querySolutionCollection);
        this.updateRowCount(querySolutionCollection);
        this.loadSolution(querySolutionInfo);
        if (this.getCommonQueryPanel().getDefaultToolBar().getCurrentQuerySolutionInfo() != null && this.getCommonQueryPanel().getDefaultToolBar().getCurrentQuerySolutionInfo().getSolutionType().getValue().equals("10")) {
            this.getCommonQueryPanel().getDefaultToolBar().disEditButton();
        }
    }

    private void upgradeToNoOrg(QuerySolutionCollection querySolutionCollection, ShareTypeEnum currentShareType) throws Exception {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("shareType"));
        boolean upgraded = false;
        StringBuffer upgradedSolutionNames = new StringBuffer();
        for (int i = querySolutionCollection.size() - 1; i >= 0; --i) {
            QuerySolutionInfo temp = querySolutionCollection.get(i);
            if (!currentShareType.equals((Object)ShareTypeEnum.USER_LEVEL) || temp.getOrgID() != null) continue;
            temp.setShareType(ShareTypeEnum.USER_NOORG_LEVEL);
            iQuerySolution.updatePartial((CoreBaseInfo)temp, selectorCol);
            querySolutionCollection.removeObject(i);
            upgraded = true;
            upgradedSolutionNames.append("\"").append(temp.getName()).append("\"").append(",");
        }
        if (upgraded) {
            Object[] params = new Object[]{upgradedSolutionNames.toString()};
            String msg = MessageFormat.format(EASResource.getString((String)commonQueryRes, (String)"UPGRADE_TO_NOORG"), params);
            MsgBox.showWarning((Component)((Object)this), (String)msg);
        }
    }

    private void updateRowCount(QuerySolutionCollection solutionCol) throws BOSException, EASBizException {
        if (!this.getCommonQueryPanel().isDisShowRowCount()) {
            for (int i = 0; i < solutionCol.size(); ++i) {
                QuerySolutionInfo querySolutionInfo = solutionCol.get(i);
                if (querySolutionInfo.getRowCount() != -1) continue;
                querySolutionInfo.setRowCount(300);
                IQuerySolution querySolution = QuerySolutionFactory.getRemoteInstance();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("rowCount"));
                querySolution.updatePartial((CoreBaseInfo)querySolutionInfo, selector);
            }
        }
    }

    private QuerySolutionInfo getDefaultSolution(QuerySolutionCollection coll) {
        if (coll == null) {
            return null;
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            QuerySolutionInfo info = coll.get(i);
            if (!info.getSolutionType().getValue().equals("10")) continue;
            return coll.get(i);
        }
        return null;
    }

    private QuerySolutionInfo addNewDefaultSolution(String ObjectName, BOSUuid orgID, ShareTypeEnum currentShareType, boolean isDefault) throws Exception {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
        if (this.getCommonQueryPanel().getDefaultToolBar() == null) {
            this.getCommonQueryPanel().initLeftPanel();
        }
        QuerySolutionInfo querySolutionInfo = this.createSysDefaultSolutionInfo(ObjectName, orgID, currentShareType);
        querySolutionInfo.setIsUserDefaultSolu(isDefault);
        iQuerySolution.addnew((CoreBaseInfo)querySolutionInfo);
        return querySolutionInfo;
    }

    private QuerySolutionInfo getNeedDisplaySolution(QuerySolutionCollection coll) {
        QuerySolutionInfo defalutSolution = null;
        QuerySolutionInfo userDefaultSolution = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            if (coll.get(i).getSolutionType().getValue().equals("10")) {
                defalutSolution = coll.get(i);
            }
            if (!coll.get(i).isIsUserDefaultSolu() || !this.getCurrentUserId().equals((Object)coll.get(i).getOwner())) continue;
            userDefaultSolution = coll.get(i);
        }
        boolean showDefaultSolution = this.commonQueryParam.isShowDefaultSolution();
        if (userDefaultSolution != null && this.getCurrentUserId().equals((Object)userDefaultSolution.getOwner())) {
            return userDefaultSolution;
        }
        if (showDefaultSolution) {
            return defalutSolution;
        }
        return coll.get(0);
    }

    protected void LoadSoutionList(ShareTypeEnum currentShareType) throws Exception {
        boolean disVisiableDefaultView = this.commonQueryParam.isDisVisiableDefaultView();
        if (this.getCommonQueryPanel().showToolbar) {
            this.loadShowToolBarSolution(currentShareType);
        } else {
            this.getCommonQueryPanel().disVisiableDefaultView();
            this.getCommonQueryPanel().disVisiableRowCount();
        }
        if (disVisiableDefaultView) {
            this.commonQueryPanel.disVisiableDefaultView();
        }
        if (this.getCommonQueryPanel() != null && this.getCommonQueryPanel().getCommonFilterPanel() != null) {
            super.enableExportExcel(this.getCommonQueryPanel().getCommonFilterPanel().getKdtTable());
        }
    }

    protected void setSelected(QuerySolutionInfo info) {
        this.getCommonQueryPanel().getSolutionListPanel().setSelected(info);
    }

    private QuerySolutionInfo createSysDefaultSolutionInfo(String queryObjectName, BOSUuid orgID, ShareTypeEnum currentShareType) throws Exception {
        QuerySolutionInfo querySolutionInfo = new QuerySolutionInfo();
        querySolutionInfo.setId(BOSUuid.create((String)"F93E381C"));
        querySolutionInfo.setOwner(SysContext.getSysContext().getCurrentUserInfo().getId());
        querySolutionInfo.setSolutionType(SolutionTypeEnum.SYSTEM_SOLUTION);
        querySolutionInfo.setQueryObjectName(queryObjectName);
        if (currentShareType == ShareTypeEnum.CU_LEVEL) {
            orgID = SysContext.getSysContext().getCurrentCtrlUnit().getId();
        }
        querySolutionInfo.setOrgID(orgID);
        querySolutionInfo.setShareType(currentShareType);
        if (this.getCommonQueryPanel().getDefaultToolBar() != null) {
            querySolutionInfo.setTableParams(this.commonQueryParam.getDefaultTableparams());
        }
        String parentUIName = this.commonQueryPanel.getParentUIClassName();
        querySolutionInfo.setParentUIName(parentUIName);
        QueryPanelCollection queryPanelCollection = new QueryPanelCollection();
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        queryPanelCollection.add(queryPanelInfo);
        querySolutionInfo.getQueryPanelInfo().addCollection(queryPanelCollection);
        List langList = KDBizMultiLangBox.getLanguageList();
        for (int i = 0; i < langList.size(); ++i) {
            querySolutionInfo.setName(ResourceBase.getString((String)commonQueryRes, (String)"sysDefaultRule", (Locale)((LanguageInfo)langList.get(i)).getLocale()), ((LanguageInfo)langList.get(i)).getLocale());
        }
        if (this.commonQueryParam.isDisShowRowCount()) {
            querySolutionInfo.setRowCount(-1);
        } else {
            querySolutionInfo.setRowCount(CommonQueryParam.defaultReturnMaxCount);
        }
        querySolutionInfo.setIsUserDefaultSolu(true);
        querySolutionInfo.setSolutionType(SolutionTypeEnum.SYSTEM_SOLUTION);
        return querySolutionInfo;
    }

    private void loadSolution(QuerySolutionInfo querySolutionInfo) throws Exception {
        this.commonQueryPanel.loadSolutionInfo(querySolutionInfo);
    }

    private int getWidth(int width, boolean showToolbar) {
        if (showToolbar) {
            width = width == 0 ? 760 : (width += 220);
        } else if (width == 0) {
            width = 540;
        }
        return width;
    }

    private int getHeight(int height, boolean showButton) {
        if (showButton) {
            height = height == 0 ? 480 : (height += 80);
        } else if (height == 0) {
            height = 400;
        }
        return height;
    }

    private void setDialogTitle(String dialogName) {
        if (dialogName == null || dialogName.trim().equalsIgnoreCase("")) {
            dialogName = EASResource.getString((String)commonQueryRes, (String)"dialogName");
        }
        this.setUITitle(dialogName);
    }

    private void addPanels(ArrayList panels) throws Exception {
        int size = panels.size();
        for (int i = 0; i < size; ++i) {
            CustomerQueryPanel customerQueryPanel = (CustomerQueryPanel)panels.get(i);
            logger.info((Object)("customer panel ui name:" + customerQueryPanel.getClass().getName()));
            if (customerQueryPanel.getPanelName() != null && !customerQueryPanel.getPanelName().trim().equalsIgnoreCase("")) continue;
            customerQueryPanel.setPanelName(EASResource.getString((String)commonQueryRes, (String)"customerPanelName"));
        }
        this.commonQueryPanel.addPanels(panels);
    }

    protected CommonQueryPanel getCommonQueryPanel() {
        return this.commonQueryPanel;
    }

    protected int getCloseWindowType() {
        return this.getCommonQueryPanel().getCloseWindowType();
    }

    protected EntityViewInfo getEntityViewInfo() {
        return this.getCommonQueryPanel().getEntityViewInfo();
    }

    protected EntityViewInfo getEntityViewInnerInfo() throws BOSException {
        return this.getCommonQueryPanel().getEntityViewInnerInfo();
    }

    public String getdefaultTableParams() {
        if (this.getCommonQueryPanel().getCommonTablePanel() != null) {
            return this.getCommonQueryPanel().getCommonTablePanel().getTableParams();
        }
        if (this.commonQueryParam.getUiObject() != null) {
            return Util.getOrigialTableParams(Util.getQueryInfo(this.commonQueryParam.getQueryObjectPK()), (Component)this.commonQueryParam.getUiObject());
        }
        return null;
    }

    public String getTableParamsFromUI() {
        if (this.commonQueryParam.getUiObject() != null) {
            String tableParam = Util.getOrigialTableParams(Util.getQueryInfo(this.commonQueryParam.getQueryObjectPK()), (Component)this.commonQueryParam.getUiObject());
            return tableParam;
        }
        return null;
    }

    protected String getTableParamsInnerInfo() {
        return this.getCommonQueryPanel().getTableParamsInnerInfo();
    }

    protected boolean isConfirm() {
        return this.getCloseWindowType() == 0;
    }

    protected JButton getDefaultButton() {
        return super.getDefaultButton();
    }

    public CommonQueryParam getCommonQueryParam() {
        return this.commonQueryParam;
    }

    protected boolean checkBeforeWindowClosing() {
        this.getCommonQueryPanel().setCloseWindowType(2);
        return super.checkBeforeWindowClosing();
    }

    protected UserInfo getCurrUserInfo() {
        return (UserInfo)SysContext.getSysContext().getCurrentUser();
    }

    void handleSysDynQuerySolution() {
        if (this.isNeedLoadDynSysDefaultSolu()) {
            try {
                String oql = "WHERE isSysDefault = '1' AND uiName = '" + this.commonQueryParam.getParentUIClassName() + "'";
                DynQuerySolutionInfo sysDynSolution = DynQuerySolutionFactory.getRemoteInstance().getDynQuerySolutionInfo(oql);
                this.getCommonQueryPanel().setDynQuery(sysDynSolution);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isNeedLoadDynSysDefaultSolu() {
        boolean hasDynSolution = this.getCommonQueryPanel().getDynQuerySolutionInfo() != null;
        boolean isSynSolution = false;
        isSynSolution = this.commonQueryPanel.getCurrentSolution() != null ? this.commonQueryPanel.getCurrentSolution().getSolutionType() == SolutionTypeEnum.SYSTEM_SOLUTION : true;
        boolean isSupport = this.commonQueryParam.isSupportDynSysDefaultSolution();
        return !hasDynSolution && isSynSolution && isSupport;
    }
}

