/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.query;

import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.IQueryInfoPanel;
import com.kingdee.eas.base.commonquery.client.KDCommonQueryList;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.client.query.CommonQueryPanel;
import com.kingdee.eas.fi.gr.cslrpt.client.query.CommonQueryUI;
import com.kingdee.eas.fi.gr.cslrpt.client.query.Util;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SolutionListPanel
extends KDPanel {
    private static final String commonQueryRes = "com.kingdee.eas.base.commonquery.client.CommonQueryPanel";
    private KDList solutionList;

    public SolutionListPanel() {
        this.init();
    }

    private void init() {
        KDScrollPane pane = new KDScrollPane();
        this.solutionList = new KDCommonQueryList();
        pane.getViewport().add((Component)this.solutionList, null);
        this.setLayout(new BorderLayout());
        this.add((Component)pane, "Center");
        this.solutionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                try {
                    if (!e.getValueIsAdjusting()) {
                        SolutionListPanel.this.solutionListClicked(e);
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void setDefaultSolutionAsCurrentSolution() {
        if (this.getCommonQueryPanel().getCustomerQueryPanel().size() == 0) {
            this.getCommonQueryPanel().getSolutionListPanel().refreshSolutionList();
            this.solutionList.setSelectedIndex(0);
            this.solutionList.repaint();
        }
    }

    private void solutionListClicked(ListSelectionEvent e) throws Exception {
        if (this.solutionList.getSelectedValue() != null && ((QuerySolutionInfo)this.solutionList.getSelectedValue()).getName() != null) {
            this.resetSorterPanel();
            if (this.solutionList.getSelectedValue().toString().equals(EASResource.getString((String)commonQueryRes, (String)"sysDefaultRule"))) {
                this.resetToolBar();
                this.resetUserPanels();
                this.resetFilterPanel();
                this.resetTablePanels();
                this.getCommonQueryPanel().getDefaultToolBar().disEditButton();
            } else {
                this.getCommonQueryPanel().getDefaultToolBar().enEditButton();
            }
        }
        this.loadSolution(e);
        CommonQueryUI commonQueryUI = (CommonQueryUI)((Object)Util.getComponent((Component)((Object)this), CommonQueryUI.class.getName()));
        if (commonQueryUI != null) {
            commonQueryUI.handleSysDynQuerySolution();
        }
    }

    private void resetToolBar() {
    }

    private void resetTablePanels() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel.getCommonTablePanel() != null) {
            commonQueryPanel.getCommonTablePanel().clear();
        }
    }

    private void resetUserPanels() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        Collection panels = commonQueryPanel.getPanels().values();
        for (KDPanel tempPanel : panels) {
            if (!(tempPanel instanceof IQueryInfoPanel)) continue;
            ((IQueryInfoPanel)tempPanel).clear();
        }
    }

    private void resetFilterPanel() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel.isShowFilter() && commonQueryPanel.getCommonFilterPanel() != null) {
            commonQueryPanel.getCommonFilterPanel().clear();
        }
    }

    private void resetSorterPanel() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel.isShowSorter() && commonQueryPanel.getCommonSorterPanel() != null) {
            commonQueryPanel.getCommonSorterPanel().clear();
        }
    }

    private void loadSolution(ListSelectionEvent e) throws Exception {
        QuerySolutionInfo querySolutionInfo = (QuerySolutionInfo)this.solutionList.getSelectedValue();
        if (querySolutionInfo != null) {
            this.getCommonQueryPanel().loadSolutionInfo(querySolutionInfo);
            this.changeUIStatusByOwner(querySolutionInfo);
        }
    }

    private void changeUIStatusByOwner(QuerySolutionInfo querySolutionInfo) {
        boolean isSystemSolution = SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)querySolutionInfo.getSolutionType());
        String userid = querySolutionInfo.getOwner().toString();
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        boolean isOwned = userid.equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        commonQueryPanel.getConfirmButton().setEnabled(true);
        commonQueryPanel.getDefaultToolBar().setSaveAsButtonStatus(true);
        commonQueryPanel.getDefaultToolBar().setDelButtonStatus(isOwned && !isSystemSolution);
        commonQueryPanel.getDefaultToolBar().setRenameButtonStatus(isOwned && !isSystemSolution);
        commonQueryPanel.getDefaultToolBar().setSaveButtonStatus(isOwned && !isSystemSolution);
        commonQueryPanel.setDefaultViewSelected(isOwned && querySolutionInfo.isIsUserDefaultSolu());
        commonQueryPanel.setDefaultViewSelectEnable(isOwned);
    }

    protected void setSelected(QuerySolutionInfo info) {
        if (info != null) {
            ListModel model = this.solutionList.getModel();
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                QuerySolutionInfo solutionInfo = (QuerySolutionInfo)model.getElementAt(i);
                if (!solutionInfo.getId().equals((Object)info.getId())) continue;
                this.solutionList.setSelectedIndex(i);
            }
        }
    }

    public QuerySolutionCollection getAllSolutionCollection() {
        QuerySolutionCollection coll = new QuerySolutionCollection();
        ListModel model = this.solutionList.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            QuerySolutionInfo solutionInfo = (QuerySolutionInfo)model.getElementAt(i);
            coll.add(solutionInfo);
        }
        return coll;
    }

    protected QuerySolutionInfo getSelectedQuerySolutionInfo() {
        return (QuerySolutionInfo)this.solutionList.getSelectedValue();
    }

    protected void refreshSolutionList() {
        ShareTypeEnum shareType = this.getCommonQueryPanel().getDefaultToolBar().getCurrentShareType();
        QuerySolutionCollection querySolutionCollection = this.getCommonQueryPanel().getDefaultToolBar().getQuerySolutions(shareType);
        querySolutionCollection = Util.justOneDefaultSolutionVisible(querySolutionCollection);
        this.refreshSolutionList(querySolutionCollection);
    }

    protected void refreshSolutionList(QuerySolutionCollection querySolutionCollection) {
        this.solutionList.removeAllElements();
        Icon icon = EASResource.getIcon((String)"imgTree_public");
        Iterator it = querySolutionCollection.iterator();
        QuerySolutionInfo qsinfo = null;
        while (it.hasNext()) {
            qsinfo = (QuerySolutionInfo)it.next();
            if ("10".equals(qsinfo.getSolutionType().getValue())) {
                this.solutionList.insertElement((Object)qsinfo, 0);
            } else {
                this.solutionList.addElement((Object)qsinfo);
            }
            this.solutionList.setElementIcon(icon, (Object)qsinfo);
        }
    }

    private CommonQueryPanel getCommonQueryPanel() {
        return (CommonQueryPanel)((Object)Util.getComponent((Component)((Object)this), CommonQueryPanel.class.getName()));
    }
}

