/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.report.IRptMenuExtManager;
import com.kingdee.eas.fi.newrpt.client.designer.BaseReportMenuManager;
import com.kingdee.eas.fi.newrpt.client.designer.ReportMenuState;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import org.apache.log4j.Logger;

public class CslRptMenuManager
extends BaseReportMenuManager
implements IRptMenuExtManager {
    private static final Logger logger = Logger.getLogger(CslRptMenuManager.class);

    public void applyMenuState(ReportMenuState state) {
        super.applyMenuState(state);
        ReportBaseInfo cslReportInfo = (ReportBaseInfo)state.getBookProvider().getEditValue();
        if (OprtState.ADDNEW.equals(state.getEditState())) {
            this.initMenuAddState(cslReportInfo);
        } else if (OprtState.EDIT.equals(state.getEditState())) {
            this.initMenuEditState(cslReportInfo);
        } else if (OprtState.VIEW.equals(state.getEditState())) {
            this.initMenuViewState(cslReportInfo);
        }
    }

    private void initMenuAddState(ReportBaseInfo cslReportInfo) {
        this.initMenuEditState(cslReportInfo);
        this.addStateExtMenuSetting(cslReportInfo);
    }

    private void initMenuEditState(ReportBaseInfo cslReportInfo) {
        this.enableVisibleMenu("menuEdit/menuSumRange", false, false, true);
        this.enableVisibleMenu("menuStyle", true, true, true);
        this.enableVisibleMenu("menuWindow", true, true, true);
        this.enableVisibleMenu("menuTool/menuReportCheck", true, true, true);
        this.enableVisibleMenu("menuFile/menuItemImport", true, true);
        this.enableVisibleMenu("menuFile/itemImportData", true, true);
        this.enableVisibleMenu("menuTool/menuItemSheetManager", true, true);
        this.enableVisibleMenu("menuTool/menuItemReportRound", true, true, true);
        this.enableVisibleMenu("menuTool/menuItemSheeSum", false, false);
        this.enableVisibleMenu("menuData/menuItemCalculate", true, true);
        this.enableVisibleMenu("menuData/menuItemCalculateSelectedSheet", true, true);
        this.enableVisibleMenu("menuData/menuMultiCalculate", true, true, true);
        this.editStateExtMenuSetting(cslReportInfo);
    }

    private void initMenuViewState(ReportBaseInfo cslReportInfo) {
        this.enableVisibleMenu("menuStyle", true, true);
        this.enableVisibleMenu("menuStyle/menuItemStyleCell", false, false, true);
        this.enableVisibleMenu("menuStyle/menuItemStyleRow", false, false, true);
        this.enableVisibleMenu("menuStyle/menuItemStyleColumn", false, false, true);
        this.enableVisibleMenu("menuStyle/menuItemStyleSheet", false, false, true);
        this.enableVisibleMenu("menuStyle/menuItemCellMerge", false, false);
        this.enableVisibleMenu("menuStyle/menuItemLock", false, false);
        this.enableVisibleMenu("menuStyle/menuItemUnLock", false, false);
        this.enableVisibleMenu("menuFile/menuItemImport", false, false);
        this.enableVisibleMenu("menuFile/itemImportData", false, false);
        this.enableVisibleMenu("menuTool/menuItemSheetManager", false, false);
        this.enableVisibleMenu("menuTool/menuItemReportRound", false, false, true);
        this.enableVisibleMenu("menuTool/menuItemSheeSum", false, false);
        this.viewStateExtMenuSetting(cslReportInfo);
    }

    public void applyCommonMenu(ReportMenuState state) {
        super.applyCommonMenu(state);
        this.enableVisibleMenu("menuFind/findAccount/itemFindIndexData", false, false);
        ReportBaseInfo reportBase = (ReportBaseInfo)state.getBookProvider().getEditValue();
        if (reportBase != null && (reportBase.getSourceType() == RptSrcTypeEnum.DYNAMICCSLREPORT || reportBase.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || reportBase.getSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT || reportBase.getSourceType() == RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE)) {
            this.enableVisibleMenu("menuData/sepDataAnalysis", true, true);
            this.enableVisibleMenu("menuData/menuDynaItemAnalysisItem", true, true);
            this.enableVisibleMenu("menuRangeContext/menuDynaItemRCAnalysisItem", true, true);
            this.enableVisibleMenu("menuRangeContext/menuDyItemPerspectivity", true, true);
            this.enableVisibleMenu("menuData/menuDyItemPerspectivity_data", true, true);
            this.enableVisibleMenu("menuRangeContext/itemDynaRange", true, true);
        } else {
            this.enableVisibleMenu("menuData/sepDataAnalysis", true, true);
            this.enableVisibleMenu("menuData/menuItemAnalysisItem", true, true);
            this.enableVisibleMenu("menuRangeContext/menuItemRCAnalysisItem", true, true);
            this.enableVisibleMenu("menuRangeContext/menuItemPerspectivity", true, true);
            this.enableVisibleMenu("menuData/menuItemPerspectivity_data", true, true);
            this.enableVisibleMenu("menuRangeContext/itemDynaRange", true, false);
        }
        this.enableVisibleMenu("menuData/menuItemAutoFillAndCalculateSelectedSheet", false, false);
        this.enableVisibleMenu("menuData/menuItemAutoFillAndCalculateAllSheet", false, false);
    }

    protected void applySheetRelatedMenu(ReportMenuState state) {
        super.applySheetRelatedMenu(state);
        ReportBaseInfo reportBase = (ReportBaseInfo)state.getBookProvider().getEditValue();
        ReportVariables variables = ReportVariables.loadFromBook((Book)state.getSheet().getBook());
        VariableEntry variable = variables.get("SheetClass", state.getSheet().getSheetName());
        if (variable != null && String.valueOf(String.valueOf(1)).equals(variable.getValue())) {
            if (reportBase.getSourceType() != RptSrcTypeEnum.DYNAMICCSLREPORT && reportBase.getSourceType() != RptSrcTypeEnum.DYNAMICNORMALREPORT && reportBase.getSourceType() != RptSrcTypeEnum.DYNAMICSUMREPORT && reportBase.getSourceType() != RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT && reportBase.getSourceType() != RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) {
                this.enableVisibleMenu("menuData/sepDataAnalysis", true, true);
                this.enableVisibleMenu("menuData/menuItemAnalysisItem", true, true);
                this.enableVisibleMenu("menuRangeContext/menuItemRCAnalysisItem", true, true);
            }
        } else {
            this.enableVisibleMenu("menuData/sepDataAnalysis", false, false);
            this.enableVisibleMenu("menuData/menuItemAnalysisItem", false, false);
            this.enableVisibleMenu("menuRangeContext/menuItemRCAnalysisItem", false, false);
            this.enableVisibleMenu("menuData/menuItemAnalysisCell", false, false);
            this.enableVisibleMenu("menuRangeContext/menuItemRCAnalysisCell", false, false);
        }
    }

    protected void refreshAuditMenu(ReportMenuState state) {
        boolean isTopLevel;
        boolean isCommitted;
        boolean isUnCommitted;
        boolean isAudited;
        ReportBaseInfo cslReport;
        block10: {
            int isQueryBudget = state.getBookProvider().getIsQueryBudget();
            cslReport = (ReportBaseInfo)state.getBookProvider().getEditValue();
            isAudited = cslReport.getAuditedStatus().getValue() == 2;
            isUnCommitted = cslReport.getCommittedStatus().getValue() == 1;
            isCommitted = cslReport.getCommittedStatus().getValue() == 2;
            isTopLevel = false;
            try {
                if (isQueryBudget == 0) {
                    isTopLevel = CslRptUtil.isCslTopLevelAtClient((CslReportInfo)cslReport);
                }
            }
            catch (BOSException e) {
                if (!logger.isDebugEnabled()) break block10;
                logger.debug((Object)e);
            }
        }
        String meunText = isAudited ? RptUtil.getRptMenuResource((String)"miUnAudit") : RptUtil.getRptMenuResource((String)"miAudit");
        this.setMenuText("menuTool/menuItemAudit", meunText);
        if (isTopLevel) {
            this.enableVisibleMenu("menuTool/menuItemAudit", true, true);
            this.enableVisibleMenu("menuTool/itemRptCommit", false, false);
            this.enableVisibleMenu("menuTool/itemRptUnCommit", false, false);
        } else {
            this.enableVisibleMenu("menuTool/menuItemAudit", true, isUnCommitted);
            this.enableVisibleMenu("menuTool/itemRptCommit", true, isAudited && isUnCommitted);
            this.enableVisibleMenu("menuTool/itemRptUnCommit", true, isCommitted);
        }
        String id = cslReport.getId().toString();
        try {
            if (!cslReport.getSourceType().equals((Object)RptSrcTypeEnum.DYNACSLELIMREPORT)) {
                SumRptAddedPerportyInfo sumRptAddedPerportyInfo = SumRptAddedPerportyFactory.getRemoteInstance().getSumRptAddedPerportyInfo("select isSupportGroup where report = '" + id + "'");
                if (sumRptAddedPerportyInfo.getIsSupportGroup().getValue() == 2) {
                    this.enableVisibleMenu("menuTool/itemRptCommit", true, false);
                }
            } else {
                this.enableVisibleMenu("menuTool/itemRptCommit", true, false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"refreshAuditMenu: ", (Throwable)e);
        }
        this.auditStateExtMenuSetting(cslReport);
    }

    @Override
    public void editStateExtMenuSetting(ReportBaseInfo reportBaseInfo) {
        if (this.isDynaCslReport(reportBaseInfo)) {
            this.enableVisibleMenu("menuTool/generateElimReport", true, true);
            this.enableVisibleMenu("menuTool/linkElimReport", true, true);
        }
    }

    @Override
    public void addStateExtMenuSetting(ReportBaseInfo reportBaseInfo) {
        if (this.isDynaCslReport(reportBaseInfo)) {
            this.enableVisibleMenu("menuTool/generateElimReport", true, true);
            this.enableVisibleMenu("menuTool/linkElimReport", true, true);
        }
    }

    @Override
    public void auditStateExtMenuSetting(ReportBaseInfo reportBaseInfo) {
        if (this.isDynaCslReport(reportBaseInfo)) {
            boolean isAudited = reportBaseInfo.getAuditedStatus().getValue() == 2;
            this.enableVisibleMenu("menuTool/generateElimReport", true, !isAudited);
            this.enableVisibleMenu("menuTool/linkElimReport", true, true);
        }
    }

    @Override
    public void viewStateExtMenuSetting(ReportBaseInfo reportBaseInfo) {
        if (this.isDynaCslReport(reportBaseInfo)) {
            this.enableVisibleMenu("menuTool/generateElimReport", true, false);
            this.enableVisibleMenu("menuTool/linkElimReport", true, true);
        }
    }

    public boolean isDynaCslReport(ReportBaseInfo reportBaseInfo) {
        return RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)reportBaseInfo.getSourceType()) || RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE.equals((Object)reportBaseInfo.getSourceType());
    }
}

