/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.newrpt.client.designer.BaseReportMenuManager;
import com.kingdee.eas.fi.newrpt.client.designer.ReportMenuState;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptSumTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import org.apache.log4j.Logger;

public class SumReportMenuManager
extends BaseReportMenuManager {
    private static final Logger logger = Logger.getLogger(SumReportMenuManager.class);

    public void applyMenuState(ReportMenuState state) {
        super.applyMenuState(state);
        ReportBaseInfo cslReportInfo = (ReportBaseInfo)state.getBookProvider().getEditValue();
        if (OprtState.ADDNEW.equals(state.getEditState())) {
            this.initMenuAddState(cslReportInfo);
        } else if (OprtState.EDIT.equals(state.getEditState())) {
            this.initMenuEditState(cslReportInfo);
        } else if (OprtState.VIEW.equals(state.getEditState())) {
            this.initMenuViewState(cslReportInfo);
        }
    }

    private void initMenuAddState(ReportBaseInfo cslReportInfo) {
        this.initMenuEditState(cslReportInfo);
    }

    private void initMenuEditState(ReportBaseInfo cslReportInfo) {
        int sourceType = cslReportInfo.getSourceType().getValue();
        int dynamicType = cslReportInfo.getTemplate().getDynaRptType().getValue();
        if (sourceType == RptSrcTypeEnum.DYNAMICNORMALREPORT.getValue() && dynamicType == DynaEnumRptTypeEnum.DYNAMIC.getValue()) {
            this.enableVisibleMenu("menuTool/itemDynaItemFillWizard", true, true);
        } else {
            this.enableVisibleMenu("menuTool/itemDynaItemFillWizard", false, false);
        }
        this.enableVisibleMenu("menuFile/itemImportData", true, true);
    }

    private void initMenuViewState(ReportBaseInfo cslReportInfo) {
        this.enableVisibleMenu("menuFile/itemImportData", true, false);
    }

    public void applyCommonMenu(ReportMenuState state) {
        block12: {
            super.applyCommonMenu(state);
            ReportBaseInfo reportBase = (ReportBaseInfo)state.getBookProvider().getEditValue();
            boolean isSubByPage = reportBase.getTemplate().getSumType().getValue() == 1;
            this.enableVisibleMenu("menuEdit/menuSumRange", true, isSubByPage, true);
            this.enableVisibleMenu("menuView/menuItemViewSumRange", true, isSubByPage);
            this.enableVisibleMenu("menuData/menuMultiCalculate", false, false, true);
            this.enableVisibleMenu("menuFind", false, false);
            this.enableVisibleMenu("menuTool/menuItemSheeSum", false, false);
            if (reportBase.getSourceType() == RptSrcTypeEnum.DYNAMICCSLREPORT || reportBase.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || reportBase.getSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT || reportBase.getSourceType() == RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE || reportBase.getSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) {
                this.enableVisibleMenu("menuData/sepDataAnalysis", true, true);
                this.enableVisibleMenu("menuData/menuDynaItemAnalysisItem", true, true);
                this.enableVisibleMenu("menuData/menuDyItemPerspectivity_data", true, true);
                this.enableVisibleMenu("menuRangeContext/menuDyItemPerspectivity", true, true);
                this.enableVisibleMenu("menuRangeContext/menuDynaItemRCAnalysisItem", true, true);
            } else {
                this.enableVisibleMenu("menuData/sepDataAnalysis", true, true);
                if (reportBase.getTemplate().getSumType() == RptSumTypeEnum.BYITEM || reportBase.getSourceType() == RptSrcTypeEnum.CONSOLIDATION_FASTMERGE) {
                    this.enableVisibleMenu("menuData/menuItemAnalysisItem", true, true);
                    this.enableVisibleMenu("menuRangeContext/menuItemRCAnalysisItem", true, true);
                    this.enableVisibleMenu("menuRangeContext/menuItemPerspectivity", true, true);
                    this.enableVisibleMenu("menuData/menuItemPerspectivity_data", true, true);
                } else {
                    this.enableVisibleMenu("menuData/menuItemAnalysisCell", true, true);
                    this.enableVisibleMenu("menuRangeContext/menuItemRCAnalysisCell", true, true);
                }
            }
            this.enableVisibleMenu("menuData/menuItemAutoFillAndCalculateSelectedSheet", false, false);
            this.enableVisibleMenu("menuData/menuItemAutoFillAndCalculateAllSheet", false, false);
            try {
                if (reportBase.getSourceType().getValue() != 2) break block12;
                boolean isDynaSum = CslRptUtil.getCslParamForDynamicSumRpt(null);
                if (isDynaSum) {
                    try {
                        Book book = reportBase.getBook();
                        if (book == null || book.getSheetCount() <= 0) break block12;
                        for (int i = 0; i < book.getSheetCount(); ++i) {
                            Sheet sheet = book.getSheet(i);
                            Object dynaKey = sheet.getUserObjectValue("DYNAMICSUMKEYZONE");
                            if (dynaKey != null) {
                                this.enableVisibleMenu("menuView/menuRelaView/itemCellView", false, false);
                                break block12;
                            }
                            this.enableVisibleMenu("menuView/menuRelaView/itemCellView", true, true);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        logger.error((Object)"reportBase.getBook()_Exception", (Throwable)e);
                        break block12;
                    }
                }
                this.enableVisibleMenu("menuView/menuRelaView/itemCellView", true, true);
            }
            catch (EASBizException e) {
                logger.error((Object)"CslRptUtil.getCslParamForDynamicSumRpt_EASBizException", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"CslRptUtil.getCslParamForDynamicSumRpt_BOSException", (Throwable)e);
            }
        }
    }

    protected void applySheetRelatedMenu(ReportMenuState state) {
        super.applySheetRelatedMenu(state);
        ReportBaseInfo reportBase = (ReportBaseInfo)state.getBookProvider().getEditValue();
        ReportVariables variables = ReportVariables.loadFromBook((Book)state.getSheet().getBook());
        VariableEntry variable = variables.get("SheetClass", state.getSheet().getSheetName());
        if (variable != null && String.valueOf(String.valueOf(1)).equals(variable.getValue())) {
            if (reportBase.getSourceType() != RptSrcTypeEnum.DYNAMICCSLREPORT && reportBase.getSourceType() != RptSrcTypeEnum.DYNAMICNORMALREPORT && reportBase.getSourceType() != RptSrcTypeEnum.DYNAMICSUMREPORT && reportBase.getSourceType() != RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) {
                this.enableVisibleMenu("menuData/sepDataAnalysis", true, true);
                if (reportBase.getTemplate().getSumType() == RptSumTypeEnum.BYITEM) {
                    this.enableVisibleMenu("menuData/menuItemAnalysisItem", true, true);
                    this.enableVisibleMenu("menuRangeContext/menuItemRCAnalysisItem", true, true);
                    this.enableVisibleMenu("menuRangeContext/menuItemPerspectivity", true, true);
                    this.enableVisibleMenu("menuData/menuItemPerspectivity_data", true, true);
                } else {
                    this.enableVisibleMenu("menuData/menuItemAnalysisCell", true, true);
                    this.enableVisibleMenu("menuRangeContext/menuItemRCAnalysisCell", true, true);
                }
            }
        } else {
            this.enableVisibleMenu("menuData/sepDataAnalysis", false, false);
            this.enableVisibleMenu("menuData/menuItemAnalysisItem", false, false);
            this.enableVisibleMenu("menuRangeContext/menuItemRCAnalysisItem", false, false);
            this.enableVisibleMenu("menuRangeContext/menuItemPerspectivity", false, false);
            this.enableVisibleMenu("menuData/menuItemPerspectivity_data", false, false);
            this.enableVisibleMenu("menuData/menuItemAnalysisCell", false, false);
            this.enableVisibleMenu("menuRangeContext/menuItemRCAnalysisCell", false, false);
        }
    }

    protected void refreshAuditMenu(ReportMenuState state) {
        super.refreshAuditMenu(state);
        int isQueryBudget = state.getBookProvider().getIsQueryBudget();
        ReportBaseInfo cslReport = (ReportBaseInfo)state.getBookProvider().getEditValue();
        boolean isAudited = cslReport.getAuditedStatus().getValue() == 2;
        boolean isUnCommitted = cslReport.getCommittedStatus().getValue() == 1;
        boolean isCommitted = cslReport.getCommittedStatus().getValue() == 2;
        boolean isTopLevel = false;
        try {
            if (isQueryBudget == 0) {
                isTopLevel = CslRptUtil.isCslTopLevelAtClient((CslReportInfo)cslReport);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"isCslTopLevelAtClient_BOSException", (Throwable)e);
        }
        if (isTopLevel) {
            this.enableVisibleMenu("menuTool/menuItemAudit", true, true);
            this.enableVisibleMenu("menuTool/itemRptCommit", false, false);
            this.enableVisibleMenu("menuTool/itemRptUnCommit", false, false);
        } else {
            this.enableVisibleMenu("menuTool/menuItemAudit", true, isUnCommitted);
            this.enableVisibleMenu("menuTool/itemRptCommit", true, isAudited && isUnCommitted);
            this.enableVisibleMenu("menuTool/itemRptUnCommit", true, isCommitted);
        }
    }
}

