/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.RelatedPartyRelationshipsFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLSysParamanager;
import com.kingdee.eas.fi.gr.cslrpt.client.reportcalc.AbstractRptCalculate;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.RptCalcHelper;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.Vector;

public abstract class AbstractMnsConsCalculate
extends AbstractRptCalculate {
    public AbstractMnsConsCalculate(CslReportInfo cslRptInfo) {
        super(cslRptInfo);
    }

    protected void checkRptRule() throws EASBizException {
        OrgTreeInfo orgTree = null;
        FullOrgUnitInfo parentCompany = null;
        OrgUnitCollection units = null;
        Vector<OrgUnitInfo> companys = new Vector<OrgUnitInfo>(0);
        Vector<String> companyIDs = new Vector<String>(0);
        if (this.cslRptInfo.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION) || this.cslRptInfo.getSourceType().equals((Object)RptSrcTypeEnum.MANUSCRIPT)) {
            orgTree = this.cslRptInfo.getOrgTree();
            parentCompany = this.cslRptInfo.getOrgUnit();
            try {
                units = this.getOrgUnits(orgTree, (OrgUnitInfo)parentCompany);
            }
            catch (BOSException e) {
                this.setNeedCalc(false);
                ExceptionHandler.handle((Throwable)e);
            }
            if (units != null && units.size() > 0) {
                for (OrgUnitInfo info : units) {
                    if (info == null) continue;
                    companyIDs.add(info.getNumber());
                    companys.add(info);
                }
            }
        }
        this.checkRptRule(companys, companyIDs);
    }

    protected void checkRptRule(Vector companys, Vector companyIDs) throws EASBizException {
        RptCalcHelper.checkRptRule(null, this.cslRptInfo, companys, companyIDs);
    }

    private OrgUnitCollection getOrgUnits(OrgTreeInfo orgTreeInfo, OrgUnitInfo parentCompanyInfo) throws EASBizException, BOSException {
        IOrgUnitCommon orgUtil = null;
        try {
            orgUtil = OrgUnitCommonFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        OrgUnitCollection units = null;
        boolean isByLevel = true;
        CSLContextHelper.getSysParamanager().refreshParams();
        int i = CSLContextHelper.getSysParamanager().getMergeType();
        if (i == -1) {
            throw new SumRptException(SumRptException.PLEASE_SET_SYSPARAMS);
        }
        isByLevel = i != 0;
        try {
            units = isByLevel ? orgUtil.getUnionDebtChildren(parentCompanyInfo, orgTreeInfo) : orgUtil.getUnionDebtAllOrgUnit(parentCompanyInfo, orgTreeInfo);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"labGetLowLevelCom"), (Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"labGetLowLevelCom"), (Throwable)e);
        }
        int elimMethod = Integer.parseInt(CSLSysParamanager.getSysParamValue(orgTreeInfo, "GR_CSL_ELIMMETHOD_001"));
        if (elimMethod == 2) {
            units = RelatedPartyRelationshipsFactory.getRemoteInstance().getHKRelationOrgUnits(units);
        }
        return units;
    }
}

