/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.Map;

public abstract class AbstractRptCalculate {
    protected CslReportInfo cslRptInfo;
    protected CoreUIObject reportProcessUI;
    protected Book book;
    protected Map newContext;
    private Map context;
    private boolean needCalc = true;
    private boolean calcAll = true;
    protected int precision;

    public AbstractRptCalculate(CslReportInfo cslRptInfo) {
        this.cslRptInfo = cslRptInfo;
    }

    protected void init(CoreUIObject reportProcessUI, Book book, Map context, boolean calcAll) {
        this.reportProcessUI = reportProcessUI;
        this.book = book;
        this.context = context;
        this.newContext = new UIContext((Object)reportProcessUI);
        this.newContext.put("isBeforeAdjust", context.get("isBeforeAdjust"));
        this.newContext.put("dataElementRelating", context.containsKey("dataElementRelating") ? context.get("dataElementRelating") : Integer.valueOf(-1));
        this.newContext.put("isSupport", context.get("isSupport"));
        if (calcAll) {
            this.newContext.put("dynaKeyCache", context.get("dynaKeyCache"));
        }
    }

    public void prepareCalculate() throws EASBizException, UIException, KDFException {
        this.precision = CslRptUIUtil.getPrecisionByCry(this.cslRptInfo.getCurrency());
        if (this.cslRptInfo.getAdjustStatus().getValue() == 1) {
            return;
        }
        this.prepare();
    }

    public void calculate() {
        try {
            this.calc();
        }
        catch (Exception e) {
            this.needCalc = false;
            ExceptionHandler.handle((Throwable)e);
        }
        Boolean isCanceled = (Boolean)this.newContext.get("isCancelCalculateGuideUI");
        this.context.put("isCancelCalculateGuideUI", isCanceled);
        if (this.calcAll) {
            Boolean bySumReport = (Boolean)this.newContext.get("bySumReport");
            this.context.put("bySumReport", bySumReport);
        }
        this.newContext.remove("isBeforeAdjust");
        this.newContext.remove("isSupport");
    }

    public boolean isNeedCalc() {
        return this.needCalc;
    }

    protected void setNeedCalc(boolean needCalc) {
        this.needCalc = needCalc;
    }

    protected abstract void prepare() throws EASBizException, KDFException, UIException;

    protected abstract void calc() throws EASBizException, BOSException;
}

