/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fi.gr.cslrpt.client.util.IRowData;
import java.util.List;

public class FillTable {
    private KDTable table;
    private String[] columnNames;

    public FillTable(KDTable table, String[] columnNames) {
        this.table = table;
        this.columnNames = columnNames;
    }

    public void exec(List<? extends IRowData> data) {
        IRow row = null;
        for (IRowData iRowData : data) {
            row = this.table.addRow();
            for (String columnName : this.columnNames) {
                row.getCell(columnName).setValue(iRowData.getValue(columnName));
                row.getCell(columnName).setUserObject(iRowData.getUserObject(columnName));
            }
        }
    }

    public void insert(List<? extends IRowData> data, int afterRowIndex) {
        IRow row = null;
        int currRowIndex = afterRowIndex + 1;
        for (int preRowIndex = currRowIndex - 1; this.table.getRow(preRowIndex) == null || preRowIndex < 0; --preRowIndex) {
            this.table.addRow(preRowIndex);
        }
        for (IRowData iRowData : data) {
            row = this.table.addRow(currRowIndex);
            ++currRowIndex;
            for (String columnName : this.columnNames) {
                if (row.getCell(columnName) == null) continue;
                row.getCell(columnName).setValue(iRowData.getValue(columnName));
                row.getCell(columnName).setUserObject(iRowData.getUserObject(columnName));
                if (!(iRowData.getValue(columnName) instanceof Number)) continue;
                StyleAttributes sa = row.getCell(columnName).getStyleAttributes();
                sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                sa.setNumberFormat("##,###.##");
            }
        }
    }

    public <T extends IRowData> int save(T rowData, int currRowIndex) {
        IRow row = null;
        for (int preRowIndex = currRowIndex - 1; this.table.getRow(preRowIndex) == null && preRowIndex >= 0; --preRowIndex) {
            this.table.addRow(preRowIndex);
        }
        row = this.table.getRow(currRowIndex);
        if (row == null) {
            row = this.table.addRow(currRowIndex);
        }
        row.setUserObject(rowData);
        for (String columnName : this.columnNames) {
            if (row.getCell(columnName) == null) continue;
            row.getCell(columnName).setValue(rowData.getValue(columnName));
            row.getCell(columnName).setUserObject(rowData.getUserObject(columnName));
        }
        return currRowIndex;
    }
}

