/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.util;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.util.IDispatchPeriodSource;
import java.util.HashMap;

public class SaveJobProcessDef {
    private static final long serialVersionUID = -3400004677802722012L;
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", SaveJobProcessDef.class);

    public String exec(IDispatchPeriodSource source) {
        try {
            ScheduleDef schedule = source.getUserObject();
            if (schedule == null) {
                return null;
            }
            String jobProcessDef = source.getJobProcess();
            if (jobProcessDef != null) {
                source.getWorkflowClient().updateProcessSchedule(jobProcessDef, KpdlParser.scheduleToString((ScheduleDef)schedule));
                return jobProcessDef;
            }
            HashMap<String, String> jobContext = new HashMap<String, String>();
            jobContext.put("formulaCalcContextId", ((FormulaCalcContextInfo)source.getJobParam()).getId().toString());
            FunctionObjectInfo function = this.buildFunctionObjectInfo(source);
            OperationInfo operation = this.buildOperationInfo(source, function);
            jobProcessDef = source.getWorkflowClient().createJobProcessDef(source.getJobTitle(), function, operation, jobContext, KpdlParser.scheduleToString((ScheduleDef)schedule), SysContext.getSysContext().getLocale());
            source.setJobProcess(jobProcessDef);
            return jobProcessDef;
        }
        catch (WfException e) {
            LOG.error("", e);
        }
        catch (Exception e) {
            LOG.error("", e);
        }
        return null;
    }

    protected OperationInfo buildOperationInfo(IDispatchPeriodSource source, FunctionObjectInfo function) {
        OperationInfo operation = function.getOperation().get(source.operationIndex());
        return operation;
    }

    protected FunctionObjectInfo buildFunctionObjectInfo(IDispatchPeriodSource source) {
        MetaDataPK functionPK = MetaDataPK.create((String)source.function());
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK);
        return function;
    }
}

