/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.util.mutex;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.client.MessageHandler;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexException;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexUtil;
import com.kingdee.util.Uuid;
import org.apache.log4j.Logger;

public class MutexLock {
    private String type;
    private String actionName;
    private MessageHandler handler;
    private String errorMsg;
    private Logger logger;

    public MutexLock(String type, String actionName, MessageHandler handler, String errorMsg, Logger logger) {
        this.type = type;
        this.actionName = actionName;
        this.handler = handler;
        this.errorMsg = errorMsg;
        this.logger = logger;
    }

    public boolean isLock(BOSUuid flag) {
        try {
            MutexUtil.checkMutex(this.type, flag, this.actionName);
            return false;
        }
        catch (MutexException e1) {
            this.logger.warn((Object)"", (Throwable)((Object)e1));
            return true;
        }
    }

    public Uuid lock(BOSUuid flag) {
        try {
            return MutexUtil.setMutex(this.type, flag, this.actionName);
        }
        catch (MutexException e1) {
            this.logger.warn((Object)"", (Throwable)((Object)e1));
            return null;
        }
    }

    public void unLock(Uuid lockId) {
        MutexUtil.releaseMutex(lockId);
    }

    public void showError() {
        this.showError(null);
    }

    public void showError(String newMessage) {
        if (newMessage == null) {
            this.handler.show(this.errorMsg);
        } else {
            this.handler.show(newMessage);
        }
    }
}

