/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.elimreport;

import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.DynaCslRptGuideUI;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.BuildElimRptBookInfo;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.CatchDynaCslElimRptDataSource;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.DynaCslElimRptGenerate;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ICatchDataSource;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.IElimReportGenerate;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaCslRptParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.MnsRptGuideHelper;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;

public class GenerateDynaCslElimReport4Client
implements IElimReportGenerate,
ICatchDataSource {
    private CoreUIObject _reportProcessUI;
    private ICatchDataSource iCatchDataSource;

    public GenerateDynaCslElimReport4Client(CoreUIObject reportProcessUI) {
        this._reportProcessUI = reportProcessUI;
        this.iCatchDataSource = new CatchDynaCslElimRptDataSource();
    }

    @Override
    public void catchDataSource(BuildElimRptBookInfo buildInfo) throws Exception {
        this.convertSrcReportToElimReport(buildInfo);
        this.execCatchDataSource(buildInfo);
    }

    @Override
    public void generateElimReportBookStructure(BuildElimRptBookInfo buildInfo) throws Exception {
        new DynaCslElimRptGenerate().generateElimReportBookStructure(buildInfo);
    }

    private void convertSrcReportToElimReport(BuildElimRptBookInfo buildInfo) {
        if (buildInfo.getSrcCslRptInfo() == null) {
            throw new RuntimeException("Source CslReportInfo is Null for Build ElimReport!");
        }
        if (buildInfo.getElimRptInfo() != null) {
            return;
        }
        CslReportInfo srcCslRptInfo = buildInfo.getSrcCslRptInfo();
        CslReportInfo elimRptInfo = (CslReportInfo)srcCslRptInfo.clone();
        elimRptInfo.setId(BOSUuid.create((BOSObjectType)srcCslRptInfo.getBOSType()));
        elimRptInfo.setSourceType(RptSrcTypeEnum.DYNACSLELIMREPORT);
        buildInfo.setElimRptInfo(elimRptInfo);
    }

    private void execCatchDataSource(BuildElimRptBookInfo buildInfo) throws Exception {
        if (buildInfo.isSupportCrossMerger()) {
            this.buildParam4SupportCrossMerger(buildInfo);
        } else {
            this.buildParam4NotSupportCrossMerger(buildInfo);
        }
        this.iCatchDataSource.catchDataSource(buildInfo);
    }

    protected void buildParam4SupportCrossMerger(BuildElimRptBookInfo buildInfo) throws Exception {
        CslReportInfo srcCslRptInfo = buildInfo.getSrcCslRptInfo();
        UserObject userObject = srcCslRptInfo.getBook().getUserObject("unitMap2SerialString");
        DynaCslRptParamInfo paramInfo = new DynaCslRptParamInfo();
        if (this._reportProcessUI.getUIContext().get("dyGuideUI") != null) {
            DynaCslRptGuideUI guide = (DynaCslRptGuideUI)this._reportProcessUI.getUIContext().get("dyGuideUI");
            paramInfo = guide.getDynaCslRptParamInfo();
        } else if (userObject != null && !StringUtils.isEmpty((String)((String)userObject.getValue()))) {
            paramInfo.parseStr2UnitMap((String)userObject.getValue());
        } else {
            DynaCslRptGuideUI guideUI = new DynaCslRptGuideUI((IUIObject)this._reportProcessUI, srcCslRptInfo, srcCslRptInfo.getBook());
            if (guideUI.hasDefaultSolution(false)) {
                paramInfo = guideUI.getDynaCslRptParamInfo();
            } else {
                FullOrgUnitCollection fullOrgUnitCollection = MnsRptGuideHelper.getUnionDebtChildren(srcCslRptInfo.getOrgTree().getId().toString(), srcCslRptInfo.getOrgUnit().getId().toString());
                if (fullOrgUnitCollection == null || fullOrgUnitCollection.size() == 0) {
                    throw new Exception("not found any orgUnit under current tree!");
                }
                guideUI.loadSysDefaultSolution(fullOrgUnitCollection);
                paramInfo = guideUI.getDynaCslRptParamInfo();
                if (buildInfo.isSupportCrossMerger()) {
                    paramInfo.setSumMethod(DynaSumMethodEnum.LIST_DETAIL_COMP_NAME);
                }
            }
        }
        paramInfo.setReportID(srcCslRptInfo.getId().toString());
        buildInfo.setDynaCslRptParamInfo(paramInfo);
    }

    protected void buildParam4NotSupportCrossMerger(BuildElimRptBookInfo buildInfo) throws Exception {
        OrgUnitCollection coll = DynamicTemplateUtility.getOrgUnits((OrgTreeInfo)buildInfo.getSrcCslRptInfo().getOrgTree(), (OrgUnitInfo)buildInfo.getSrcCslRptInfo().getOrgUnit());
        ArrayList<Object> companyList = new ArrayList<Object>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            companyList.add(coll.get(i).getId().toString());
        }
        DynaCslRptParamInfo paramInfo = new DynaCslRptParamInfo();
        paramInfo.setOnlyList(false);
        paramInfo.setOnlyListCompany(false);
        paramInfo.setShowTotal(false);
        buildInfo.setDynaCslRptParamInfo(paramInfo);
        buildInfo.setCompanyList(companyList);
    }
}

