/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.elimreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostMan;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostManManager;
import com.kingdee.eas.fi.gr.cslrpt.MnsFillOrgUnitCollection;
import com.kingdee.eas.fi.gr.cslrpt.RpcHandleFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.app.RpcHandleFacadeControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.BuildElimRptBookInfo;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.CatchDynaCslElimRptDataSource;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.DynaCslElimReportSaveImp;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.DynaCslElimRptGenerate;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ElimReportUtils;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.IBuildService;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ICatchDataSource;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.IElimReportGenerate;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.IElimReportSave;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaCslRptParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.ReportCalcGroupKey;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.MnsRptGuideHelper;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GenerateDynaCslElimReport4Server
implements IElimReportGenerate,
ICatchDataSource,
IElimReportSave,
IBuildService {
    private ICatchDataSource iCatchDataSource;
    private IElimReportGenerate iGenerate;
    private IElimReportSave iSave;
    private Context ctx;
    private CslReportInfo srcRptInfo;
    private BuildElimRptBookInfo buildInfo;

    public GenerateDynaCslElimReport4Server(Context ctx, CslReportInfo srcRptInfo) {
        this.ctx = ctx;
        this.srcRptInfo = srcRptInfo;
        this.iCatchDataSource = new CatchDynaCslElimRptDataSource();
        this.iGenerate = new DynaCslElimRptGenerate();
        this.iSave = new DynaCslElimReportSaveImp();
        this.initBuildElimRptInfo();
    }

    public GenerateDynaCslElimReport4Server() {
        this.iCatchDataSource = new CatchDynaCslElimRptDataSource();
        this.iGenerate = new DynaCslElimRptGenerate();
        this.iSave = new DynaCslElimReportSaveImp();
    }

    private void initBuildElimRptInfo() {
        this.buildInfo = new BuildElimRptBookInfo();
        this.buildInfo.setCtx(this.ctx);
        this.buildInfo.setSrcCslRptInfo(this.srcRptInfo);
        this.buildInfo.setDyRptSaveUpdateItem4CM(CSLParamUtil.isDyRptSaveUpdateItem4CM(this.ctx));
        boolean isSupportCrossMerger = CSLParamUtil.isSupportCrossMerger(this.ctx, this.srcRptInfo.getOrgTree().getId().toString());
        if (!StringUtils.isEmpty((String)this.buildInfo.getSrcCslRptInfo().getFastMergeSoluId())) {
            try {
                FastMergeSoluInfo soluInfo = FastMergeSoluFactory.getLocalInstance(this.ctx).getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(this.srcRptInfo.getFastMergeSoluId()));
                if (!soluInfo.isIsSupportGroupReport()) {
                    isSupportCrossMerger = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.buildInfo.setSupportCrossMerger(isSupportCrossMerger);
    }

    @Override
    public void build() throws Exception {
        this.catchDataSource(this.buildInfo);
        this.generateElimReportBookStructure(this.buildInfo);
        this.saveElimReport(this.ctx, this.buildInfo.getElimRptInfo(), new HashMap<Object, Object>());
    }

    @Override
    public void generateElimReportBookStructure(BuildElimRptBookInfo buildInfo) throws Exception {
        this.iGenerate.generateElimReportBookStructure(buildInfo);
    }

    @Override
    public void catchDataSource(BuildElimRptBookInfo buildInfo) throws Exception {
        this.convertSrcReportToElimReport(buildInfo);
        this.execCatchDataSource(buildInfo);
    }

    @Override
    public boolean saveElimReport(Context ctx, CslReportInfo elimRptInfo, Map<Object, Object> extMap) throws Exception {
        this.iSave.saveElimReport(ctx, elimRptInfo, extMap);
        return false;
    }

    private void convertSrcReportToElimReport(BuildElimRptBookInfo buildInfo) {
        if (buildInfo.getSrcCslRptInfo() == null) {
            throw new RuntimeException("Source CslReportInfo is Null for Build ElimReport!");
        }
        if (buildInfo.getElimRptInfo() != null) {
            return;
        }
        CslReportInfo srcCslRptInfo = buildInfo.getSrcCslRptInfo();
        CslReportInfo elimRptInfo = (CslReportInfo)srcCslRptInfo.clone();
        elimRptInfo.setId(BOSUuid.create((BOSObjectType)srcCslRptInfo.getBOSType()));
        elimRptInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        elimRptInfo.setSourceType(ElimReportUtils.getElimRptSrcTypeBySrcReportInfo(this.srcRptInfo));
        elimRptInfo.setSourceRpt(null);
        buildInfo.setElimRptInfo(elimRptInfo);
    }

    private void execCatchDataSource(BuildElimRptBookInfo buildInfo) throws Exception {
        if (buildInfo.isSupportCrossMerger()) {
            this.buildParam4SupportCrossMerger(buildInfo);
        } else {
            this.buildParam4NotSupportCrossMerger(buildInfo);
        }
        this.iCatchDataSource.catchDataSource(buildInfo);
    }

    protected void buildParam4SupportCrossMerger(BuildElimRptBookInfo buildInfo) throws Exception {
        CslReportInfo srcCslRptInfo = buildInfo.getSrcCslRptInfo();
        UserObject userObject = srcCslRptInfo.getBook().getUserObject("unitMap2SerialString");
        String mergeSoluId = srcCslRptInfo.getFastMergeSoluId();
        if (userObject != null && StringUtils.isEmpty((String)((String)userObject.getValue()))) {
            DynaCslRptParamInfo paramInfo = new DynaCslRptParamInfo();
            paramInfo.parseStr2UnitMap((String)userObject.getValue());
            buildInfo.setDynaCslRptParamInfo(paramInfo);
        } else if (!StringUtils.isEmpty((String)mergeSoluId)) {
            String dynaCslSoluId = this.getDynaCslSoluId(buildInfo);
            if (!StringUtils.isEmpty((String)dynaCslSoluId)) {
                this.fillDynaCslSolu2BuildInfo(buildInfo, dynaCslSoluId);
            } else {
                this.buildDefaultSolution(buildInfo);
            }
        } else {
            this.buildDefaultSolution(buildInfo);
        }
        buildInfo.getDynaCslRptParamInfo().setReportID(srcCslRptInfo.getId().toString());
    }

    private void buildDefaultSolution(BuildElimRptBookInfo buildInfo) throws Exception {
        if (!this.hasDefaultSolution(buildInfo)) {
            this.loadSysDefaultSolution(buildInfo);
            if (buildInfo.isSupportCrossMerger()) {
                buildInfo.getDynaCslRptParamInfo().setSumMethod(DynaSumMethodEnum.LIST_DETAIL_COMP_NAME);
            }
        }
    }

    private void fillDynaCslSolu2BuildInfo(BuildElimRptBookInfo buildInfo, String dynaCslSoluId) throws Exception {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("solutionType"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("entityViewInfo"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.appendFilterItem("id", (Object)dynaCslSoluId);
        entityViewInfo.setFilter(filterInfo);
        QuerySolutionCollection q = QuerySolutionFactory.getLocalInstance((Context)this.ctx).getQuerySolutionCollection(entityViewInfo);
        if (q.get(0) == null || q.get(0).getEntityViewInfo() == null || StringUtils.isEmpty((String)q.get(0).getEntityViewInfo())) {
            this.buildDefaultSolution(buildInfo);
            return;
        }
        if (q != null && q.size() > 0) {
            QuerySolutionInfo solution = q.get(0);
            solution.setQueryObjectName(this.getQueryName());
            solution.setParentUIName(this.getParentUIClassName(buildInfo));
            entityViewInfo = QueryUtils.getInnerFilterInfo((Context)this.ctx, (QuerySolutionInfo)solution);
            FilterItemCollection filterItems = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
            MessagePostManManager msgMng = new MessagePostManManager("fillDynaCslSolu2BuildInfo");
            msgMng.addMessage(new MessagePostMan("rptDate", buildInfo.getSrcCslRptInfo().getEndDate()));
            msgMng.addMessage(new MessagePostMan("userId", ContextUtil.getCurrentUserInfo((Context)buildInfo.getCtx()).getId().toString()));
            DynaCslRptParamInfo dynaCslRptParamInfo = new DynaCslRptParamInfo();
            for (int i = 0; i < filterItems.size(); ++i) {
                FilterItemInfo item = filterItems.get(i);
                if (item.getPropertyName().equalsIgnoreCase("mnsOrgs")) {
                    MnsFillOrgUnitCollection coll = MnsFillOrgUnitCollection.parse(item.getCompareValue().toString());
                    RpcHandleFacadeControllerBean.fetchData((Context)buildInfo.getCtx(), (MessagePostManManager)msgMng, (MnsFillOrgUnitCollection)coll);
                    int arrCount = coll.size();
                    for (int k = 0; k < arrCount; ++k) {
                        FullOrgUnitInfo fullOrgUnitInfo = coll.get(k).getFullOrgUnitInfo();
                        dynaCslRptParamInfo.addCompany(coll.get(k).getOrgTreeInfo(), fullOrgUnitInfo.getId().toString());
                        dynaCslRptParamInfo.addCompanyGroupMap(new ReportCalcGroupKey(coll.get(k)), fullOrgUnitInfo.getId().toString());
                        if (!fullOrgUnitInfo.isIsUnion() && !fullOrgUnitInfo.isIsGrouping()) continue;
                        dynaCslRptParamInfo.addUnion(coll.get(k).getOrgTreeInfo(), fullOrgUnitInfo.getId().toString());
                    }
                }
                Object params = null;
                if (item.getPropertyName().equalsIgnoreCase("sumMethod")) {
                    params = item.getCompareValue();
                    dynaCslRptParamInfo.setSumMethod(DynaSumMethodEnum.getEnum((Integer)params));
                }
                if (item.getPropertyName().equalsIgnoreCase("displayNumber")) {
                    params = item.getCompareValue();
                    dynaCslRptParamInfo.setDisplayNumber((Integer)params);
                }
                if (msgMng.getItem("isShowTotal") != null) {
                    params = item.getCompareValue();
                    dynaCslRptParamInfo.setShowTotal("1".equals(params));
                }
                if (msgMng.getItem("isOnlyList") != null) {
                    params = item.getCompareValue();
                    dynaCslRptParamInfo.setOnlyList("1".equals(params));
                }
                if (msgMng.getItem("isOnlyListCompany") == null) continue;
                params = item.getCompareValue();
                dynaCslRptParamInfo.setOnlyListCompany("1".equals(params));
            }
            buildInfo.setDynaCslRptParamInfo(dynaCslRptParamInfo);
        }
    }

    private String getDynaCslSoluId(BuildElimRptBookInfo buildInfo) throws Exception {
        CslReportInfo srcCslRptInfo = buildInfo.getSrcCslRptInfo();
        StringBuffer sql = new StringBuffer(100);
        sql.append(" select entry.fdynaCalcSolu from T_CSL_FastMergeSolu m \n").append(" join T_CSL_FastMergeOrgUnit entry on m.fid = entry.FFastMergeSoluID \n").append(" join T_ORG_Tree tree on m.FOrgBoundID = tree.fid \n").append(" join T_ORG_BaseUnit unit on unit.fid = entry.FOrgUnitID \n").append(" where m.fid = ? and tree.fnumber = ? and unit.fnumber = ? \n").append(" ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{srcCslRptInfo.getFastMergeSoluId(), srcCslRptInfo.getOrgTree().getNumber(), srcCslRptInfo.getOrgUnit().getNumber()});
        if (rs != null && rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    protected void buildParam4NotSupportCrossMerger(BuildElimRptBookInfo buildInfo) throws Exception {
        MergeModeEnum mergeMode = RptAutoWeaveUtil.getMergeMode(buildInfo.getCtx(), buildInfo.getSrcCslRptInfo().getOrgTree().getId().toString());
        IOrgUnitCommon orgUtil = OrgUnitCommonFactory.getLocalInstance((Context)buildInfo.getCtx());
        OrgUnitCollection coll = MergeModeEnum.DIRECT.equals((Object)mergeMode) ? orgUtil.getUnionDebtAllOrgUnit((OrgUnitInfo)buildInfo.getSrcCslRptInfo().getOrgUnit(), buildInfo.getSrcCslRptInfo().getOrgTree()) : orgUtil.getUnionDebtChildren((OrgUnitInfo)buildInfo.getSrcCslRptInfo().getOrgUnit(), buildInfo.getSrcCslRptInfo().getOrgTree());
        ArrayList<Object> companyList = new ArrayList<Object>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            companyList.add(coll.get(i).getId().toString());
        }
        DynaCslRptParamInfo paramInfo = new DynaCslRptParamInfo();
        paramInfo.setOnlyList(false);
        paramInfo.setOnlyListCompany(false);
        paramInfo.setShowTotal(false);
        buildInfo.setDynaCslRptParamInfo(paramInfo);
        buildInfo.setCompanyList(companyList);
    }

    public boolean hasDefaultSolution(BuildElimRptBookInfo buildInfo) throws BOSException, EASBizException {
        MessagePostManManager msgMng = new MessagePostManManager("hasDefaultMnsGuideSolution");
        msgMng.addMessage(new MessagePostMan("treeId", buildInfo.getSrcCslRptInfo().getOrgTree().getId().toString()));
        msgMng.addMessage(new MessagePostMan("orgUnitId", buildInfo.getSrcCslRptInfo().getOrgUnit().getId().toString()));
        msgMng.addMessage(new MessagePostMan("queryObjectName", this.getQueryName()));
        msgMng.addMessage(new MessagePostMan("parentUIName", this.getParentUIClassName(buildInfo)));
        msgMng.addMessage(new MessagePostMan("rptDate", buildInfo.getSrcCslRptInfo().getReportDate()));
        String currUserID = ContextUtil.getCurrentUserInfo((Context)buildInfo.getCtx()).getId().toString();
        msgMng.addMessage(new MessagePostMan("userId", currUserID));
        msgMng = RpcHandleFacadeFactory.getLocalInstance(buildInfo.getCtx()).getRpcZipData(msgMng);
        if (msgMng.getItem("hasDefaultSolution").getParams().equals(Boolean.FALSE)) {
            return false;
        }
        if (msgMng.getItem("isSystemSolution").getParams().equals(Boolean.FALSE)) {
            DynaCslRptParamInfo dynaCslRptParamInfo = new DynaCslRptParamInfo();
            MnsFillOrgUnitCollection coll = (MnsFillOrgUnitCollection)msgMng.getItem("MnsFillOrgUnitCollection").getParams();
            if (coll == null) {
                return false;
            }
            int arrCount = coll.size();
            for (int i = 0; i < arrCount; ++i) {
                FullOrgUnitInfo fullOrgUnitInfo = coll.get(i).getFullOrgUnitInfo();
                dynaCslRptParamInfo.addCompany(coll.get(i).getOrgTreeInfo(), fullOrgUnitInfo.getId().toString());
                if (!fullOrgUnitInfo.isIsUnion() && !fullOrgUnitInfo.isIsGrouping()) continue;
                dynaCslRptParamInfo.addUnion(coll.get(i).getOrgTreeInfo(), fullOrgUnitInfo.getId().toString());
            }
            Object params = null;
            if (msgMng.getItem("sumMethod") != null) {
                params = msgMng.getItem("sumMethod").getParams();
                dynaCslRptParamInfo.setSumMethod(DynaSumMethodEnum.getEnum((Integer)params));
            }
            if (msgMng.getItem("displayNumber") != null) {
                params = msgMng.getItem("displayNumber").getParams();
                dynaCslRptParamInfo.setDisplayNumber((Integer)params);
            }
            if (msgMng.getItem("isShowTotal") != null) {
                params = msgMng.getItem("isShowTotal").getParams();
                dynaCslRptParamInfo.setShowTotal("1".equals(params));
            }
            if (msgMng.getItem("isOnlyList") != null) {
                params = msgMng.getItem("isOnlyList").getParams();
                dynaCslRptParamInfo.setOnlyList("1".equals(params));
            }
            if (msgMng.getItem("isOnlyListCompany") != null) {
                params = msgMng.getItem("isOnlyListCompany").getParams();
                dynaCslRptParamInfo.setOnlyListCompany("1".equals(params));
            }
            buildInfo.setDynaCslRptParamInfo(dynaCslRptParamInfo);
            return true;
        }
        return false;
    }

    private void loadSysDefaultSolution(BuildElimRptBookInfo buildInfo) throws Exception {
        FullOrgUnitCollection fullOrgUnitCollection = MnsRptGuideHelper.getUnionDebtChildren(buildInfo.getCtx(), buildInfo.getSrcCslRptInfo().getOrgTree().getId().toString(), buildInfo.getSrcCslRptInfo().getOrgUnit().getId().toString());
        if (fullOrgUnitCollection == null || fullOrgUnitCollection.size() == 0) {
            throw new Exception("not found any orgUnit under current tree!");
        }
        int arrCount = fullOrgUnitCollection.size();
        DynaCslRptParamInfo dynaCslRptParamInfo = new DynaCslRptParamInfo();
        OrgTreeInfo orgTree = buildInfo.getSrcCslRptInfo().getOrgTree();
        for (int i = 0; i < arrCount; ++i) {
            FullOrgUnitInfo fullOrgUnitInfo = fullOrgUnitCollection.get(i);
            dynaCslRptParamInfo.addCompany(orgTree, fullOrgUnitInfo.getId().toString());
            if (!fullOrgUnitInfo.isIsUnion() && !fullOrgUnitInfo.isIsGrouping()) continue;
            dynaCslRptParamInfo.addUnion(orgTree, fullOrgUnitInfo.getId().toString());
        }
        buildInfo.setDynaCslRptParamInfo(dynaCslRptParamInfo);
    }

    public String getParentUIClassName(BuildElimRptBookInfo buildInfo) {
        return "com.kingdee.eas.fi.gr.cslrpt.client.MnsRptGuide_" + buildInfo.getSrcCslRptInfo().getOrgTree().getNumber() + "_" + buildInfo.getSrcCslRptInfo().getOrgUnit().getNumber();
    }

    public String getQueryName() {
        return "com.kingdee.eas.fi.gr.cslrpt.HisMnsRptQuery";
    }
}

