/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.excel;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.excel.ExcelClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.excel.ExcelServerManager;
import com.kingdee.eas.fi.gr.cslrpt.excel.handler.ExcelHandlerServer;
import com.kingdee.eas.util.client.EASResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ExcelClient
implements Runnable {
    private static final Logger logger = Logger.getLogger(ExcelClient.class);
    private static String encoding = "UTF-8";
    private static ServerSocket ss = null;

    public ExcelClient() throws IOException {
        if (ss == null) {
            ss = ExcelServerManager.getServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket s = null;
        InputStream is = null;
        OutputStream os = null;
        OutputStreamWriter osw = null;
        RequestInfo requestInfo = null;
        try {
            String openExcel = null;
            String startConn = null;
            String endConn = null;
            String closeExcel = null;
            boolean flag = true;
            while (flag) {
                block14: {
                    try {
                        s = ss.accept();
                        is = s.getInputStream();
                        os = s.getOutputStream();
                        osw = new OutputStreamWriter(os, encoding);
                        requestInfo = this.readRequestInfo(is);
                        String method = requestInfo.getMethod();
                        String sessionId = requestInfo.getSessionId();
                        if ("initSheet".equals(method)) {
                            ExcelServerManager.addExcelClient(sessionId);
                            if (!ExcelServerManager.getExcelClientPool().contains(sessionId)) {
                                if (openExcel == null) {
                                    openExcel = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"953_ExcelClient");
                                }
                                logger.info((Object)(openExcel + sessionId + "]"));
                            }
                        }
                        Object result = "";
                        if (ExcelServerManager.getExcelClientPool().contains(sessionId)) {
                            if (startConn == null) {
                                startConn = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"954_ExcelClient");
                            }
                            logger.info((Object)(startConn + sessionId + "] method:" + method));
                            result = this.callBusinessMethod(requestInfo);
                            if (endConn == null) {
                                endConn = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"955_ExcelClient");
                            }
                            logger.info((Object)(endConn + sessionId + "] method:" + method));
                        }
                        osw.write(result.toString());
                        osw.flush();
                        if (!"clearSession".equals(method)) break block14;
                        ExcelServerManager.removeExcelClient(sessionId);
                        if (closeExcel == null) {
                            closeExcel = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"956_ExcelClient");
                        }
                        logger.info((Object)(closeExcel + sessionId + "]"));
                    }
                    catch (Throwable throwable) {
                        CslRptUtil.closeWriter(osw);
                        CslRptUtil.closeOutputStream(os);
                        CslRptUtil.closeInputStream(is);
                        CslRptUtil.closeSocket(s);
                        throw throwable;
                    }
                }
                CslRptUtil.closeWriter(osw);
                CslRptUtil.closeOutputStream(os);
                CslRptUtil.closeInputStream(is);
                CslRptUtil.closeSocket(s);
            }
            ExcelClientHelper.setStarted(false);
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                CslRptUtil.closeWriter(osw);
                CslRptUtil.closeOutputStream(os);
                CslRptUtil.closeInputStream(is);
                CslRptUtil.closeSocket(s);
                ExcelClientHelper.setStarted(false);
                throw throwable;
            }
            CslRptUtil.closeWriter(osw);
            CslRptUtil.closeOutputStream(os);
            CslRptUtil.closeInputStream(is);
            CslRptUtil.closeSocket(s);
            ExcelClientHelper.setStarted(false);
        }
        CslRptUtil.closeWriter(osw);
        CslRptUtil.closeOutputStream(os);
        CslRptUtil.closeInputStream(is);
        CslRptUtil.closeSocket(s);
        ExcelClientHelper.setStarted(false);
    }

    private Object callBusinessMethod(RequestInfo requestInfo) {
        StringBuffer result = new StringBuffer();
        if (requestInfo == null) {
            return null;
        }
        String method = requestInfo.getMethod();
        String params = requestInfo.getParams();
        try {
            Class<ExcelHandlerServer> clzz = ExcelHandlerServer.class;
            Object instant = clzz.newInstance();
            Method m = clzz.getDeclaredMethod(method, String.class);
            result.append(m.invoke(instant, params));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.append(e);
        }
        return result;
    }

    private RequestInfo readRequestInfo(InputStream is) throws Exception {
        RequestInfo info = new RequestInfo();
        String line = "";
        int lineNumber = 0;
        String url = "";
        String methodType = "";
        String method = "";
        int contentLength = 0;
        String data = "";
        String sessionId = "";
        do {
            line = ExcelClient.readLine(is, 0);
            if (lineNumber == 0) {
                methodType = line.startsWith("POST") ? "POST" : "GET";
            }
            if (line.startsWith("Content-Length")) {
                contentLength = Integer.parseInt(line.split(":")[1].trim());
            }
            if (line.startsWith("POST")) {
                url = line.split(" ")[1];
                method = url.substring(url.indexOf("=") + 1, url.length());
            }
            if (line.startsWith("sessionid") || line.startsWith("sessionId")) {
                sessionId = line.split(":")[1].trim();
            }
            ++lineNumber;
        } while (!line.equals("\r\n"));
        if ("POST".equals(methodType) && contentLength > 0) {
            data = ExcelClient.readLine(is, contentLength);
        }
        info.setContentLength(contentLength);
        info.setMethod(method);
        info.setParams(this.getParamsFromData(data));
        info.setMethodType(methodType);
        info.setUrl(url);
        info.setData(data);
        info.setSessionId(sessionId);
        return info;
    }

    private String getParamsFromData(String data) {
        if (StringUtils.isEmpty((String)data)) {
            return "";
        }
        return data;
    }

    private static String readLine(InputStream is, int contentLenght) throws IOException {
        byte readByte;
        ArrayList<Byte> lineByteList = new ArrayList<Byte>();
        int total = 0;
        if (contentLenght != 0) {
            do {
                readByte = (byte)is.read();
                lineByteList.add(readByte);
            } while (++total < contentLenght);
        } else {
            do {
                readByte = (byte)is.read();
                lineByteList.add(readByte);
            } while (readByte != 10);
        }
        byte[] tmpByteArr = new byte[lineByteList.size()];
        for (int i = 0; i < lineByteList.size(); ++i) {
            tmpByteArr[i] = (Byte)lineByteList.get(i);
        }
        lineByteList.clear();
        return new String(tmpByteArr, encoding);
    }

    public static void main(String[] args) throws Exception {
        String sessionId = "sessionid: 1408501946521".split(":")[1].trim();
        System.out.println(sessionId);
    }

    class RequestInfo {
        private String methodType;
        private String url;
        private String data;
        private int contentLength;
        private String method;
        private String params;
        private String sessionId;

        RequestInfo() {
        }

        public String getMethodType() {
            return this.methodType;
        }

        public void setMethodType(String methodType) {
            this.methodType = methodType;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public int getContentLength() {
            return this.contentLength;
        }

        public void setContentLength(int contentLength) {
            this.contentLength = contentLength;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getParams() {
            return this.params;
        }

        public void setParams(String params) {
            this.params = params;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }
    }
}

