/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.excel.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.excel.json.BOSUuidTypeAdapter;
import com.kingdee.eas.fi.gr.cslrpt.excel.json.BosObjectCollectionTypeAdapter;
import com.kingdee.eas.fi.gr.cslrpt.excel.json.DateTypeAdapter;
import com.kingdee.eas.fi.gr.cslrpt.excel.json.EnumTypeAdapter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class JSONUtils {
    protected static Logger logger = Logger.getLogger(JSONUtils.class);
    protected static final String QUOTES_PREFIX = "${quote_2312415321232}";
    protected static final String LEFT_BRACKETS_PREFIX = "${leftbracket_2312415321232}";
    protected static final String RIGHT_BRACKETS_PREFIX = "${rightbracket_2312415321232}";

    public static String convertObjectToJson(Object object) {
        if (object == null || object.equals("")) {
            return "\"\"";
        }
        Gson gson = JSONUtils.getGson();
        String result = gson.toJson(object);
        if (result == null) {
            return "\"\"";
        }
        result = JSONUtils.processJsonResult(result);
        return result;
    }

    public static String processJsonResult(String result) {
        result = result.replace(QUOTES_PREFIX, "\"");
        result = result.replace("\"${leftbracket_2312415321232}", "{");
        result = result.replace(LEFT_BRACKETS_PREFIX, "{");
        result = result.replace("${rightbracket_2312415321232}\"", "}");
        result = result.replace(RIGHT_BRACKETS_PREFIX, "}");
        return result;
    }

    public static <T> T convertJsonToObject(String json, Class<T> clz) throws BOSException {
        return (T)JSONUtils.getGson().fromJson(json, clz);
    }

    public static HashMap<?, ?> convertJsonToObject(String json) throws BOSException {
        return JSONUtils.convertJsonToObject(json, HashMap.class);
    }

    public static String encodeJson(String json) throws BOSException {
        StringBuilder encodedJson = new StringBuilder();
        for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (c > '\u007f') {
                encodedJson.append("\\u").append(Integer.toHexString(c));
                continue;
            }
            encodedJson.append(c);
        }
        return encodedJson.toString();
    }

    public static Gson getGson() {
        return new GsonBuilder().serializeNulls().serializeSpecialFloatingPointValues().enableComplexMapKeySerialization().registerTypeHierarchyAdapter(Date.class, (Object)new DateTypeAdapter()).registerTypeHierarchyAdapter(Timestamp.class, (Object)new DateTypeAdapter()).registerTypeHierarchyAdapter(BOSUuid.class, (Object)new BOSUuidTypeAdapter()).registerTypeHierarchyAdapter(IObjectCollection.class, (Object)new BosObjectCollectionTypeAdapter()).registerTypeHierarchyAdapter(BizEnumValueDTO.class, (Object)new EnumTypeAdapter()).registerTypeHierarchyAdapter(Enum.class, (Object)new EnumTypeAdapter()).create();
    }
}

