/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.IRptCalculate;
import com.kingdee.eas.fi.rpt.RptMultiCalculateEntry;
import java.util.List;
import java.util.Map;

public abstract class AbstractRptCalculate
implements IRptCalculate {
    protected Context _ctx;
    protected Map _context;
    protected Book book = null;
    protected CslReportInfo cslRptInfo;
    protected CoreUIObject reportProcessUI;
    protected List multiCalculateQueue = null;
    protected int calcType = 0;

    public AbstractRptCalculate(Context ctx) {
        this._ctx = ctx;
    }

    public AbstractRptCalculate(Context ctx, Map context) {
        this._ctx = ctx;
        this._context = context;
    }

    @Override
    public void prepareCalculate() throws EASBizException, BOSException {
        if (this.calcType == 1) {
            for (int i = 0; i < this.book.getSheetCount(); ++i) {
                this.book.getSheet(i).setEnableCalculation(false);
            }
            this.book.getActiveSheet().setEnableCalculation(true);
        } else if (this.calcType == 2) {
            for (int i = 0; i < this.book.getSheetCount(); ++i) {
                if (this.multiCalculateQueue != null && this.multiCalculateQueue.contains(new RptMultiCalculateEntry(this.book.getSheet(i).getID()))) {
                    this.book.getSheet(i).setEnableCalculation(true);
                    continue;
                }
                this.book.getSheet(i).setEnableCalculation(false);
            }
        }
    }

    @Override
    public abstract void calculate() throws EASBizException, BOSException;

    @Override
    public void afterCalculate() {
        for (int i = 0; i < this.book.getSheetCount(); ++i) {
            this.book.getSheet(i).setEnableCalculation(true);
        }
        this.multiCalculateQueue = null;
        this.calcType = 0;
    }

    @Override
    public void setBook(Book book) {
        this.book = book;
    }

    @Override
    public void setCalcType(int calcType) {
        this.calcType = calcType;
    }

    public int getCalcType() {
        return this.calcType;
    }

    @Override
    public void setCslRptInfo(CslReportInfo cslRptInfo) {
        this.cslRptInfo = cslRptInfo;
    }

    public void setReportProcessUI(CoreUIObject reportProcessUI) {
        this.reportProcessUI = reportProcessUI;
    }

    public void setMultiCalculateQueue(List multiCalculateQueue) {
        this.multiCalculateQueue = multiCalculateQueue;
    }
}

