/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.reportcalc;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.MnsFillOrgUnitInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class ReportCalcGroupKey
implements Serializable {
    private OrgTreeInfo orgTree = null;
    private boolean isFromStatutory = true;
    private FastMergeSoluInfo sourceSoluInfo = null;
    private int periodOffset = 0;
    private static String split = "@@";

    public ReportCalcGroupKey(MnsFillOrgUnitInfo mnsOrgUnitInfo) {
        if (mnsOrgUnitInfo != null) {
            this.orgTree = mnsOrgUnitInfo.getOrgTreeInfo();
            this.isFromStatutory = mnsOrgUnitInfo.isFromStatutory();
            this.sourceSoluInfo = mnsOrgUnitInfo.getSourceSoluInfo();
            this.periodOffset = mnsOrgUnitInfo.getPeriodOffset();
        }
    }

    public ReportCalcGroupKey(String orgTreeNumber, String solutId) {
        this.orgTree = new OrgTreeInfo();
        this.orgTree.setNumber(orgTreeNumber);
        if (!StringUtils.isEmpty((String)solutId)) {
            this.sourceSoluInfo = new FastMergeSoluInfo();
            this.sourceSoluInfo.setId(BOSUuid.read((String)solutId));
        }
    }

    public ReportCalcGroupKey(String orgTreeNumber, String solutId, boolean isFromStatutory) {
        this(orgTreeNumber, solutId);
        this.isFromStatutory = isFromStatutory;
    }

    public ReportCalcGroupKey() {
    }

    public OrgTreeInfo getOrgTree() {
        return this.orgTree;
    }

    public void setOrgTree(OrgTreeInfo orgTree) {
        this.orgTree = orgTree;
    }

    public boolean isFromStatutory() {
        return this.isFromStatutory;
    }

    public void setFromStatutory(boolean isFromStatutory) {
        this.isFromStatutory = isFromStatutory;
    }

    public FastMergeSoluInfo getSourceSoluInfo() {
        return this.sourceSoluInfo;
    }

    public void setSourceSoluInfo(FastMergeSoluInfo sourceSoluInfo) {
        this.sourceSoluInfo = sourceSoluInfo;
    }

    public int getPeriodOffset() {
        return this.periodOffset;
    }

    public void setPeriodOffset(int periodOffset) {
        this.periodOffset = periodOffset;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer key = new StringBuffer();
        if (this.orgTree != null && this.orgTree.getId() != null) {
            key.append(this.orgTree.getId().toString()).append(split);
        } else {
            key.append("").append(split);
        }
        if (this.sourceSoluInfo != null && this.sourceSoluInfo.get("id") != null) {
            key.append(this.sourceSoluInfo.get("id").toString()).append(split);
        } else {
            key.append("").append(split);
        }
        key.append(this.isFromStatutory).append(split);
        key.append(this.periodOffset).append(split);
        if (this.orgTree != null && !StringUtils.isEmpty((String)this.orgTree.getNumber()) && this.orgTree.getId() == null) {
            key.append(this.orgTree.getNumber());
        } else {
            key.append("");
        }
        return key.toString();
    }

    public static ReportCalcGroupKey parse2ReportCalcGroupKey(String str) {
        String[] strArray;
        if (!StringUtils.isEmpty((String)str) && (strArray = str.split(split)).length >= 4) {
            OrgTreeInfo orgTree;
            ReportCalcGroupKey reportCalcGroupKey = new ReportCalcGroupKey();
            if (!StringUtils.isEmpty((String)strArray[0])) {
                orgTree = new OrgTreeInfo();
                orgTree.setId(BOSUuid.read((String)strArray[0]));
                reportCalcGroupKey.setOrgTree(orgTree);
            }
            if (!StringUtils.isEmpty((String)strArray[1])) {
                FastMergeSoluInfo soluInfo = new FastMergeSoluInfo();
                soluInfo.setId(BOSUuid.read((String)strArray[1]));
                reportCalcGroupKey.setSourceSoluInfo(soluInfo);
            }
            if (!StringUtils.isEmpty((String)strArray[2])) {
                reportCalcGroupKey.setFromStatutory(Boolean.valueOf(strArray[2]));
            }
            if (!StringUtils.isEmpty((String)strArray[3])) {
                reportCalcGroupKey.setFromStatutory(strArray[2].equalsIgnoreCase("true"));
            }
            if (reportCalcGroupKey.getOrgTree() == null && strArray.length >= 5 && !StringUtils.isEmpty((String)strArray[4])) {
                orgTree = new OrgTreeInfo();
                orgTree.setNumber(strArray[4]);
                reportCalcGroupKey.setOrgTree(orgTree);
            }
            return reportCalcGroupKey;
        }
        return null;
    }

    public boolean equals(Object anObject) {
        if (anObject != null && anObject instanceof ReportCalcGroupKey) {
            return ((ReportCalcGroupKey)anObject).toString().equals(this.toString());
        }
        return false;
    }
}

