/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.upload;

import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.util.client.EASResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ExcelReportInfo
implements Serializable {
    private byte[] data = null;
    private String excelName = null;
    private int DS_TYPE = 4;
    private int DATA_STATE = 0;
    private static final int DS_TYPE_BYTE = 0;
    private static final int DS_TYPE_PATH = 1;
    private static final int DS_TYPE_FILE = 2;
    private static final int DS_TYPE_STREAM = 3;
    private static final int DS_TYPE_NULL = 4;
    private static final int DATA_STATE_UNLOAD = 0;
    private static final int DATA_STATE_LOADED = 1;
    private transient String paramPath = null;
    private transient InputStream paramInStream = null;
    private transient File paramFile = null;

    public String getExcelName() {
        return this.excelName;
    }

    public InputStream getInputStream() throws Exception {
        this.flushByteData();
        ByteArrayInputStream in = new ByteArrayInputStream(this.data);
        return in;
    }

    public ExcelReportInfo(File file) throws IOException {
        this.paramFile = file;
        this.DS_TYPE = 2;
    }

    public ExcelReportInfo(String absPath) throws IOException {
        this.paramPath = absPath;
        this.DS_TYPE = 1;
    }

    public ExcelReportInfo(byte[] bytes, String _excelName) {
        this.excelName = _excelName;
        this.data = bytes;
        this.DS_TYPE = 0;
    }

    public ExcelReportInfo(InputStream in, String _excelName) throws IOException {
        this.paramInStream = in;
        this.excelName = _excelName;
        this.DS_TYPE = 3;
    }

    synchronized void flushByteData() throws Exception {
        if (this.DATA_STATE == 0) {
            switch (this.DS_TYPE) {
                case 0: {
                    break;
                }
                case 1: {
                    this.loadPath(this.paramPath);
                    break;
                }
                case 2: {
                    this.loadFile(this.paramFile);
                    break;
                }
                case 3: {
                    this.loadStream(this.paramInStream);
                    break;
                }
                case 4: {
                    throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"847_ExcelReportInfo"));
                }
            }
        }
        this.DATA_STATE = 1;
    }

    synchronized void deleteData() {
        this.DATA_STATE = 0;
        this.DS_TYPE = 4;
        this.data = null;
    }

    private void loadBytes(byte[] bytes) {
        this.data = bytes;
    }

    private void loadStream(InputStream in) throws IOException {
        int count;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((count = in.read(buf)) >= 0) {
            out.write(buf, 0, count);
            out.flush();
        }
        this.loadBytes(out.toByteArray());
        if (this.DS_TYPE != 3) {
            in.close();
        }
    }

    private void loadFile(File file) throws FileNotFoundException, IOException {
        this.excelName = file.getName();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.loadStream(in);
        }
        catch (Throwable throwable) {
            CslRptUtil.closeInputStream(in);
            throw throwable;
        }
        CslRptUtil.closeInputStream(in);
    }

    private void loadPath(String path) throws FileNotFoundException, IOException {
        this.loadFile(new File(path));
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        this.flushByteData();
        out.writeInt(this.DS_TYPE);
        out.writeInt(this.DATA_STATE);
        out.writeObject(this.data);
        out.writeObject(this.excelName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.DS_TYPE = in.readInt();
        this.DATA_STATE = in.readInt();
        this.data = (byte[])in.readObject();
        this.excelName = (String)in.readObject();
    }
}

