/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.upload;

import com.kingdee.eas.fi.gr.cslrpt.upload.AllReportsCompletedEvent;
import com.kingdee.eas.fi.gr.cslrpt.upload.InvokeException;
import com.kingdee.eas.fi.gr.cslrpt.upload.OneReportCompletedEvent;
import com.kingdee.eas.fi.gr.cslrpt.upload.UpLoadReportListener;
import com.kingdee.eas.fi.gr.cslrpt.upload.UpLoadResultInfo;
import com.kingdee.eas.fi.gr.cslrpt.upload.UpLoadResultItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.upload.UpLoadResultItemInfoImpl;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class UpLoadResultInfoImpl
extends UpLoadResultInfo {
    private static final Logger logger = Logger.getLogger(UpLoadResultInfoImpl.class);
    static final int ASY_COMPLETED = 0;
    static final int ASY_EXCEPTION = 4;
    static final int ASY_UPING = 1;
    static final int ASY_NULL = 3;
    int jobState = 3;
    private ArrayList items = new ArrayList();
    private Object monitor = new Object();
    public static final int RESULT_COMPLETED = 0;
    public static final int RESULT__EXCEPTION = 4;
    public static final int RESULT__NULL = 0;
    private int resultState = 0;
    private boolean allTashOver = false;
    private ArrayList errors = new ArrayList();
    private ArrayList listeners = new ArrayList();

    @Override
    public InvokeException[] getExceptions() {
        return this.errors.toArray(new InvokeException[this.errors.size()]);
    }

    void addException(InvokeException error) {
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        this.errors.add(error);
    }

    void asyCompleted() {
        this.setJobState(0);
    }

    void asyException() {
        this.setJobState(4);
    }

    void asyUping() {
        this.setJobState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getResultState() {
        UpLoadResultInfoImpl upLoadResultInfoImpl = this;
        synchronized (upLoadResultInfoImpl) {
            return this.resultState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJobState(int state) {
        Object object = this;
        synchronized (object) {
            this.jobState = state;
            if (this.jobState == 0) {
                this.resultState = 0;
            } else if (this.jobState == 4) {
                this.resultState = 4;
            }
        }
        if (this.isAsyCompleted()) {
            object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAsyCompleted() {
        UpLoadResultInfoImpl upLoadResultInfoImpl = this;
        synchronized (upLoadResultInfoImpl) {
            return (this.jobState == 0 || this.jobState == 4) && this.allTashOver;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompleted() {
        while (!this.isAsyCompleted()) {
            try {
                Object object = this.monitor;
                synchronized (object) {
                    this.monitor.wait();
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)"waitForCompleted_InterruptedException", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompleted(long ms) {
        while (!this.isAsyCompleted()) {
            try {
                Object object = this.monitor;
                synchronized (object) {
                    this.monitor.wait(ms);
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)"waitForCompleted(long ms)_InterruptedException", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertItem(UpLoadResultItemInfo info) {
        ArrayList arrayList = this.items;
        synchronized (arrayList) {
            this.items.add(info);
        }
        this.fireOneReportCompletedEvent(info);
    }

    @Override
    public int getUpLoadResultItemCount() {
        return this.items.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpLoadResultItemInfo getUpLoadResultItemInfo(int index) {
        ArrayList arrayList = this.items;
        synchronized (arrayList) {
            return (UpLoadResultItemInfo)this.items.get(index);
        }
    }

    @Override
    public boolean isAllUpLoadResultItemIsSucess() {
        for (int i = 0; i < this.getUpLoadResultItemCount(); ++i) {
            if (((UpLoadResultItemInfoImpl)this.getUpLoadResultItemInfo(i)).getState() == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStateException() {
        return this.getResultState() == 4;
    }

    @Override
    public boolean isStateSucess() {
        return this.getResultState() == 0;
    }

    public void addUpLoadReportListener(UpLoadReportListener listener) {
        this.listeners.add(listener);
    }

    void fireOneReportCompletedEvent(UpLoadResultItemInfo info) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((UpLoadReportListener)this.listeners.get(i)).onOneReportCompleted(new OneReportCompletedEvent(info, this));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireAllReportsCompletedEvent() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((UpLoadReportListener)this.listeners.get(i)).onAllReportsCompleted(new AllReportsCompletedEvent(this));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Object object = this;
        synchronized (object) {
            this.allTashOver = true;
        }
        if (this.isAsyCompleted()) {
            object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.items.size(); ++i) {
            buf.append(((UpLoadResultItemInfoImpl)this.items.get(i)).toString() + "\r\n");
        }
        return buf.toString();
    }
}

