/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CSLIOUtils {
    private static final Logger logger = Logger.getLogger(CSLIOUtils.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        CSLIOUtils.copy(input, output);
        return output.toByteArray();
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        CSLIOUtils.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                CSLIOUtils.forceDelete(file);
                continue;
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            CSLIOUtils.deleteDirectory(file);
        } else {
            if (!file.exists()) {
                throw new FileNotFoundException("File does not exist: " + file);
            }
            if (!file.delete()) {
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    public static String arrayToString(Object[] objArray, String toStringMethod, String operator) {
        Method method = null;
        try {
            method = objArray[0].getClass().getMethod(toStringMethod, new Class[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (objArray != null && objArray.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < objArray.length; ++i) {
                if (method != null) {
                    try {
                        sb.append(method.invoke(objArray[i], new Object[0]) + operator);
                    }
                    catch (IllegalArgumentException e) {
                        logger.error((Object)"method.invoke_IllegalArgumentException", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.error((Object)"method.invoke_IllegalAccessException", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        logger.error((Object)"method.invoke_InvocationTargetException", (Throwable)e);
                    }
                    continue;
                }
                sb.append(objArray[i] + operator);
            }
            if (operator != null && operator.length() > 0) {
                if (sb.indexOf(operator) == 0) {
                    sb.delete(0, operator.length());
                } else if (sb.lastIndexOf(operator) == sb.length() - operator.length()) {
                    sb.delete(sb.length() - operator.length(), sb.length());
                }
            }
            return sb.toString();
        }
        return null;
    }

    public static FileFilter getExcelFileFilter() {
        ExcelFileFilter FileFilter2 = new ExcelFileFilter();
        return FileFilter2;
    }

    public static FileFilter getExcel2007FileFilter() {
        Excel2007FileFilter FileFilter2 = new Excel2007FileFilter();
        return FileFilter2;
    }

    public static FileFilter getXMLFileFilter() {
        XMLFileFilter FileFilter2 = new XMLFileFilter();
        return FileFilter2;
    }

    public static void main(String[] args) {
        String[] st = new String[]{"tesat", "fafdafdaf"};
    }

    static class XMLFileFilter
    extends FileFilter {
        protected static final String POSTFIX = ".xml";
        protected final String description = "XML File";

        XMLFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase(Locale.getDefault()).endsWith(POSTFIX) || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return ".xml(XML File)";
        }
    }

    static class Excel2007FileFilter
    extends FileFilter {
        protected static final String POSTFIX = ".xlsx";
        protected final String description = "Excel 2007 File";

        Excel2007FileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase(Locale.getDefault()).endsWith(POSTFIX) || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return ".xlsx(Excel 2007 File)";
        }
    }

    static class ExcelFileFilter
    extends FileFilter {
        protected static final String POSTFIX = ".xls";
        protected final String description = "Excel 2003 File";

        ExcelFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase(Locale.getDefault()).endsWith(POSTFIX) || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return ".xls(Excel 2003 File)";
        }
    }
}

