/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeUpScheduleInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CipherInputStream;
import com.kingdee.eas.fi.gr.cslrpt.util.CipherOutputStream;
import com.kingdee.eas.fi.gr.cslrpt.util.DNFFile;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class DPFFile {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.util.DPFFile");
    public static final String DNF_PASSWORD = DNFFile.getDNF_PASSWORD();
    public static final String FileExtensionName = "DPF";
    public static final String SPLIT = "-";
    public static final String DNF_ENTRY_PUBLIC = "public.dat";
    private String DNF_ENTRY_TEMPLATE = "template.dat";
    private String DNF_ENTRY_CURRENCY = "currency.dat";
    private String DNF_ENTRY_TIMEDEF = "timedef.dat";
    private List templateCollection = null;
    private List currencyCollection = null;
    private OrgUnitInfo orgUnit = null;
    private WebTimeUpScheduleInfo schedule = null;
    private String timeDef = null;
    private String timeDesc = null;
    private String timePeriod = null;
    private String scheduleType = null;
    private HashMap extEntry = null;
    private ZipFile curFile = null;

    public List getCurrencyCollection() {
        return this.currencyCollection;
    }

    private void setCurrencyCollection(List currencyCollection) {
        this.currencyCollection = currencyCollection;
    }

    public OrgUnitInfo getOrgUnit() {
        return this.orgUnit;
    }

    private void setOrgUnit(OrgUnitInfo orgUnit) {
        this.orgUnit = orgUnit;
    }

    public List getTemplateCollection() {
        return this.templateCollection;
    }

    private void setTemplateCollection(List templateCollection) {
        this.templateCollection = templateCollection;
    }

    public String getTimeDef() {
        return this.timeDef;
    }

    private void setTimeDef(String timeDef) {
        this.timeDef = timeDef;
    }

    public String getTimeDesc() {
        return this.timeDesc;
    }

    private void setTimeDesc(String timeDesc) {
        this.timeDesc = timeDesc;
    }

    public String getTimePeriod() {
        return this.timePeriod;
    }

    private void setTimePeriod(String timePeriod) {
        this.timePeriod = timePeriod;
    }

    public String getScheduleType() {
        return this.scheduleType;
    }

    private void setScheduleType(String scheduleType) {
        this.scheduleType = scheduleType;
    }

    public WebTimeUpScheduleInfo getSchedule() {
        return this.schedule;
    }

    private void setSchedule(WebTimeUpScheduleInfo schedule) {
        this.schedule = schedule;
    }

    public DPFFile(String kdtPath, String password) {
        try {
            this.init(kdtPath, password);
        }
        catch (IOException e) {
            logger.debug((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"763_DNFFile"));
        }
    }

    private ArrayList parseTemplateData(InputStream templateDat) {
        ArrayList<TemplateInfo> result = new ArrayList<TemplateInfo>();
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(templateDat);
        }
        catch (DocumentException e) {
            logger.error((Object)e.getMessage());
        }
        Element root = doc.getRootElement();
        Element foo = null;
        Iterator i = root.elementIterator("row");
        while (i.hasNext()) {
            foo = (Element)i.next();
            TemplateInfo info = new TemplateInfo();
            info.setId(BOSUuid.read((String)foo.elementTextTrim("fid")));
            info.setNumber(foo.elementTextTrim("fnumber"));
            info.setVersionNumber(foo.elementTextTrim("fversionnumber"));
            info.setName(foo.elementTextTrim("fname"));
            info.setDescription(foo.elementTextTrim("fdescription"));
            info.setPeriodType(RptPeriodTypeEnum.getEnum((int)Integer.parseInt(foo.elementTextTrim("fperiodtype"))));
            info.setTemplateType(RptTmpTypeEnum.getEnum((int)Integer.parseInt(foo.elementTextTrim("ftemplatetype"))));
            info.setDynaRptType(DynaEnumRptTypeEnum.getEnum(Integer.parseInt(foo.elementTextTrim("fdynarpttype"))));
            result.add(info);
        }
        return result;
    }

    private ArrayList parseCurrencyData(InputStream templateDat) {
        ArrayList<CurrencyInfo> result = new ArrayList<CurrencyInfo>();
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(templateDat);
        }
        catch (DocumentException e) {
            logger.error((Object)e.getMessage());
        }
        Element root = doc.getRootElement();
        Iterator i = root.elementIterator("row");
        while (i.hasNext()) {
            Element foo = (Element)i.next();
            CurrencyInfo info = new CurrencyInfo();
            info.setId(BOSUuid.read((String)foo.elementTextTrim("fid")));
            info.setNumber(foo.elementTextTrim("fnumber"));
            info.setName(foo.elementTextTrim("fname"));
            result.add(info);
        }
        return result;
    }

    private void parsePublicData(InputStream templateDat) {
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(templateDat);
        }
        catch (DocumentException e) {
            logger.error((Object)e.getMessage());
        }
        Element foo = doc.getRootElement();
        this.schedule = new WebTimeUpScheduleInfo();
        this.schedule.setId(BOSUuid.read((String)foo.elementTextTrim("scheduleid")));
        this.schedule.setNumber(foo.elementTextTrim("schedulenumber"));
        this.schedule.setName(foo.elementTextTrim("schedulename"));
        OrgUnitInfo info = new OrgUnitInfo();
        info.setId(BOSUuid.read((String)foo.elementTextTrim("companyid")));
        info.setNumber(foo.elementTextTrim("companynumber"));
        info.setName(foo.elementTextTrim("companyname"));
        this.setOrgUnit(info);
        this.setTimePeriod(foo.elementTextTrim("timeperiod"));
        this.setTimeDesc(foo.elementTextTrim("timeDesc"));
        this.setScheduleType(foo.elementTextTrim("scheduleType"));
        this.loadEntry(foo);
    }

    private String parseTimeDef(InputStream insTime) {
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(insTime);
        }
        catch (DocumentException e) {
            logger.error((Object)e.getMessage());
        }
        return doc.asXML();
    }

    private void loadEntry(Element foo) {
        this.DNF_ENTRY_TEMPLATE = foo.elementTextTrim("templatefile");
        this.DNF_ENTRY_CURRENCY = foo.elementTextTrim("currencyfile");
        this.DNF_ENTRY_TIMEDEF = foo.elementTextTrim("timedeffile");
    }

    private void saveEntry(Element foo) {
        foo.addElement("templatefile").setText(this.DNF_ENTRY_TEMPLATE);
        foo.addElement("currencyfile").setText(this.DNF_ENTRY_CURRENCY);
        foo.addElement("timedeffile").setText(this.DNF_ENTRY_TIMEDEF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String kdtPath, String password) throws IOException {
        File tempFile;
        boolean isEncrypt;
        block7: {
            isEncrypt = false;
            tempFile = new File(kdtPath);
            if (StringUtils.isEmpty((String)password)) break block7;
            CipherInputStream in = null;
            FileOutputStream out = null;
            FileInputStream fileIn = null;
            try {
                int c;
                fileIn = new FileInputStream(tempFile);
                in = new CipherInputStream(fileIn, password);
                kdtPath = kdtPath + System.currentTimeMillis();
                tempFile = new File(kdtPath);
                out = new FileOutputStream(tempFile);
                while ((c = ((InputStream)in).read()) != -1) {
                    ((OutputStream)out).write(c);
                }
            }
            catch (Throwable throwable) {
                CslRptUtil.close(in);
                CslRptUtil.close(out);
                CslRptUtil.close(fileIn);
                throw throwable;
            }
            CslRptUtil.close(in);
            CslRptUtil.close(out);
            CslRptUtil.close(fileIn);
            isEncrypt = true;
        }
        try {
            this.curFile = new ZipFile(tempFile);
        }
        catch (IOException e) {
            if (isEncrypt) {
                tempFile.delete();
            }
            throw e;
        }
        ZipEntry ze = null;
        ze = this.curFile.getEntry(DNF_ENTRY_PUBLIC);
        this.parsePublicData(this.curFile.getInputStream(ze));
        ze = this.curFile.getEntry(this.DNF_ENTRY_TEMPLATE);
        this.setTemplateCollection(this.parseTemplateData(this.curFile.getInputStream(ze)));
        ze = this.curFile.getEntry(this.DNF_ENTRY_CURRENCY);
        this.setCurrencyCollection(this.parseCurrencyData(this.curFile.getInputStream(ze)));
        ze = this.curFile.getEntry(this.DNF_ENTRY_TIMEDEF);
        this.setTimeDef(this.parseTimeDef(this.curFile.getInputStream(ze)));
        this.curFile.close();
        if (isEncrypt) {
            tempFile.delete();
        }
    }

    public DPFFile(WebTimeUpScheduleInfo schedule, OrgUnitInfo targetCompany, List templates, List currencies) {
        this.setSchedule(schedule);
        this.setTemplateCollection(templates);
        this.setOrgUnit(targetCompany);
        this.setCurrencyCollection(currencies);
        this.setTimeDef(schedule.getTimeDef());
        this.setTimeDesc(schedule.getDescription());
        this.setTimePeriod(String.valueOf(schedule.getTimePeriod().getValue()));
        this.setScheduleType(String.valueOf(schedule.getScheduleType().getValue()));
        this.extEntry = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean export(String path, String password) {
        boolean result;
        block11: {
            result = true;
            HashMap map = this.extEntry;
            if (this.templateCollection != null && this.templateCollection.size() != 0) {
                map.put(this.DNF_ENTRY_TEMPLATE, this.parseTemplateCollection(this.templateCollection));
            }
            if (this.currencyCollection != null && this.currencyCollection.size() != 0) {
                map.put(this.DNF_ENTRY_CURRENCY, this.parseCurrencyCollection(this.currencyCollection));
            }
            if (this.schedule != null) {
                map.put(DNF_ENTRY_PUBLIC, this.parsePublic());
            }
            map.put(this.DNF_ENTRY_TIMEDEF, this.timeDef);
            CipherOutputStream f = null;
            FileOutputStream f1 = null;
            ZipOutputStream out = null;
            try {
                f1 = new FileOutputStream(path);
                if (!StringUtils.isEmpty((String)password)) {
                    f = new CipherOutputStream(f1, password);
                }
                out = new ZipOutputStream(new DataOutputStream(f));
                Set keySet = map.keySet();
                for (String key : keySet) {
                    out.putNextEntry(new ZipEntry(key));
                    Object entry = map.get(key);
                    byte[] data = null;
                    data = entry instanceof byte[] ? (byte[])entry : ((String)entry).getBytes("UTF-8");
                    for (int i = 0; i < data.length; ++i) {
                        byte b = data[i];
                        out.write(b);
                    }
                }
                CslRptUtil.close(out);
            }
            catch (Exception e) {
                result = false;
                logger.error((Object)e.getMessage());
                break block11;
            }
            finally {
                CslRptUtil.close(out);
                CslRptUtil.close(f);
                CslRptUtil.close(f1);
            }
            CslRptUtil.close(f);
            CslRptUtil.close(f1);
        }
        return result;
    }

    private String parseTemplateCollection(List templates) {
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("GBK");
        Element rootElement = document.addElement("template");
        for (int i = 0; i < templates.size(); ++i) {
            TemplateInfo info = (TemplateInfo)templates.get(i);
            Element rowElement = rootElement.addElement("row");
            rowElement.addElement("fid").setText(info.getId().toString());
            rowElement.addElement("fnumber").setText(info.getNumber());
            rowElement.addElement("fversionnumber").setText(info.getVersionNumber());
            rowElement.addElement("fname").setText(info.getName());
            String des = info.getDescription();
            if (des == null) {
                des = "";
            }
            rowElement.addElement("fdescription").setText(des);
            rowElement.addElement("fperiodtype").setText(Integer.toString(info.getPeriodType().getValue()));
            rowElement.addElement("ftemplatetype").setText(Integer.toString(info.getTemplateType().getValue()));
            rowElement.addElement("fdynarpttype").setText(Integer.toString(info.getDynaRptType().getValue()));
        }
        return document.asXML();
    }

    private String parseCurrencyCollection(List currencys) {
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("GBK");
        Element rootElement = document.addElement("currency");
        for (int i = 0; i < currencys.size(); ++i) {
            CurrencyInfo info = (CurrencyInfo)currencys.get(i);
            Element rowElement = rootElement.addElement("row");
            rowElement.addElement("fid").setText(info.getId().toString());
            rowElement.addElement("fnumber").setText(info.getNumber());
            rowElement.addElement("fname").setText(info.getName());
        }
        return document.asXML();
    }

    private String parsePublic() {
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("GBK");
        Element rootElement = document.addElement("public");
        rootElement.addElement("scheduleid").setText(this.schedule.getId().toString());
        rootElement.addElement("schedulenumber").setText(this.schedule.getNumber());
        rootElement.addElement("schedulename").setText(this.schedule.getName());
        rootElement.addElement("companyid").setText(this.orgUnit.getId().toString());
        rootElement.addElement("companynumber").setText(this.orgUnit.getNumber());
        rootElement.addElement("companyname").setText(this.orgUnit.getName());
        rootElement.addElement("timeperiod").setText(this.timePeriod);
        rootElement.addElement("timeDesc").setText(this.timeDesc);
        rootElement.addElement("scheduleType").setText(this.scheduleType);
        this.saveEntry(rootElement);
        return document.asXML();
    }
}

