/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.SelectionAdapter;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyEvent;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import java.awt.Component;
import org.apache.log4j.Logger;

public class KDSpreadPasteValidater {
    private static Logger logger = Logger.getLogger(KDSpreadPasteValidater.class);
    private NotifyEvent event;

    public KDSpreadPasteValidater(NotifyEvent e) {
        this.event = e;
    }

    public void validate() {
        if (this.event == null) {
            return;
        }
        SpreadContext ctx = (SpreadContext)this.event.getSource();
        Book book = ctx.getSpread().getBook();
        Sheet sheet = book.getActiveSheet();
        Range range = sheet.getSelectionRange();
        SelectionAdapter selection = ctx.getSelection();
        try {
            int size = range.size();
            for (int i = 0; i < size; ++i) {
                CellBlock block = range.getBlock(i);
                int row = block.getRow();
                int col = block.getCol();
                int row2 = block.getRow2();
                int col2 = block.getCol2();
                Sheet.ICellsIterator it = sheet.getCellsIterator(row, col, row2, col2, false, false);
                while (it.hasNext()) {
                    boolean b;
                    Cell cell = it.next();
                    String text = cell.getText();
                    MessagedValidate mv = sheet.getValidations().getValidate(cell.getRow(), cell.getCol());
                    if (mv == null || (b = mv == null || mv.isValidated(sheet, text) || mv.isErrorHide())) continue;
                    CellBlock cb = CellBlock.getNewCellBlock((int)cell.getRow(), (int)cell.getCol());
                    selection.changeSelection(cb, 2);
                    String title = mv.getErrorTitle();
                    String msg = mv.getErrorMessage();
                    String style = mv.getErrorStyle();
                    if (MessagedValidate.WARNING_STYLE.equals(style)) {
                        MessageDialog.show((Component)ctx, (Object)(StringUtil.isEmptyString((String)msg) ? MultiLanguageKeys.getLocalText((String)"KEY_MESSAGE_INVALID_VALUE_CONTINUE") : msg), (String)(StringUtil.isEmptyString((String)title) ? FacadeManager.getDefaultMsgTitle() : title), (int)-1, (int)2, (int)1, null);
                        book.getUndoManager().undo();
                        return;
                    }
                    if (MessagedValidate.STOP_STYLE.equals(style)) {
                        MessageDialog.show((Component)ctx, (Object)(StringUtil.isEmptyString((String)msg) ? MultiLanguageKeys.getLocalText((String)"KEY_MESSAGE_INVALID_VALUE_CONTINUE") : msg), (String)(StringUtil.isEmptyString((String)title) ? FacadeManager.getDefaultMsgTitle() : title), (int)-1, (int)0, (int)1, null);
                        book.getUndoManager().undo();
                        return;
                    }
                    MessageDialog.show((Component)ctx, (Object)(StringUtil.isEmptyString((String)msg) ? MultiLanguageKeys.getLocalText((String)"KEY_MESSAGE_INVALID_VALUE_CONTINUE") : msg), (String)(StringUtil.isEmptyString((String)title) ? FacadeManager.getDefaultMsgTitle() : title), (int)-1, (int)3, (int)1, null);
                    book.getUndoManager().undo();
                    return;
                }
            }
        }
        catch (Exception e) {
            this.setRangeValueNull(sheet, range);
            logger.error((Object)"KDSpreadPasteValidater:validate", (Throwable)e);
        }
    }

    private void setRangeValueNull(Sheet sheet, Range range) {
        int size = range.size();
        for (int i = 0; i < size; ++i) {
            CellBlock block = range.getBlock(i);
            int row = block.getRow();
            int col = block.getCol();
            int row2 = block.getRow2();
            int col2 = block.getCol2();
            Sheet.ICellsIterator it = sheet.getCellsIterator(row, col, row2, col2, false, false);
            while (it.hasNext()) {
                Cell cell = it.next();
                cell.setValue(Variant.nullVariant);
            }
        }
    }
}

