/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.eas.fi.gr.cslrpt.WriteFile;
import com.kingdee.util.StringUtils;
import java.util.Stack;

public class LogProvider {
    private boolean _isOpen = true;
    private Stack _st = new Stack();
    private static final String _token = "    ";
    private int _level = 1;

    public LogProvider(String subSys, String mainKey, String subKey) {
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public void startLevel() {
        if (!this.isOpen()) {
            return;
        }
        ++this._level;
    }

    public void endLevel() {
        if (!this.isOpen()) {
            return;
        }
        --this._level;
    }

    public void startRoot() {
        if (!this.isOpen()) {
            return;
        }
        this.writeExt(true);
        this.start("START");
    }

    public void endRoot() {
        if (!this.isOpen()) {
            return;
        }
        this.end("END");
        this.writeExt(true);
    }

    public void startRoot(String content) {
        if (!this.isOpen()) {
            return;
        }
        this.start("START: " + content);
    }

    public void endRoot(String content) {
        if (!this.isOpen()) {
            return;
        }
        this.end("END: " + content);
    }

    public void start() {
        if (!this.isOpen()) {
            return;
        }
        this.writeExt(false);
        this._st.push(String.valueOf(System.currentTimeMillis()));
    }

    public void start(String content) {
        if (!this.isOpen()) {
            return;
        }
        this.writeExt(false);
        if (StringUtils.isEmpty((String)content)) {
            content = "start";
        }
        this._st.push(String.valueOf(System.currentTimeMillis()));
        this.write(content);
    }

    public void end(String content) {
        if (!this.isOpen()) {
            return;
        }
        if (StringUtils.isEmpty((String)content)) {
            content = "end";
        }
        Object obj = this._st.pop();
        long t1 = Long.parseLong((String)obj);
        long t2 = System.currentTimeMillis();
        this.write(content);
        this.write("spend time:" + (t2 - t1));
        this.writeExt(false);
    }

    private void writeExt(boolean isFull) {
        if (!this.isOpen()) {
            return;
        }
        try {
            throw new Exception();
        }
        catch (Throwable e) {
            this.write(e.getStackTrace()[2].getFileName() + _token + "Line: " + e.getStackTrace()[2].getLineNumber());
            if (isFull) {
                this.write(e.getStackTrace()[2].getClassName() + _token + "Method: " + e.getStackTrace()[2].getMethodName());
            }
            return;
        }
    }

    public void write(String content) {
        if (!this.isOpen()) {
            return;
        }
        WriteFile.write(this.getStoken() + content);
    }

    private String getStoken() {
        if (!this.isOpen()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._level; ++i) {
            sb.append(_token);
        }
        return sb.toString();
    }
}

