/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.ClipboardProxy;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyEvent;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyListener;
import com.kingdee.bos.ctrl.excel.impl.action.PasteAction;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.dynamic.util.ExpireManager;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TableBeforeAction
extends ExpireManager
implements NotifyListener {
    private static final Logger logger = Logger.getLogger(TableBeforeAction.class);
    private String Action_Name;
    private IBookProvider bookProvider;
    private boolean isItemEditable;
    private boolean isDynamic;
    private PasteAction pasteAction = null;
    private Map uiContext = null;
    private boolean isAutoFillFormula;
    private boolean isDynaSum = false;
    private boolean isTemplate = false;

    protected TableBeforeAction() {
    }

    public TableBeforeAction(String action_Name, IBookProvider bProvider) {
        this.Action_Name = action_Name;
        this.bookProvider = bProvider;
        this.initStatus();
        try {
            this.isDynaSum = CslRptUtil.getCslParamForDynamicSumRpt(null);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private boolean isCopyOrCutFromExcel() {
        ClipboardProxy clipProxy = ClipboardProxy.getInstance();
        if (clipProxy != null) {
            clipProxy.openClipboard(null);
            byte[] bytes = clipProxy.getClipboardDataByName("KML");
            clipProxy.closeClipboard();
            return bytes == null || bytes.length <= 0;
        }
        return false;
    }

    public void doNotify(NotifyEvent e) {
        SpreadContext ctx = (SpreadContext)e.getSource();
        Book book = ctx.getSpread().getBook();
        boolean isCancel = false;
        Sheet activeSheet = book.getActiveSheet();
        Range range = book.getSelectionRange();
        range.isColBlocks();
        range.isCellBlocks();
        range.isRowBlocks();
        if ("Paste".equals(this.Action_Name)) {
            boolean isCopyOrCutFromExcel;
            if (this.pasteAction == null) {
                this.pasteAction = (PasteAction)ctx.getActionManager().getAction("Paste");
            }
            this.pasteAction.setPasteMode((isCopyOrCutFromExcel = this.isCopyOrCutFromExcel()) ? PasteMode.VALUES : PasteMode.ALL);
            if (isCopyOrCutFromExcel) {
                book.setAutoCalculate(false);
                this.pasteAction.putValue("isCopyOrCutFromExcel", (Object)true);
            } else {
                this.pasteAction.putValue("isCopyOrCutFromExcel", (Object)false);
            }
        } else if ("Copy".equals(this.Action_Name) || "Cut".equals(this.Action_Name)) {
            HashMap basePosition;
            Range selectionRang;
            int num;
            int reportClass;
            if (this.pasteAction == null) {
                this.pasteAction = (PasteAction)ctx.getActionManager().getAction("Paste");
            }
            this.pasteAction.putValue("selectItemFormula", null);
            this.pasteAction.putValue("startPoint", null);
            this.pasteAction.putValue("endPoint", null);
            this.pasteAction.putValue("basePoint", null);
            this.pasteAction.putValue("sheetId", null);
            ReportVariables variables = ReportVariables.loadFromBook((Book)book);
            if (variables != null && ((reportClass = variables.getIntValue("SheetClass", activeSheet.getSheetName(), 1)) == 10 || reportClass == 20) && range != null && (num = (selectionRang = UserObjectHelper.getUnprotectedRange((Range)range)).size()) > 0 && (basePosition = CslRptUtil.getBasePosition(activeSheet)) != null && basePosition.size() > 0) {
                int left = (Integer)basePosition.get("left");
                int top = (Integer)basePosition.get("top");
                Point startPoint = null;
                Point endPoint = null;
                Point basePoint = new Point();
                basePoint.x = left;
                basePoint.y = top;
                Cell cell = null;
                int endRowIndex = -1;
                int endColIndex = -1;
                ArrayList<ItemFormula> selectItemFormula = new ArrayList<ItemFormula>();
                CellBlock block = selectionRang.getBlock(0);
                for (int j = block.getRow(); j <= block.getRow2(); ++j) {
                    for (int k = block.getCol(); k <= block.getCol2(); ++k) {
                        endRowIndex = j;
                        endColIndex = k;
                        cell = activeSheet.getCell(j, k, false);
                        if (startPoint == null) {
                            startPoint = new Point();
                            startPoint.y = endRowIndex;
                            startPoint.x = endColIndex;
                        }
                        if (k != left) continue;
                        ItemFormula item = UserObjectHelper.getItemFormula((Cell)cell);
                        selectItemFormula.add(item);
                    }
                }
                if (endRowIndex != -1 && endColIndex != -1) {
                    endPoint = new Point();
                    endPoint.y = endRowIndex;
                    endPoint.x = endColIndex;
                }
                if (!selectItemFormula.isEmpty()) {
                    this.pasteAction.putValue("selectItemFormula", selectItemFormula);
                }
                if (startPoint != null) {
                    this.pasteAction.putValue("startPoint", startPoint);
                }
                if (endPoint != null) {
                    this.pasteAction.putValue("endPoint", (Object)endPoint);
                }
                this.pasteAction.putValue("basePoint", (Object)basePoint);
                this.pasteAction.putValue("sheetId", (Object)activeSheet.getID().toString());
            }
        }
        if (("Delete_Row".equals(this.Action_Name) || "Delete_Col".equals(this.Action_Name)) && activeSheet.getSheetOption().getProtection(false) != null && activeSheet.getSheetOption().getProtection(false).isProtected()) {
            for (int i = 0; i < range.size(); ++i) {
                CellBlock cb = range.getBlock(i);
                if (cb == null) continue;
                for (int row = cb.getRow(); row <= cb.getRow2(); ++row) {
                    for (int col = cb.getCol(); col <= cb.getCol2(); ++col) {
                        if (!activeSheet.getCellStyle(row, col).isLocked()) continue;
                        return;
                    }
                }
            }
        }
        if (this.isDynamic && ("Delete_Cell".equals(this.Action_Name) || "Delete_Row".equals(this.Action_Name) || "Delete_Col".equals(this.Action_Name) || "CLEAR_CELL_ALL".equals(this.Action_Name))) {
            if (!DynamicTemplateUtility.isContainBasePoint((Book)book, (Range)range, (boolean)true)) {
                e.setCancel(true);
                return;
            }
            if (!DynamicTemplateUtility.beforeDel((Book)book, (Range)range, (boolean)true, (String)this.Action_Name)) {
                e.setCancel(true);
                return;
            }
        }
        if (this.isTemplate && this.isDynamic && ("Delete_Cell".equals(this.Action_Name) || "Delete_Row".equals(this.Action_Name) || "Delete_Col".equals(this.Action_Name) || "CLEAR_CELL_ALL".equals(this.Action_Name)) && !CslRptUIUtil.isCellDeletable(book, range, true)) {
            e.setCancel(true);
            return;
        }
        if (this.isTemplate && this.isDynamic && ("Cut".equals(this.Action_Name) || "Copy".equals(this.Action_Name)) && !CslRptUIUtil.isBasePosition(book, this.Action_Name)) {
            e.setCancel(true);
            return;
        }
        if (this.isDynamic && ("Insert_Cell".equals(this.Action_Name) || "Delete_Cell".equals(this.Action_Name) && range.isCellBlocks() || "Show_InsertPaste_Wizzard".equals(this.Action_Name))) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"58_TableBeforeAction", (Locale)ctx.getLocale());
            MsgBox.showError((String)msg);
            e.setCancel(true);
            return;
        }
        if (this.isTemplate && this.isDynamic && "CLEAR_CELL_ALL".equals(this.Action_Name) && DynamicTemplateUtility.checkTextGradeBeforeClearAll((Sheet)activeSheet, (Range)book.getActiveSheet().getSelectionRange())) {
            MsgBox.showError((String)ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"771_TableBeforeAction", (Locale)ctx.getLocale()));
            e.setCancel(true);
            return;
        }
        if ("Delete_Cell".equals(this.Action_Name) || "Delete_Row".equals(this.Action_Name) || "Delete_Col".equals(this.Action_Name)) {
            if (this.isDynaSum && "Delete_Row".equals(this.Action_Name)) {
                if (this.isTemplate) {
                    Object dynaValueRange = activeSheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
                    Object dynaKeyRange = activeSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
                    if (dynaKeyRange != null) {
                        TableBeforeAction.paintBackColor(activeSheet, (SumcalcRange)dynaKeyRange);
                    }
                    if (dynaValueRange != null) {
                        TableBeforeAction.paintBackColor(activeSheet, (SumcalcRange)dynaValueRange);
                    }
                } else {
                    Object dynaValueRange = activeSheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
                    Object dynaKeyRange = activeSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
                    if (dynaKeyRange != null || dynaValueRange != null) {
                        SumcalcRange dynaSumRange = (SumcalcRange)dynaKeyRange;
                        CslRptUIUtil.DeleteDynaRange(activeSheet, dynaSumRange, (SumcalcRange)dynaValueRange);
                        book.setActiveSheet(activeSheet);
                    }
                }
            }
            if (this.isItemEditable && !this.isAutoFillFormula) {
                return;
            }
            if (this.isItemEditable && this.isAutoFillFormula) {
                if ("Delete_Row".equals(this.Action_Name) || activeSheet.getSelectionRange().isRowBlocks()) {
                    e.setCancel(DynamicTemplateUtility.beforeDeleteRow((Sheet)activeSheet));
                } else if ("Delete_Col".equals(this.Action_Name) || activeSheet.getSelectionRange().isColBlocks()) {
                    e.setCancel(DynamicTemplateUtility.beforeDeleteColumn((Sheet)activeSheet));
                }
                return;
            }
            if (!CslRptUIUtil.isCellDeletable(book, range, true)) {
                e.setCancel(true);
                return;
            }
        } else if ("Paste".equals(this.Action_Name)) {
            if (this.isItemEditable && !this.isAutoFillFormula) {
                return;
            }
            e.setCancel(isCancel);
        } else if ("Insert_Row".equals(this.Action_Name) || "Insert_MultiRow".equals(this.Action_Name) || "Insert_Cell".equals(this.Action_Name) && activeSheet.getSelectionRange().isRowBlocks()) {
            if ("Insert_Row".equals(this.Action_Name) && this.isDynaSum) {
                if (this.isTemplate) {
                    Object dynaValueRange = activeSheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
                    Object dynaKeyRange = activeSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
                    if (dynaKeyRange != null) {
                        TableBeforeAction.paintBackColor(activeSheet, (SumcalcRange)dynaValueRange);
                    }
                    if (dynaValueRange != null) {
                        TableBeforeAction.paintBackColor(activeSheet, (SumcalcRange)dynaValueRange);
                    }
                } else {
                    Object dynaRange = activeSheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
                    Object dynaRangeKey = activeSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
                    if (dynaRangeKey != null && dynaRange != null) {
                        CslRptUIUtil.InsertDynaRange(activeSheet, (SumcalcRange)dynaRangeKey, (SumcalcRange)dynaRange);
                    }
                }
            }
            if (!this.isDynamic) {
                return;
            }
            isCancel = "Insert_MultiRow".equals(this.Action_Name) ? DynamicTemplateUtility.beforeAddMultiRow((Sheet)activeSheet) : DynamicTemplateUtility.beforeAddRow((Sheet)activeSheet);
            e.setCancel(isCancel);
        } else if ("Insert_Col".equals(this.Action_Name) || "Insert_Cell".equals(this.Action_Name) && activeSheet.getSelectionRange().isColBlocks()) {
            if (!this.isDynamic) {
                return;
            }
            isCancel = DynamicTemplateUtility.beforeAddColumn((Sheet)activeSheet);
            e.setCancel(isCancel);
        } else if ("Sheet_Delete".equals(this.Action_Name)) {
            if (!this.isTemplate && !CslRptUIUtil.isCellDeletable(book, activeSheet.getSheetRange(), true)) {
                e.setCancel(true);
            }
        } else if ("Merge".equals(this.Action_Name)) {
            if (!CslRptUIUtil.isCellDeletable(book, activeSheet.getSelectionRange(), true)) {
                e.setCancel(true);
            }
        } else if ("CLEAR_CELL_ALL".equals(this.Action_Name) || "Clear_CellFormulaAndValue".equals(this.Action_Name)) {
            Sheet.ICellsIterator it = book.getRangeCellsIterator(activeSheet.getSelectionRange(), false, true);
            while (it.hasNext()) {
                String c;
                Cell cell = it.next();
                ItemFormula f = (ItemFormula)cell.getUserObjectValue("ITEM");
                if (f == null || StringUtils.isEmpty((String)(c = f.getExt("16")))) continue;
                f.removeExt("16");
                String number = f.getExt("26");
                if (!StringUtils.isEmpty((String)number)) {
                    f.removeExt("26");
                }
                activeSheet.getRange(cell).setUserObject("ITEM", (Object)f);
            }
        }
        book.activeSheet(activeSheet);
    }

    public static void paintBackColor(Sheet curSheet, SumcalcRange newSumRange) {
        if (curSheet == null || newSumRange == null) {
            return;
        }
        for (int i = 0; i < newSumRange.size(); ++i) {
            CellBlock sb = newSumRange.getCellBlock(i);
            for (int iCol = sb.getCol(); iCol <= sb.getCol2(); ++iCol) {
                for (int iRow = sb.getRow(); iRow <= sb.getRow2(); ++iRow) {
                    curSheet.getCell(iRow, iCol, true);
                }
            }
        }
    }

    private void initStatus() {
        IObjectValue data = this.bookProvider.getEditValue();
        if (data instanceof TemplateInfo) {
            TemplateInfo template = (TemplateInfo)data;
            RptTmpTypeEnum templateType = template.getTemplateType();
            if (templateType.equals((Object)RptTmpTypeEnum.SUMREPORT) || templateType.equals((Object)RptTmpTypeEnum.MANUSCRIPT) || templateType.equals((Object)RptTmpTypeEnum.CSLREPORT) || templateType.equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || templateType.equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) || templateType.equals((Object)RptTmpTypeEnum.DYNAMICSUMREPORT) || templateType.equals((Object)RptTmpTypeEnum.DYNAMICCSLREPORT) || templateType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT) || templateType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICSUMREPORT) || templateType.equals((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT) || templateType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLPORT)) {
                this.isItemEditable = true;
            }
            if (templateType.equals((Object)RptTmpTypeEnum.RPTDYNAMICREPORT) || templateType.equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) || templateType.equals((Object)RptTmpTypeEnum.DYNAMICSUMREPORT) || templateType.equals((Object)RptTmpTypeEnum.DYNAMICCSLREPORT) || templateType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT) || templateType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICSUMREPORT) || templateType.equals((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT) || templateType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLPORT)) {
                this.isDynamic = true;
                this.isAutoFillFormula = true;
            }
            this.isTemplate = true;
        } else if (data instanceof ReportInfo || data instanceof CslReportInfo) {
            TemplateInfo template;
            ReportBaseInfo report = (ReportBaseInfo)data;
            RptSrcTypeEnum sourceType = report.getSourceType();
            if (sourceType.equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT) || sourceType.equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || sourceType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || sourceType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT) || sourceType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) || sourceType.equals((Object)RptSrcTypeEnum.DYNACSLELIMREPORT) || sourceType.equals((Object)RptSrcTypeEnum.DYNACSLELIMREPORT_FASTMERGE) || sourceType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) || sourceType.equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) || sourceType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT)) {
                this.isDynamic = true;
            }
            if ((sourceType.equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT) || sourceType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT) || sourceType.equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || sourceType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || sourceType.equals((Object)RptSrcTypeEnum.DYNACSLELIMREPORT) || sourceType.equals((Object)RptSrcTypeEnum.DYNACSLELIMREPORT_FASTMERGE) || sourceType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) || sourceType.equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) || sourceType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT)) && (template = report.getTemplate()) != null && DynaEnumRptTypeEnum.DYNAMIC.equals((Object)template.getDynaRptType())) {
                this.isItemEditable = true;
                this.isAutoFillFormula = true;
            }
            this.isTemplate = false;
        }
    }

    public String getAction_Name() {
        return this.Action_Name;
    }

    public void setAction_Name(String action_Name) {
        this.Action_Name = action_Name;
    }

    public Map getUiContext() {
        return this.uiContext;
    }

    public void setUiContext(Map uiContext) {
        this.uiContext = uiContext;
    }
}

