/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalcUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslRptQuerySoluInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportCalculator;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.IRpcHandleFacade;
import com.kingdee.eas.fi.gr.cslrpt.MnsFillOrgUnitCollection;
import com.kingdee.eas.fi.gr.cslrpt.RpcHandleFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.CslRptCalculate;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaCslRptParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaRptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaRptStyle;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.ReportCalcGroupKey;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.RptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DyRptSaveHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.SumHelper;
import com.kingdee.eas.fi.gr.dynamic.fill.ClearUpBook;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.fast.CSLContextData;
import com.kingdee.eas.fi.gr.fast.FastMergeExecSelector;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.IFastMergeSolu;
import com.kingdee.eas.fi.gr.fast.SolutionExecuteParam;
import com.kingdee.eas.fi.gr.fast.biz.ISoluExecute;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.sqlUtil.SqlResultFillter;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AutoCslRptExecute
implements ISoluExecute {
    private static Logger LOGGER = Logger.getLogger(AutoCslRptExecute.class);
    private CslReportInfo cslRptInfo = null;
    private Context _ctx;
    private SolutionExecuteParam _executeParam;
    private TemplateInfo templateInfo;
    private CslRptQuerySoluInfo querySoluInfo = null;
    private CSLContextData cslContest = null;
    private boolean iscontinue = true;
    private FastMergeSoluInfo soluInfo = null;
    private CoreUIObject reportProcessUI = null;
    private DynaSumMethodEnum defaultDySumMethod;
    private String userId = null;
    private boolean isFromStatutory = false;

    public AutoCslRptExecute(Context ctx, SolutionExecuteParam executeParam, TemplateInfo templateInfo, CslRptQuerySoluInfo querySoluInfo, DynaSumMethodEnum defaultDySumMethod) {
        this._ctx = ctx;
        this._executeParam = executeParam;
        this.templateInfo = templateInfo;
        this.querySoluInfo = querySoluInfo;
        this.defaultDySumMethod = defaultDySumMethod;
        this.soluInfo = executeParam.getSoluInfo();
        this.userId = this._executeParam.getCurUser().getId().toString();
        this.init();
    }

    public AutoCslRptExecute(CoreUIObject reportProcessUI) {
        Object[] dynaSumMethods;
        this.reportProcessUI = reportProcessUI;
        if (this.defaultDySumMethod == null && (dynaSumMethods = CSLParamUtil.getDynaSumMethod(this._ctx)) != null && dynaSumMethods.length > 0 && dynaSumMethods[0] instanceof DynaSumMethodEnum) {
            this.defaultDySumMethod = (DynaSumMethodEnum)((Object)dynaSumMethods[0]);
        }
    }

    public AutoCslRptExecute() {
        Object[] dynaSumMethods;
        if (this.defaultDySumMethod == null && (dynaSumMethods = CSLParamUtil.getDynaSumMethod(this._ctx)) != null && dynaSumMethods.length > 0 && dynaSumMethods[0] instanceof DynaSumMethodEnum) {
            this.defaultDySumMethod = (DynaSumMethodEnum)((Object)dynaSumMethods[0]);
        }
    }

    public AutoCslRptExecute(CoreUIObject reportProcessUI, DynaSumMethodEnum sumMethod) {
        this(reportProcessUI);
        this.defaultDySumMethod = sumMethod;
    }

    private void init() {
        this.cslContest = new CSLContextData(this._executeParam.getDataCollInfo(), this._executeParam.getSoluInfo().getOrgBound(), (OrgUnitInfo)this._executeParam.getCurOrgUnit(), this._executeParam.getReportDate(), this._executeParam.getPeriod(), RptPeriodTypeEnum.getEnum((int)this._executeParam.getPeriodType()), this._executeParam.getYear(), false);
        this.soluInfo = this._executeParam.getSoluInfo();
    }

    private void addNew() throws Exception {
        String rptId = this.verifyCslReport();
        boolean isSupportGroupReport = this._executeParam.getSoluInfo().isIsSupportGroupReport();
        Map map = null;
        if (!StringUtils.isEmpty((String)rptId)) {
            ICslReport iReport = CslReportFactory.getLocalInstance(this._ctx);
            this.cslRptInfo = iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rptId)), RptAutoWeaveUtil.getCslRptSelectors());
            boolean bl = this.iscontinue = this.cslRptInfo.getAuditedStatus() == AuditedStatusEnum.UNAUDITED;
            if (this.iscontinue) {
                FastMergeUtil.requestBizObjIDForUpdate(this._ctx, rptId);
                map = FastMergeUtil.getReportVersion(this._ctx, rptId);
                iReport.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rptId)));
            } else {
                return;
            }
        }
        int year = this.cslContest.getCurRptYear();
        int period = this.cslContest.getCurRptPeriod();
        boolean isMergeByFiscalPeriod = this._executeParam.isMergeByFiscalPeriod();
        PeriodCollection periods = null;
        if (isMergeByFiscalPeriod) {
            periods = FiscalPeriodHelper.getPeriodCollection(this._ctx, this.cslContest.getCurOrgBound());
        }
        Date startDate = FiscalPeriodHelper.getPeriodFirstDate(year, period, this.cslContest.getCurRptPeriodType(), periods, isMergeByFiscalPeriod);
        Date endDate = FiscalPeriodHelper.getPeriodLastDate(periods, year, period, this.cslContest.getCurRptPeriodType(), isMergeByFiscalPeriod);
        try {
            this.templateInfo = TemplateFactory.getLocalInstance((Context)this._ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.templateInfo.getId().toString())), RptAutoWeaveUtil.getTemplateSelectorForWeaveRpt());
            FullOrgUnitInfo comp = new FullOrgUnitInfo();
            comp = this.cslContest.getCurOrgGroup();
            this.cslRptInfo = FastMergeUtil.createCslRpt(this.cslContest, this.templateInfo, this._executeParam.getSoluInfo().getCurrency(), this._executeParam.isSupportOtherDS(), startDate, endDate, this._executeParam.getDescription(), (OrgUnitInfo)comp, isSupportGroupReport);
        }
        catch (Exception e) {
            LOGGER.error((Object)"AutoCslRptExecute.addnew", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        int periodType = this.templateInfo.getPeriodType().getValue();
        int templateType = this.templateInfo.getTemplateType().getValue();
        int reportType = RptAutoWeaveUtil.getReportTypeByTempType(templateType, isSupportGroupReport);
        Boolean isSupportOtherDS = this._executeParam.isSupportOtherDS();
        RptAutoWeaveUtil rptAutoWeaveUtil = new RptAutoWeaveUtil();
        String fastMergeSoluId = null;
        if (this._executeParam.getSoluInfo().getId() != null) {
            fastMergeSoluId = this._executeParam.getSoluInfo().getId().toString();
        }
        SumRptAddedPerportyInfo addedPerporty = rptAutoWeaveUtil.getSumRptAddedPerporty(this._ctx, this.templateInfo, this._executeParam.getSoluInfo().getCurrency(), this._executeParam.getSoluInfo().getOrgBound(), (OrgUnitInfo)this._executeParam.getCurOrgUnit(), isSupportOtherDS, year, periodType, (short)period, reportType, isSupportGroupReport, fastMergeSoluId);
        this.cslRptInfo.put("addedPerporty", addedPerporty);
        if (map != null && !map.isEmpty()) {
            SumRptAddedPerportyInfo addedPerportyNew = (SumRptAddedPerportyInfo)this.cslRptInfo.get("addedperporty");
            int version = Integer.valueOf(map.get("version").toString());
            String addGroup = String.valueOf(map.get("group"));
            addedPerporty.setVersion(version);
            addedPerporty.setGroup(addGroup);
            this.cslRptInfo.put("addedPerporty", addedPerportyNew);
        }
        if (this._executeParam.getDescription() != null) {
            this.cslRptInfo.setDescription(this._executeParam.getDescription());
        }
        this._ctx.put((Object)"UserInfo", (Object)this._executeParam.getCurUser());
        this.cslRptInfo.setCreator(this._executeParam.getCurUser());
        if (fastMergeSoluId != null) {
            this.cslRptInfo.setFastMergeSoluId(fastMergeSoluId);
        }
        this.cslRptInfo.setOrgType(OrgType.getEnum((int)this._executeParam.getSoluInfo().getOrgBound().getLayerType().getValue()));
        IObjectPK pk = CslReportFactory.getLocalInstance(this._ctx).submit((CoreBaseInfo)this.cslRptInfo);
        this.cslRptInfo.setId(BOSUuid.read((String)pk.toString()));
    }

    private String verifyCslReport() throws BOSException {
        String treeID = this.cslContest.getCurOrgBound().getId().toString();
        String companyID = this.cslContest.getCurOrgGroup().getId().toString();
        String currencyID = this._executeParam.getSoluInfo().getCurrency().getId().toString();
        int templateType = this.templateInfo.getTemplateType().getValue();
        boolean isSupportGroupReport = this._executeParam.getSoluInfo().isIsSupportGroupReport();
        String fastMergeSoluId = null;
        int reportType = RptAutoWeaveUtil.getReportTypeByTempType(templateType, isSupportGroupReport);
        if (!isSupportGroupReport) {
            fastMergeSoluId = this._executeParam.getSoluInfo().getId().toString();
        }
        return FastMergeUtil.get_ReportByTmpVersionFromFastMerge(this._ctx, treeID, companyID, currencyID, this.templateInfo.getId().toString(), reportType, this.templateInfo.getPeriodType().getValue(), this.cslContest.getCurRptYear(), this.cslContest.getCurRptPeriod(), null, this._executeParam.getDataCollInfo().getNumber(), fastMergeSoluId, isSupportGroupReport);
    }

    public void initForCalAndSave(CslReportInfo cslRptInfo, FastMergeSoluInfo soluInfo, CslRptQuerySoluInfo querySoluInfo, DynaSumMethodEnum defaultDySumMethod, String userId) {
        this.soluInfo = soluInfo;
        this.querySoluInfo = querySoluInfo;
        this.defaultDySumMethod = defaultDySumMethod;
        this.cslRptInfo = cslRptInfo;
        this.userId = userId;
    }

    @Override
    public void execute() throws Exception {
        this.addNew();
        if (this.iscontinue) {
            if (this.cslRptInfo == null) {
                return;
            }
            this.calcAndSave();
            FastMergeUtil.releaseObjIDForUpdate(this._ctx, this.cslRptInfo.getId().toString());
        }
        if (this._executeParam.getCreateRptStrategy() == 2) {
            return;
        }
        if (this.iscontinue) {
            FastMergeUtil.cslrptAduit(this._ctx, this.cslRptInfo);
        }
        if (this.cslRptInfo.getCommittedStatus() == null || this.cslRptInfo.getCommittedStatus() == CommittedStatusEnum.UNCOMMITTED) {
            FastMergeUtil.cslrptCommit(this._ctx, this.cslRptInfo);
        }
        if (this.cslRptInfo.getCommittedStatus() == CommittedStatusEnum.COMMITTED) {
            FastMergeUtil.cslReceive(this._ctx, this.cslRptInfo);
        }
    }

    private void initParamsFromCslRpt(Context ctx, CslReportInfo cslRptInfo, Book book, FastMergeSoluInfo soluInfo) throws Exception {
        IFastMergeSolu iFastMergeSolu;
        if (cslRptInfo == null) {
            return;
        }
        if (soluInfo == null && cslRptInfo.getFastMergeSoluId() == null) {
            return;
        }
        this._ctx = ctx;
        this.cslRptInfo = cslRptInfo;
        if (soluInfo == null && (soluInfo = (iFastMergeSolu = ctx != null ? FastMergeSoluFactory.getLocalInstance(ctx) : FastMergeSoluFactory.getRemoteInstance()).getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(cslRptInfo.getFastMergeSoluId()), new FastMergeExecSelector().getSelector())) == null) {
            return;
        }
        this.soluInfo = soluInfo;
        if (this.querySoluInfo == null) {
            this.initQuerySoluInfo(ctx, cslRptInfo, soluInfo);
        }
    }

    public void saveRptFromCslRpt(Context ctx, CslReportInfo cslRptInfo, Book book) throws Exception {
        if (cslRptInfo.getSourceType() == RptSrcTypeEnum.DYNAMICCSLREPORT || cslRptInfo.getSourceType() == RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) {
            String userId = ctx == null ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : ctx.getCaller().toString();
            this.initParamsFromCslRpt(ctx, cslRptInfo, book, null);
            if (this.querySoluInfo == null || cslRptInfo == null || this.soluInfo == null) {
                return;
            }
            boolean isSupportCrossMerger = !this.soluInfo.isIsSupportGroupReport() || CSLParamUtil.isSupportCrossMerger(ctx, cslRptInfo.getOrgTree().getId().toString());
            this.saveDynaItemdata(cslRptInfo, isSupportCrossMerger);
        }
    }

    public void calc(Context ctx, CslReportInfo cslRptInfo, Book book, FastMergeSoluInfo soluInfo, String userId, boolean isSingeSheetCal) throws Exception {
        boolean isDynaTypeRpt;
        this.initParamsFromCslRpt(ctx, cslRptInfo, book, soluInfo);
        if (this.querySoluInfo == null || cslRptInfo == null || this.soluInfo == null) {
            return;
        }
        soluInfo = this.soluInfo;
        boolean bl = isDynaTypeRpt = cslRptInfo != null && (RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)cslRptInfo.getSourceType()) || RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE.equals((Object)cslRptInfo.getSourceType()) || RptSrcTypeEnum.DYNACSLELIMREPORT.equals((Object)cslRptInfo.getSourceType()));
        if (!isDynaTypeRpt) {
            int precision = RptCalcHelper.getPrecisionByCry(ctx, soluInfo.getCurrency());
            new CslRptCalcUtil().consolidationRptCalculate(ctx, book, cslRptInfo, precision);
        } else {
            boolean isSupportCrossMerger;
            boolean bl2 = isSupportCrossMerger = !soluInfo.isIsSupportGroupReport() || CSLParamUtil.isSupportCrossMerger(ctx, cslRptInfo.getOrgTree().getId().toString());
            if (isSupportCrossMerger) {
                this.calcCrossMergerDyna(ctx, cslRptInfo, soluInfo, book, isSingeSheetCal);
            } else {
                this.calcNoCrossMergerDyna(ctx, cslRptInfo, book, isSingeSheetCal);
            }
        }
    }

    private void initQuerySoluInfo(Context ctx, CslReportInfo cslRptInfo, FastMergeSoluInfo soluInfo) throws Exception {
        IRpcHandleFacade rpcHand = ctx == null ? RpcHandleFacadeFactory.getRemoteInstance() : RpcHandleFacadeFactory.getLocalInstance(ctx);
        FastMergeOrgUnitInfo fastMergeOrgUnitInfo = this.getFastMergeOrgUnitInfo(soluInfo.getOrgUnits(), cslRptInfo);
        String cslQuerySoluId = null;
        if (fastMergeOrgUnitInfo != null && (cslQuerySoluId = fastMergeOrgUnitInfo.getFixedCalcSolu()) != null) {
            this.querySoluInfo = FastMergeUtil.getCslQuerySoluInfo(ctx, cslQuerySoluId, cslRptInfo.getOrgTree(), cslRptInfo.getReportDate());
        }
        if (this.querySoluInfo == null) {
            if (soluInfo.getOrgBound() != null) {
                soluInfo.getOrgBound().setId(cslRptInfo.getOrgTree().getId());
            }
            this.querySoluInfo = FastMergeUtil.getCslDefaultQuerySoluInfo(soluInfo, rpcHand, cslRptInfo.getOrgUnit().getId().toString(), this.defaultDySumMethod);
        }
    }

    private FastMergeOrgUnitInfo getFastMergeOrgUnitInfo(FastMergeOrgUnitCollection orgUnitColl, CslReportInfo cslRptInfo) {
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            if (!orgUnitColl.get(i).getOrgUnit().getNumber().equals(cslRptInfo.getOrgUnit().getNumber())) continue;
            return orgUnitColl.get(i);
        }
        return null;
    }

    private void calcSqlGetData(Book book, CslReportInfo reportInfo) {
        SqlResultFillter fillter = new SqlResultFillter(this._ctx, book, false, (ReportBaseInfo)reportInfo);
        fillter.fillResult();
    }

    public void calcAndSave() throws Exception {
        Book book = this.cslRptInfo.getBook();
        CslRptUtil.prepareCalculate(this._ctx, this.cslRptInfo, book, true);
        this.calc(this._ctx, this.cslRptInfo, book, this.soluInfo, this.userId, false);
        this.calcSqlGetData(book, this.cslRptInfo);
        book.calc();
        ClearUpBook clearupbook = new ClearUpBook(book, false);
        if (this.cslRptInfo.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) || this.cslRptInfo.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT)) {
            Sheet activeSheet = book.getActiveSheet();
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                clearupbook.removeNullLine(sheet);
                clearupbook.removeZeroDynamicRow(sheet, this.cslRptInfo.getSourceType(), false);
                clearupbook.sortEveryDynamicItemBySheet(sheet);
                sheet.setSelected(false);
            }
            book.setActiveSheet(activeSheet);
        }
        this.cslRptInfo.setBook(book);
        this.saveReport(this.cslRptInfo);
    }

    public void initForCalAndSave(CslReportInfo cslRptInfo, FastMergeSoluInfo soluInfo, CslRptQuerySoluInfo querySoluInfo, DynaSumMethodEnum defaultDySumMethod, String userId, boolean isFromStatutory) {
        this.soluInfo = soluInfo;
        this.querySoluInfo = querySoluInfo;
        this.defaultDySumMethod = defaultDySumMethod;
        this.cslRptInfo = cslRptInfo;
        this.userId = userId;
        this.isFromStatutory = isFromStatutory;
    }

    private void saveReport(CslReportInfo cslRptInfo) throws Exception {
        boolean isDynaTypeRpt;
        (this._ctx == null ? CslReportFactory.getRemoteInstance() : CslReportFactory.getLocalInstance(this._ctx)).submit((CoreBaseInfo)cslRptInfo);
        boolean isSupportCrossMerger = !this.soluInfo.isIsSupportGroupReport() || CSLParamUtil.isSupportCrossMerger(this._ctx, cslRptInfo.getOrgTree().getId().toString());
        boolean bl = isDynaTypeRpt = cslRptInfo != null && (RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)cslRptInfo.getSourceType()) || RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE.equals((Object)cslRptInfo.getSourceType()) || RptSrcTypeEnum.DYNACSLELIMREPORT.equals((Object)cslRptInfo.getSourceType()));
        if (isDynaTypeRpt) {
            this.saveDynaItemdata(cslRptInfo, isSupportCrossMerger);
        }
    }

    private void saveDynaItemdata(CslReportInfo cslRptInfo, boolean isSupportCrossMerger) throws Exception {
        Book book = cslRptInfo.getBook();
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        if (!isSupportCrossMerger) {
            Vector<FullOrgUnitInfo> companys = new Vector<FullOrgUnitInfo>();
            MnsFillOrgUnitCollection orgs = this.querySoluInfo.getOrgUnitCollection();
            for (int i = 0; i < orgs.size(); ++i) {
                companys.add(orgs.get(i).getFullOrgUnitInfo());
            }
            uiContext.put("companyIds", companys);
        } else {
            book.setUserObject("unitMap2SerialString", (Object)this.getDynaParamInfo(cslRptInfo, this.soluInfo).unitMap2SerialString());
        }
        uiContext.put("DynaSumMethod", (Object)this.querySoluInfo.getSumMethod());
        uiContext.put("isSupportCrossMerger", isSupportCrossMerger);
        uiContext.put("onlyList", this.querySoluInfo.isOnlyList());
        uiContext.put("isFromFastMergeSolu", Boolean.TRUE);
        DyRptSaveHelper.saveDyCslRptItemData(this._ctx, cslRptInfo, book, true, false, uiContext);
        if (uiContext.containsKey("errorMsg") && uiContext.get("errorMsg") != null) {
            throw new RptWeaveException(uiContext.get("errorMsg").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcNoCrossMergerDyna(Context ctx, CslReportInfo cslRptInfo, Book book, boolean isSingeSheetCal) throws Exception {
        HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
        HashMap<String, Map> tableValues = new HashMap<String, Map>();
        DynaSumMethodEnum selectedItem = this.querySoluInfo.getSumMethod();
        if (selectedItem == null) {
            return;
        }
        boolean onlyList = this.querySoluInfo.isOnlyList();
        boolean isShowTotal = this.querySoluInfo.isShowTotal();
        boolean isOnlyListCompany = this.querySoluInfo.isOnlyListCompany();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet table = book.getSheet(i);
            if (!table.isEnableCalculation()) continue;
            Map tableMap = SumHelper.scanDynaTable(table, selectedItem, onlyList, isShowTotal, isOnlyListCompany);
            DynamicTemplateUtility.setSheetSumMethod((Sheet)table, (DynaSumMethodEnum)selectedItem);
            if (table == null) continue;
            tables.put(table.getID(), table);
            tableValues.put(table.getID(), tableMap);
        }
        ICSLReportCalculator ie = ctx == null ? CSLReportCalculatorFactory.getRemoteInstance() : CSLReportCalculatorFactory.getLocalInstance(ctx);
        ArrayList<String> companyList = new ArrayList<String>();
        MnsFillOrgUnitCollection orgs = this.querySoluInfo.getOrgUnitCollection();
        for (int i = 0; i < orgs.size(); ++i) {
            companyList.add(String.valueOf(orgs.get(i).getFullOrgUnitInfo().getId()));
        }
        DynaRptStyle dynaRptStyle = new DynaRptStyle(this._ctx, cslRptInfo, book, this.querySoluInfo.getSumMethod() == null ? this.defaultDySumMethod : this.querySoluInfo.getSumMethod(), isSingeSheetCal);
        dynaRptStyle.getDynaRptStyle();
        Map sumResult = ie.calculateDynaSumRpt(String.valueOf(cslRptInfo.getId()), companyList, tableValues, true, false);
        book.getUndoManager().startGroup();
        Object sheet = null;
        try {
            int precision = RptCalcHelper.getPrecisionByCry(this._ctx, cslRptInfo.getCurrency());
            DynaRptCalcHelper.fillDynaData(this._ctx, cslRptInfo, book, tables, tableValues, sumResult, precision, this.querySoluInfo.getDisplayNumber(), selectedItem, isShowTotal, onlyList);
        }
        finally {
            book.getUndoManager().endGroup();
        }
        dynaRptStyle.resetDynaRptStyle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcCrossMergerDyna(Context ctx, CslReportInfo cslRptInfo, FastMergeSoluInfo soluInfo, Book book, boolean isSingeSheetCal) throws Exception {
        boolean isListener = DynaItemListener.getisListener();
        if (isListener) {
            DynaItemListener.setListener((boolean)false);
        }
        try {
            CslRptCalculate cslRptCalc = new CslRptCalculate(ctx);
            cslRptCalc.setReportProcessUI(this.reportProcessUI);
            cslRptCalc.setSupportCrossMerger(true);
            cslRptCalc.setCslRptInfo(cslRptInfo);
            cslRptCalc.setBook(book);
            cslRptCalc.setCalcType(isSingeSheetCal ? 1 : 0);
            cslRptCalc.setDynaCslRptParamInfo(this.getDynaParamInfo(cslRptInfo, soluInfo));
            cslRptCalc.prepareCalculate();
            cslRptCalc.calculate();
        }
        finally {
            DynaItemListener.setListener((boolean)isListener);
        }
    }

    private DynaCslRptParamInfo getDynaParamInfo(CslReportInfo cslRptInfo, FastMergeSoluInfo soluInfo) throws EASBizException, BOSException {
        DynaCslRptParamInfo dynaInfo = new DynaCslRptParamInfo();
        dynaInfo.setReportID(String.valueOf(cslRptInfo.getId()));
        OrgTreeInfo orgTree = null;
        FullOrgUnitInfo orgUnit = null;
        MnsFillOrgUnitCollection needSumUnits = this.querySoluInfo.getOrgUnitCollection();
        for (int i = 0; i < needSumUnits.size(); ++i) {
            orgTree = needSumUnits.get(i).getOrgTreeInfo();
            orgUnit = needSumUnits.get(i).getFullOrgUnitInfo();
            if (!(needSumUnits.get(i).isFromStatutory() || !orgUnit.isIsUnion() && !orgUnit.isIsGrouping() || needSumUnits.get(i).getSourceSoluInfo() != null && needSumUnits.get(i).getSourceSoluInfo().getId() != null)) {
                needSumUnits.get(i).setSourceSoluInfo(soluInfo);
                if (soluInfo.containsKey("issupportgroupreport") && soluInfo.isIsSupportGroupReport()) {
                    needSumUnits.get(i).setFromStatutory(true);
                }
            }
            dynaInfo.addCompanyGroupMap(new ReportCalcGroupKey(needSumUnits.get(i)), String.valueOf(orgUnit.getId()));
            dynaInfo.addCompany(orgTree, String.valueOf(orgUnit.getId()));
            if (!orgUnit.isIsUnion() && !orgUnit.isIsGrouping()) continue;
            dynaInfo.addUnion(orgTree, String.valueOf(orgUnit.getId()));
        }
        dynaInfo.setSumMethod(this.querySoluInfo.getSumMethod());
        dynaInfo.setDisplayNumber(this.querySoluInfo.getDisplayNumber());
        dynaInfo.setOnlyList(this.querySoluInfo.isOnlyList());
        dynaInfo.setOnlyListCompany(this.querySoluInfo.isOnlyListCompany());
        dynaInfo.setShowTotal(this.querySoluInfo.isShowTotal());
        dynaInfo.setFastMegerIn(true);
        if (soluInfo.isIsSupportGroupReport()) {
            dynaInfo.setIncludeUnAuditElim(false);
        } else {
            dynaInfo.setIncludeUnAuditElim(true);
        }
        return dynaInfo;
    }
}

