/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.fast.client.AbstractEliminationForPCEditUI;
import com.kingdee.eas.fi.gr.fast.client.EliminationDynamicForPCEditUI;
import com.kingdee.eas.fi.gr.fast.util.FastUIUtil;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import java.awt.event.ActionEvent;
import java.util.Observable;

public class EliminationForPCEditUI
extends AbstractEliminationForPCEditUI {
    private boolean hasEditPerm = false;
    private boolean hasAuditPerm = false;

    public EliminationForPCEditUI() throws Exception {
        try {
            this.initPermission();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void loadFields() {
        this.loadEliminationFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return this.getEliminationSelectors();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeAliminationFields();
    }

    private void initPermission() throws Exception {
        IPermission permissionIntf = PermissionFactory.getRemoteInstance();
        boolean[] permissions = permissionIntf.hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId()), new String[]{"mcsl_elimination_edit", "mcsl_elimination_audit"});
        if (permissions != null && permissions.length >= 2) {
            this.hasEditPerm = permissions[1];
            this.hasAuditPerm = permissions[0];
        }
    }

    @Override
    protected void initCSLContext() {
        this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
    }

    @Override
    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }

    @Override
    protected String getEliminationDynamicEditUI() {
        return EliminationDynamicForPCEditUI.class.getName();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        FastUIUtil.setCslContext2Server(this.getCSLContext());
        super.actionSubmit_actionPerformed(e);
        FastUIUtil.restoreCslContext2Server();
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    protected IObjectPK getOrgPK(ItemAction action) {
        try {
            return new ObjectUuidPK(MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType(SysContext.getSysContext().getCurrentOrgUnit(), null).getId());
        }
        catch (Exception e) {
            return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.hasEditPerm) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (!this.hasEditPerm) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (!this.hasEditPerm) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
        super.actionAddNew_actionPerformed(e);
    }
}

