/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.MessageHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.UnionVersion2F7;
import com.kingdee.eas.fi.gr.cslrpt.client.util.mutex.MutexLock;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluType;
import com.kingdee.eas.fi.gr.fast.FastMergeTemplateCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeTemplateInfo;
import com.kingdee.eas.fi.gr.fast.FastRptException;
import com.kingdee.eas.fi.gr.fast.IFastMergeSolu;
import com.kingdee.eas.fi.gr.fast.SrcTmpRelateTagTmpInfo;
import com.kingdee.eas.fi.gr.fast.client.AbstractFastMergeEditUI;
import com.kingdee.eas.fi.gr.fast.client.databind.FastMergeUnitTableDataBinder;
import com.kingdee.eas.fi.gr.fast.client.query.FullOrgUnitTableNode;
import com.kingdee.eas.fi.gr.fast.util.CombineValidateException;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.ChooseTemplate;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.KDTableMoveAction;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class FastMergeEditUI
extends AbstractFastMergeEditUI {
    private static final long serialVersionUID = -418681790998596157L;
    private static final Logger logger = CoreUIObject.getLogger(FastMergeEditUI.class);
    private FastMergeSoluInfo old_editData = null;
    private FastMergeUnitTableDataBinder fastMergeUnitTableDataBinder = null;
    private boolean isHasCreatedMergeReport = false;
    private MutexLock editLock;
    private MutexLock immediateRunLock;
    private MutexLock setTimeDispatchCalcLock;

    public FastMergeEditUI() throws Exception {
        if (this.isAutoSum()) {
            this.tblTplUnit.checkParsed(false);
        }
        this.tblTpl.checkParsed(false);
        this.defineBinding();
        this.addOrganUnitFilter();
        this.editLock = new MutexLock("Edit", "ActionEdit", this.getMessageHandler(), FastMergeUtil.getStringRes("scheme.is.modified.cannot.execute"), logger);
        this.immediateRunLock = new MutexLock("ImmediateRun", "ActionImmediateRunLock", this.getMessageHandler(), FastMergeUtil.getStringRes("scheme.is.running.cannot.execute"), logger);
        this.setTimeDispatchCalcLock = new MutexLock("SetTimeDispatch", "ActionSetTimeDispatch", this.getMessageHandler(), FastMergeUtil.getStringRes("scheme.is.scheduled.cannot.execute"), logger);
    }

    public void addOrganUnitFilter() {
        String companyId = null;
        try {
            companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        }
        catch (Exception e) {
            logger.error((Object)"getCurOrgGroup", (Throwable)e);
        }
        EntityViewInfo autoItem_view = new EntityViewInfo();
        FilterInfo autoItem_filter = new FilterInfo();
        autoItem_filter.getFilterItems().add(new FilterItemInfo("schmOrg", (Object)companyId, CompareType.EQUALS));
        autoItem_view.setFilter(autoItem_filter);
        this.kDpSingleDataSolution.setEntityViewInfo(autoItem_view);
        EntityViewInfo adjust_view = new EntityViewInfo();
        FilterInfo adjust_filter = new FilterInfo();
        adjust_filter.getFilterItems().add(new FilterItemInfo("organUnit.id", (Object)companyId, CompareType.EQUALS));
        adjust_view.setFilter(adjust_filter);
        this.kDpAdjustSolution.setEntityViewInfo(adjust_view);
        EntityViewInfo elim_view = new EntityViewInfo();
        FilterInfo elim_filter = new FilterInfo();
        elim_filter.getFilterItems().add(new FilterItemInfo("organUnit.id", (Object)companyId, CompareType.EQUALS));
        elim_view.setFilter(elim_filter);
        this.kDpElimSolution.setEntityViewInfo(elim_view);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.bindAction();
        this.isHasCreatedMergeReport();
        if (this.isSupportGroupReport()) {
            this.kDIsContainUnReceive.setEnabled(false);
            this.kDpSingleDataSolution.setEnabled(false);
        } else {
            this.kdcIsAutoCalcSingleData.setSelected(true);
            this.kDpSingleDataSolution.setEnabled(true);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fastMergeLoadFields();
    }

    public void fastMergeLoadFields() {
        if (this.editData.isIsAutoSum()) {
            this.rbnIsAutoSum.setSelected(true);
            this.rbnIsAutoMerge.setSelected(false);
            this.editData.setIsAutoSum(true);
        } else {
            this.rbnIsAutoSum.setSelected(false);
            this.rbnIsAutoMerge.setSelected(true);
            this.editData.setIsAutoSum(false);
        }
        this.initOrgUnitTbl();
        this.kDpElimSolution.setEnabled(!this.rbnIsAutoSum.isSelected());
        if (this.isSupportGroupReport.isSelected()) {
            this.kdcIsAutoCalcSingleData.setEnabled(false);
            this.kDpSingleDataSolution.setEnabled(false);
        } else {
            this.kDpSingleDataSolution.setEnabled(this.kdcIsAutoCalcSingleData.isSelected());
        }
        if (!this.kdcIsAutoCalcSingleData.isSelected()) {
            this.kDpSingleDataSolution.setValue(null);
        }
        CslClientHelper.initCurrencyToCombox((JComboBox)this.comboCurrency, true, false);
        this.setCurrency();
    }

    private void setCurrency() {
        if (this.editData != null && this.editData.getCurrency() != null) {
            String currencyId = this.editData.getCurrency().getId().toString();
            int count = this.comboCurrency.getItemCount();
            for (int i = 0; i < count; ++i) {
                CurrencyInfo cur = (CurrencyInfo)this.comboCurrency.getItemAt(i);
                if (!currencyId.equals(cur.getId().toString())) continue;
                this.comboCurrency.setSelectedIndex(i);
                break;
            }
        }
    }

    protected void initOrgUnitTbl() {
        if (this.bizOrgBound.getData() != null) {
            OrgTreeInfo orgTree = (OrgTreeInfo)this.bizOrgBound.getData();
            String pk = null;
            if (this.editData != null && this.editData.getId() != null) {
                pk = this.editData.getId().toString();
            }
            FastMergeOrgUnitCollection coll = new FastMergeOrgUnitCollection();
            try {
                String isAutoSum = null;
                isAutoSum = this.editData.isIsAutoSum() ? "isAutoSum" : "isNotAutoSum";
                coll = FastMergeOrgUnitFactory.getRemoteInstance().constructFastMergeUnitColl(orgTree.getId().toString(), pk, isAutoSum);
            }
            catch (EASBizException e) {
                logger.error((Object)"initOrgUnitTbl", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"initOrgUnitTbl", (Throwable)e);
            }
            if (this.fastMergeUnitTableDataBinder == null) {
                this.fastMergeUnitTableDataBinder = new FastMergeUnitTableDataBinder(this.tblTplUnit, (IUIObject)this, this.isAutoSum(), this.isSupportGroupReport());
            }
            this.fastMergeUnitTableDataBinder.setTreeInfo(orgTree);
            this.fastMergeUnitTableDataBinder.setSupportGroupReport(this.isSupportGroupReport.isSelected());
            this.fastMergeUnitTableDataBinder.setIsAutoSum(this.rbnIsAutoSum.isSelected());
            this.fastMergeUnitTableDataBinder.setTableData((IObjectCollection)coll, true);
        }
    }

    private void initOrgUnitTblByFromPk(String fromPk) {
        if (this.bizOrgBound.getData() != null) {
            OrgTreeInfo orgTree = (OrgTreeInfo)this.bizOrgBound.getData();
            FastMergeOrgUnitCollection coll = new FastMergeOrgUnitCollection();
            try {
                String isAutoSum = null;
                isAutoSum = this.editData.isIsAutoSum() ? "isAutoSum" : "isNotAutoSum";
                coll = FastMergeOrgUnitFactory.getRemoteInstance().constructFastMergeUnitColl(orgTree.getId().toString(), fromPk, isAutoSum);
            }
            catch (EASBizException e) {
                logger.error((Object)"initOrgUnitTblByFromPk", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"initOrgUnitTblByFromPk", (Throwable)e);
            }
            if (this.fastMergeUnitTableDataBinder == null) {
                this.fastMergeUnitTableDataBinder = new FastMergeUnitTableDataBinder(this.tblTplUnit, (IUIObject)this, this.isAutoSum(), this.isSupportGroupReport());
            }
            this.fastMergeUnitTableDataBinder.setTreeInfo(orgTree);
            this.fastMergeUnitTableDataBinder.setTableData((IObjectCollection)coll, true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        UnionVersion2F7 f7 = new UnionVersion2F7();
        f7.setTitile(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource.sorgse"));
        this.bizOrgBound.setSelector((KDPromptSelector)f7);
        this.disenableAction();
    }

    private void disenableAction() {
        this.actionSave.setEnabled(false);
        this.actionSave.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.actionRemove.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionFirst.setEnabled(false);
        this.actionFirst.setVisible(false);
        this.actionNext.setEnabled(false);
        this.actionNext.setVisible(false);
        this.actionPre.setEnabled(false);
        this.actionPre.setVisible(false);
        this.actionLast.setEnabled(false);
        this.actionLast.setVisible(false);
        this.actionCancel.setEnabled(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setEnabled(false);
        this.actionCancelCancel.setVisible(false);
    }

    private void defineBinding() {
        this.dataBinder.registerBinding("clientSoluUnit", IObjectCollection.class, (Component)new FastMergeUnitTableDataBinder(this.tblTplUnit, (IUIObject)this, this.isAutoSum(), this.isSupportGroupReport()), "tableData");
    }

    private boolean isAutoSum() {
        return this.rbnIsAutoSum.isSelected();
    }

    private boolean isSupportGroupReport() {
        return this.isSupportGroupReport.isSelected();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.FastMergeStoreFields();
    }

    public void FastMergeStoreFields() {
        this.storeUnitEntries();
        this.editData.setIsAutoSum(this.rbnIsAutoSum.isSelected());
    }

    protected void storeUnitEntries() {
        this.editData.setSyncOldValue(false);
        int size = this.tblTplUnit.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblTplUnit.getRow(i);
            FastMergeOrgUnitInfo entryInfo = (FastMergeOrgUnitInfo)row.getUserObject();
            if (entryInfo == null) continue;
            if (row.getCell("fixedTabSoluName").getValue() instanceof IObjectValue) {
                entryInfo.setFixedCalcSolu(((IObjectValue)row.getCell("fixedTabSoluName").getValue()).getString("id"));
            } else if (row.getCell("fixedTabSoluName").getValue() == null) {
                entryInfo.setFixedCalcSolu(null);
            }
            if (row.getCell("fixedTabExcludeSoluName") != null) {
                if (row.getCell("fixedTabExcludeSoluName").getValue() instanceof IObjectValue) {
                    entryInfo.setFixExcludeCalcSolu(((IObjectValue)row.getCell("fixedTabExcludeSoluName").getValue()).getString("id"));
                } else if (row.getCell("fixedTabExcludeSoluName").getValue() == null) {
                    entryInfo.setFixExcludeCalcSolu(null);
                }
            }
            if (row.getCell("dynaTabSoluName").getValue() instanceof IObjectValue) {
                entryInfo.setDynaCalcSolu(((IObjectValue)row.getCell("dynaTabSoluName").getValue()).getString("id"));
                continue;
            }
            if (row.getCell("dynaTabSoluName").getValue() != null) continue;
            entryInfo.setDynaCalcSolu(null);
        }
    }

    protected MessageHandler getMessageHandler() {
        return new MessageHandler(1);
    }

    private boolean dataIsLocking() throws Exception {
        BOSUuid bosUuid = this.editData.getId();
        if (this.editLock.isLock(bosUuid)) {
            this.editLock.showError();
            return true;
        }
        if (this.setTimeDispatchCalcLock.isLock(bosUuid)) {
            this.setTimeDispatchCalcLock.showError();
            return true;
        }
        if (RptNewUIUtil.hasMutexLock(null, (String)bosUuid.toString())) {
            this.immediateRunLock.showError();
            return true;
        }
        return false;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.isHasCreatedMergeReport();
        this.tblTplUnit.removeRows();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.dataIsLocking()) {
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.saveJobDef();
        super.actionSave_actionPerformed(e);
    }

    protected String getClassAlise() {
        return FastMergeSoluType.fastCsl.getAlias();
    }

    protected void doBeforeSubmit(ActionEvent e) throws Exception {
        super.doBeforeSubmit(e);
        FastMergeTemplateCollection entrys = (FastMergeTemplateCollection)((Object)this.tblTpl.getUserObject());
        for (int i = 0; entrys != null && i < entrys.size(); ++i) {
            entrys.get(i).setSeq(i + 1);
        }
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        super.doAfterSubmit(pk);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.editData.setIsAutoSum(false);
            this.tblTplUnit.removeRows();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    private void saveJobDef() throws Exception {
        try {
            this.checkEditData();
        }
        catch (Exception e1) {
            MessageHandler messageHandler = new MessageHandler(1);
            messageHandler.show(e1.toString());
            SysUtil.abort();
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.selectOrClear(this.tblTplUnit, true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
        this.selectOrClear(this.tblTplUnit, false);
    }

    private void selectOrClear(KDTable adjustTbl, boolean isSelect) {
        block3: {
            int activeRow;
            block2: {
                activeRow = adjustTbl.getSelectManager().getActiveRowIndex();
                if (activeRow >= 0) break block2;
                for (int i = 0; i < adjustTbl.getRowCount(); ++i) {
                    adjustTbl.getCell(i, "choose").setValue((Object)isSelect);
                }
                break block3;
            }
            Object userObject = adjustTbl.getCell(activeRow, "orgUnit").getUserObject();
            adjustTbl.getCell(activeRow, "choose").setValue((Object)isSelect);
            if (userObject == null || !(userObject instanceof FullOrgUnitTableNode) || !((FullOrgUnitTableNode)userObject).getOrgUnit().isIsUnion()) break block3;
            String longNumber = ((FullOrgUnitTableNode)userObject).getLongNumber();
            for (int i = activeRow + 1; i < adjustTbl.getRowCount() && ((FullOrgUnitTableNode)(userObject = adjustTbl.getCell(i, "orgUnit").getUserObject())).getLongNumber().startsWith(longNumber + "!"); ++i) {
                adjustTbl.getCell(i, "choose").setValue((Object)isSelect);
            }
        }
    }

    protected IObjectValue createNewData() {
        FastMergeSoluInfo info = new FastMergeSoluInfo();
        info.setOrganUnit(SysContext.getSysContext().getCurrentFIUnit().castToFullOrgUnitInfo());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FastMergeSoluFactory.getRemoteInstance();
    }

    public void bindAction() {
        this.bizOrgBound.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (FastMergeEditUI.this.isHasCreatedMergeReport) {
                    String showMsg = FastMergeUtil.getStringRes("cannot.change.orgbound.has.created");
                    MsgBox.showInfo((String)showMsg);
                    e.setResult(0);
                    return;
                }
            }
        });
        this.bizOrgBound.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FastMergeEditUI.this.initOrgUnitTbl();
            }
        });
        this.btnAddTpl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                if (FastMergeEditUI.this.bizOrgBound.getData() == null) {
                    String showMsg = FastMergeUtil.getStringRes("62_selectOrgTree");
                    MsgBox.showInfo((String)showMsg);
                    return;
                }
                List tpls = new ChooseTemplate().open((Component)((Object)FastMergeEditUI.this), true, FastMergeEditUI.this.getChooseTemplateEntityView(), FastMergeEditUI.this.btnAddTpl.getText(), FastMergeEditUI.this.getChooseTemplateFilterProceccor(), FastMergeEditUI.this.getChooseTemplateHiddenColumnSetting());
                if (!FastMergeEditUI.this.canEdit() || tpls.isEmpty()) {
                    return;
                }
                TemplateInfo tpl = null;
                FastMergeTemplateInfo tempEntry = null;
                IRow row = null;
                HashSet<String> rowIdSet = new HashSet<String>();
                FastMergeTemplateCollection entrys = (FastMergeTemplateCollection)((Object)FastMergeEditUI.this.tblTpl.getUserObject());
                for (i = 0; entrys != null && i < entrys.size(); ++i) {
                    rowIdSet.add(entrys.get(i).getTemplate().getId().toString());
                }
                if (!FastMergeEditUI.this.isAutoSum()) {
                    tpls = FastMergeEditUI.this.handleMnsTemplate(tpls);
                }
                for (i = 0; i < tpls.size(); ++i) {
                    tpl = (TemplateInfo)tpls.get(i);
                    tempEntry = new FastMergeTemplateInfo();
                    tempEntry.setTemplate(tpl);
                    if (rowIdSet.contains(tpl.getId().toString())) continue;
                    row = FastMergeEditUI.this.tblTpl.addRow();
                    row.setUserObject((Object)tempEntry);
                    BindingUtility.loadDataToTableLine((int)row.getRowIndex(), (IObjectValue)tempEntry, (KDTable)FastMergeEditUI.this.tblTpl, null, (DataComponentMap)FastMergeEditUI.this.getDataBinder().getDataComponentMap());
                    rowIdSet.add(tpl.getId().toString());
                    entrys = (FastMergeTemplateCollection)((Object)FastMergeEditUI.this.tblTpl.getUserObject());
                    entrys.add(tempEntry);
                }
            }
        });
        this.btnDelTpl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FastMergeEditUI.this.canEdit()) {
                    return;
                }
                int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)FastMergeEditUI.this.tblTpl);
                FastMergeTemplateCollection entrys = (FastMergeTemplateCollection)((Object)FastMergeEditUI.this.tblTpl.getUserObject());
                HashSet rowIdSet = (HashSet)FastMergeEditUI.this.tblTpl.getClientProperty((Object)"ROW_ID_SET");
                if (rowIdSet == null) {
                    rowIdSet = new HashSet();
                    FastMergeEditUI.this.tblTpl.putClientProperty((Object)"ROW_ID_SET", rowIdSet);
                }
                FastMergeTemplateInfo entryInfo = null;
                int rowIndex = 0;
                for (int i = selectRowIndexes.length - 1; i >= 0; --i) {
                    rowIndex = selectRowIndexes[i];
                    entryInfo = (FastMergeTemplateInfo)FastMergeEditUI.this.tblTpl.getRow(rowIndex).getUserObject();
                    rowIdSet.remove(entryInfo.getTemplate().getId().toString());
                    entrys.removeObject((IObjectValue)entryInfo);
                    FastMergeEditUI.this.tblTpl.removeRow(rowIndex);
                }
            }
        });
        final KDTableMoveAction rowMoveAction = new KDTableMoveAction(this.tblTpl);
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FastMergeEditUI.this.canEdit()) {
                    return;
                }
                rowMoveAction.moveSelectedRowToPreRow();
            }
        });
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FastMergeEditUI.this.canEdit()) {
                    return;
                }
                rowMoveAction.moveSelectedRowToNextRow();
            }
        });
        this.btnMoveBegin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FastMergeEditUI.this.canEdit()) {
                    return;
                }
                rowMoveAction.moveSelectedRowToHead();
            }
        });
        this.btnMoveEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FastMergeEditUI.this.canEdit()) {
                    return;
                }
                rowMoveAction.moveSelectedRowToTail();
            }
        });
        this.kdcIsAutoCalcSingleData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FastMergeEditUI.this.kDpSingleDataSolution.setEnabled(FastMergeEditUI.this.kdcIsAutoCalcSingleData.isSelected());
                if (!FastMergeEditUI.this.kdcIsAutoCalcSingleData.isSelected()) {
                    FastMergeEditUI.this.kDpSingleDataSolution.setValue(null);
                }
            }
        });
        this.rbnIsAutoSum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FastMergeEditUI.this.initOrgUnitTbl();
                FastMergeEditUI.this.kDpElimSolution.setEnabled(!FastMergeEditUI.this.rbnIsAutoSum.isSelected());
                if (FastMergeEditUI.this.rbnIsAutoSum.isSelected()) {
                    FastMergeEditUI.this.kDpElimSolution.setValue(null);
                    FastMergeEditUI.this.resetUnitEntries();
                    FastMergeEditUI.this.tblTpl.removeRows();
                    FastMergeEditUI.this.tblTpl.refresh();
                }
            }
        });
        this.rbnIsAutoMerge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FastMergeEditUI.this.initOrgUnitTbl();
                FastMergeEditUI.this.resetUnitEntries();
                FastMergeEditUI.this.tblTpl.removeRows();
                FastMergeEditUI.this.tblTpl.refresh();
                FastMergeEditUI.this.kDpElimSolution.setEnabled(FastMergeEditUI.this.rbnIsAutoMerge.isSelected());
            }
        });
        this.tblTplUnit.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                try {
                    FastMergeEditUI.this.tblTplUnit_editValueChanged(e);
                }
                catch (Exception exc) {
                    FastMergeEditUI.this.handUIException(exc);
                }
            }
        });
        this.isSupportGroupReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FastMergeEditUI.this.isHasCreatedMergeReport) {
                    String showMsg = FastMergeUtil.getStringRes("cannot.change.ishascreatedmergereport.has.created");
                    MsgBox.showInfo((String)showMsg);
                    FastMergeEditUI.this.isSupportGroupReport.setSelected(FastMergeEditUI.this.editData.isIsSupportGroupReport());
                } else {
                    if (FastMergeEditUI.this.isSupportGroupReport.isSelected()) {
                        FastMergeEditUI.this.kdcIsAutoCalcSingleData.setEnabled(false);
                        FastMergeEditUI.this.kdcIsAutoCalcSingleData.setSelected(false);
                        FastMergeEditUI.this.kDpSingleDataSolution.setEnabled(false);
                        FastMergeEditUI.this.kDpSingleDataSolution.setValue(null);
                        FastMergeEditUI.this.kDIsContainUnReceive.setEnabled(false);
                        FastMergeEditUI.this.kDIsContainUnReceive.setSelected(false);
                    } else {
                        FastMergeEditUI.this.kdcIsAutoCalcSingleData.setEnabled(true);
                        FastMergeEditUI.this.kDpSingleDataSolution.setEnabled(true);
                        FastMergeEditUI.this.kDIsContainUnReceive.setEnabled(true);
                    }
                    FastMergeEditUI.this.initOrgUnitTbl();
                }
            }
        });
        this.kDIsContainUnReceive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FastMergeEditUI.this.isHasCreatedMergeReport) {
                    String showMsg = FastMergeUtil.getStringRes("cannot.change.ishascreatedmergereport.has.created");
                    MsgBox.showInfo((String)showMsg);
                    FastMergeEditUI.this.kDIsContainUnReceive.setSelected(FastMergeEditUI.this.editData.isIsContainUnRecive());
                }
            }
        });
    }

    private void tblTplUnit_editValueChanged(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int collIndex = e.getColIndex();
        String fieldName = this.tblTplUnit.getColumnKey(collIndex);
        if ("choose".equalsIgnoreCase(fieldName)) {
            if (((Boolean)this.tblTplUnit.getRow(rowIndex).getCell(fieldName).getValue()).booleanValue()) {
                this.tblTplUnit.getCell(rowIndex, collIndex).setValue((Object)false);
            } else {
                this.tblTplUnit.getCell(rowIndex, collIndex).setValue((Object)true);
            }
        }
    }

    private void resetUnitEntries() {
        this.editData.setSyncOldValue(false);
        int size = this.tblTplUnit.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblTplUnit.getRow(i);
            FastMergeOrgUnitInfo entryInfo = (FastMergeOrgUnitInfo)row.getUserObject();
            if (entryInfo == null || !entryInfo.isIsSelected()) continue;
            entryInfo.setFixedCalcSolu(null);
            row.getCell("fixedTabSoluName").setValue(null);
            if (row.getCell("fixedTabExcludeSoluName") != null) {
                entryInfo.setFixExcludeCalcSolu(null);
                row.getCell("fixedTabExcludeSoluName").setValue(null);
            }
            entryInfo.setDynaCalcSolu(null);
            row.getCell("dynaTabSoluName").setValue(null);
        }
    }

    protected EntityViewInfo getChooseTemplateEntityView() {
        FilterInfo filter = new FilterInfo();
        StringBuffer debars = new StringBuffer();
        StringBuffer maskString = new StringBuffer();
        int maskIndex = 0;
        int dynaType = 11;
        if (this.isAutoSum()) {
            filter.getFilterItems().add(new FilterItemInfo("sumType", (Object)1, CompareType.NOTEQUALS));
            maskString.append(" and #" + maskIndex++ + " ");
            debars.append(3);
            dynaType = 11;
        } else {
            dynaType = 13;
            debars.append(5);
        }
        filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)debars.toString(), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)dynaType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dynaRptType", (Object)2, CompareType.EQUALS));
        maskString.append(" (#" + maskIndex++ + " or (#" + maskIndex++ + " and #" + maskIndex++ + "))");
        filter.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)new Integer(1), CompareType.EQUALS));
        maskString.append(" and #" + maskIndex++);
        filter.getFilterItems().add(new FilterItemInfo("isfreezed", (Object)new Integer(0), CompareType.EQUALS));
        maskString.append(" and #" + maskIndex++);
        Set<String> selectIds = this.getSelectTmpIds();
        if (!selectIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.NOTINCLUDE));
            maskString.append(" and #" + maskIndex++);
        }
        filter.setMaskString(maskString.toString());
        OrgTreeInfo orgTree = (OrgTreeInfo)this.bizOrgBound.getData();
        if (orgTree != null && orgTree.getId() != null) {
            String inStr = "select distinct fdispensesrcid from t_csl_templetdispense where forgboundid='" + orgTree.getId().toString() + "'";
            try {
                FilterInfo dispenseFilter = new FilterInfo("id in (" + inStr + ")");
                filter.mergeFilter(dispenseFilter, "and");
            }
            catch (Exception e) {
                logger.error((Object)"filter.mergeFilter error.", (Throwable)e);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        selector.add("number0");
        selector.add("templateType");
        selector.add("periodType");
        view.setSelector(selector);
        logger.debug((Object)("[Weave]view:" + view));
        return view;
    }

    private Set<String> getSelectTmpIds() {
        HashSet<String> tmpIds = new HashSet<String>();
        Object id = null;
        for (int i = 0; i < this.tblTpl.getRowCount(); ++i) {
            id = this.tblTpl.getRow(i).getCell("TplId").getValue();
            if (id == null) continue;
            tmpIds.add(id.toString());
        }
        return tmpIds;
    }

    private IProcessor getChooseTemplateFilterProceccor() {
        return new CommonQueryProcessor(){

            public void process() throws Exception {
                String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
                if (fieldProperty.equalsIgnoreCase("templateType")) {
                    KDComboBox cmbxSourceType = (KDComboBox)this.get("CURRENT_EDITOR");
                    for (int i = cmbxSourceType.getItemCount() - 1; i > 0; --i) {
                        RptTmpTypeEnum rptSrcType = (RptTmpTypeEnum)cmbxSourceType.getItemAt(i);
                        if (rptSrcType.getValue() == 6 || rptSrcType.getValue() == 10) continue;
                        cmbxSourceType.removeItemAt(i);
                    }
                } else if (fieldProperty.equalsIgnoreCase("sumType") || fieldProperty.equalsIgnoreCase("orgType")) {
                    // empty if block
                }
            }
        };
    }

    protected Map getChooseTemplateHiddenColumnSetting() {
        HashMap<String, Boolean> hiddenColumns = new HashMap<String, Boolean>();
        hiddenColumns.put("sumType", Boolean.TRUE);
        hiddenColumns.put("orgType", Boolean.TRUE);
        hiddenColumns.put("isK3Tpl", Boolean.TRUE);
        hiddenColumns.put("auditedStatus", Boolean.TRUE);
        return hiddenColumns;
    }

    protected boolean canEdit() {
        return !"VIEW".equals(this.getOprtState());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return this.getFastMergeSelectors();
    }

    public SelectorItemCollection getFastMergeSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add("isAutoSum");
        selectors.add("isContainUnRecive");
        selectors.add("dispatchPeriodId");
        selectors.add("isCurrentPeriod");
        selectors.add("templates.id");
        selectors.add("templates.template.id");
        selectors.add("templates.template.number");
        selectors.add("templates.template.name");
        selectors.add("templates.template.periodType");
        selectors.add("templates.template.templateType");
        selectors.add("templates.seq");
        selectors.add("orgUnits.id");
        selectors.add("orgUnits.seq");
        selectors.add("orgUnits.fixedCalcSolu");
        selectors.add("orgUnits.fixExcludeCalcSolu");
        selectors.add("orgUnits.dynaCalcSolu");
        selectors.add("orgUnits.orgUnit.id");
        selectors.add("orgUnits.orgUnit.name");
        selectors.add("orgUnits.orgUnit.number");
        selectors.add("current.id");
        selectors.add("current.name");
        selectors.add("current.number");
        return selectors;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        try {
            this.checkEditData();
        }
        catch (Exception e1) {
            MessageHandler messageHandler = new MessageHandler(1);
            messageHandler.show(e1.toString());
            SysUtil.abort();
        }
    }

    public void checkEditData() throws Exception {
        FastMergeTemplateCollection tpls;
        ArrayList<EASBizException> exceptions = new ArrayList<EASBizException>();
        if (StringUtil.isEmpty((String)this.editData.getNumber())) {
            exceptions.add(new FastRptException(FastRptException.NUMBER_ISBLANK));
        }
        if (StringUtil.isEmpty((String)this.editData.getName())) {
            exceptions.add(new FastRptException(FastRptException.NAME_ISBLANK));
        }
        if (this.kdcIsAutoCalcSingleData.isSelected() && this.editData.getAutoItemFormual() == null) {
            exceptions.add(new FastRptException(FastRptException.AUTOITEM_ISBLANK));
        }
        if (this.editData.getOrgBound() == null) {
            exceptions.add(new FastRptException(FastRptException.ORGBOUND_ISBLANK));
        }
        if (this.editData.getOrgUnits() == null || this.editData.getOrgUnits().size() == 0) {
            exceptions.add(new FastRptException(FastRptException.ORGUNIT_ISBLANK));
        }
        if ((tpls = this.editData.getTemplates()) == null || tpls.isEmpty()) {
            exceptions.add(new FastRptException(FastRptException.TEMPLATE_ISBLANK));
        } else {
            RptPeriodTypeEnum samePeriodType = null;
            try {
                if (!tpls.isEmpty()) {
                    samePeriodType = tpls.get(0).getTemplate().getPeriodType();
                }
                int size = tpls.size();
                for (int i = 1; i < size; ++i) {
                    if (tpls.get(i).getTemplate().getPeriodType() == samePeriodType) continue;
                    exceptions.add(new FastRptException(FastRptException.TMPPERIOD_ISNOTSAME));
                    break;
                }
            }
            catch (NullPointerException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        if (FastMergeUtil.checkNumberDup((IObjectValue)this.editData, true, (ICoreBase)FastMergeSoluFactory.getRemoteInstance())) {
            exceptions.add(new FastRptException(FastRptException.NUMBER_ISDUP));
        }
        if (FastMergeUtil.checkNameDup((IObjectValue)this.editData, true, (ICoreBase)FastMergeSoluFactory.getRemoteInstance())) {
            exceptions.add(new FastRptException(FastRptException.NAME_ISDUP));
        }
        if (!exceptions.isEmpty()) {
            throw new CombineValidateException(exceptions);
        }
    }

    private void checkSelectTemplate() throws Exception {
        String path = "com.kingdee.eas.fi.gr.fast.FastMergeResource";
        FastMergeTemplateCollection templateCol = this.editData.getTemplates();
        FastMergeTemplateInfo fastTemplateInfo = null;
        TemplateInfo templateInfo = null;
        ArrayList<String> templateIds = new ArrayList<String>();
        HashMap<String, Object> templateNumber_Types = new HashMap<String, Object>();
        HashMap<String, TemplateInfo> templateMap = new HashMap<String, TemplateInfo>();
        for (int i = 0; i < templateCol.size(); ++i) {
            fastTemplateInfo = templateCol.get(i);
            if (fastTemplateInfo == null || (templateInfo = fastTemplateInfo.getTemplate()) == null || !RptTmpTypeEnum.CSLREPORT.equals((Object)templateInfo.getTemplateType()) && !RptTmpTypeEnum.MANUSCRIPT.equals((Object)templateInfo.getTemplateType())) continue;
            templateIds.add(String.valueOf(templateInfo.getId()));
            templateNumber_Types.put(templateInfo.getNumber() + templateInfo.getTemplateType().getValue(), null);
            templateMap.put(String.valueOf(templateInfo.getId()), templateInfo);
        }
        FastMergeOrgUnitCollection orgUnitCol = this.editData.getOrgUnits();
        FullOrgUnitInfo orgUnitInfo = null;
        String orgUnitId = null;
        ArrayList<Integer> orgUnitLevels = new ArrayList<Integer>();
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        for (int i = 0; i < orgUnitCol.size(); ++i) {
            orgUnitInfo = orgUnitCol.get(i).getOrgUnit();
            orgUnitId = String.valueOf(orgUnitInfo.getId());
            if (!orgUnitIds.contains(orgUnitId)) {
                orgUnitIds.add(orgUnitId);
            }
            if (orgUnitLevels.contains(orgUnitInfo.getLevel())) continue;
            orgUnitLevels.add(orgUnitInfo.getLevel());
        }
        if (!CslRptUtil.isListEmpty(templateIds)) {
            boolean fag = false;
            for (Integer level : orgUnitLevels) {
                if (!orgUnitLevels.contains(level + 1)) continue;
                fag = true;
                break;
            }
            HashMap<String, ArrayList<String>> orgTrees = new HashMap<String, ArrayList<String>>();
            orgTrees.put(String.valueOf(this.editData.getOrgBound().getId()), orgUnitIds);
            List result = FastMergeSoluFactory.getRemoteInstance().getRelateTemplates(templateIds, orgTrees);
            StringBuffer erroMsg = new StringBuffer();
            erroMsg.append(this.getNotExistTmpErrorStr(result, templateMap, path, fag));
            erroMsg.append(this.getNoSelectTmpErrorStr(result, templateNumber_Types, path));
            templateMap.clear();
            templateNumber_Types.clear();
            result.clear();
            if (erroMsg.length() > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)path, (String)"noSelectRelateTmp"), (String)erroMsg.toString(), (int)1);
                SysUtil.abort();
            }
        }
    }

    private String getNotExistTmpErrorStr(List<SrcTmpRelateTagTmpInfo> result, Map<String, TemplateInfo> templateMap, String path, boolean fag) {
        StringBuffer erroMsg = new StringBuffer();
        boolean isExists = false;
        Iterator<String> ids = templateMap.keySet().iterator();
        String id = null;
        TemplateInfo templateInfo = null;
        HashMap tmpInfoMap = new HashMap();
        for (SrcTmpRelateTagTmpInfo info : result) {
            tmpInfoMap.put(info.getSrcTmpId(), null);
        }
        while (ids.hasNext()) {
            isExists = false;
            id = ids.next();
            if (result != null && tmpInfoMap.containsKey(id)) {
                isExists = true;
            }
            if (isExists) continue;
            templateInfo = templateMap.get(id);
            String resourceName = "noExistsMnsTmp";
            if (templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.MANUSCRIPT)) {
                if (!fag) continue;
                resourceName = "noExistsCslTmp";
            }
            erroMsg.append(MessageFormat.format(EASResource.getString((String)path, (String)resourceName), "[" + templateInfo.getName() + "(" + templateInfo.getNumber() + ")]"));
            erroMsg.append("\n");
        }
        tmpInfoMap.clear();
        return erroMsg.toString();
    }

    private String getNoSelectTmpErrorStr(List<SrcTmpRelateTagTmpInfo> result, Map<String, Object> templateNumber_Types, String path) {
        StringBuffer erroMsg = new StringBuffer();
        if (!CslRptUtil.isListEmpty(result)) {
            SrcTmpRelateTagTmpInfo info = null;
            List<TemplateInfo> tagTmpList = null;
            StringBuffer srcStr = new StringBuffer();
            StringBuffer tagStr = new StringBuffer();
            String resourceStr = "noSelectMnsTmp";
            for (int i = 0; i < result.size(); ++i) {
                info = result.get(i);
                tagTmpList = info.getTagTmpList();
                if (this.isExist(templateNumber_Types, tagTmpList)) continue;
                srcStr.setLength(0);
                tagStr.setLength(0);
                srcStr.append("[").append(info.getSrcTmpName()).append("(").append(info.getSrcTmpNumber()).append(")]");
                for (TemplateInfo tmpInfo : tagTmpList) {
                    tagStr.append(" [").append(tmpInfo.getName()).append("(").append(tmpInfo.getNumber()).append(")] ");
                }
                if (info.getSrcTmpType().equals(String.valueOf(4))) {
                    resourceStr = "noSelectCslTmp";
                }
                erroMsg.append(MessageFormat.format(EASResource.getString((String)path, (String)resourceStr), srcStr.toString(), tagStr.toString()));
                erroMsg.append("\n");
            }
        }
        return erroMsg.toString();
    }

    private boolean isExist(Map<String, Object> templateNumber_Types, List<TemplateInfo> tag) {
        for (int i = 0; i < tag.size(); ++i) {
            if (!templateNumber_Types.containsKey(tag.get(i).getNumber() + tag.get(i).getTemplateType().getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isModify() {
        boolean isModify = false;
        if (this.editData == null || this.getOprtState() == OprtState.VIEW || "FINDVIEW".equals(this.getOprtState())) {
            return isModify;
        }
        if (this.getOprtState() == OprtState.ADDNEW || this.getOprtState() == OprtState.COPYADDNEW) {
            return super.isModify();
        }
        this.storeFields();
        if (this.getOprtState() == OprtState.EDIT) {
            this.initOldEditData();
            isModify = this.compareEditData(this.old_editData, this.editData);
            if (isModify) {
                return isModify;
            }
            isModify = this.compareOrgUnitEntries(this.old_editData.getOrgUnits(), this.editData.getOrgUnits());
            if (isModify) {
                return isModify;
            }
            isModify = this.compareTemplateEntries(this.old_editData.getTemplates(), this.editData.getTemplates());
            if (isModify) {
                return isModify;
            }
        }
        return isModify;
    }

    private void initOldEditData() {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            this.old_editData = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)pk, this.getSelectors());
        }
        catch (Exception err) {
            super.handleException(err);
        }
    }

    public boolean compareEditData(FastMergeSoluInfo old_editData, FastMergeSoluInfo new_editData) {
        if (old_editData == null && new_editData == null) {
            return false;
        }
        if (old_editData != null && new_editData != null) {
            if (!StringUtils.equals((String)old_editData.getName(), (String)new_editData.getName())) {
                return true;
            }
            if (!StringUtils.equals((String)old_editData.getNumber(), (String)new_editData.getNumber())) {
                return true;
            }
            if (!StringUtils.equals((String)old_editData.getCurrency().getId().toString(), (String)new_editData.getCurrency().getId().toString())) {
                return true;
            }
            if (!old_editData.isIsAutoDispatch() == new_editData.isIsAutoDispatch()) {
                return true;
            }
            if (!old_editData.isIsCurrentPeriod() == new_editData.isIsCurrentPeriod()) {
                return true;
            }
            if (!StringUtils.equals((String)old_editData.getDescription(), (String)new_editData.getDescription())) {
                return true;
            }
            if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getOrgBound(), (AbstractObjectValue)new_editData.getOrgBound())) {
                return true;
            }
            if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getAutoItemFormual(), (AbstractObjectValue)new_editData.getAutoItemFormual())) {
                return true;
            }
            if (!old_editData.isIsAutoSum() == new_editData.isIsAutoSum()) {
                return true;
            }
            if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getAdjustEntrySolu(), (AbstractObjectValue)new_editData.getAdjustEntrySolu())) {
                return true;
            }
            if (!old_editData.isIsAutoSum() && !ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getElimEntrySolu(), (AbstractObjectValue)new_editData.getElimEntrySolu())) {
                return true;
            }
            if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getOrgBound(), (AbstractObjectValue)new_editData.getOrgBound())) {
                return true;
            }
        }
        return false;
    }

    private boolean compareOrgUnitEntries(FastMergeOrgUnitCollection old_col, FastMergeOrgUnitCollection new_col) {
        if (old_col == null && new_col == null) {
            return false;
        }
        if (old_col != null && new_col != null) {
            if (old_col.size() != new_col.size()) {
                return true;
            }
            int size = old_col.size();
            for (int i = 0; i < size; ++i) {
                FastMergeOrgUnitInfo oldInfo = old_col.get(i);
                FastMergeOrgUnitInfo newInfo = new_col.get(oldInfo.getId());
                if (!oldInfo.getOrgUnit().getId().equals((Object)newInfo.getOrgUnit().getId())) {
                    return true;
                }
                if (!StringUtil.equals((String)oldInfo.getFixedCalcSolu(), (String)newInfo.getFixedCalcSolu())) {
                    return true;
                }
                if (StringUtil.equals((String)oldInfo.getDynaCalcSolu(), (String)newInfo.getDynaCalcSolu())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean compareTemplateEntries(FastMergeTemplateCollection old_col, FastMergeTemplateCollection new_col) {
        if (old_col == null && new_col == null) {
            return false;
        }
        if (old_col != null && new_col != null) {
            if (old_col.size() != new_col.size()) {
                return true;
            }
            int size = old_col.size();
            for (int i = 0; i < size; ++i) {
                FastMergeTemplateInfo oldInfo = old_col.get(i);
                FastMergeTemplateInfo newInfo = new_col.get(i);
                if (oldInfo.getTemplate().getId().equals((Object)newInfo.getTemplate().getId())) continue;
                return true;
            }
        }
        return false;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        String fromPk = null;
        if (this.editData != null && this.editData.getId() != null) {
            fromPk = this.editData.getId().toString();
        }
        this.getUIContext().put("isCopy", "isCopy");
        super.actionCopy_actionPerformed(e);
        this.editData.setOrganUnit(SysContext.getSysContext().getCurrentFIUnit().castToFullOrgUnitInfo());
        this.getUIContext().remove("isCopy");
        this.initOrgUnitTblByFromPk(fromPk);
        this.isHasCreatedMergeReport();
    }

    public boolean destroyWindow() {
        if (this.getUIContext().get("ObjectUpdateLockId") != null) {
            MutexUtil.releaseMutex(Uuid.fromString((String)((String)this.getUIContext().get("ObjectUpdateLockId"))));
        }
        return super.destroyWindow();
    }

    private void isHasCreatedMergeReport() throws Exception {
        IFastMergeSolu iFastMergeSolu = (IFastMergeSolu)this.getBizInterface();
        if (this.editData == null || this.editData.getId() == null) {
            this.isHasCreatedMergeReport = false;
            return;
        }
        this.isHasCreatedMergeReport = iFastMergeSolu.isHasCreatedMergeReport((IObjectPK)new ObjectUuidPK(this.editData.getId()));
    }

    private List<TemplateInfo> handleMnsTemplate(List<TemplateInfo> cslTemplate) {
        try {
            if (cslTemplate != null && !cslTemplate.isEmpty() && (OrgTreeInfo)this.bizOrgBound.getData() != null) {
                ArrayList<String> cslTemplateIds = new ArrayList<String>();
                ArrayList<TemplateInfo> dyCslTemplateInfos = new ArrayList<TemplateInfo>();
                for (TemplateInfo info : cslTemplate) {
                    if (info.getTemplateType().equals((Object)RptTmpTypeEnum.CSLREPORT)) {
                        cslTemplateIds.add(info.getId().toString());
                        continue;
                    }
                    if (!info.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICCSLREPORT)) continue;
                    dyCslTemplateInfos.add(info);
                }
                if (!cslTemplateIds.isEmpty()) {
                    String orgTreeId = ((OrgTreeInfo)this.bizOrgBound.getData()).getId().toString();
                    HashMap<String, Object> orgTreeMap = new HashMap<String, Object>();
                    orgTreeMap.put(orgTreeId, null);
                    ArrayList<TemplateInfo> allTemplates = FastMergeSoluFactory.getRemoteInstance().getRelateTemplates(cslTemplateIds, orgTreeMap);
                    if (allTemplates != null && !allTemplates.isEmpty()) {
                        allTemplates.addAll(dyCslTemplateInfos);
                        Collections.sort(allTemplates, new Comparator(){

                            public int compare(Object arg0, Object arg1) {
                                TemplateInfo info1 = (TemplateInfo)arg0;
                                TemplateInfo info2 = (TemplateInfo)arg1;
                                return info1.getNumber().compareTo(info2.getNumber());
                            }
                        });
                    } else {
                        allTemplates = dyCslTemplateInfos;
                    }
                    return allTemplates;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"handleMnsTemplate error", (Throwable)e);
            SysUtil.abort();
        }
        return cslTemplate;
    }

    public class AddTplAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

