/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.IUIManager;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.base.uiframe.client.UIWinManager;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MessageHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.NeedRefreshable;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.UIParamForNonCompared;
import com.kingdee.eas.fi.gr.cslrpt.client.util.mutex.MutexLock;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.IFastMergeSolu;
import com.kingdee.eas.fi.gr.fast.client.AbstractFastMergeListUI;
import com.kingdee.eas.fi.gr.fast.client.AdjustProcListUI;
import com.kingdee.eas.fi.gr.fast.client.AutoMergeItemDataUI;
import com.kingdee.eas.fi.gr.fast.client.AutoMergeReportUI;
import com.kingdee.eas.fi.gr.fast.client.EliminationForPCListUI;
import com.kingdee.eas.fi.gr.fast.client.FastMergeSetTimeDispatchUI;
import com.kingdee.eas.fi.gr.fast.client.FastMergeSoluExecGuideUI;
import com.kingdee.eas.fi.gr.fast.client.MergeReportCenterListUI;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Map;
import org.apache.log4j.Logger;

public class FastMergeListUI
extends AbstractFastMergeListUI {
    private static final long serialVersionUID = 1672170644713031311L;
    private static final Logger logger = CoreUIObject.getLogger(FastMergeListUI.class);
    private MutexLock editLock;
    private MutexLock immediateRunLock;
    private MutexLock setTimeDispatchCalcLock;

    public FastMergeListUI() throws Exception {
        this.setBtnIcon();
        this.editLock = new MutexLock("Edit", "ActionEdit", this.getMessageHandler(), FastMergeUtil.getStringRes("scheme.is.modified.cannot.execute"), logger);
        this.immediateRunLock = new MutexLock("ImmediateRun", "ActionImmediateRunLock", this.getMessageHandler(), FastMergeUtil.getStringRes("scheme.is.running.cannot.execute"), logger);
        this.setTimeDispatchCalcLock = new MutexLock("SetTimeDispatch", "ActionSetTimeDispatch", this.getMessageHandler(), FastMergeUtil.getStringRes("scheme.is.scheduled.cannot.execute"), logger);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private boolean dataIsLocking() throws Exception {
        FastMergeSoluInfo fastMergeSoluInfo = this.getFastMergeSoluInfo(-1);
        BOSUuid bosUuid = fastMergeSoluInfo.getId();
        if (this.editLock.isLock(bosUuid)) {
            this.editLock.showError();
            return true;
        }
        if (this.setTimeDispatchCalcLock.isLock(bosUuid)) {
            this.setTimeDispatchCalcLock.showError();
            return true;
        }
        if (RptNewUIUtil.hasMutexLock(null, (String)bosUuid.toString())) {
            this.immediateRunLock.showError();
            return true;
        }
        return false;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.checkIsOpenEditUI(e)) {
            if (this.dataIsLocking()) {
                return;
            }
            FastMergeSoluInfo fastMergeSoluInfo = this.getFastMergeSoluInfo(-1);
            BOSUuid bosUuid = fastMergeSoluInfo.getId();
            Uuid mutexEditUuid = this.editLock.lock(bosUuid);
            if (mutexEditUuid == null) {
                this.editLock.showError();
                return;
            }
            this.setObjectUpdateLockId(mutexEditUuid.toString());
        }
        super.actionEdit_actionPerformed(e);
    }

    private boolean checkIsOpenEditUI(ActionEvent e) throws UIException {
        IUIObject uiObject = null;
        IUIManager uiManager = null;
        IMainUIObject mainUI = null;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        if (SystemEntry.instance.getMainUIObject() == null) {
            if (!"false".equals(uiContext.get((Object)"findModel"))) {
                uiObject = UIWinManager.getInstance().findUIObject(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
            }
        } else {
            mainUI = UIFactoryHelper.getMainUIObject((Map)uiContext);
            uiManager = mainUI.getUiManager();
            if (!"false".equals(uiContext.get((Object)"findModel"))) {
                uiObject = uiManager.findUIObject(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
            }
        }
        return uiObject != null;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.dataIsLocking()) {
            return;
        }
        FastMergeSoluInfo fastMergeSoluInfo = this.getFastMergeSoluInfo(-1);
        ObjectUuidPK pk = new ObjectUuidPK(fastMergeSoluInfo.getId());
        if (!fastMergeSoluInfo.isIsSupportGroupReport() && this.isHasCreatedMergeReport(pk)) {
            String showMsg = FastMergeUtil.getStringRes("merge.has.created.remove");
            int isDel = MsgBox.showConfirm2((String)showMsg);
            if (isDel == 2) {
                return;
            }
            FastMergeUtil.deleteMergeReport(null, (IObjectPK)pk);
            this.getBizInterface().delete((IObjectPK)pk);
            this.refreshList();
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    private boolean isHasCreatedMergeReport(ObjectUuidPK pk) throws Exception {
        if (pk == null) {
            return false;
        }
        IFastMergeSolu iFastMergeSolu = (IFastMergeSolu)this.getBizInterface();
        return iFastMergeSolu.isHasCreatedMergeReport((IObjectPK)pk);
    }

    @Override
    public void actionImmediateRun_actionPerformed(ActionEvent e) throws Exception {
        super.actionImmediateRun_actionPerformed(e);
        this.checkSelected();
        if (this.dataIsLocking()) {
            return;
        }
        String fastMergeSoluId = this.getSelectedKeyValue();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("number");
        selectors.add("name");
        selectors.add("orgBound.id");
        selectors.add("orgBound.number");
        selectors.add("orgBound.name");
        selectors.add("currency.id");
        selectors.add("currency.name");
        selectors.add("isSupportGroupReport");
        selectors.add("templates.id");
        selectors.add("templates.template.id");
        selectors.add("templates.template.periodType");
        selectors.add("templates.id");
        selectors.add("templates.template.id");
        selectors.add("templates.template.periodType");
        FastMergeSoluInfo soluInfo = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selectors);
        if (soluInfo.getTemplates() == null || soluInfo.getTemplates().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FastMergeUtil.getStringRes("scheduledef.is.not.exist.template"));
            SysUtil.abort();
        }
        String orgBoundId = soluInfo.getOrgBound().getId().toString();
        RptPeriodTypeEnum periodType = soluInfo.getTemplates().get(0).getTemplate().getPeriodType();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"fastMergeSoluInfo", (Object)soluInfo);
        uiContext.put((Object)"fastMergeSoluId", (Object)fastMergeSoluId);
        uiContext.put((Object)"periodType", (Object)periodType);
        IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FastMergeSoluExecGuideUI.class.getName(), (Map)uiContext, null);
        iUIWindow.show();
    }

    @Override
    public void actionSetTimeDispatch_actionPerformed(ActionEvent e) throws Exception {
        super.actionRunnedReport_actionPerformed(e);
        this.checkSelected();
        if (this.dataIsLocking()) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        String fastMergeSoluId = this.getSelectedKeyValue();
        uiContext.put((Object)"fastMergeSoluId", (Object)fastMergeSoluId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FastMergeSetTimeDispatchUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionUnSetTimeDispatch_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnSetTimeDispatch_actionPerformed(e);
        this.checkSelected();
        if (this.dataIsLocking()) {
            return;
        }
        FastMergeSoluInfo fastMergeSoluInfo = this.getFastMergeSoluInfo(-1);
        if (!fastMergeSoluInfo.isIsAutoDispatch() && fastMergeSoluInfo.getDispatchPeriodId() == null) {
            this.getMessageHandler().show(FastMergeUtil.getStringRes("scheduledef.is.not.exist"));
            return;
        }
        fastMergeSoluInfo.setDispatchPeriodId(null);
        fastMergeSoluInfo.setIsAutoDispatch(false);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("isAutoDispatch");
        selector.add("dispatchPeriodId");
        FastMergeSoluFactory.getRemoteInstance().updatePartial(fastMergeSoluInfo, selector);
        super.actionRefresh_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FastMergeSoluFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fi.gr.fast.client.FastMergeEditUI";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentFIUnit() == null) {
            return filter;
        }
        filter.appendFilterItem("organUnit.Id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        return filter;
    }

    private void setBtnIcon() {
        this.btnImmediateRun.setIcon(EASResource.getIcon((String)"imgTbtn_datatask_execute"));
        this.btnRunnedReport.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.btnFindReport.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
        this.btnFindItemData.setIcon(EASResource.getIcon((String)"imgTbtn_showdata"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionQueryScheme.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionFindItemData.setVisible(false);
    }

    @Override
    public void actionRunnedReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionRunnedReport_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        String fastMergeSoluId = this.getSelectedKeyValue();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("name");
        selectors.add("isAutoSum");
        selectors.add("autoItemFormual.id");
        selectors.add("adjustEntrySolu.id");
        selectors.add("elimEntrySolu.id");
        selectors.add("currency.name");
        FastMergeSoluInfo currentInfo = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selectors);
        uiContext.put((Object)"ID", (Object)currentInfo.getId().toString());
        uiContext.put((Object)"mergeContext", (Object)currentInfo);
        uiContext.put((Object)"currencyName", (Object)currentInfo.getCurrency().getName());
        UIParamForNonCompared paramForUI = new UIParamForNonCompared();
        uiContext.put(UIParamForNonCompared.class, (Object)paramForUI);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(AutoMergeReportUI.class.getName(), (Map)uiContext, null, OprtState.VIEW, this.getWinStyle());
        uiWindow.getUIObject().getUIContext().putAll(uiContext);
        if (uiWindow.getUIObject() instanceof NeedRefreshable && ((NeedRefreshable)uiWindow.getUIObject()).isNeed()) {
            ((NeedRefreshable)uiWindow.getUIObject()).toRefresh();
        }
        uiWindow.show();
    }

    @Override
    public void actinFindAdjudtEntry_actionPerformed(ActionEvent e) throws Exception {
        String userId;
        boolean isExistsFlag;
        super.actinFindAdjudtEntry_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        String fastMergeSoluId = this.getSelectedKeyValue();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("templates.id");
        selectors.add("templates.template.id");
        selectors.add("templates.template.periodType");
        FastMergeSoluInfo soluInfo = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selectors);
        if (soluInfo.getTemplates() == null || soluInfo.getTemplates().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FastMergeUtil.getStringRes("scheduledef.is.not.exist.template"));
            SysUtil.abort();
        }
        RptPeriodTypeEnum periodType = soluInfo.getTemplates().get(0).getTemplate().getPeriodType();
        int[] yearAndPeriod = FastMergeUtil.getLastExcuteYearAndPeriod(null, fastMergeSoluId);
        if (yearAndPeriod == null) {
            Calendar calendar = Calendar.getInstance();
            yearAndPeriod = RPTDateUtil.getPeriod(calendar.getTime(), periodType);
        }
        if (!(isExistsFlag = FastMergeUtil.checkHasOrgTreeInfo(userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString(), fastMergeSoluId, yearAndPeriod[0], yearAndPeriod[1]))) {
            MessageHandler messageHandler = new MessageHandler(1);
            messageHandler.show(FastMergeUtil.getStringRes("fastmerge.check.orgtree"));
            return;
        }
        uiContext.put((Object)"fastMergeSoluId", (Object)fastMergeSoluId);
        uiContext.put((Object)"isFromFastMerge", (Object)Boolean.TRUE);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(AdjustProcListUI.class.getName(), (Map)uiContext, null, OprtState.EDIT, this.getWinStyle());
        if (uiWindow.getUIObject() instanceof NeedRefreshable && ((NeedRefreshable)uiWindow.getUIObject()).isNeed()) {
            ((NeedRefreshable)uiWindow.getUIObject()).toRefresh();
        }
        uiWindow.show();
    }

    @Override
    public void actinFindElimEntry_actionPerformed(ActionEvent e) throws Exception {
        String userId;
        OrgTreeInfo orgTreeInfo;
        super.actinFindElimEntry_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        String fastMergeSoluId = this.getSelectedKeyValue();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("templates.id");
        selectors.add("templates.template.id");
        selectors.add("templates.template.periodType");
        FastMergeSoluInfo soluInfo = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selectors);
        if (soluInfo.getTemplates() == null || soluInfo.getTemplates().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FastMergeUtil.getStringRes("scheduledef.is.not.exist.template"));
            SysUtil.abort();
        }
        RptPeriodTypeEnum periodType = soluInfo.getTemplates().get(0).getTemplate().getPeriodType();
        int[] yearAndPeriod = FastMergeUtil.getLastExcuteYearAndPeriod(null, fastMergeSoluId);
        if (yearAndPeriod == null) {
            Calendar calendar = Calendar.getInstance();
            yearAndPeriod = RPTDateUtil.getPeriod(calendar.getTime(), periodType);
        }
        if ((orgTreeInfo = FastMergeUtil.getOrgTreeInfo(userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString(), fastMergeSoluId, yearAndPeriod[0], yearAndPeriod[1])) == null) {
            MessageHandler messageHandler = new MessageHandler(1);
            messageHandler.show(FastMergeUtil.getStringRes("fastmerge.check.orgtree"));
            return;
        }
        uiContext.put((Object)"fastMergeSoluId", (Object)fastMergeSoluId);
        uiContext.put((Object)"isFromFastMerge", (Object)Boolean.TRUE);
        uiContext.put((Object)"orgTreeId", (Object)orgTreeInfo.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(EliminationForPCListUI.class.getName(), (Map)uiContext, null, OprtState.EDIT, this.getWinStyle());
        if (uiWindow.getUIObject() instanceof NeedRefreshable && ((NeedRefreshable)uiWindow.getUIObject()).isNeed()) {
            ((NeedRefreshable)uiWindow.getUIObject()).toRefresh();
        }
        uiWindow.show();
    }

    @Override
    public void actionFindReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionFindReport_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        String fastMergeSoluId = this.getSelectedKeyValue();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("isAutoSum");
        selectors.add("number");
        selectors.add("name");
        selectors.add("orgBound.id");
        selectors.add("orgBound.name");
        selectors.add("orgBound.number");
        selectors.add("templates.template.periodType");
        FastMergeSoluInfo currentInfo = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selectors);
        uiContext.put((Object)"ID", (Object)currentInfo.getId().toString());
        uiContext.put((Object)"fastMergeSoluInfo", (Object)currentInfo);
        UIParamForNonCompared paramForUI = new UIParamForNonCompared();
        uiContext.put(UIParamForNonCompared.class, (Object)paramForUI);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(MergeReportCenterListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW, this.getWinStyle());
        if (uiWindow.getUIObject() instanceof NeedRefreshable && ((NeedRefreshable)uiWindow.getUIObject()).isNeed()) {
            ((NeedRefreshable)uiWindow.getUIObject()).toRefresh();
        }
        uiWindow.show();
    }

    protected int getWinStyle() {
        return 85;
    }

    @Override
    public void actionFindItemData_actionPerformed(ActionEvent e) throws Exception {
        super.actionFindItemData_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        String fastMergeSoluId = this.getSelectedKeyValue();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("name");
        selectors.add("isAutoSum");
        selectors.add("autoItemFormual.id");
        selectors.add("adjustEntrySolu.id");
        selectors.add("elimEntrySolu.id");
        selectors.add("templates.template.*");
        selectors.add("orgUnits.orgUnit.*");
        selectors.add("orgBound.id");
        selectors.add("orgBound.number");
        selectors.add("currency.id");
        selectors.add("currency.name");
        FastMergeSoluInfo currentInfo = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selectors);
        uiContext.put((Object)"ID", (Object)currentInfo.getId().toString());
        uiContext.put(FastMergeSoluInfo.class, (Object)currentInfo);
        uiContext.put((Object)"FastMergeId", (Object)currentInfo.getId().toString());
        UIParamForNonCompared paramForUI = new UIParamForNonCompared();
        uiContext.put(UIParamForNonCompared.class, (Object)paramForUI);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(AutoMergeItemDataUI.class.getName(), (Map)uiContext, null, OprtState.VIEW, this.getWinStyle());
        uiWindow.getUIObject().getUIContext().putAll(uiContext);
        if (uiWindow.getUIObject() instanceof NeedRefreshable && ((NeedRefreshable)uiWindow.getUIObject()).isNeed()) {
            ((NeedRefreshable)uiWindow.getUIObject()).toRefresh();
        }
        uiWindow.show();
    }

    protected MessageHandler getMessageHandler() {
        return new MessageHandler(1);
    }

    protected FastMergeSoluInfo getFastMergeSoluInfo(int rowIndex) throws Exception {
        String selectedId;
        String keyFiledName = this.subKeyFieldName == null ? this.getKeyFieldName() : this.subKeyFieldName;
        int[] selectRows = new int[]{rowIndex};
        if (rowIndex == -1 && (selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain)).length == 0) {
            selectRows = new int[]{0};
        }
        if (!BOSUuid.isValid((String)(selectedId = ListUiHelper.getSelectedKeyValue((int[])selectRows, (KDTable)this.tblMain, (String)keyFiledName)), (boolean)true)) {
            this.getMessageHandler().show(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        FastMergeSoluInfo fastMergeSoluInfo = (FastMergeSoluInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(selectedId));
        return fastMergeSoluInfo;
    }
}

