/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.fast.client.AbstractManageMergeElimInvestRateListUI;
import com.kingdee.eas.fi.gr.fast.client.MgMergeElimInvestRateFilterUI;
import com.kingdee.eas.fi.gr.fast.client.MyDatataskCaller;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class ManageMergeElimInvestRateListUI
extends AbstractManageMergeElimInvestRateListUI {
    private static final Logger logger = CoreUIObject.getLogger(ManageMergeElimInvestRateListUI.class);
    protected CommonQueryDialog dlg = null;
    protected OrgStructureCollection orgStruct = null;
    private boolean refreshTree = true;
    private String curOrgId = null;
    private boolean isPerformDefaultQuery = false;

    public ManageMergeElimInvestRateListUI() throws Exception {
        this.ctx = new CSLContext();
    }

    @Override
    public void onLoad() throws Exception {
        EntityViewInfo filter;
        boolean isShow;
        super.listUIOnLoad();
        this.dlg = this.initCommonQueryDialog();
        if (!this.isPerformDefaultQuery && !(isShow = this.dlg.show())) {
            SysUtil.abort();
        }
        this.mainQuery = filter = this.getFilter();
        this.filterInfoParse(filter.getFilter());
        this.initCslContext();
        this.refreshOrgTree();
        super.onLoad();
        this.orgStruct.clear();
        this.includechild.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    ManageMergeElimInvestRateListUI.this.refreshTree = false;
                    ManageMergeElimInvestRateListUI.this.getUIContext().put("isIncludeChild", ManageMergeElimInvestRateListUI.this.includechild.isSelected());
                    ManageMergeElimInvestRateListUI.this.curOrgId = ManageMergeElimInvestRateListUI.this.getSelectedOrgStructureInfo().getUnit().getId().toString();
                    ManageMergeElimInvestRateListUI.this.tblMain.repaint();
                    ManageMergeElimInvestRateListUI.this.tblMain.removeRows();
                    ManageMergeElimInvestRateListUI.this.changeCtx();
                }
                finally {
                    ManageMergeElimInvestRateListUI.this.refreshTree = true;
                }
            }
        });
        this.setSelectedRoot();
    }

    private EntityViewInfo getFilter() {
        EntityViewInfo filter = this.dlg.getEntityViewInfoResult();
        if (filter == null) {
            filter = new EntityViewInfo();
        }
        if (filter.getFilter() == null && (this.mainQuery == null || this.mainQuery.getFilter() == null || this.mainQuery.getFilter().getFilterItems().size() <= 0)) {
            ArrayList panels = this.dlg.getUserPanels();
            for (Object obj : panels) {
                if (!(obj instanceof MgMergeElimInvestRateFilterUI)) continue;
                filter.setFilter(((MgMergeElimInvestRateFilterUI)((Object)obj)).getFilterInfo());
            }
        }
        return filter;
    }

    private void setSelectedRoot() {
        if (((DefaultTreeModel)this.orgTree.getModel()).getRoot() != null && ((DefaultTreeModel)this.orgTree.getModel()).getRoot() instanceof KDTreeNode) {
            this.orgTree.setSelectionNode((DefaultKingdeeTreeNode)((KDTreeNode)((DefaultTreeModel)this.orgTree.getModel()).getRoot()));
        }
        this.includechild.setSelected(true);
    }

    @Override
    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        return pk;
    }

    @Override
    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dlg == null) {
            this.dlg = super.initCommonQueryDialog();
            try {
                this.dlg.init();
                this.dlg.getCommonQueryParam().setDirty(false);
            }
            catch (Exception e2) {
                ExceptionHandler.handle((Throwable)e2);
            }
        }
        return this.dlg;
    }

    @Override
    public boolean isManageMerge() {
        return true;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        try {
            if (viewInfo.getFilter() != null) {
                this.filterInfoParse(viewInfo.getFilter());
                this.initParams2Map();
            }
            if (this.refreshTree) {
                this.refreshOrgTree();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        OrgStructureInfo info = this.getSelectedOrgStructureInfo();
        if (info != null && !info.getUnit().isIsUnion()) {
            StringBuffer maskString = new StringBuffer();
            if (viewInfo.getFilter().getMaskString() != null) {
                maskString.append(viewInfo.getFilter().getMaskString());
            }
            int maskCount = viewInfo.getFilter().getFilterItems().size();
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getUnit().getId().toString()));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("targetCompany.id", (Object)info.getUnit().getId().toString()));
            maskString.append(" AND (#").append(maskCount++).append(" or #").append(maskCount++).append(")");
            viewInfo.getFilter().setMaskString(maskString.toString());
        }
        try {
            this.builderOrgUnitFilter(viewInfo);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return queryExecutor;
    }

    @Override
    protected void builderOrgUnitFilter(EntityViewInfo viewInfo) throws BOSException {
        Set unions = this.getSelectedUnions();
        HashSet<String> unionIds = new HashSet<String>();
        for (Object union : unions) {
            unionIds.add(((FullOrgUnitInfo)union).getId().toString());
        }
        unions.clear();
        if (!unionIds.isEmpty()) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", unionIds, CompareType.INCLUDE));
        } else {
            super.builderOrgUnitFilter(viewInfo);
        }
    }

    private Set getSelectedUnions() {
        HashSet<FullOrgUnitInfo> unions = new HashSet<FullOrgUnitInfo>();
        OrgStructureInfo info = this.getSelectedOrgStructureInfo();
        if (info != null) {
            KDTreeNode curNode = this.getSelectedNode();
            if (!info.getUnit().isIsUnion()) {
                info = this.getParentUnion(curNode);
                unions.add(info.getUnit());
            } else if (this.includechild.isSelected()) {
                unions.add(((OrgStructureInfo)curNode.getUserObject()).getUnit());
                this.addUnionChilds(curNode, unions);
            } else {
                unions.add(info.getUnit());
            }
        }
        return unions;
    }

    private OrgStructureInfo getParentUnion(KDTreeNode curNode) {
        OrgStructureInfo info = (OrgStructureInfo)curNode.getUserObject();
        while (curNode != null && !info.getUnit().isIsUnion()) {
            curNode = (KDTreeNode)curNode.getParent();
            info = (OrgStructureInfo)curNode.getUserObject();
        }
        return info;
    }

    private void getChildUnions(KDTreeNode curNode, Set unions) {
        OrgStructureInfo info = (OrgStructureInfo)curNode.getUserObject();
        if (curNode != null && info.getUnit().isIsUnion()) {
            KDTreeNode node = null;
            for (int i = 0; i < curNode.getChildCount(); ++i) {
                node = (KDTreeNode)curNode.getChildAt(i);
                if (node == null || node.getUserObject() == null) continue;
                info = (OrgStructureInfo)node.getUserObject();
                unions.add(info.getUnit().getId().toString());
                this.getChildUnions(node, unions);
            }
        }
    }

    private void addUnionChilds(KDTreeNode parentNode, Set unions) {
        KDTreeNode curNode = null;
        OrgStructureInfo info = null;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            curNode = (KDTreeNode)parentNode.getChildAt(i);
            info = (OrgStructureInfo)curNode.getUserObject();
            if (!info.getUnit().isIsUnion()) continue;
            unions.add(info.getUnit());
            this.addUnionChilds(curNode, unions);
        }
    }

    @Override
    protected void initCslContext() {
        DataCollectInfo dateCollection = new DataCollectInfo();
        dateCollection.setNumber("ACTUALDATA");
        ((CSLContext)this.ctx).setCurDataCollect(dateCollection);
    }

    protected void filterInfoParse(FilterInfo filterInfo) throws Exception {
        if (filterInfo != null) {
            FilterItemCollection filterItems = filterInfo.getFilterItems();
            FilterItemInfo itemInfo = null;
            for (int i = 0; i < filterItems.size(); ++i) {
                itemInfo = filterItems.get(i);
                if (itemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                    ((CSLContext)this.ctx).setCurRptPeriodType(RptPeriodTypeEnum.getEnum((int)((Integer)itemInfo.getCompareValue())));
                    continue;
                }
                if (itemInfo.getPropertyName().equalsIgnoreCase("year")) {
                    ((CSLContext)this.ctx).setCurRptYear((Integer)itemInfo.getCompareValue());
                    this.rptYear = this.ctx.getCurRptYear();
                    continue;
                }
                if (itemInfo.getPropertyName().equalsIgnoreCase("period")) {
                    ((CSLContext)this.ctx).setCurRptPeriod((Integer)itemInfo.getCompareValue());
                    this.rptPeriod = this.ctx.getCurRptPeriod();
                    continue;
                }
                if (!itemInfo.getPropertyName().equalsIgnoreCase("orgBound.id")) continue;
                this.orgBound = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo("where id='" + (String)itemInfo.getCompareValue() + "'");
                ((CSLContext)this.ctx).setCurOrgBound(this.orgBound);
                if (((CSLContext)this.ctx).getCurOrgBound() == null) continue;
                String orgTreeId = ((CSLContext)this.ctx).getCurOrgBound().getId().toString();
                this.orgStruct = this.getTargetOrgUnit(orgTreeId);
                if (this.orgStruct == null || this.orgStruct.size() <= 0 || this.ctx.getCurOrgGroup() != null) continue;
                ((CSLContext)this.ctx).setCurOrgGroup((OrgUnitInfo)this.orgStruct.get(0).getUnit());
                this.curOrgGroup = this.ctx.getCurOrgGroup();
            }
            if (this.ctx.getCurRptYear() < 0) {
                SysUtil.abort();
            }
            ((CSLContext)this.ctx).setCurReportDate(RPTDateUtil.getPeriodLastDate(this.ctx.getCurRptYear(), this.ctx.getCurRptPeriod(), this.ctx.getCurRptPeriodType() == null ? RptPeriodTypeEnum.MONTHLY : this.ctx.getCurRptPeriodType()));
            this.reportDate = this.ctx.getCurReportDate();
        }
    }

    private void refreshOrgTree() throws Exception {
        if (this.refreshTree) {
            OrgTreeInfo curOrgTree = this.ctx.getCurOrgBound();
            if (curOrgTree != null) {
                if (this.orgStruct == null) {
                    this.orgStruct = this.getTargetOrgUnit(curOrgTree.getId().toString());
                }
                OrgStructureInfo orgStructureInfo = null;
                HashMap<String, List<OrgStructureInfo>> parent_childs = new HashMap<String, List<OrgStructureInfo>>();
                for (int i = 0; i < this.orgStruct.size(); ++i) {
                    orgStructureInfo = this.orgStruct.get(i);
                    if (orgStructureInfo.getParent() == null || orgStructureInfo.getParent().getId() == null) continue;
                    ArrayList<OrgStructureInfo> childList = (ArrayList<OrgStructureInfo>)parent_childs.get(orgStructureInfo.getParent().getId().toString());
                    if (childList == null) {
                        childList = new ArrayList<OrgStructureInfo>();
                        parent_childs.put(orgStructureInfo.getParent().getId().toString(), childList);
                    }
                    childList.add(orgStructureInfo);
                }
                this.orgTree.setShowsRootHandles(true);
                if (this.orgStruct.size() > 0) {
                    orgStructureInfo = this.orgStruct.get(0);
                    KDTreeNode curNode = new KDTreeNode((Object)orgStructureInfo.getUnit());
                    curNode.setUserObject((Object)orgStructureInfo);
                    ((DefaultTreeModel)this.orgTree.getModel()).setRoot((TreeNode)curNode);
                    this.initChildTree(curNode, parent_childs);
                }
                parent_childs.clear();
            }
            this.setSelectedRoot();
        }
        this.orgTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (ManageMergeElimInvestRateListUI.this.getSelectedOrgStructureInfo() != null) {
                    if (ManageMergeElimInvestRateListUI.this.curOrgId != null && ManageMergeElimInvestRateListUI.this.curOrgId.equals(ManageMergeElimInvestRateListUI.this.getSelectedOrgStructureInfo().getUnit().getId().toString())) {
                        return;
                    }
                    try {
                        ManageMergeElimInvestRateListUI.this.refreshTree = false;
                        ManageMergeElimInvestRateListUI.this.curOrgId = ManageMergeElimInvestRateListUI.this.getSelectedOrgStructureInfo().getUnit().getId().toString();
                        ManageMergeElimInvestRateListUI.this.tblMain.repaint();
                        ManageMergeElimInvestRateListUI.this.tblMain.removeRows();
                        ManageMergeElimInvestRateListUI.this.changeCtx();
                    }
                    finally {
                        ManageMergeElimInvestRateListUI.this.refreshTree = true;
                    }
                }
            }
        });
    }

    protected void changeCtx() {
        this.curOrgGroup = this.getSelectedOrgStructureInfo().getUnit().isIsUnion() ? this.getSelectedOrgStructureInfo().getUnit() : this.getParentUnion(this.getSelectedNode()).getUnit();
        ((CSLContext)this.ctx).setCurOrgGroup(this.curOrgGroup);
        this.getUIContext().put("ctx", this.ctx);
        this.initParams2Map();
        SysContext.getSysContext().setProperty((Object)"currentSelectedOrg", (Object)this.curOrgGroup);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        try {
            if (this.isExisElimInvestRateCurrentMonth()) {
                if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"MONTH_ELIMINVESTRATE_EXIS")))) {
                    this.params.put("isCovered", true);
                    this.IElimInvestRate.autoCopyElimInvestRatePrePeriod(this.params);
                }
            } else {
                this.params.put("isCovered", true);
                this.IElimInvestRate.autoCopyElimInvestRatePrePeriod(this.params);
            }
            this.refreshTree = false;
            this.tblMain.removeRows();
        }
        finally {
            this.params.remove("isCovered");
            this.refreshTree = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCreate_actionPerformed(ActionEvent e) throws Exception {
        Set unions = this.getSelectedUnions();
        boolean isCreate = true;
        Exception exception = null;
        if (this.isExisElimInvestRateCurrentMonth() && !MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"GENERATE_ELIMINVESTRATE_EXIS")))) {
            isCreate = false;
        }
        try {
            if (isCreate) {
                for (Object unitInfo : unions) {
                    this.params.put("orgUnit", unitInfo);
                    try {
                        this.IElimInvestRate.generateElimInvestRate(this.params);
                    }
                    catch (Exception ex) {
                        exception = ex;
                    }
                }
            }
            this.refreshTree = false;
            this.tblMain.removeRows();
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            this.refreshTree = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCalEquivShareRate_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Map notice = ElimInvestRateFactory.getRemoteInstance().calEquivShareRate(idList, this.params);
        if (notice != null && notice.get("report") != null) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"461_ElimInvestRateListUI"), (String)notice.get("report").toString(), (int)0);
        }
        try {
            this.refreshTree = false;
            this.tblMain.removeRows();
        }
        finally {
            this.refreshTree = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            ArrayList selectIdList = this.getSelectedIdValues();
            param.put("selectIdList", selectIdList);
            param.put("orgBoundId", this.orgBound.getId().toString());
            param.put("reportDate", this.reportDate);
            param.put("orgUnit", this.curOrgGroup);
            param.put("rptPeriod", new Integer(this.rptPeriod));
            param.put("rptPeriodType", this.rptPeriodType);
            this.IElimInvestRate.deleteElimInvestRate(param);
        }
        try {
            this.refreshTree = false;
            this.tblMain.removeRows();
        }
        finally {
            this.refreshTree = true;
        }
    }

    private KDTreeNode getSelectedNode() {
        return (KDTreeNode)this.orgTree.getLastSelectedPathComponent();
    }

    private OrgStructureInfo getSelectedOrgStructureInfo() {
        KDTreeNode selectedTreeNode = this.getSelectedNode();
        if (selectedTreeNode != null && selectedTreeNode.getUserObject() != null && selectedTreeNode.getUserObject() instanceof OrgStructureInfo) {
            return (OrgStructureInfo)selectedTreeNode.getUserObject();
        }
        return null;
    }

    public void initChildTree(KDTreeNode curNode, Map<String, List<OrgStructureInfo>> parent_childs) {
        if (curNode != null && curNode.getUserObject() != null && curNode.getUserObject() instanceof OrgStructureInfo) {
            KDTreeNode childNode = null;
            OrgStructureInfo unitInfo = (OrgStructureInfo)curNode.getUserObject();
            List<OrgStructureInfo> childList = parent_childs.get(unitInfo.getId().toString());
            if (childList != null && !childList.isEmpty()) {
                for (OrgStructureInfo curUnitInfo : childList) {
                    childNode = new KDTreeNode((Object)curUnitInfo.getUnit());
                    childNode.setUserObject((Object)curUnitInfo);
                    curNode.add((MutableTreeNode)childNode);
                    this.initChildTree(childNode, parent_childs);
                }
            }
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        try {
            if (e != null) {
                this.refreshTree = false;
            }
            super.refresh(e);
        }
        finally {
            this.refreshTree = true;
        }
    }

    @Override
    public void actionChange_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.refreshTree = false;
            super.actionChange_actionPerformed(e);
        }
        finally {
            this.refreshTree = true;
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.refreshTree = false;
            super.actionEdit_actionPerformed(e);
        }
        finally {
            this.refreshTree = true;
        }
    }

    private OrgStructureCollection getTargetOrgUnit(String orgTreeId) throws Exception {
        if (!StringUtils.isEmpty((String)orgTreeId)) {
            OrgStructureCollection orgStructureColl = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection("select id,level,isLeaf,unit.name,unit.number,unit.longNumber,unit.id,tree.number,unit.isunion,parent.id where tree.id='" + orgTreeId + "' and  unit.isunion=1 order by longnumber asc");
            return orgStructureColl;
        }
        return null;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = ManageMergeElimInvestRateListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        this.isPerformDefaultQuery = this.isPerformDefaultQuery(iQuery, queryName);
        super.actionQuery_actionPerformed(e);
        if (!this.isPerformDefaultQuery && !this.isFirstDefaultQuery()) {
            this.autoCopyPrePeriodInvestRate();
        }
    }

    @Override
    protected boolean isExisElimInvestRateCurrentMonth() throws BOSException, EASBizException {
        HashSet<String> unions = new HashSet<String>();
        this.getChildUnions(this.getSelectedNode(), unions);
        unions.add(this.curOrgGroup.getId().toString());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("rptDate", (Object)new Timestamp(this.reportDate.getTime())));
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)this.rptPeriodType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(this.rptPeriod)));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)this.orgBound.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", unions, CompareType.INCLUDE));
        return this.IElimInvestRate.exists(filterInfo);
    }

    @Override
    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        MyDatataskCaller task = new MyDatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        if (this.getImportParam() != null) {
            task.invoke(this.getImportParam(), 0);
        }
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            DatataskParameter dp = (DatataskParameter)tmp;
            dp.putContextParam((Object)"mainQueryPK", (Object)this.mainQueryPK);
            dp.putContextParam((Object)"mainQuery", (Object)this.mainQuery);
        }
        MyDatataskCaller dc = new MyDatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.setMainOrgContext(this.getMainOrgContext());
        dc.invoke(para, 1);
    }
}

