/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslDataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptItemF7;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeTemplateCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeTemplateFactory;
import com.kingdee.eas.fi.gr.fast.client.AbstractMgCslDynaItemDataFilterUI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MgCslDynaItemDataFilterUI
extends AbstractMgCslDynaItemDataFilterUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MgCslDynaItemDataFilterUI.class);
    private CslRptItemF7 cslRptItemF7UI = new CslRptItemF7((IUIObject)this);
    private static String selectAll = CslRptUtil.getString("CslRptItemDataNameAll");
    private static String selectItem = CslRptUtil.getString("CslRptItemDataNameItem");
    private static String selectElim = CslRptUtil.getString("CslRptItemDataNameElim");
    private static String selectAdju = CslRptUtil.getString("CslRptItemDataNameAdjust");
    private boolean isMergeByFiscalPeriod;
    private PeriodCollection periodCollection = null;
    private Map<String, RptPeriodTypeEnum> cache = new HashMap<String, RptPeriodTypeEnum>();

    public MgCslDynaItemDataFilterUI() throws Exception {
        this.isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);
        this.initUI();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.clearUI();
        this.comboPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)MgCslDynaItemDataFilterUI.this.comboPeriodType.getSelectedItem();
                    if (periodType == null) {
                        periodType = RptPeriodTypeEnum.MONTHLY;
                    }
                    if (FiscalPeriodHelper.isMergeByFiscalPeriod(MgCslDynaItemDataFilterUI.this.isMergeByFiscalPeriod, periodType)) {
                        return;
                    }
                    Date date = MgCslDynaItemDataFilterUI.this.dpkDateTo.getSqlDate();
                    if (date == null) {
                        date = new Date();
                    }
                    List timesList = RPTDateUtil.getRptPeriod(date, periodType);
                    MgCslDynaItemDataFilterUI.this.dpkDateTo.setValue(timesList.get(2));
                    int year = (Integer)timesList.get(0);
                    int period = (Integer)timesList.get(1);
                    Date firstDate = RPTDateUtil.getPeriodFirstDate(year, period, periodType);
                    MgCslDynaItemDataFilterUI.this.dpkDate.setValue((Object)firstDate);
                }
            }
        });
    }

    private void initComponentState() {
        this.treeCmb.setEnabled(false);
        this.comboPeriodType.setEnabled(false);
        this.bizCompany.setEditable(false);
    }

    private void initUI() throws EASBizException, BOSException {
        this.createSchemePromp();
        this.comboItemType.addItem((Object)selectAll);
        try {
            this.comboItemType.addItems(ReportClassFactory.getRemoteInstance().getReportClassCollection(CslGradeManageUtil.filterRptItemTypeGradeManage(null, null)).toArray());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.initDate();
        CurrencyCollection currencyColl = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
        this.comboSourceCurrency.addItem((Object)selectAll);
        this.comboSourceCurrency.addItems(currencyColl.toArray());
        this.comboCurrency.addItem((Object)selectAll);
        this.comboCurrency.addItems(currencyColl.toArray());
        this.bizItem.setSelector((KDPromptSelector)this.cslRptItemF7UI);
        this.bizItemTo.setSelector((KDPromptSelector)this.cslRptItemF7UI);
        this.spnLevel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Integer level = (Integer)MgCslDynaItemDataFilterUI.this.spnLevel.getValue();
                if (level < 1) {
                    MgCslDynaItemDataFilterUI.this.spnLevel.setValue((Object)new Integer(1));
                }
            }
        });
        this.spnLevelTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Integer level = (Integer)MgCslDynaItemDataFilterUI.this.spnLevelTo.getValue();
                if (level < 1) {
                    MgCslDynaItemDataFilterUI.this.spnLevelTo.setValue((Object)new Integer(1));
                }
            }
        });
        this.initCmbxType(true);
        this.cmbxType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MgCslDynaItemDataFilterUI.this.actionTypeChanged();
                }
            }
        });
        this.cmbxAdjustStatus.addItem((Object)selectAll);
        this.cmbxAdjustStatus.addItems(AdjustStatusEnum.getEnumList().toArray());
        this.cmbxAdjustStatus.removeItem((Object)AdjustStatusEnum.CALIADJUSTED);
        this.comboElim.removeAllItems();
        this.comboElim.addItem((Object)selectAll);
        this.comboElim.addItem((Object)CslDataSrcTypeEnum.SINGLE);
        this.comboElim.addItem((Object)CslDataSrcTypeEnum.SUMMARY);
        this.comboElim.addItem((Object)CslDataSrcTypeEnum.COMBINE);
        this.bizDataType.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.DataElementQuery");
        this.bizDataType.setEditFormat("$number$");
        this.bizDataType.setDisplayFormat("$name$");
        this.bizDataType.setEditable(true);
        this.bizDataType.setRequired(true);
        this.bizDataType.setCommitFormat("$number$");
        try {
            CslGradeManageUtil.setDataElementF7GMFilter((KDBizPromptBox)this.bizDataType, null, (boolean)true);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.bizCompany.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (MgCslDynaItemDataFilterUI.this.treeCmb.getSelectedItem() == null) {
                    MsgBox.showError((Component)((Object)MgCslDynaItemDataFilterUI.this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)"needSelectSolution"));
                    SysUtil.abort();
                }
            }
        });
        this.initComponentState();
    }

    private void initCmbxType(boolean includeElim) {
        this.cmbxType.removeAllItems();
        this.cmbxType.addItem((Object)ItemTypeFactory.getInstance().getItemType(1));
        this.cmbxType.addItem((Object)ItemTypeFactory.getInstance().getItemType(2));
        if (includeElim) {
            this.cmbxType.addItem((Object)ItemTypeFactory.getInstance().getItemType(3));
        }
        this.cmbxType.addItem((Object)ItemTypeFactory.getInstance().getItemType(4));
    }

    private void initDate() {
        this.dpkDate.setValue((Object)RPTDateUtil.getFirstDayByDate(RPTDateUtil.getPrevMonthLastDayByDate(new Date())));
        this.dpkDateTo.setValue((Object)RPTDateUtil.getPrevMonthLastDayByDate(new Date()));
    }

    private void createOrgUnitPrompF7(OrgTreeInfo orgTreeInfo) {
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3){};
        f7.setTreeID(orgTreeInfo.getId().toString());
        f7.setCtrlUnitPK(orgTreeInfo.getCU());
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        f7.setMultiSelect(true);
        this.bizCompany.setSelector((KDPromptSelector)f7);
    }

    private void createSchemePromp() throws EASBizException, BOSException {
        this.schemePromp.setEditable(false);
        this.schemePromp.setQueryInfo("com.kingdee.eas.fi.gr.fast.MergeSchemeF7Query");
        EntityViewInfo view = new EntityViewInfo();
        this.schemePromp.setSelectorCollection(this.getMergeShemeSelector());
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("FastMergeSolu.Creator.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        view.setFilter(filter);
        this.schemePromp.setEntityViewInfo(view);
        this.schemePromp.setHRHistoryEnbable(false);
        this.schemePromp.setCommitFormat("$number$");
        this.schemePromp.setDisplayFormat("$name$");
        this.schemePromp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MgCslDynaItemDataFilterUI.this.treeCmb.removeAllItems();
                MgCslDynaItemDataFilterUI.this.bizCompany.setData(null);
                FastMergeSoluInfo soluInfo = (FastMergeSoluInfo)MgCslDynaItemDataFilterUI.this.schemePromp.getData();
                if (soluInfo != null) {
                    MgCslDynaItemDataFilterUI.this.treeCmb.addItem((Object)soluInfo.getOrgBound());
                    MgCslDynaItemDataFilterUI.this.comboSourceCurrency.setSelectedItem((Object)selectAll);
                    MgCslDynaItemDataFilterUI.this.comboCurrency.setSelectedItem((Object)selectAll);
                    MgCslDynaItemDataFilterUI.this.comboElim.setSelectedItem((Object)selectAll);
                    if (soluInfo.isIsAutoSum()) {
                        MgCslDynaItemDataFilterUI.this.initCmbxType(false);
                    } else {
                        MgCslDynaItemDataFilterUI.this.initCmbxType(true);
                    }
                    MgCslDynaItemDataFilterUI.this.comboPeriodType.setSelectedItem((Object)MgCslDynaItemDataFilterUI.this.getFastMegerSchemePeriodType(soluInfo));
                    MgCslDynaItemDataFilterUI.this.createOrgUnitPrompF7(soluInfo.getOrgBound());
                }
            }
        });
    }

    private RptPeriodTypeEnum getFastMegerSchemePeriodType(FastMergeSoluInfo soluInfo) {
        if (this.cache.containsKey(soluInfo.getId().toString())) {
            return this.cache.get(soluInfo.getId().toString());
        }
        String oql = "select template.periodType where fastMergeSolu='" + soluInfo.getId().toString() + "'";
        try {
            FastMergeTemplateCollection col = FastMergeTemplateFactory.getRemoteInstance().getFastMergeTemplateCollection(oql);
            if (col != null && col.size() > 0) {
                this.cache.put(soluInfo.getId().toString(), col.get(0).getTemplate().getPeriodType());
            }
            return col.get(0).getTemplate().getPeriodType();
        }
        catch (BOSException e) {
            this.handUIException(e);
            return null;
        }
    }

    private SelectorItemCollection getMergeShemeSelector() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("number", "number");
        selectors.add("name");
        selectors.add("isSupportGroupReport");
        selectors.add("isAutoSum", "mergeType");
        selectors.add("orgBound.id");
        selectors.add("orgBound.name");
        selectors.add("orgBound.number");
        selectors.add("orgBound.layerType");
        selectors.add("currency.id");
        selectors.add("currency.number");
        selectors.add("currency.name");
        return selectors;
    }

    private void actionTypeChanged() {
        this.comboElim.removeAllItems();
        this.comboElim.addItem((Object)selectAll);
        if (this.cmbxType.getSelectedItem().equals(ItemTypeFactory.getInstance().getItemType(1))) {
            this.comboElim.addItem((Object)CslDataSrcTypeEnum.ELIMDEBIT);
            this.comboElim.addItem((Object)CslDataSrcTypeEnum.ELIMCREDIT);
        } else {
            this.comboElim.addItem((Object)CslDataSrcTypeEnum.SINGLE);
            this.comboElim.addItem((Object)CslDataSrcTypeEnum.SUMMARY);
            this.comboElim.addItem((Object)CslDataSrcTypeEnum.COMBINE);
        }
    }

    public boolean verify() {
        if (this.schemePromp.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)"solutionIsNull"));
            return false;
        }
        if (this.bizCompany.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"51_ItemAnalysisFilterUI"));
            return false;
        }
        return true;
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo item;
        Calendar calendar;
        FilterItemInfo filterCurrency;
        CurrencyInfo currency;
        Object item2;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
            this.filterInfo.setMaskString(null);
        }
        StringBuffer strMask = new StringBuffer();
        int iIndex = 0;
        FilterItemInfo filterOrgTree = new FilterItemInfo("orgTreeId", (Object)((OrgTreeInfo)this.treeCmb.getSelectedItem()).getId().toString(), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(filterOrgTree);
        strMask.append("#").append(iIndex++);
        FastMergeSoluInfo soluInfo = (FastMergeSoluInfo)this.schemePromp.getData();
        if (this.schemePromp.getData() != null) {
            item2 = new FilterItemInfo("mergeSchemeId", (Object)((FastMergeSoluInfo)this.schemePromp.getData()).getId().toString());
            this.filterInfo.getFilterItems().add(item2);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.bizCompany.getData() != null) {
            Object[] companys = (Object[])this.bizCompany.getData();
            FilterItemInfo filterCompany = new FilterItemInfo("orgUnitId", (Object)this.getCollectionIDs(Arrays.asList(companys)), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCompany);
            strMask.append(" and #").append(iIndex++);
        } else {
            FilterItemInfo filterCompany = new FilterItemInfo("defaultOrgBound", (Object)"defaultOrgBound", CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCompany);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.comboItemType.getSelectedItem() != null && !this.comboItemType.getSelectedItem().equals(selectAll)) {
            ReportClassInfo itemType = (ReportClassInfo)this.comboItemType.getSelectedItem();
            FilterItemInfo filterItemType = new FilterItemInfo("reportClass", (Object)itemType.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemType);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.comboSourceCurrency.getSelectedItem() != null && !this.comboSourceCurrency.getSelectedItem().equals(selectAll)) {
            currency = (CurrencyInfo)this.comboSourceCurrency.getSelectedItem();
            filterCurrency = new FilterItemInfo("currency", (Object)currency.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCurrency);
            strMask.append(" and #").append(iIndex++);
            FilterItemInfo filterCurrencyName = new FilterItemInfo("currencyName", (Object)currency.getName(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCurrencyName);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.comboCurrency.getSelectedItem() != null && !this.comboCurrency.getSelectedItem().equals(selectAll)) {
            currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            filterCurrency = new FilterItemInfo("targetCurrency", (Object)currency.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCurrency);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.dpkDate.getValue() != null) {
            Date startDate = (Date)this.dpkDate.getValue();
            calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            Timestamp startTime = new Timestamp(calendar.getTimeInMillis());
            FilterItemInfo filterStartDate = new FilterItemInfo("rptDate", (Object)startTime, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterStartDate);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.dpkDateTo.getValue() != null) {
            Date endDate = (Date)this.dpkDateTo.getValue();
            calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            Timestamp endTime = new Timestamp(calendar.getTimeInMillis());
            FilterItemInfo filterEndDate = new FilterItemInfo("rptDateTo", (Object)endTime, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterEndDate);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.bizItem.getData() != null) {
            item2 = (RPTItemInfo)this.bizItem.getData();
            FilterItemInfo filterItem = new FilterItemInfo("item", (Object)item2.getNumber(), CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterItem);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.bizItemTo.getData() != null) {
            RPTItemInfo itemTo = (RPTItemInfo)this.bizItemTo.getData();
            FilterItemInfo filterItemTo = new FilterItemInfo("itemTo", (Object)itemTo.getNumber(), CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo);
            strMask.append(" and #").append(iIndex++);
        }
        Integer level = (Integer)this.spnLevel.getValue();
        FilterItemInfo filterItemLevel = new FilterItemInfo("itemLevel", (Object)level, CompareType.GREATER_EQUALS);
        this.filterInfo.getFilterItems().add(filterItemLevel);
        strMask.append(" and #").append(iIndex++);
        Integer levelTo = (Integer)this.spnLevelTo.getValue();
        FilterItemInfo filterItemLevelTo = new FilterItemInfo("itemLevelTo", (Object)levelTo, CompareType.LESS_EQUALS);
        this.filterInfo.getFilterItems().add(filterItemLevelTo);
        strMask.append(" and #").append(iIndex++);
        Integer type = new Integer(((ItemType)this.cmbxType.getSelectedItem())._value);
        FilterItemInfo filterType = new FilterItemInfo("type", (Object)type);
        this.filterInfo.getFilterItems().add(filterType);
        strMask.append(" and #").append(iIndex++);
        if (this.comboPeriodType.getSelectedItem() != null && !this.comboPeriodType.getSelectedItem().equals(selectAll)) {
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
            FilterItemInfo filterPeriodType = new FilterItemInfo("periodType", (Object)new Integer(periodType.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterPeriodType);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.cmbxAdjustStatus.getSelectedIndex() > 0) {
            AdjustStatusEnum isAdjusted = (AdjustStatusEnum)((Object)this.cmbxAdjustStatus.getSelectedItem());
            FilterItemInfo filterAdjust = new FilterItemInfo("AdjustStatus", (Object)new Integer(isAdjusted.getValue()));
            this.filterInfo.getFilterItems().add(filterAdjust);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.comboElim.getSelectedIndex() > 0) {
            int iDataSrc = ((CslDataSrcTypeEnum)((Object)this.comboElim.getSelectedItem())).getValue();
            this.filterInfo.getFilterItems().add(new FilterItemInfo("dataSource", (Object)new Integer(iDataSrc)));
            strMask.append(" and #").append(iIndex++);
        }
        if (this.bizDataType.getValue() != null) {
            DataElementInfo dataElement = (DataElementInfo)this.bizDataType.getValue();
            this.filterInfo.getFilterItems().add(new FilterItemInfo("dataElement", (Object)new Integer(dataElement.getInterSeq()), CompareType.EQUALS));
            strMask.append(" and #").append(iIndex++);
        }
        int valueType = this.btnMoney.isSelected() ? 1 : (this.btnQuantity.isSelected() ? 2 : 3);
        this.filterInfo.getFilterItems().add(new FilterItemInfo("valueType", (Object)new Integer(valueType)));
        strMask.append(" and #").append(iIndex++);
        if (!StringUtils.isEmpty((String)this.txtDynaItem.getText())) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("keyName", (Object)this.txtDynaItem.getText().trim()));
            strMask.append(" and #").append(iIndex++);
        }
        if (!this.isShowFreezeItem.isSelected()) {
            item = new FilterItemInfo("isShowFreezeItem", (Object)new Boolean(this.isShowFreezeItem.isSelected()));
            this.filterInfo.getFilterItems().add(item);
            strMask.append(" and #").append(iIndex++);
        }
        if (this.includeRecChk.isSelected()) {
            item = new FilterItemInfo("includeUnRecData", (Object)(this.includeRecChk.isSelected() ? 1 : 0));
            this.filterInfo.getFilterItems().add(item);
            strMask.append(" and #").append(iIndex++);
        }
        this.filterInfo.setMaskString(strMask.toString());
        return this.filterInfo;
    }

    private String getCollectionIDs(List l) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; l != null && i < l.size(); ++i) {
            CoreBaseInfo info = (CoreBaseInfo)l.get(i);
            if (i == 0) {
                sb.append(info.get("id"));
                continue;
            }
            sb.append(",").append(info.get("id"));
        }
        return sb.length() < 1 ? null : sb.toString();
    }

    public void clear() {
        super.clear();
        try {
            this.clearUI();
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    private void clearUI() throws BOSException {
        this.bizCompany.setData(null);
        this.bizItem.setData(null);
        this.bizItemTo.setData(null);
        this.comboCurrency.setSelectedItem((Object)selectAll);
        this.comboSourceCurrency.setSelectedItem((Object)selectAll);
        this.initDate();
        this.schemePromp.setData(null);
        if (this.isMergeByFiscalPeriod) {
            this.comboPeriodType.setEnabled(false);
            this.dpkDate.setEnabled(false);
            this.dpkDateTo.setEnabled(false);
        }
        this.comboElim.setSelectedItem((Object)selectAll);
        this.comboItemType.setSelectedItem((Object)selectAll);
        this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.spnLevel.setValue((Object)new Integer(1));
        this.spnLevelTo.setValue((Object)new Integer(1));
        this.initCmbxType(true);
        this.cmbxType.setSelectedIndex(0);
        this.btnMoney.setSelected(true);
        this.txtDynaItem.setText(null);
    }

    public CustomerParams getCustomerParams() {
        return super.getCustomerParams();
    }

    public boolean destroyWindow() {
        this.getCustomerParams();
        return super.destroyWindow();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        try {
            this.clearUI();
        }
        catch (BOSException e1) {
            super.handUIException((Throwable)e1);
        }
        super.loadData(entityViewInfo);
        boolean isDataAll = true;
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        boolean isShowFreezedItem = true;
        block10: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            RPTItemCollection itemCollection;
            FilterInfo filter;
            ReportClassInfo tmpInfo;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            String propertyName = filterItemInfo.getPropertyName();
            if (propertyName.equalsIgnoreCase("mergeSchemeId")) {
                String schemePK = (String)filterItemInfo.getCompareValue();
                if (StringUtils.isEmpty((String)schemePK)) continue;
                try {
                    this.schemePromp.setData((Object)FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(schemePK), this.getMergeShemeSelector()));
                }
                catch (Exception exception) {}
                continue;
            }
            if (propertyName.equalsIgnoreCase("orgUnitId")) {
                if (filterItemInfo.getCompareValue() instanceof LinkedHashSet) {
                    this.bizCompany.setData(null);
                    continue;
                }
                String companyID = (String)filterItemInfo.getCompareValue();
                companyID = CslRptUtil.AryToItemString(Arrays.asList(companyID.split(",")));
                try {
                    OrgUnitCollection companys = FullOrgUnitFactory.getRemoteInstance().getOrgUnitCollection("select id,number,name where id in(" + companyID + ")");
                    if (companys == null) continue;
                    this.bizCompany.setData((Object)companys.toArray());
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("reportClass")) {
                String reportClassID = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.comboItemType.getItemCount(); ++j) {
                    tmpInfo = (ReportClassInfo)this.comboItemType.getItemAt(j);
                    if (!tmpInfo.getId().toString().equals(reportClassID)) continue;
                    this.comboItemType.setSelectedItem((Object)tmpInfo);
                    continue block10;
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("rptDate")) {
                Date time = (Date)filterItemInfo.getCompareValue();
                this.dpkDate.setValue((Object)new Date(time.getTime()));
                continue;
            }
            if (propertyName.equalsIgnoreCase("rptDateTo")) {
                Date time = (Date)filterItemInfo.getCompareValue();
                this.dpkDateTo.setValue((Object)new Date(time.getTime()));
                continue;
            }
            if (propertyName.equalsIgnoreCase("targetCurrency")) {
                String currencyID = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.comboCurrency.getItemCount(); ++j) {
                    tmpInfo = (CurrencyInfo)this.comboCurrency.getItemAt(j);
                    if (!tmpInfo.getId().toString().equalsIgnoreCase(currencyID)) continue;
                    this.comboCurrency.setSelectedItem((Object)tmpInfo);
                    continue block10;
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("currency")) {
                String currencyID = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.comboSourceCurrency.getItemCount(); ++j) {
                    tmpInfo = (CurrencyInfo)this.comboSourceCurrency.getItemAt(j);
                    if (!tmpInfo.getId().toString().equalsIgnoreCase(currencyID)) continue;
                    this.comboSourceCurrency.setSelectedItem((Object)tmpInfo);
                    continue block10;
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("item")) {
                String itemNumber = (String)filterItemInfo.getCompareValue();
                EntityViewInfo entityView = new EntityViewInfo();
                entityView.getSelector().add(new SelectorItemInfo("id"));
                entityView.getSelector().add(new SelectorItemInfo("number"));
                entityView.getSelector().add(new SelectorItemInfo("name"));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)itemNumber));
                entityView.setFilter(filter);
                try {
                    itemCollection = RPTItemFactory.getRemoteInstance().getRPTItemCollection(entityView);
                    if (itemCollection.size() <= 0) continue;
                    this.bizItem.setData((Object)itemCollection.get(0));
                }
                catch (BOSException bOSException) {}
                continue;
            }
            if (propertyName.equalsIgnoreCase("itemTo")) {
                String itemNumber = (String)filterItemInfo.getCompareValue();
                EntityViewInfo entityView = new EntityViewInfo();
                entityView.getSelector().add(new SelectorItemInfo("id"));
                entityView.getSelector().add(new SelectorItemInfo("number"));
                entityView.getSelector().add(new SelectorItemInfo("name"));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)itemNumber));
                entityView.setFilter(filter);
                try {
                    itemCollection = RPTItemFactory.getRemoteInstance().getRPTItemCollection(entityView);
                    if (itemCollection.size() <= 0) continue;
                    this.bizItemTo.setData((Object)itemCollection.get(0));
                }
                catch (BOSException bOSException) {}
                continue;
            }
            if (propertyName.equalsIgnoreCase("itemLevel")) {
                Integer level = (Integer)filterItemInfo.getCompareValue();
                this.spnLevel.setValue((Object)level);
                continue;
            }
            if (propertyName.equalsIgnoreCase("itemLevelTo")) {
                Integer level = (Integer)filterItemInfo.getCompareValue();
                this.spnLevelTo.setValue((Object)level);
                continue;
            }
            if (propertyName.equalsIgnoreCase("type")) {
                Integer iSelectType = (Integer)filterItemInfo.getCompareValue();
                if (iSelectType == 1) {
                    this.cmbxType.setSelectedItem((Object)ItemTypeFactory.getInstance().getItemType(1));
                    continue;
                }
                if (iSelectType == 2) {
                    this.cmbxType.setSelectedItem((Object)ItemTypeFactory.getInstance().getItemType(2));
                    continue;
                }
                if (iSelectType == 3) {
                    this.cmbxType.setSelectedItem((Object)ItemTypeFactory.getInstance().getItemType(3));
                    continue;
                }
                if (iSelectType != 4) continue;
                this.cmbxType.setSelectedItem((Object)ItemTypeFactory.getInstance().getItemType(4));
                continue;
            }
            if (propertyName.equalsIgnoreCase("periodType")) {
                Integer periodType = (Integer)filterItemInfo.getCompareValue();
                this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.getEnum((int)periodType));
                continue;
            }
            if (propertyName.equalsIgnoreCase("AdjustStatus")) {
                Integer adjust = (Integer)filterItemInfo.getCompareValue();
                this.cmbxAdjustStatus.setSelectedItem((Object)AdjustStatusEnum.getEnum(adjust));
                continue;
            }
            if (propertyName.equalsIgnoreCase("dataSource")) {
                Integer dataSrc = (Integer)filterItemInfo.getCompareValue();
                if (dataSrc + 9 == 10) {
                    this.comboElim.setSelectedItem((Object)CslDataSrcTypeEnum.SINGLE);
                    continue;
                }
                if (dataSrc + 9 == 11) {
                    this.comboElim.setSelectedItem((Object)CslDataSrcTypeEnum.SUMMARY);
                    continue;
                }
                if (dataSrc + 9 == 12) {
                    this.comboElim.setSelectedItem((Object)CslDataSrcTypeEnum.COMBINE);
                    continue;
                }
                if (dataSrc == 4) {
                    this.comboElim.setSelectedItem((Object)CslDataSrcTypeEnum.ELIMDEBIT);
                    continue;
                }
                if (dataSrc != 5) continue;
                this.comboElim.setSelectedItem((Object)CslDataSrcTypeEnum.ELIMCREDIT);
                continue;
            }
            if (propertyName.equalsIgnoreCase("dataElement")) {
                Integer dataElement = (Integer)filterItemInfo.getCompareValue();
                this.bizDataType.setValue((Object)DataElementProvider.getDataElementInfo(dataElement));
                isDataAll = false;
                continue;
            }
            if (propertyName.equalsIgnoreCase("valueType")) {
                Integer valueType = (Integer)filterItemInfo.getCompareValue();
                if (valueType == 1) {
                    this.btnMoney.setSelected(true);
                    continue;
                }
                if (valueType == 2) {
                    this.btnQuantity.setSelected(true);
                    continue;
                }
                this.btnTxt.setSelected(true);
                continue;
            }
            if (propertyName.equalsIgnoreCase("keyName")) {
                this.txtDynaItem.setText((String)filterItemInfo.getCompareValue());
                continue;
            }
            if (propertyName.equalsIgnoreCase("isShowFreezeItem")) {
                isShowFreezedItem = false;
                continue;
            }
            if (!propertyName.equalsIgnoreCase("includeUnRecData")) continue;
            int selected = (Integer)filterItemInfo.getCompareValue();
            this.includeRecChk.setSelected(selected == 1);
        }
        this.isShowFreezeItem.setSelected(isShowFreezedItem);
    }

    private static class ItemTypeFactory {
        private static ItemTypeFactory fac;
        private static Map<Integer, ItemType> itemTypes;

        private ItemTypeFactory() {
        }

        static ItemTypeFactory getInstance() {
            if (fac == null) {
                fac = new ItemTypeFactory();
                itemTypes = new HashMap<Integer, ItemType>();
                ItemTypeFactory.initItemTypes();
            }
            return fac;
        }

        private static void initItemTypes() {
            itemTypes.put(1, new ItemType(1, selectAll));
            itemTypes.put(2, new ItemType(2, selectItem));
            itemTypes.put(3, new ItemType(3, selectElim));
            itemTypes.put(4, new ItemType(4, selectAdju));
        }

        ItemType getItemType(int indexVal) {
            return itemTypes.get(indexVal);
        }
    }

    private static class ItemType {
        int _value;
        String _displayName;

        ItemType(int value, String displayName) {
            this._value = value;
            this._displayName = displayName;
        }

        public String toString() {
            return this._displayName;
        }

        public int hashCode() {
            return this._value;
        }
    }
}

