/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tools.datatask.DatataskMode;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.util.client.EASResource;
import org.apache.log4j.Logger;

public class MyPermCheckUtil {
    private static final Logger logger = CoreUIObject.getLogger(MyPermCheckUtil.class);

    public static String[][] hasFunctionPermision(int mode, String itemNameLong) {
        String[][] result = new String[1][2];
        try {
            if (itemNameLong == null || itemNameLong.equals("")) {
                result[0][0] = "true";
                return result;
            }
            String[] itemNames = itemNameLong.trim().split(";");
            IPermission perm = PermissionFactory.getRemoteInstance();
            IPermItem iPermItem = PermItemFactory.getRemoteInstance();
            UserInfo currentUserInfo = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(currentUserInfo.getId());
            int nopermCount = 0;
            String permAlias = "";
            String orgAlias = "";
            for (int i = 0; i < itemNames.length; ++i) {
                String itemName = itemNames[i];
                PermItemInfo piInfo = iPermItem.getPermItemInfoByNumber(itemName);
                OrgType orgType = piInfo.getOrgRelation();
                if (itemName == null || itemName.equals("")) {
                    ++nopermCount;
                    continue;
                }
                ObjectUuidPK orgPK = orgType == OrgType.NONE ? new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4") : MyPermCheckUtil.getPermissionItemRelatedOrgId();
                if (orgPK != null) {
                    if (perm.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, itemName)) continue;
                    ++nopermCount;
                    permAlias = permAlias + piInfo.getAlias() + ",";
                    continue;
                }
                ++nopermCount;
                if (orgAlias.contains(orgType.toString())) continue;
                orgAlias = orgAlias + orgType.toString() + ",";
            }
            if (nopermCount > 0) {
                result[0][0] = "false";
                String s1 = "";
                String orgName = SysContext.getSysContext().getCurrentOrgUnit().getName();
                if (permAlias.endsWith(",")) {
                    permAlias = permAlias.substring(0, permAlias.length() - 1);
                    s1 = EASResourceJoinUtil.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"permissionCheck", (Object[])new Object[]{currentUserInfo.getName(), orgName, permAlias});
                }
                String s2 = "";
                if (orgAlias.endsWith(",")) {
                    orgAlias = orgAlias.substring(0, orgAlias.length() - 1);
                    s2 = EASResourceJoinUtil.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"noOrgType", (Object[])new Object[]{orgName, orgAlias});
                    if (!DatataskMode.isImpMode((int)mode)) {
                        s2 = s2.replaceAll(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"import"), EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"export"));
                    }
                }
                result[0][1] = s1 + s2;
            } else {
                result[0][0] = "true";
            }
            return result;
        }
        catch (Exception e) {
            result[0][0] = "error";
            result[0][1] = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorMessage") + ":" + e.getMessage();
            logger.error((Object)e.getMessage(), (Throwable)e);
            return result;
        }
    }

    private static ObjectUuidPK getPermissionItemRelatedOrgId() throws BOSException, EASBizException {
        OrgUnitInfo currentOrgUnit = (OrgUnitInfo)SysContext.getSysContext().getProperty((Object)"currentSelectedOrg");
        if (currentOrgUnit == null) {
            return null;
        }
        return new ObjectUuidPK(currentOrgUnit.getId().toString());
    }
}

