/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.SuperSQL;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MessageHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.OpenReport;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.treetable.ITreeTableNodeEntity;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.treetable.SetTreeTable;
import com.kingdee.eas.fi.gr.cslrpt.client.util.FillTable;
import com.kingdee.eas.fi.gr.cslrpt.util.DeleteTableRow;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.biz.query.UpdateOrgUnitByNewVersionOrgTree;
import com.kingdee.eas.fi.gr.fast.client.AbstractQueryMergeRptUI;
import com.kingdee.eas.fi.gr.fast.client.query.QueryCslReport;
import com.kingdee.eas.fi.gr.fast.client.query.ReportRowDataByTemplateOrgUnit;
import com.kingdee.eas.fi.gr.fast.client.query.TemplateAndOrgUnit;
import com.kingdee.eas.fi.gr.fast.log.ConvertToReportType;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class QueryMergeRptUI
extends AbstractQueryMergeRptUI {
    private static final long serialVersionUID = 1448966844468751045L;
    private static final Logger logger = CoreUIObject.getLogger(QueryMergeRptUI.class);
    private FastMergeSoluInfo mergeContext;

    public QueryMergeRptUI() throws Exception {
        this.report.checkParsed(false);
        this.report.getStyleAttributes().setLocked(true);
        this.report.getSelectManager().setSelectMode(2);
        if (this.getMainStatusBar() != null && this.getMainStatusBar().getStatusBar() != null) {
            this.getMainStatusBar().getStatusBar().setVisible(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        new SetTreeTable(false).exec(this.report, "companyOrReport", null, null);
        this.report.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = e.getRowIndex();
                    Object rowData = QueryMergeRptUI.this.report.getRow(row).getUserObject();
                    if (!(rowData instanceof ReportRowDataByTemplateOrgUnit) && ((ReportRowDataByTemplateOrgUnit)rowData).getReport() == null) {
                        QueryMergeRptUI.this.getMessageHandler().show(ResourceDebugUtil.res("wait.to.finish"));
                        return;
                    }
                    if (!(rowData instanceof ReportRowDataByTemplateOrgUnit) || ((ReportRowDataByTemplateOrgUnit)rowData).getReport() == null) {
                        Object companyOrReport = QueryMergeRptUI.this.report.getRow(row).getCell("companyOrReport").getUserObject();
                        if (companyOrReport instanceof ITreeTableNodeEntity && !((ITreeTableNodeEntity)companyOrReport).isLeaf()) {
                            return;
                        }
                        QueryMergeRptUI.this.getMessageHandler().show(ResourceDebugUtil.res("report.not.be.found"));
                        return;
                    }
                    try {
                        CslReportInfo report = ((ReportRowDataByTemplateOrgUnit)rowData).getReport();
                        new OpenReport().exec(report, (Object)QueryMergeRptUI.this, OprtState.EDIT);
                    }
                    catch (UIException e1) {
                        logger.error((Object)"", (Throwable)e1);
                    }
                    catch (BOSException e1) {
                        logger.error((Object)"", (Throwable)e1);
                    }
                }
            }
        });
        this.mergeContext = (FastMergeSoluInfo)this.getUIContext().get(FastMergeSoluInfo.class);
        if (this.mergeContext == null) {
            throw new BOSException("uicontext's error!please check. ");
        }
        this.setUITitle(ResourceDebugUtil.res("show.report"));
        CslRptUIUtil.setSpineRange(this.year, 1974, Integer.MAX_VALUE);
        CslRptUIUtil.setSpineRange(this.period, 1, 366);
        this.year.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    if (!(QueryMergeRptUI.this.year.getValue() instanceof Integer)) {
                        QueryMergeRptUI.this.getMessageHandler().show(ResourceDebugUtil.res("error.for.setting.year"));
                    }
                    QueryMergeRptUI.this.loadItemValue();
                }
                catch (EASBizException e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
                catch (BOSException e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
            }
        });
        this.period.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    if (!(QueryMergeRptUI.this.period.getValue() instanceof Integer)) {
                        QueryMergeRptUI.this.getMessageHandler().show(ResourceDebugUtil.res("error.for.setting.period"));
                    }
                    QueryMergeRptUI.this.loadItemValue();
                }
                catch (EASBizException e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
                catch (BOSException e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
            }
        });
        this.loadFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        RptPeriodTypeEnum periodType = this.getPeriodType();
        int[] yearAndPeriod = RPTDateUtil.getPeriod(new Date(), periodType);
        if (yearAndPeriod != null && yearAndPeriod.length == 2) {
            this.year.setValue((Object)yearAndPeriod[0], false);
            this.period.setValue((Object)yearAndPeriod[1], false);
        } else {
            this.year.setValue((Object)2013, false);
            this.period.setValue((Object)1, false);
        }
        this.periodType.setText(periodType.getAlias());
        this.currency.setText(this.mergeContext.getCurrency().getName());
        try {
            this.loadItemValue();
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void loadItemValue() throws EASBizException, BOSException {
        this.report.removeRows();
        FullOrgUnitInfo company = null;
        TemplateInfo template = null;
        FillTable fill = new FillTable(this.report, new String[]{"companyOrReport", "reportType"});
        int currRow = -1;
        ReportRowDataByTemplateOrgUnit rowData = null;
        HashSet<LazyFillReportCondition> conditions = new HashSet<LazyFillReportCondition>();
        int size = this.mergeContext.getOrgUnits().size();
        for (int companyIndex = 0; companyIndex < size; ++companyIndex) {
            company = this.mergeContext.getOrgUnits().get(companyIndex).getOrgUnit();
            fill.save(new ReportRowDataByTemplateOrgUnit(null, company, null), ++currRow);
            for (int templateIndex = 0; templateIndex < this.mergeContext.getTemplates().size(); ++templateIndex) {
                template = this.mergeContext.getTemplates().get(templateIndex).getTemplate();
                rowData = new ReportRowDataByTemplateOrgUnit(template, company, new ConvertToReportType().exec(template.getTemplateType()));
                fill.save(rowData, ++currRow);
                conditions.add(new LazyFillReportCondition(company, template, rowData, currRow));
            }
        }
        this.lazyFillReport(conditions, fill);
    }

    protected void lazyFillReport(final Collection<LazyFillReportCondition> conditions, final FillTable fill) throws EASBizException, BOSException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Collection<CslReportInfo> reports = null;
                try {
                    DBHandler dao = new DBHandler(null);
                    HashSet<Integer> commitTypes = new HashSet<Integer>(4);
                    ArrayList<TemplateAndOrgUnit> tempOrOrgUnits = new ArrayList<TemplateAndOrgUnit>();
                    new UpdateOrgUnitByNewVersionOrgTree(dao).exec(QueryMergeRptUI.this.mergeContext.getOrgUnits(), QueryMergeRptUI.this.mergeContext.getOrgBound(), (Integer)QueryMergeRptUI.this.year.getValue(Integer.class), (Integer)QueryMergeRptUI.this.period.getValue(Integer.class), QueryMergeRptUI.this.getPeriodType());
                    for (int tIndex = 0; tIndex < QueryMergeRptUI.this.mergeContext.getTemplates().size(); ++tIndex) {
                        for (int orgIndex = 0; orgIndex < QueryMergeRptUI.this.mergeContext.getOrgUnits().size(); ++orgIndex) {
                            if (QueryMergeRptUI.this.mergeContext.getTemplates().get(tIndex) == null) continue;
                            tempOrOrgUnits.add(new TemplateAndOrgUnit(QueryMergeRptUI.this.mergeContext.getTemplates().get(tIndex).getTemplate(), QueryMergeRptUI.this.mergeContext.getOrgUnits().get(orgIndex).getOrgUnit()));
                        }
                    }
                    SuperSQL soluLimit = null;
                    if (!QueryMergeRptUI.this.mergeContext.isIsSupportGroupReport()) {
                        commitTypes.add(31);
                        commitTypes.add(34);
                        commitTypes.add(33);
                        commitTypes.add(35);
                        commitTypes.add(32);
                        soluLimit = new SuperSQL("and ffastmergesoluid = ? ");
                        soluLimit.set(new Object[0], new Object[]{QueryMergeRptUI.this.mergeContext.getId().toString()});
                    } else {
                        commitTypes.add(2);
                        commitTypes.add(3);
                        commitTypes.add(4);
                        commitTypes.add(12);
                        commitTypes.add(11);
                    }
                    reports = new QueryCslReport(dao).exec((Integer)QueryMergeRptUI.this.year.getValue(Integer.class), (Integer)QueryMergeRptUI.this.period.getValue(Integer.class), QueryMergeRptUI.this.getPeriodType(), QueryMergeRptUI.this.mergeContext.getCurrency().getId().toString(), tempOrOrgUnits.iterator(), null, commitTypes, soluLimit);
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                    this.error(ResourceDebugUtil.res("fail.to.query") + ":" + e.getMessage());
                    return;
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    this.error(ResourceDebugUtil.res("fail.to.query") + ":" + e.getMessage());
                    return;
                }
                HashMap<String, CslReportInfo> cacheReports = new HashMap<String, CslReportInfo>(reports.size());
                String key = null;
                for (CslReportInfo report : reports) {
                    key = report.getOrgUnit().getNumber() + "|" + report.getTemplate().getTemplateType().getValue() + "|" + report.getTemplate().getNumber();
                    cacheReports.put(key, report);
                }
                CslReportInfo rowReport = null;
                DeleteTableRow delete = new DeleteTableRow(QueryMergeRptUI.this.report);
                for (LazyFillReportCondition condition : conditions) {
                    key = condition.getCompany().getNumber() + "|" + condition.getTemplate().getTemplateType().getValue() + "|" + condition.getTemplate().getNumber();
                    rowReport = (CslReportInfo)cacheReports.get(key);
                    if (rowReport == null) {
                        delete.addRow(condition.getCurrRow());
                        continue;
                    }
                    condition.getRowData().setReport(rowReport);
                    fill.save(condition.getRowData(), condition.getCurrRow());
                }
                delete.delete();
            }

            public void error(String error) {
                DeleteTableRow delete = new DeleteTableRow(QueryMergeRptUI.this.report);
                for (LazyFillReportCondition condition : conditions) {
                    delete.addRow(condition.getCurrRow());
                }
                delete.delete();
            }
        }).start();
    }

    protected RptPeriodTypeEnum getPeriodType() {
        RptPeriodTypeEnum periodType;
        try {
            periodType = this.mergeContext.getTemplates().get(0).getTemplate().getPeriodType();
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            periodType = RptPeriodTypeEnum.MONTHLY;
        }
        return periodType;
    }

    protected MessageHandler getMessageHandler() {
        return new MessageHandler(1);
    }

    private static class LazyFillReportCondition {
        private FullOrgUnitInfo company;
        private TemplateInfo template;
        private ReportRowDataByTemplateOrgUnit rowData;
        private int currRow;

        public LazyFillReportCondition(FullOrgUnitInfo company, TemplateInfo template, ReportRowDataByTemplateOrgUnit rowData, int currRow) {
            this.company = company;
            this.template = template;
            this.rowData = rowData;
            this.currRow = currRow;
        }

        public FullOrgUnitInfo getCompany() {
            return this.company;
        }

        public TemplateInfo getTemplate() {
            return this.template;
        }

        public ReportRowDataByTemplateOrgUnit getRowData() {
            return this.rowData;
        }

        public int getCurrRow() {
            return this.currRow;
        }
    }
}

