/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluType;
import com.kingdee.eas.fi.gr.fast.FastMergeTemplateCollection;
import com.kingdee.eas.fi.gr.fast.FastRptException;
import com.kingdee.eas.fi.gr.fast.IFastMergeSolu;
import com.kingdee.eas.fi.gr.fast.client.AbstractSimulationMergeEditUI;
import com.kingdee.eas.fi.gr.fast.client.CslViewUI;
import com.kingdee.eas.fi.gr.fast.util.CombineValidateException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class SimulationMergeEditUI
extends AbstractSimulationMergeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SimulationMergeEditUI.class);

    public SimulationMergeEditUI() throws Exception {
        this.tblTplUnit.checkParsed(false);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveBegin.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMoveEnd.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAddTpl.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelTpl.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.kDIsContainUnReceive.setSelected(true);
        } else {
            this.kDIsContainUnReceive.setSelected(this.editData.isIsContainUnRecive());
        }
        this.kDTabbedPane1.remove(0);
        this.initWorkButtonByCreator();
        this.kDbSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.kDbClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        String simulationMergeName = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SimulationMergeName");
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(simulationMergeName + this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(simulationMergeName + this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
        } else {
            this.setUITitle(simulationMergeName + this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
        }
        this.combineView.setEnabled(true);
    }

    private void initWorkButtonByCreator() throws Exception {
        String fastMergeSoluId;
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (this.editData != null && this.editData.getId() != null && !StringUtils.isEmpty((String)(fastMergeSoluId = this.editData.getId().toString()))) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("creator.id");
            FastMergeSoluInfo soluInfo = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selectors);
            String creatorId = soluInfo.getCreator().getId().toString();
            if (!userId.equals(creatorId)) {
                this.btnEdit.setEnabled(false);
            }
        }
        this.txtNumber.setMaxLength(80);
        this.txtName.setMaxLength(255);
        this.txtDes.setMaxLength(255);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.FastMergeStoreFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fastMergeLoadFields();
        this.kDpSingleDataSolution.setEnabled(true);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return this.getFastMergeSelectors();
    }

    @Override
    public void checkEditData() throws Exception {
        String errorMsg;
        FastMergeTemplateCollection tpls;
        ArrayList<EASBizException> exceptions = new ArrayList<EASBizException>();
        if (StringUtil.isEmpty((String)this.editData.getNumber())) {
            exceptions.add(new FastRptException(FastRptException.NUMBER_ISBLANK));
        }
        if (StringUtil.isEmpty((String)this.editData.getName())) {
            exceptions.add(new FastRptException(FastRptException.NAME_ISBLANK));
        }
        if (this.editData.getOrgBound() == null) {
            exceptions.add(new FastRptException(FastRptException.ORGBOUND_ISBLANK));
        } else if (this.editData.isIsSupportGroupReport() && this.editData.getOrgBound().getLayerType() == OrgViewType.PROFITCENTER) {
            exceptions.add(new FastRptException(FastRptException.ORGBOUND_UNSUITABLE));
        }
        if (this.editData.getOrgUnits() == null || this.editData.getOrgUnits().size() == 0) {
            exceptions.add(new FastRptException(FastRptException.ORGUNIT_ISBLANK));
        }
        if ((tpls = this.editData.getTemplates()) == null || tpls.isEmpty()) {
            exceptions.add(new FastRptException(FastRptException.TEMPLATE_ISBLANK));
        } else {
            RptPeriodTypeEnum samePeriodType = null;
            try {
                if (!tpls.isEmpty()) {
                    samePeriodType = tpls.get(0).getTemplate().getPeriodType();
                }
                int size = tpls.size();
                for (int i = 1; i < size; ++i) {
                    if (tpls.get(i).getTemplate().getPeriodType() == samePeriodType) continue;
                    exceptions.add(new FastRptException(FastRptException.TMPPERIOD_ISNOTSAME));
                    break;
                }
            }
            catch (NullPointerException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        if (!StringUtil.isEmpty((String)this.editData.getNumber()) && !StringUtils.isEmpty((String)(errorMsg = this.checkNumberDup((IObjectValue)this.editData, false, FastMergeSoluFactory.getRemoteInstance())))) {
            exceptions.add(new FastRptException(FastRptException.NUMBER_ISDUP, new Object[]{errorMsg}));
        }
        if (!StringUtil.isEmpty((String)this.editData.getName()) && !StringUtils.isEmpty((String)(errorMsg = this.checkNameDup((IObjectValue)this.editData, false, FastMergeSoluFactory.getRemoteInstance())))) {
            exceptions.add(new FastRptException(FastRptException.NAME_ISDUP, new Object[]{errorMsg}));
        }
        if (!exceptions.isEmpty()) {
            throw new CombineValidateException(exceptions);
        }
    }

    @Override
    public boolean compareEditData(FastMergeSoluInfo old_editData, FastMergeSoluInfo new_editData) {
        if (old_editData == null && new_editData == null) {
            return false;
        }
        if (old_editData != null && new_editData != null) {
            if (!StringUtils.equals((String)old_editData.getName(), (String)new_editData.getName())) {
                return true;
            }
            if (!StringUtils.equals((String)old_editData.getNumber(), (String)new_editData.getNumber())) {
                return true;
            }
            if (!StringUtils.equals((String)old_editData.getCurrency().getId().toString(), (String)new_editData.getCurrency().getId().toString())) {
                return true;
            }
            if (!old_editData.isIsAutoDispatch() == new_editData.isIsAutoDispatch()) {
                return true;
            }
            if (!old_editData.isIsCurrentPeriod() == new_editData.isIsCurrentPeriod()) {
                return true;
            }
            if (!StringUtils.equals((String)old_editData.getDescription(), (String)new_editData.getDescription())) {
                return true;
            }
            if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getOrgBound(), (AbstractObjectValue)new_editData.getOrgBound())) {
                return true;
            }
            if (new_editData.getAutoItemFormual() != null && !ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getAutoItemFormual(), (AbstractObjectValue)new_editData.getAutoItemFormual())) {
                return true;
            }
            if (!old_editData.isIsAutoSum() == new_editData.isIsAutoSum()) {
                return true;
            }
            if (!old_editData.isIsSupportGroupReport() == new_editData.isIsSupportGroupReport()) {
                return true;
            }
            if (!old_editData.isIsContainUnRecive() == new_editData.isIsContainUnRecive()) {
                return true;
            }
            if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getAdjustEntrySolu(), (AbstractObjectValue)new_editData.getAdjustEntrySolu())) {
                return true;
            }
            if (!old_editData.isIsAutoSum() && !ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getElimEntrySolu(), (AbstractObjectValue)new_editData.getElimEntrySolu())) {
                return true;
            }
            if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getOrgBound(), (AbstractObjectValue)new_editData.getOrgBound())) {
                return true;
            }
        }
        return false;
    }

    private String getExistFastMergeSoluInfo(String keyCon, String valueTxt, FastMergeSoluType isAutoSum) throws Exception {
        String rtnTxt = null;
        FastMergeSoluInfo existFastMergeSoluInfo = null;
        IFastMergeSolu iFastMergeSolu = (IFastMergeSolu)this.getBizInterface();
        existFastMergeSoluInfo = iFastMergeSolu.getFastMergeSoluInfo("where " + keyCon + "='" + valueTxt + "' and isautosum=" + isAutoSum.getValue());
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        rtnTxt = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(existFastMergeSoluInfo.getOrganUnit().getId())).getName();
        return rtnTxt;
    }

    private String checkNumberDup(IObjectValue model, boolean isOrgFilter, IFastMergeSolu corebase) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        FilterItemInfo filterItem0 = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        int formulaIndex = 0;
        filter.getFilterItems().add(filterItem0);
        sbFormula.append(" #" + formulaIndex++);
        if (dataBaseInfo.getId() != null) {
            FilterItemInfo filterItem1 = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem1);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (isOrgFilter) {
            FilterItemInfo filterItem2 = new FilterItemInfo("organUnit.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
        }
        FilterItemInfo filterItem3 = new FilterItemInfo("isautosum", dataBaseInfo.get("isautosum"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem3);
        sbFormula.append(" #" + formulaIndex++);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("organUnit.name");
        viewInfo.setSelector(coll);
        viewInfo.setFilter(filter);
        FastMergeSoluCollection fastColl = corebase.getFastMergeSoluCollection(viewInfo);
        if (fastColl != null && fastColl.size() > 0) {
            return fastColl.get(0).getOrganUnit().getName();
        }
        return null;
    }

    private String checkNameDup(IObjectValue model, boolean isOrgFilter, IFastMergeSolu corebase) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        FilterItemInfo filterItem0 = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        int formulaIndex = 0;
        filter.getFilterItems().add(filterItem0);
        sbFormula.append(" #" + formulaIndex++);
        if (dataBaseInfo.getId() != null) {
            FilterItemInfo filterItem1 = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem1);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (isOrgFilter) {
            FilterItemInfo filterItem2 = new FilterItemInfo("organUnit.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
        }
        FilterItemInfo filterItem3 = new FilterItemInfo("isautosum", dataBaseInfo.get("isautosum"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem3);
        sbFormula.append(" #" + formulaIndex++);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("organUnit.name");
        viewInfo.setSelector(coll);
        viewInfo.setFilter(filter);
        FastMergeSoluCollection fastColl = corebase.getFastMergeSoluCollection(viewInfo);
        if (fastColl != null && fastColl.size() > 0) {
            return fastColl.get(0).getOrganUnit().getName();
        }
        return null;
    }

    @Override
    public void actionCombineView_actionPerformed(ActionEvent e) throws Exception {
        UIContext context = new UIContext((Object)this);
        context.put((Object)"solutionName", this.txtName.getSelectedItemData());
        if (this.bizOrgBound.getData() != null) {
            context.put((Object)"orgTreeId", (Object)((OrgTreeInfo)this.bizOrgBound.getData()).getId().toString());
            this.storeUnitEntries();
            FastMergeOrgUnitCollection coll = new FastMergeOrgUnitCollection();
            FastMergeOrgUnitInfo info = null;
            for (int i = 0; i < this.tblTplUnit.getRowCount(); ++i) {
                info = (FastMergeOrgUnitInfo)this.tblTplUnit.getRow(i).getUserObject();
                if (info == null) continue;
                info.setIsSelected((Boolean)this.tblTplUnit.getRow(i).getCell("choose").getValue());
                coll.add(info);
            }
            if (coll.size() > 0) {
                context.put((Object)"isSupportGroupReport", (Object)this.isSupportGroupReport.isSelected());
                context.put((Object)"orgUnitColl", (Object)coll);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CslViewUI.class.getName(), (Map)context, null, OprtState.VIEW);
                uiWindow.show();
            }
        }
    }
}

