/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client.f7;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptCalculateGuideUI;
import com.kingdee.eas.fi.gr.fast.client.f7.MnsAndDynaCslRptCalGuideUI;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptSumTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;

public class QuerySolutionPromptBox
extends KDCommonPromptDialog {
    private static final long serialVersionUID = 7523412446148678972L;
    private boolean isDyna;
    private boolean isSum;
    private CslReportInfo reportInfo;
    private IUIObject owner;
    private boolean canceled = true;
    private Object data = null;

    public QuerySolutionPromptBox(boolean isDyna, boolean isSum) {
        this.isDyna = isDyna;
        this.isSum = isSum;
    }

    protected void dialogInit() {
        super.dialogInit();
        try {
            Field field = KDCommonPromptDialog.class.getDeclaredField("myCommonUseTable");
            if (field != null) {
                NewRptUtil.makeAccessible((Field)field);
                KDTable curMyCommonUseTable = (KDTable)field.get((Object)this);
                if (curMyCommonUseTable != null) {
                    curMyCommonUseTable.getColumn("number").getStyleAttributes().setHided(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public QuerySolutionPromptBox(IUIObject owner, boolean isDyna, boolean isSum, OrgTreeInfo orgTree, FullOrgUnitInfo orgUnit) {
        this.isDyna = isDyna;
        this.isSum = isSum;
        this.owner = owner;
        this.initReport(orgTree, orgUnit);
    }

    protected void benMaintainObject_actionPerformed(ActionEvent e) {
        try {
            if (this.isSum) {
                this.openSumGuideUI();
            } else {
                this.openCslGuideUI();
            }
        }
        catch (Exception be) {
            ExceptionHandler.handle((Throwable)be);
        }
    }

    private void openCslGuideUI() throws Exception {
        MnsAndDynaCslRptCalGuideUI ui = new MnsAndDynaCslRptCalGuideUI(this.owner, this.reportInfo, null);
        ui.setSettingGuide(false);
        boolean bl = this.canceled = !ui.show();
        if (!this.canceled) {
            this.data = ui.getCurrentSolutionInfo();
        }
    }

    private void openSumGuideUI() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"CslReport", (Object)this.reportInfo);
        Book book = Book.Manager.getNewBook((String)"Sheet1", (int)1);
        book.setCalculate(false);
        uiContext.put((Object)"Sheets", (Object)book);
        uiContext.put((Object)"isFastMerge", (Object)Boolean.TRUE);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SumRptCalculateGuideUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.canceled = ((SumRptCalculateGuideUI)uiWindow.getUIObject()).isCancel();
        if (!this.canceled) {
            this.data = ((SumRptCalculateGuideUI)uiWindow.getUIObject()).getSelectedSumSchmInfo();
        }
    }

    private void initReport(OrgTreeInfo orgTree, FullOrgUnitInfo orgUnit) {
        this.reportInfo = new CslReportInfo();
        this.reportInfo.setOrgTree(orgTree);
        this.reportInfo.setOrgUnit(orgUnit);
        Date reportDate = new Date();
        try {
            reportDate = CslRptUIUtil.getLastPeriodDate(CSLContext.getInstance().getCurReportDate());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.reportInfo.setReportDate(reportDate);
        TemplateInfo tmpInfo = new TemplateInfo();
        tmpInfo.setSumType(RptSumTypeEnum.BYITEM);
        this.reportInfo.setTemplate(tmpInfo);
        if (this.isDyna) {
            this.reportInfo.setSourceType(RptSrcTypeEnum.DYNAMICSUMREPORT);
            TemplateInfo tmp = new TemplateInfo();
            tmp.setDynaRptType(DynaEnumRptTypeEnum.DYNAMIC);
            this.reportInfo.setTemplate(tmp);
        } else {
            this.reportInfo.setSourceType(RptSrcTypeEnum.SUM);
            TemplateInfo tmp = new TemplateInfo();
            tmp.setDynaRptType(DynaEnumRptTypeEnum.FIXED);
            this.reportInfo.setTemplate(tmp);
        }
    }

    public Object getData() {
        IObjectValue obj;
        if (this.isSum && this.data != null && this.data instanceof IObjectValue && !(obj = (IObjectValue)this.data).containsKey("name") && obj.containsKey("schmname")) {
            obj.put("name", obj.get("schmname"));
        }
        return this.data;
    }

    public String getTitle() {
        if (this.isSum) {
            return super.getTitle();
        }
        return EASResource.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)"62_cslSolution");
    }

    public void show() {
        try {
            if (this.isSum) {
                this.openSumGuideUI();
            } else {
                this.openCslGuideUI();
            }
        }
        catch (Exception be) {
            ExceptionHandler.handle((Throwable)be);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

