/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.SuperSQL;
import com.kingdee.eas.fi.gr.fast.client.query.TemplateAndOrgUnit;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class QueryCslReport {
    private DBHandler dao;

    public QueryCslReport(DBHandler dao) {
        this.dao = dao;
    }

    public Collection<CslReportInfo> exec(int year, int period, RptPeriodTypeEnum periodType, String currency, Iterator<TemplateAndOrgUnit> it, SelectorItemCollection selector, Set<Integer> sourceTypes, SuperSQL extraLimit) throws EASBizException, BOSException {
        HashSet<CslReportInfo> reports = new HashSet<CslReportInfo>(1);
        FilterInfo filter = new FilterInfo();
        StringBuffer mask = new StringBuffer();
        int maskIndex = 0;
        filter.appendFilterItem("report.fyear", (Object)year);
        mask.append("#" + maskIndex++);
        filter.appendFilterItem("report.fperiod", (Object)period);
        mask.append(" and #" + maskIndex++);
        filter.appendFilterItem("report.fperiodType", (Object)periodType.getValue());
        mask.append(" and #" + maskIndex++);
        filter.appendFilterItem("report.fcurrencyid", (Object)currency);
        mask.append(" and #" + maskIndex++);
        filter.getFilterItems().add(new FilterItemInfo("report.fsourceType", sourceTypes, CompareType.INCLUDE));
        mask.append(" and #" + maskIndex++);
        TemplateAndOrgUnit templateAndCompany = null;
        StringBuffer tplAndCompMask = new StringBuffer();
        String joinChar = " OR ";
        while (it.hasNext()) {
            templateAndCompany = it.next();
            tplAndCompMask.append(joinChar);
            filter.appendFilterItem("template.fnumber", (Object)templateAndCompany.getTemplate().getNumber());
            tplAndCompMask.append(" ( #" + maskIndex++);
            filter.appendFilterItem("template.FTemplateType", (Object)templateAndCompany.getTemplate().getTemplateType().getValue());
            tplAndCompMask.append(" AND #" + maskIndex++);
            filter.appendFilterItem("report.forgUnitid", (Object)templateAndCompany.getOrgUnit().getId().toString());
            tplAndCompMask.append(" AND #" + maskIndex++);
            tplAndCompMask.append(" ) ");
        }
        if (tplAndCompMask.length() == 0) {
            return reports;
        }
        mask.append(" and ( " + tplAndCompMask.substring(joinChar.length()) + " ) ");
        filter.setMaskString(mask.toString());
        FileSQL sqlFile = new FileSQL("com/kingdee/eas/fi/gr/fast/client/query/query_csl_report.sql");
        SuperSQL sql = new SuperSQL(sqlFile.sql());
        Object extraSql = extraLimit;
        if (extraSql == null) {
            extraSql = "";
        }
        sql.set(new Object[]{filter.toSql(), extraSql}, new Object[0]);
        IRowSet data = this.dao.getExecuteSQL().executeQuery(sql.sql(), sql.params());
        if (data.size() == 0) {
            return reports;
        }
        HashSet<String> ids = new HashSet<String>(data.size());
        try {
            while (data.next()) {
                ids.add(data.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        FilterInfo detailFilter = new FilterInfo();
        detailFilter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(detailFilter);
        if (selector == null) {
            selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("name");
            selector.add("number");
            selector.add("sourceType");
            selector.add("auditedStatus");
            selector.add("template.id");
            selector.add("template.number");
            selector.add("template.templateType");
            selector.add("orgUnit.id");
            selector.add("orgUnit.number");
            selector.add("orgTree.id");
            selector.add("orgTree.number");
        }
        view.setSelector(selector);
        CslReportCollection reportInfos = this.dao.get(ICslReport.class).getCslReportCollection(view);
        for (int i = 0; i < reportInfos.size(); ++i) {
            reports.add(reportInfos.get(i));
        }
        return reports;
    }
}

