/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogStatus;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.AutoItemLog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.FormulaCalcSimpleReport;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.thread.ILogThread;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.thread.LogThread;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.ExecuteSQL;
import com.kingdee.eas.fi.gr.cslrpt.client.LazyShowName;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.fast.AutoMergeLogFactory;
import com.kingdee.eas.fi.gr.fast.AutoMergeLogInfo;
import com.kingdee.eas.fi.gr.fast.IAutoMergeLog;
import com.kingdee.eas.fi.gr.fast.log.AutoMergeNodeReport;
import com.kingdee.eas.fi.gr.fast.log.AutoMergeReport;
import com.kingdee.eas.fi.gr.fast.log.CompanyInOrgUnit;
import com.kingdee.eas.fi.gr.fast.log.LazyAddNewInfoTask;
import com.kingdee.eas.fi.gr.fast.log.QueryName;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class AutoMergeLog {
    private Context ctx;
    private String mergeContextId;
    private IAutoMergeLog logDao;
    private static ILogThread logThread = new LogThread();
    private String executeTaskId;
    private int year;
    private int period;
    public LinkedBlockingQueue<AutoMergeLogInfo> queue = null;
    public AtomicInteger threadCount = new AtomicInteger(0);

    public AutoMergeLog(Context ctx, String mergeContextId, String executeTaskId, int year, int period) {
        this.ctx = ctx;
        this.mergeContextId = mergeContextId;
        this.executeTaskId = executeTaskId;
        this.year = year;
        this.period = period;
    }

    public AutoMergeLog(Context ctx, String mergeContextId, String executeTaskId) {
        this.ctx = ctx;
        this.mergeContextId = mergeContextId;
        this.executeTaskId = executeTaskId;
    }

    public AutoMergeLog(Context ctx, String mergeContextId) {
        this.ctx = ctx;
        this.mergeContextId = mergeContextId;
    }

    public void start() {
        try {
            logThread.start();
            this.delete();
            AutoMergeLogInfo info = new AutoMergeLogInfo();
            info.setError("0");
            info.setMergeContext(this.mergeContextId);
            info.setNodeType(0);
            info.setStartTime(new Timestamp(System.currentTimeMillis()));
            info.setTaskId(this.executeTaskId);
            info.setYear(this.year);
            info.setPeriod(this.period);
            this.addnewAtOnce(info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void end() {
        logThread.execBatch();
        try {
            AutoMergeLogInfo info = new AutoMergeLogInfo();
            info.setError("100");
            info.setMergeContext(this.mergeContextId);
            info.setNodeType(0);
            info.setEndTime(new Timestamp(System.currentTimeMillis()));
            info.setTaskId(this.executeTaskId);
            this.update(info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logThread.end();
    }

    public void processing(int progressNum) {
        try {
            AutoMergeLogInfo info = new AutoMergeLogInfo();
            info.setError(progressNum + "");
            info.setMergeContext(this.mergeContextId);
            info.setNodeType(0);
            info.setTaskId(this.executeTaskId);
            this.update(info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void update(AutoMergeLogInfo info) throws BOSException {
        if (this.queue == null) {
            this.updateLog(info);
        } else {
            this.queue.add(info);
        }
    }

    private void updateLog(AutoMergeLogInfo info) throws BOSException {
        DBHandler dao = new DBHandler(this.ctx);
        StringBuffer updateProcessSQL = new StringBuffer();
        updateProcessSQL.append(" UPDATE T_CSL_AutoMergeLog \n");
        updateProcessSQL.append(" SET  FError_" + dao.getLocale() + " = ? \n");
        updateProcessSQL.append(" ,  FEndTime = ? \n");
        updateProcessSQL.append(" ,  FTaskId = ? \n");
        updateProcessSQL.append(" WHERE FMergeContext = ? \n");
        updateProcessSQL.append(" AND \tFNodeType = 0 \n");
        DbUtil.execute((Context)this.ctx, (String)updateProcessSQL.toString(), (Object[])new Object[]{info.getError(), info.getEndTime(), info.getTaskId(), info.getMergeContext()});
    }

    public void createThread() throws BOSException {
        if (this.threadCount.get() <= 0) {
            this.queue = new LinkedBlockingQueue();
            Thread update = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            block3: while (true) {
                                AutoMergeLogInfo info;
                                if ((info = AutoMergeLog.this.queue.poll()) != null) {
                                    AutoMergeLog.this.updateLog(info);
                                }
                                while (true) {
                                    if (!AutoMergeLog.this.queue.isEmpty()) continue block3;
                                    1.sleep(50L);
                                }
                                break;
                            }
                        }
                        catch (Throwable ex) {
                            Logger.error((Throwable)ex, (String)"update error.");
                            continue;
                        }
                        break;
                    }
                }
            };
            update.start();
        }
    }

    private void delete() throws BOSException {
        StringBuffer updateProcessSQL = new StringBuffer();
        updateProcessSQL.append(" DELETE FROM T_CSL_AutoMergeLog \n");
        updateProcessSQL.append(" WHERE FMergeContext = ? \n");
        new DBHandler(this.ctx).getExecuteSQL().execute(updateProcessSQL.toString(), new Object[]{this.mergeContextId});
    }

    private void addnewAtOnce(AutoMergeLogInfo info) throws BOSException {
        this.getDao().addnew(info);
    }

    private void addnew(AutoMergeLogInfo info) throws BOSException {
        LazyAddNewInfoTask task = new LazyAddNewInfoTask();
        task.setParams(info, this.getDao());
        logThread.addForBatch(task);
    }

    public void adaptEntry(String orgUnitId, String directSubCompanyId, String errorDetail, boolean isSuccess) {
        try {
            AutoMergeLogInfo info = new AutoMergeLogInfo();
            info.setOrgUnit(orgUnitId);
            info.setCompany(directSubCompanyId);
            info.setError(errorDetail);
            info.setMergeContext(this.mergeContextId);
            info.setNodeType(2);
            info.setStatus(isSuccess);
            info.setTaskId(this.executeTaskId);
            this.addnew(info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void sumReport(String orgUnitId, String sumTemplateId, String errorDetail, boolean isSuccess) {
        try {
            AutoMergeLogInfo info = new AutoMergeLogInfo();
            info.setOrgUnit(orgUnitId);
            info.setCompany(null);
            info.setTemplate(sumTemplateId);
            if (errorDetail.indexOf("#") > 0) {
                String[] msg = errorDetail.split("#");
                info.setError(msg[0]);
                info.setDetail(msg[1]);
            } else {
                info.setError(errorDetail);
            }
            info.setMergeContext(this.mergeContextId);
            info.setNodeType(3);
            info.setStatus(isSuccess);
            info.setTaskId(this.executeTaskId);
            this.addnew(info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void elimEntry(String orgUnitId, String errorDetail, boolean isSuccess) {
        try {
            AutoMergeLogInfo info = new AutoMergeLogInfo();
            info.setOrgUnit(orgUnitId);
            info.setCompany(null);
            info.setTemplate(null);
            if (!StringUtils.isEmpty((String)errorDetail) && errorDetail.toCharArray().length > 255) {
                char[] cs = errorDetail.toCharArray();
                char[] newCs = new char[249];
                for (int i = 0; i < 249; ++i) {
                    newCs[i] = cs[i];
                }
                info.setError(String.valueOf(newCs) + "...");
            } else {
                info.setError(errorDetail);
            }
            info.setMergeContext(this.mergeContextId);
            info.setNodeType(4);
            info.setStatus(isSuccess);
            info.setTaskId(this.executeTaskId);
            this.addnew(info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cslReport(String orgUnitId, String cslTemplateId, String errorDetail, boolean isSuccess) {
        try {
            AutoMergeLogInfo info = new AutoMergeLogInfo();
            info.setOrgUnit(orgUnitId);
            info.setCompany(null);
            info.setTemplate(cslTemplateId);
            if (errorDetail.indexOf("#") > 0) {
                String[] msg = errorDetail.split("#");
                info.setError(msg[0]);
                info.setDetail(msg[1]);
            } else {
                info.setError(errorDetail);
            }
            info.setMergeContext(this.mergeContextId);
            info.setNodeType(5);
            info.setStatus(isSuccess);
            info.setTaskId(this.executeTaskId);
            this.addnew(info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AutoMergeReport queryReport() throws BOSException, EASBizException {
        String mergeContextName = null;
        String autoItemContextId = null;
        ArrayList<AutoMergeNodeReport> nodeReports = new ArrayList<AutoMergeNodeReport>(10);
        DBHandler dao = new DBHandler(this.ctx);
        ExecuteSQL executeSQL = dao.getExecuteSQL();
        Locale locale = SysContext.getSysContext().getLocale();
        StringBuffer updateProcessSQL = new StringBuffer();
        updateProcessSQL.append(" SELECT FName_" + locale.toString() + " name,FAutoItemFormualID autoitem FROM T_CSL_FastMergeSolu \n");
        updateProcessSQL.append(" WHERE Fid = ? \n");
        IRowSet rs = executeSQL.executeQuery(updateProcessSQL.toString(), new Object[]{this.mergeContextId});
        if (rs.size() == 0) {
            return null;
        }
        try {
            while (rs.next()) {
                mergeContextName = rs.getString("name");
                autoItemContextId = rs.getString("autoitem");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        Object autoItemLogStatus = "";
        if (BOSUuid.isValid(autoItemContextId, (boolean)true)) {
            FormulaCalcContextInfo autoItemContextInfo = new FormulaCalcContextInfo();
            autoItemContextInfo.setId(BOSUuid.read((String)autoItemContextId));
            FormulaCalcSimpleReport autoitemReport = new AutoItemLog(new DBHandler(null), autoItemContextInfo, this.executeTaskId, null).getReport(false);
            List<FormulaCalcLogInfo> logs = autoitemReport.detailFormat(false);
            for (FormulaCalcLogInfo log : logs) {
                if (log.getTemplate() == null || log.getCompany() == null) continue;
                autoItemLogStatus = "";
                if (FormulaCalcLogStatus.FAILURE.equals((Object)log.getStatus()) || FormulaCalcLogStatus.SUCCESS.equals((Object)log.getStatus())) {
                    autoItemLogStatus = FormulaCalcLogStatus.SUCCESS.equals((Object)log.getStatus());
                }
                AutoMergeNodeReport nodeReport = new AutoMergeNodeReport(1, autoItemLogStatus, log.getCompany(), log.getTemplate(), log.getDescription(), null);
                nodeReports.add(nodeReport);
            }
        }
        AutoMergeReport report = new AutoMergeReport(mergeContextName, null, null, "", nodeReports);
        report.setProgress(-1);
        QueryName query = new QueryName(dao);
        StringBuffer updateProcessSQL2 = new StringBuffer();
        LinkedList<String> params = new LinkedList<String>();
        updateProcessSQL2.append(" SELECT FNodeType nodeType,FOrgUnit OrgUnit,FCompany company,FTemplate template,FError_" + locale + " errorOrNodeType \n");
        updateProcessSQL2.append(" \t\t,FStartTime startTime,FEndTime endTime,FStatus status,FYear fyear,FPeriod period,FDetail detail \n");
        updateProcessSQL2.append(" FROM T_CSL_AutoMergeLog log \n");
        updateProcessSQL2.append(" left join t_org_baseUnit org on org.fid=log.FOrgUnit ");
        updateProcessSQL2.append(" WHERE FMergeContext = ? \n");
        params.add(this.mergeContextId);
        if (!this.emptyExecuteTaskId()) {
            updateProcessSQL2.append(" AND FTaskId = ? \n");
            params.add(this.executeTaskId);
        }
        updateProcessSQL2.append(" ORDER BY FNodeType,org.flongNumber,FTemplate \n");
        IRowSet rs2 = executeSQL.executeQuery(updateProcessSQL2.toString(), params.toArray());
        try {
            int nodeType = 0;
            Object status = null;
            String orgUnit = null;
            String company = null;
            String template = null;
            LazyShowName lazyOrgUnit = null;
            LazyShowName lazyCompany = null;
            LazyShowName lazyTemplate = null;
            String errorOrNodeType = null;
            Timestamp startTime = null;
            Timestamp endTime = null;
            String detail = null;
            while (rs2.next()) {
                nodeType = rs2.getInt("nodeType");
                orgUnit = rs2.getString("orgUnit");
                company = rs2.getString("company");
                template = rs2.getString("template");
                errorOrNodeType = rs2.getString("errorOrNodeType");
                startTime = rs2.getTimestamp("startTime");
                endTime = rs2.getTimestamp("endTime");
                status = rs2.getObject("status");
                String year = rs2.getString("fyear");
                String period = rs2.getString("period");
                detail = rs2.getString("detail");
                if (nodeType == 0) {
                    report.setStartTime(startTime);
                    report.setEndTime(endTime);
                    report.setYear(year);
                    report.setPeriod(period);
                    if (errorOrNodeType != null && errorOrNodeType.matches("[0-9]+")) {
                        report.setProgress(Integer.parseInt(errorOrNodeType));
                        continue;
                    }
                    report.setProgress(-1);
                    continue;
                }
                if (orgUnit != null) {
                    lazyOrgUnit = new LazyShowName(orgUnit);
                    query.put("orgUnit", lazyOrgUnit);
                } else {
                    lazyOrgUnit = null;
                }
                if (company != null) {
                    lazyCompany = new LazyShowName(company);
                    query.put("company", lazyCompany);
                } else {
                    lazyCompany = null;
                }
                if (template != null) {
                    lazyTemplate = new LazyShowName(template);
                    query.put("template", lazyTemplate);
                } else {
                    lazyTemplate = null;
                }
                AutoMergeNodeReport nodeReport = new AutoMergeNodeReport(nodeType, "".equals(status) || status == null ? "" : Boolean.valueOf(RptUtil.isTrue((Object)status)), this.getOrgInfo(lazyOrgUnit, lazyCompany), lazyTemplate, errorOrNodeType, detail);
                nodeReports.add(nodeReport);
            }
            query.replaceName();
            query.clear();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (report.getProgress() == 100) {
            if (nodeReports.isEmpty()) {
                report.setStatus(ResourceDebugUtil.res("com.kingdee.eas.fi.gr.fast.FastMergeResource", "log.reportStatus.is.finish", " "));
            } else {
                report.setStatus(ResourceDebugUtil.res("com.kingdee.eas.fi.gr.fast.FastMergeResource", "log.reportStatus.is.end", " "));
            }
        } else if (report.getProgress() == -1) {
            report.setStatus(ResourceDebugUtil.res("com.kingdee.eas.fi.gr.fast.FastMergeResource", "log.reportStatus.is.no.running", " "));
        } else {
            report.setStatus(ResourceDebugUtil.res("com.kingdee.eas.fi.gr.fast.FastMergeResource", "log.reportStatus.is.running", " "));
        }
        return report;
    }

    private boolean emptyExecuteTaskId() {
        return StringUtils.isEmpty((String)this.executeTaskId);
    }

    private Object getOrgInfo(Object orgUnit, Object company) {
        if (orgUnit != null && company != null) {
            return new CompanyInOrgUnit(orgUnit, company);
        }
        if (orgUnit != null) {
            return orgUnit;
        }
        if (company != null) {
            return company;
        }
        return null;
    }

    protected IAutoMergeLog getDao() throws BOSException {
        if (this.logDao != null) {
            return this.logDao;
        }
        this.logDao = this.ctx == null ? AutoMergeLogFactory.getRemoteInstance() : AutoMergeLogFactory.getLocalInstance(this.ctx);
        return this.logDao;
    }

    public boolean isProcessing() throws BOSException {
        DBHandler dao = new DBHandler(this.ctx);
        StringBuffer isProcessingSQL = new StringBuffer();
        isProcessingSQL.append(" SELECT FError_" + dao.getLocale() + " process FROM T_CSL_AutoMergeLog \n");
        isProcessingSQL.append(" WHERE FNodeType = ? \n");
        isProcessingSQL.append(" AND FMergeContext = ? \n");
        IRowSet record = dao.getExecuteSQL().executeQuery(isProcessingSQL.toString(), new Object[]{0, this.mergeContextId});
        if (record.size() == 0) {
            return false;
        }
        try {
            if (record.next()) {
                return !"100".equals(record.getString("process"));
            }
            return false;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }
}

