/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FindListEvent;
import com.kingdee.eas.framework.client.IFindListListener;
import com.kingdee.eas.framework.client.service.TableLocationServer;
import com.kingdee.eas.framework.util.ConfigParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;

public class FindListListener
implements IFindListListener {
    private KDTable tblMain;
    private int rowCount;
    private CoreUI parentUI;
    private static String locateFirst = "Msg_LocateFirst";
    private static String locateLast = "Msg_LocateLast";
    private TableLocationServer server;
    private TableLocationServer.LocateParam param;
    private ConfigParams config_params;

    public FindListListener(IFindCondition condition) {
        this.tblMain = condition.getSearchTable();
        this.rowCount = condition.getSearchScope();
        this.parentUI = condition.getparentUI();
        this.server = this.getTableLocationServer();
        this.server.setTblMain(this.tblMain);
        this.server.setFirstLocate(true);
    }

    protected TableLocationServer getTableLocationServer() {
        return new TableLocationServer();
    }

    private TableLocationServer.LocateParam getConfigParam(FindListEvent e) {
        this.config_params = new ConfigParams();
        this.config_params.addBooleanParam("is_match", e.isIsMatch());
        this.config_params.addIntParam("find_direction", e.getFindDeration());
        this.config_params.addBooleanParam("has_query_pk", false);
        this.config_params.addIntParam("row_count", this.rowCount);
        return new TableLocationServer.LocateParam(e.getSearch(), e.getPropertyName(), this.config_params);
    }

    public void FindNext(FindListEvent e) {
        this.param = this.getConfigParam(e);
        TableLocationServer.LocateResult result = this.server.locate(this.param);
        if (result == TableLocationServer.LocateResult.nullLocateResult) {
            return;
        }
        if (result.isLocateSuccess()) {
            this.tblMain.getSelectManager().select(result.getLocateRow(), 0);
            this.tblMain.getLayoutManager().scrollRowToShow(result.getLocateRow());
        } else if (result.getLocateRowCount() == 0) {
            String str = e.getFindDeration() == 2 ? locateLast : locateFirst;
            MsgBox.showInfo((Component)this.parentUI, (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + str)));
        } else {
            String str = e.getFindDeration() == 2 ? "Msg_LocateLast_end" : "Msg_LocateFirst_end";
            String msg = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + str));
            Object[] objs = new Object[]{new Integer(result.getLocateRowCount())};
            msg = MessageFormat.format(msg, objs);
            MsgBox.showInfo((Component)this.parentUI, (String)msg);
        }
        this.server.setFirstLocate(false);
    }

    public void FindClose(FindListEvent e) {
    }

    static interface IFindCondition {
        public KDTable getSearchTable();

        public int getSearchScope();

        public CoreUI getparentUI();
    }
}

